//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//

// generated using:
//     curl -s https://swift.org/ | iconv -c -f utf-8 -t ascii | pbcopy
let htmlASCIIOnly: String = """
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
<title>Swift.org - Welcome to Swift.org</title>
<meta name="author" content="Apple Inc." />
<meta name="viewport" content="width=device-width initial-scale=1" />
<link rel="license" href="/LICENSE.txt" />
<link rel="stylesheet" media="all" href="/assets/stylesheets/application.css" />
<link rel="shortcut icon" sizes="16x16 24x24 32x32 48x48 64x64" type="image/vnd.microsoft.icon" href="/favicon.ico" />
<link rel="apple-touch-icon" href="/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon-180x180.png" />
<link rel="mask-icon" href="/assets/images/icon-swift.svg" color="#F05339" />

<link rel="alternate" type="application/atom+xml" title="Swift.org (Atom Feed)" href="/atom.xml" />



<link rel="canonical" href="https://swift.org/" />


<meta name="twitter:card" content="summary" />
<meta name="twitter:site" content="@SwiftLang" />

<meta name="twitter:title" content="Swift.org" />
<meta name="twitter:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />


<meta property="og:site_name" content="Swift.org" />
<meta property="og:image" content="https://swift.org/touch-icon-ipad-180x180.png" />

<meta property="og:title" content="Swift.org" />
<meta property="og:url" content="https://swift.org" />
<meta property="og:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />

</head>

<body>

<nav role="navigation">
<header role="banner">
<h1 id="logo">
<a href="/" title="Swift.org" role="img" aria-label="Swift.org">
Swift.org
</a>
</h1>
</header>

<div id="menu-toggle" class="menu-toggle open"></div>

<ul>


<li>

<a href="/about/">About Swift</a>

</li>



<li>

<a href="/blog/">Blog</a>
</li>



<li>

<a href="/download/">Download</a>

</li>



<li>

<a href="/getting-started/">Getting Started</a>

</li>



<li>

<a href="/documentation/">Documentation</a>

</li>



<li>

<a href="/migration-guide-swift4/">Migrating to Swift 4</a>
</li>



<li>

<a href="/source-code/">Source Code</a>

</li>



<li>

<a href="/community/">Community</a>

</li>



<li>

<a href="/contributing/">Contributing</a>

</li>



<li>

<a href="/continuous-integration/">Continuous Integration</a>

</li>



<li>

<a href="/source-compatibility/">Source Compatibility</a>

</li>
</ul>


<h2>Focus Areas</h2>
<ul>


<li>

<a href="/abi-stability/">ABI Stability</a>

</li>



<li>

<a href="/server-apis/">Server APIs <small><small><small><i>(Work Group)</i></small></small></small></a>
</li>
</ul>

<h2>Projects</h2>
<ul>


<li>

<a href="/compiler-stdlib/">Compiler and Standard Library</a>

</li>



<li>

<a href="/package-manager/">Package Manager</a>

</li>



<li>

<a href="/core-libraries/">Core Libraries</a>

</li>



<li>

<a href="/lldb/">REPL, Debugger &amp; Playgrounds</a>

</li>

</ul>
</nav>


<main role="main">
<h1 id="welcome-to-swiftorg">Welcome to Swift.org</h1>

<p>Welcome to the Swift community. Together we are working to build a programming language to empower everyone to turn their ideas into apps on any platform.</p>

<p>Announced in 2014, the Swift programming language has quickly become one of the fastest growing languages in history. Swift makes it easy to write software that is incredibly fast and safe by design. Our goals for Swift are ambitious: we want to make programming simple things easy, and difficult things possible.</p>

<p>For students, learning Swift has been a great introduction to modern programming concepts and best practices. And because it is open, their Swift skills will be able to be applied to an even broader range of platforms, from mobile devices to the desktop to the cloud.</p>

</main>

<footer role="contentinfo">
<aside>
<a href="/atom.xml" title="Subscribe to Site Updates"><i class="feed"></i></a>
<a href="https://twitter.com/swiftlang" rel="nofollow" title="Follow @SwiftLang on Twitter"><i class="twitter"></i></a>
</aside>

<p class="copyright">Copyright  2018 Apple Inc. All rights reserved.</p>
<p class="trademark">Swift and the Swift logo are trademarks of Apple Inc.</p>
<p class="privacy">
<a href="//www.apple.com/privacy/privacy-policy/">Privacy Policy</a>
<a href="//www.apple.com/legal/privacy/en-ww/cookies/">Cookies</a>
</p>
</footer>


<script type="text/javascript">
var s_account="dappswiftorg";
</script>
<script type="text/javascript" src="/assets/javascripts/vendor/s_code_h.js"></script>
<script src="/assets/javascripts/application.js"></script>
<script type="text/javascript">
s.pageName=AC.Tracking.pageName();
var s_code=s.t();if(s_code)document.write(s_code);
</script>
</body>
</html>
"""

// generated using:
//     curl -s https://swift.org/ | pbcopy
let htmlMostlyASCII: String = """
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
<title>Swift.org - Welcome to Swift.org</title>
<meta name="author" content="Apple Inc." />
<meta name="viewport" content="width=device-width initial-scale=1" />
<link rel="license" href="/LICENSE.txt" />
<link rel="stylesheet" media="all" href="/assets/stylesheets/application.css" />
<link rel="shortcut icon" sizes="16x16 24x24 32x32 48x48 64x64" type="image/vnd.microsoft.icon" href="/favicon.ico" />
<link rel="apple-touch-icon" href="/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon-180x180.png" />
<link rel="mask-icon" href="/assets/images/icon-swift.svg" color="#F05339" />

<link rel="alternate" type="application/atom+xml" title="Swift.org (Atom Feed)" href="/atom.xml" />



<link rel="canonical" href="https://swift.org/" />


<meta name="twitter:card" content="summary" />
<meta name="twitter:site" content="@SwiftLang" />

<meta name="twitter:title" content="Swift.org" />
<meta name="twitter:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />


<meta property="og:site_name" content="Swift.org" />
<meta property="og:image" content="https://swift.org/touch-icon-ipad-180x180.png" />

<meta property="og:title" content="Swift.org" />
<meta property="og:url" content="https://swift.org" />
<meta property="og:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />

</head>

<body>

<nav role="navigation">
<header role="banner">
<h1 id="logo">
<a href="/" title="Swift.org" role="img" aria-label="Swift.org">
Swift.org
</a>
</h1>
</header>

<div id="menu-toggle" class="menu-toggle open"></div>

<ul>


<li>

<a href="/about/">About Swift</a>

</li>



<li>

<a href="/blog/">Blog</a>
</li>



<li>

<a href="/download/">Download</a>

</li>



<li>

<a href="/getting-started/">Getting Started</a>

</li>



<li>

<a href="/documentation/">Documentation</a>

</li>



<li>

<a href="/migration-guide-swift4/">Migrating to Swift 4</a>
</li>



<li>

<a href="/source-code/">Source Code</a>

</li>



<li>

<a href="/community/">Community</a>

</li>



<li>

<a href="/contributing/">Contributing</a>

</li>



<li>

<a href="/continuous-integration/">Continuous Integration</a>

</li>



<li>

<a href="/source-compatibility/">Source Compatibility</a>

</li>
</ul>


<h2>Focus Areas</h2>
<ul>


<li>

<a href="/abi-stability/">ABI Stability</a>

</li>



<li>

<a href="/server-apis/">Server APIs <small><small><small><i>(Work Group)</i></small></small></small></a>
</li>
</ul>

<h2>Projects</h2>
<ul>


<li>

<a href="/compiler-stdlib/">Compiler and Standard Library</a>

</li>



<li>

<a href="/package-manager/">Package Manager</a>

</li>



<li>

<a href="/core-libraries/">Core Libraries</a>

</li>



<li>

<a href="/lldb/">REPL, Debugger &amp; Playgrounds</a>

</li>

</ul>
</nav>


<main role="main">
<h1 id="welcome-to-swiftorg">Welcome to Swift.org</h1>

<p>Welcome to the Swift community. Together we are working to build a programming language to empower everyone to turn their ideas into apps on any platform.</p>

<p>Announced in 2014, the Swift programming language has quickly become one of the fastest growing languages in history. Swift makes it easy to write software that is incredibly fast and safe by design. Our goals for Swift are ambitious: we want to make programming simple things easy, and difficult things possible.</p>

<p>For students, learning Swift has been a great introduction to modern programming concepts and best practices. And because it is open, their Swift skills will be able to be applied to an even broader range of platforms, from mobile devices to the desktop to the cloud.</p>

</main>

<footer role="contentinfo">
<aside>
<a href="/atom.xml" title="Subscribe to Site Updates"><i class="feed"></i></a>
<a href="https://twitter.com/swiftlang" rel="nofollow" title="Follow @SwiftLang on Twitter"><i class="twitter"></i></a>
</aside>

<p class="copyright">Copyright © 2018 Apple Inc. All rights reserved.</p>
<p class="trademark">Swift and the Swift logo are trademarks of Apple Inc.</p>
<p class="privacy">
<a href="//www.apple.com/privacy/privacy-policy/">Privacy Policy</a>
<a href="//www.apple.com/legal/privacy/en-ww/cookies/">Cookies</a>
</p>
</footer>


<script type="text/javascript">
var s_account="dappswiftorg";
</script>
<script type="text/javascript" src="/assets/javascripts/vendor/s_code_h.js"></script>
<script src="/assets/javascripts/application.js"></script>
<script type="text/javascript">
s.pageName=AC.Tracking.pageName();
var s_code=s.t();if(s_code)document.write(s_code);
</script>
</body>
</html>
"""

// generated using:
//     curl -s https://swift.org/ | iconv -c -f utf-8 -t ascii | pbcopy
let htmlASCIIOnlyStaticString: StaticString = """
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
<title>Swift.org - Welcome to Swift.org</title>
<meta name="author" content="Apple Inc." />
<meta name="viewport" content="width=device-width initial-scale=1" />
<link rel="license" href="/LICENSE.txt" />
<link rel="stylesheet" media="all" href="/assets/stylesheets/application.css" />
<link rel="shortcut icon" sizes="16x16 24x24 32x32 48x48 64x64" type="image/vnd.microsoft.icon" href="/favicon.ico" />
<link rel="apple-touch-icon" href="/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon-180x180.png" />
<link rel="mask-icon" href="/assets/images/icon-swift.svg" color="#F05339" />

<link rel="alternate" type="application/atom+xml" title="Swift.org (Atom Feed)" href="/atom.xml" />



<link rel="canonical" href="https://swift.org/" />


<meta name="twitter:card" content="summary" />
<meta name="twitter:site" content="@SwiftLang" />

<meta name="twitter:title" content="Swift.org" />
<meta name="twitter:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />


<meta property="og:site_name" content="Swift.org" />
<meta property="og:image" content="https://swift.org/touch-icon-ipad-180x180.png" />

<meta property="og:title" content="Swift.org" />
<meta property="og:url" content="https://swift.org" />
<meta property="og:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />

</head>

<body>

<nav role="navigation">
<header role="banner">
<h1 id="logo">
<a href="/" title="Swift.org" role="img" aria-label="Swift.org">
Swift.org
</a>
</h1>
</header>

<div id="menu-toggle" class="menu-toggle open"></div>

<ul>


<li>

<a href="/about/">About Swift</a>

</li>



<li>

<a href="/blog/">Blog</a>
</li>



<li>

<a href="/download/">Download</a>

</li>



<li>

<a href="/getting-started/">Getting Started</a>

</li>



<li>

<a href="/documentation/">Documentation</a>

</li>



<li>

<a href="/migration-guide-swift4/">Migrating to Swift 4</a>
</li>



<li>

<a href="/source-code/">Source Code</a>

</li>



<li>

<a href="/community/">Community</a>

</li>



<li>

<a href="/contributing/">Contributing</a>

</li>



<li>

<a href="/continuous-integration/">Continuous Integration</a>

</li>



<li>

<a href="/source-compatibility/">Source Compatibility</a>

</li>
</ul>


<h2>Focus Areas</h2>
<ul>


<li>

<a href="/abi-stability/">ABI Stability</a>

</li>



<li>

<a href="/server-apis/">Server APIs <small><small><small><i>(Work Group)</i></small></small></small></a>
</li>
</ul>

<h2>Projects</h2>
<ul>


<li>

<a href="/compiler-stdlib/">Compiler and Standard Library</a>

</li>



<li>

<a href="/package-manager/">Package Manager</a>

</li>



<li>

<a href="/core-libraries/">Core Libraries</a>

</li>



<li>

<a href="/lldb/">REPL, Debugger &amp; Playgrounds</a>

</li>

</ul>
</nav>


<main role="main">
<h1 id="welcome-to-swiftorg">Welcome to Swift.org</h1>

<p>Welcome to the Swift community. Together we are working to build a programming language to empower everyone to turn their ideas into apps on any platform.</p>

<p>Announced in 2014, the Swift programming language has quickly become one of the fastest growing languages in history. Swift makes it easy to write software that is incredibly fast and safe by design. Our goals for Swift are ambitious: we want to make programming simple things easy, and difficult things possible.</p>

<p>For students, learning Swift has been a great introduction to modern programming concepts and best practices. And because it is open, their Swift skills will be able to be applied to an even broader range of platforms, from mobile devices to the desktop to the cloud.</p>

</main>

<footer role="contentinfo">
<aside>
<a href="/atom.xml" title="Subscribe to Site Updates"><i class="feed"></i></a>
<a href="https://twitter.com/swiftlang" rel="nofollow" title="Follow @SwiftLang on Twitter"><i class="twitter"></i></a>
</aside>

<p class="copyright">Copyright  2018 Apple Inc. All rights reserved.</p>
<p class="trademark">Swift and the Swift logo are trademarks of Apple Inc.</p>
<p class="privacy">
<a href="//www.apple.com/privacy/privacy-policy/">Privacy Policy</a>
<a href="//www.apple.com/legal/privacy/en-ww/cookies/">Cookies</a>
</p>
</footer>


<script type="text/javascript">
var s_account="dappswiftorg";
</script>
<script type="text/javascript" src="/assets/javascripts/vendor/s_code_h.js"></script>
<script src="/assets/javascripts/application.js"></script>
<script type="text/javascript">
s.pageName=AC.Tracking.pageName();
var s_code=s.t();if(s_code)document.write(s_code);
</script>
</body>
</html>
"""

// generated using:
//     curl -s https://swift.org/ | pbcopy
let htmlMostlyASCIIStaticString: StaticString = """
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
<title>Swift.org - Welcome to Swift.org</title>
<meta name="author" content="Apple Inc." />
<meta name="viewport" content="width=device-width initial-scale=1" />
<link rel="license" href="/LICENSE.txt" />
<link rel="stylesheet" media="all" href="/assets/stylesheets/application.css" />
<link rel="shortcut icon" sizes="16x16 24x24 32x32 48x48 64x64" type="image/vnd.microsoft.icon" href="/favicon.ico" />
<link rel="apple-touch-icon" href="/apple-touch-icon.png" />
<link rel="apple-touch-icon" sizes="57x57" href="/apple-touch-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="72x72" href="/apple-touch-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="/apple-touch-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="/apple-touch-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon-180x180.png" />
<link rel="mask-icon" href="/assets/images/icon-swift.svg" color="#F05339" />

<link rel="alternate" type="application/atom+xml" title="Swift.org (Atom Feed)" href="/atom.xml" />



<link rel="canonical" href="https://swift.org/" />


<meta name="twitter:card" content="summary" />
<meta name="twitter:site" content="@SwiftLang" />

<meta name="twitter:title" content="Swift.org" />
<meta name="twitter:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />


<meta property="og:site_name" content="Swift.org" />
<meta property="og:image" content="https://swift.org/touch-icon-ipad-180x180.png" />

<meta property="og:title" content="Swift.org" />
<meta property="og:url" content="https://swift.org" />
<meta property="og:description" content="Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns." />

</head>

<body>

<nav role="navigation">
<header role="banner">
<h1 id="logo">
<a href="/" title="Swift.org" role="img" aria-label="Swift.org">
Swift.org
</a>
</h1>
</header>

<div id="menu-toggle" class="menu-toggle open"></div>

<ul>


<li>

<a href="/about/">About Swift</a>

</li>



<li>

<a href="/blog/">Blog</a>
</li>



<li>

<a href="/download/">Download</a>

</li>



<li>

<a href="/getting-started/">Getting Started</a>

</li>



<li>

<a href="/documentation/">Documentation</a>

</li>



<li>

<a href="/migration-guide-swift4/">Migrating to Swift 4</a>
</li>



<li>

<a href="/source-code/">Source Code</a>

</li>



<li>

<a href="/community/">Community</a>

</li>



<li>

<a href="/contributing/">Contributing</a>

</li>



<li>

<a href="/continuous-integration/">Continuous Integration</a>

</li>



<li>

<a href="/source-compatibility/">Source Compatibility</a>

</li>
</ul>


<h2>Focus Areas</h2>
<ul>


<li>

<a href="/abi-stability/">ABI Stability</a>

</li>



<li>

<a href="/server-apis/">Server APIs <small><small><small><i>(Work Group)</i></small></small></small></a>
</li>
</ul>

<h2>Projects</h2>
<ul>


<li>

<a href="/compiler-stdlib/">Compiler and Standard Library</a>

</li>



<li>

<a href="/package-manager/">Package Manager</a>

</li>



<li>

<a href="/core-libraries/">Core Libraries</a>

</li>



<li>

<a href="/lldb/">REPL, Debugger &amp; Playgrounds</a>

</li>

</ul>
</nav>


<main role="main">
<h1 id="welcome-to-swiftorg">Welcome to Swift.org</h1>

<p>Welcome to the Swift community. Together we are working to build a programming language to empower everyone to turn their ideas into apps on any platform.</p>

<p>Announced in 2014, the Swift programming language has quickly become one of the fastest growing languages in history. Swift makes it easy to write software that is incredibly fast and safe by design. Our goals for Swift are ambitious: we want to make programming simple things easy, and difficult things possible.</p>

<p>For students, learning Swift has been a great introduction to modern programming concepts and best practices. And because it is open, their Swift skills will be able to be applied to an even broader range of platforms, from mobile devices to the desktop to the cloud.</p>

</main>

<footer role="contentinfo">
<aside>
<a href="/atom.xml" title="Subscribe to Site Updates"><i class="feed"></i></a>
<a href="https://twitter.com/swiftlang" rel="nofollow" title="Follow @SwiftLang on Twitter"><i class="twitter"></i></a>
</aside>

<p class="copyright">Copyright © 2018 Apple Inc. All rights reserved.</p>
<p class="trademark">Swift and the Swift logo are trademarks of Apple Inc.</p>
<p class="privacy">
<a href="//www.apple.com/privacy/privacy-policy/">Privacy Policy</a>
<a href="//www.apple.com/legal/privacy/en-ww/cookies/">Cookies</a>
</p>
</footer>


<script type="text/javascript">
var s_account="dappswiftorg";
</script>
<script type="text/javascript" src="/assets/javascripts/vendor/s_code_h.js"></script>
<script src="/assets/javascripts/application.js"></script>
<script type="text/javascript">
s.pageName=AC.Tracking.pageName();
var s_code=s.t();if(s_code)document.write(s_code);
</script>
</body>
</html>
"""
