import _SwiftFormatTestSupport

@_spi(Rules) import SwiftFormat

final class DoNotUseSemicolonsTests: LintOrFormatRuleTestCase {
  func testSemicolonUse() {
    assertFormatting(
      DoNotUseSemicolons.self,
      input: """
        print("hello")1️⃣; print("goodbye")2️⃣;
        print("3")
        """,
      expected: """
        print("hello")
        print("goodbye")
        print("3")
        """,
      findings: [
        FindingSpec("1️⃣", message: "remove ';' and move the next statement to a new line"),
        FindingSpec("2️⃣", message: "remove ';'"),
      ]
    )
  }

  func testSemicolonsInNestedStatements() {
    assertFormatting(
      DoNotUseSemicolons.self,
      input: """
        guard let someVar = Optional(items.filter ({ a in foo(a)1️⃣; return true2️⃣; })) else {
          items.forEach { a in foo(a)3️⃣; }4️⃣; return5️⃣;
        }
        """,
      // The formatting in the expected output is unappealing, but that is fixed by the pretty
      // printer and isn't a concern for the format rule.
      expected: """
        guard let someVar = Optional(items.filter ({ a in foo(a)
        return true})) else {
          items.forEach { a in foo(a)}
        return
        }
        """,
      findings: [
        FindingSpec("1️⃣", message: "remove ';' and move the next statement to a new line"),
        FindingSpec("2️⃣", message: "remove ';'"),
        FindingSpec("3️⃣", message: "remove ';'"),
        FindingSpec("4️⃣", message: "remove ';' and move the next statement to a new line"),
        FindingSpec("5️⃣", message: "remove ';'"),
      ]
    )
  }

  func testSemicolonsInMemberLists() {
    assertFormatting(
      DoNotUseSemicolons.self,
      input: """
        struct Foo {
          func foo() {
            code()
          }1️⃣;

          let someVar = 52️⃣;let someOtherVar = 63️⃣;
        }
        """,
      expected: """
        struct Foo {
          func foo() {
            code()
          }

          let someVar = 5
        let someOtherVar = 6
        }
        """,
      findings: [
        FindingSpec("1️⃣", message: "remove ';'"),
        FindingSpec("2️⃣", message: "remove ';' and move the next statement to a new line"),
        FindingSpec("3️⃣", message: "remove ';'"),
      ]
    )
  }

  func testNewlinesAfterSemicolons() {
    assertFormatting(
      DoNotUseSemicolons.self,
      input: """
        print("hello")1️⃣;
        /// This is a doc comment for printing "goodbye".
        print("goodbye")2️⃣;

        /// This is a doc comment for printing "3".
        print("3")3️⃣;

        print("4")4️⃣; /** Inline comment. */ print("5")5️⃣;

        print("6")6️⃣;  // This is an important statement.
        print("7")7️⃣;
        """,
      expected: """
        print("hello")
        /// This is a doc comment for printing "goodbye".
        print("goodbye")

        /// This is a doc comment for printing "3".
        print("3")

        print("4")
        /** Inline comment. */ print("5")

        print("6")// This is an important statement.
        print("7")
        """,
      findings: [
        FindingSpec("1️⃣", message: "remove ';'"),
        FindingSpec("2️⃣", message: "remove ';'"),
        FindingSpec("3️⃣", message: "remove ';'"),
        FindingSpec("4️⃣", message: "remove ';' and move the next statement to a new line"),
        FindingSpec("5️⃣", message: "remove ';'"),
        FindingSpec("6️⃣", message: "remove ';'"),
        FindingSpec("7️⃣", message: "remove ';'"),
      ]
    )
  }
  
  func testSemicolonsSeparatingDoWhile() {
    assertFormatting(
      DoNotUseSemicolons.self,
      input: """
        do { f() };
        while someCondition { g() }

        do {
          f()
        };

        // Comment and whitespace separating blocks.
        while someCondition {
          g()
        }

        do { f() }1️⃣;
        for _ in 0..<10 { g() }
        """,
      expected: """
        do { f() };
        while someCondition { g() }

        do {
          f()
        };

        // Comment and whitespace separating blocks.
        while someCondition {
          g()
        }

        do { f() }
        for _ in 0..<10 { g() }
        """,
      findings: [
        FindingSpec("1️⃣", message: "remove ';'"),
      ]
    )
  }
}
