/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;

public class BlobLocatorInputStream
extends InputStream {
    private final Connection connection;
    private final Blob blob;
    private long currentPos;
    private final long maxPos;

    public BlobLocatorInputStream(Connection connection, Blob blob) throws SqlException {
        this.connection = connection;
        this.blob = blob;
        this.currentPos = 1L;
        this.maxPos = -1L;
    }

    public BlobLocatorInputStream(Connection connection, Blob blob, long l, long l2) throws SqlException {
        this.connection = connection;
        this.blob = blob;
        this.currentPos = l;
        this.maxPos = l2 != -1L ? Math.min(blob.sqlLength(), l + l2 - 1L) : -1L;
    }

    public int read() throws IOException {
        byte[] byArray = this.readBytes(1);
        if (byArray.length == 0) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray2 = this.readBytes(n2);
        if (byArray2.length == 0) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private byte[] readBytes(int n) throws IOException {
        try {
            int n2 = -1;
            n2 = this.maxPos != -1L ? (int)Math.min((long)n, this.maxPos - this.currentPos + 1L) : (int)Math.min((long)n, this.blob.sqlLength() - this.currentPos + 1L);
            byte[] byArray = this.connection.locatorProcedureCall().blobGetBytes(this.blob.getLocator(), this.currentPos, n2);
            this.currentPos += (long)byArray.length;
            return byArray;
        }
        catch (SqlException sqlException) {
            IOException iOException = new IOException();
            iOException.initCause(sqlException);
            throw iOException;
        }
    }
}

