/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateIndexNode
extends DDLStatementNode {
    boolean unique;
    DataDictionary dd = null;
    Properties properties;
    String indexType;
    TableName indexName;
    TableName tableName;
    Vector columnNameList;
    String[] columnNames = null;
    boolean[] isAscending;
    int[] boundColumnIDs;
    TableDescriptor td;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        this.initAndCheck(object3);
        this.unique = (Boolean)object;
        this.indexType = (String)object2;
        this.indexName = (TableName)object3;
        this.tableName = (TableName)object4;
        this.columnNameList = (Vector)object5;
        this.properties = (Properties)object6;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "CREATE INDEX";
    }

    public boolean getUniqueness() {
        return this.unique;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public TableName getIndexName() {
        return this.indexName;
    }

    public UUID getBoundTableID() {
        return this.td.getUUID();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TableName getIndexTableName() {
        return this.tableName;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getKeyColumnIDs() {
        return this.boundColumnIDs;
    }

    public boolean[] getIsAscending() {
        return this.isAscending;
    }

    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        this.td = this.getTableDescriptor(this.tableName);
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        if (this.td.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(this.td.getTotalNumberOfIndexes()), (Object)this.tableName, (Object)String.valueOf(Short.MAX_VALUE));
        }
        this.verifyAndGetUniqueNames();
        int n = this.columnNames.length;
        this.boundColumnIDs = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            this.boundColumnIDs[i] = columnDescriptor.getPosition();
            if (columnDescriptor.getType().getTypeId().orderable(this.getClassFactory())) continue;
            throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
        }
        if (n > 16) {
            throw StandardException.newException("54008");
        }
        this.getCompilerContext().createDependency(this.td);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.td.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        int n = this.columnNames.length;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            n2 += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (n2 > 1024 && (this.properties == null || this.properties.get("derby.storage.pageSize") == null) && PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") == null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(this.unique, this.indexType, schemaDescriptor.getSchemaName(), this.indexName.getTableName(), this.tableName.getTableName(), this.td.getUUID(), this.columnNames, this.isAscending, false, null, this.properties);
    }

    private void verifyAndGetUniqueNames() throws StandardException {
        int n = this.columnNameList.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        this.columnNames = new String[n];
        this.isAscending = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.columnNames[i] = (String)this.columnNameList.elementAt(i);
            if (this.columnNames[i].endsWith(" ")) {
                this.columnNames[i] = this.columnNames[i].substring(0, this.columnNames[i].length() - 1);
                this.isAscending[i] = false;
            } else {
                this.isAscending[i] = true;
            }
            String string = hashtable.put(this.columnNames[i], this.columnNames[i]);
            if (string == null || !string.equals(this.columnNames[i])) continue;
            throw StandardException.newException("42X66", this.columnNames[i]);
        }
    }
}

