/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "SimplePromptDialog.h" 

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QCheckBox>
#include <QtGui/QPushButton>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3HBox>


SimplePromptDialog::SimplePromptDialog(
  const char* realm, const char* username, bool maySave, 
  QWidget *parent, const char *name )
: super( parent, name, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
         Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu )
{
  setCaption( _q("subcommander:prompt (simple)") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  // this one makes h and v fixed.
  //vbl->setResizeMode( QLayout::Fixed );
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Horizontal,this);
    gb->setTitle( _q("enter username/password: ") );
    gb->setInsideSpacing(10);
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);
    {
      QLabel *l1 = new QLabel(gb);
      l1->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
      l1->setText( realm );

      QLabel *l2 = new QLabel(gb);
      l2->setAlignment( Qt::AlignHCenter | Qt::AlignHCenter );
      l2->setText( _q("requests a username and password!") );

      QWidget*     w  = new QWidget(gb);
      QGridLayout* wl = new QGridLayout( w, 3, 3 );
      {
        wl->addColSpacing( 1, 20 );
        wl->addRowSpacing( 1, 10 );

        QLabel* ul = new QLabel( _q("&Username:"), w );
        _user      = new QLineEdit( w );
        ul->setBuddy(_user);
        _user->setText( username );
        _user->selectAll();
        wl->addWidget( ul, 0, 0 );
        wl->addWidget( _user, 0, 2 );

        QLabel* pl = new QLabel( _q("&Password:"), w );
        _pwd       = new QLineEdit( w );
        _pwd->setEchoMode( QLineEdit::Password );
        pl->setBuddy(_pwd);
        wl->addWidget( pl, 2, 0 );
        wl->addWidget( _pwd, 2, 2 );

        wl->addRowSpacing( 3, 10 );
      }
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      _save = new QCheckBox(_q("&store password"),this);
      hu->addWidget(_save);
      if( ! maySave )
      {
        _save->setEnabled(false);
      }

      // add some extra space, to improve dialog appearance 
      hu->addSpacing( (int)(0.9 * _save->width()) );

      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      QPushButton* ok = new QPushButton(this);
      ok->setText( _q("&Ok") );
      hu->addWidget(ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      connect( ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

SimplePromptDialog::~SimplePromptDialog()
{
}

QString SimplePromptDialog::getUsername() const
{
  return _user->text();
}

QString SimplePromptDialog::getPassword() const
{
  return _pwd->text();
}

bool SimplePromptDialog::getSave() const
{
  return _save->isChecked();
}
