/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.skiplist;

import edu.jhu.skiplist.SkipListElement;

public class SkipList {
    public static final long NOT_FOUND = -1L;
    public static final long HEADER_KEY = -2L;
    public static final long SKIPLIST_MAXLEVEL = 6L;
    public static final long NIL_KEY = Long.MAX_VALUE;
    public static final float OPT_PROB = 0.25f;
    protected int myLength = 0;
    private float myProbability;
    private int myMaxLevel;
    private int myLevel = 0;
    private SkipListElement myHeader;
    protected SkipListElement iter;

    public SkipList(float f) {
        this(f, (int)Math.ceil(Math.log(6.0) / Math.log(4.0)) - 1);
    }

    public SkipList(long l) {
        this(0.25f, (int)Math.ceil(Math.log(l) / Math.log(4.0)) - 1);
    }

    public SkipList(float f, int n) {
        this.myProbability = f;
        this.myMaxLevel = n;
        this.myHeader = new SkipListElement(this.myMaxLevel, -2L, 0L);
        SkipListElement skipListElement = new SkipListElement(this.myMaxLevel, Long.MAX_VALUE, 0L);
        int n2 = 0;
        while (n2 <= this.myMaxLevel) {
            this.myHeader.forward[n2] = skipListElement;
            ++n2;
        }
    }

    protected int generateRandomLevel() {
        int n = 0;
        while (n < this.myMaxLevel && Math.random() < (double)this.myProbability) {
            ++n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void insert(long var1_1, long var3_2) {
        var5_3 = new SkipListElement[this.myMaxLevel + 1];
        var6_4 = this.myHeader;
        var7_5 = this.myLevel;
        ** GOTO lbl10
        {
            var6_4 = var6_4.forward[var7_5];
            do {
                if (var6_4.forward[var7_5].key < var1_1) continue block0;
                var5_3[var7_5] = var6_4;
                --var7_5;
lbl10:
                // 2 sources

            } while (var7_5 >= 0);
        }
        var6_4 = var6_4.forward[0];
        if (var6_4.key == var1_1) {
            var6_4.value = var3_2;
        } else {
            var8_6 = this.generateRandomLevel();
            if (var8_6 > this.myLevel) {
                var9_7 = this.myLevel + 1;
                while (var9_7 <= var8_6) {
                    var5_3[var9_7] = this.myHeader;
                    ++var9_7;
                }
                this.myLevel = var8_6;
            }
            var6_4 = new SkipListElement(var8_6, var1_1, var3_2);
            ++this.myLength;
            var9_7 = 0;
            while (var9_7 <= var8_6) {
                var6_4.forward[var9_7] = var5_3[var9_7].forward[var9_7];
                var5_3[var9_7].forward[var9_7] = var6_4;
                var9_7 = (short)(var9_7 + 1);
            }
        }
    }

    public long search(long l) {
        SkipListElement skipListElement = this.myHeader;
        int n = this.myLevel;
        while (n >= 0) {
            SkipListElement skipListElement2 = skipListElement.forward[n];
            while (skipListElement2.key < l) {
                skipListElement = skipListElement2;
                skipListElement2 = skipListElement.forward[n];
            }
            --n;
        }
        skipListElement = skipListElement.forward[0];
        if (skipListElement.key == l) {
            return skipListElement.value;
        }
        return -1L;
    }

    public void delete(long l) {
        SkipListElement[] skipListElementArray = new SkipListElement[this.myMaxLevel + 1];
        SkipListElement skipListElement = this.myHeader;
        int n = this.myLevel;
        while (n >= 0) {
            SkipListElement skipListElement2 = skipListElement.forward[n];
            while (skipListElement2.key < l) {
                skipListElement = skipListElement2;
                skipListElement2 = skipListElement.forward[n];
            }
            skipListElementArray[n] = skipListElement;
            --n;
        }
        skipListElement = skipListElement.forward[0];
        if (skipListElement.key == l) {
            int n2 = 0;
            while (n2 <= this.myLevel) {
                if (skipListElementArray[n2].forward[n2] == skipListElement) {
                    skipListElementArray[n2].forward[n2] = skipListElement.forward[n2];
                }
                ++n2;
            }
            skipListElement = null;
            --this.myLength;
            while (this.myLevel > 0 && this.myHeader.forward[this.myLevel].key == Long.MAX_VALUE) {
                --this.myLevel;
            }
        }
    }

    public String toString() {
        String string = "";
        string = string + "SkipList:\n";
        string = string + "  probability = " + this.myProbability + "\n";
        string = string + "  level       = " + this.myLevel + "\n";
        string = string + "  max. level  = " + this.myMaxLevel + "\n";
        SkipListElement skipListElement = this.myHeader.forward[0];
        int[] nArray = new int[this.myMaxLevel + 1];
        while (skipListElement.key != Long.MAX_VALUE) {
            int n = skipListElement.getLevel();
            nArray[n] = nArray[n] + 1;
            skipListElement = skipListElement.forward[0];
        }
        int n = this.myMaxLevel;
        while (n >= 0) {
            string = string + "    Number of Elements at level " + n + " = " + nArray[n] + "\n";
            --n;
        }
        return string;
    }

    public String elementsToString() {
        String string = "Elements:\n";
        SkipListElement skipListElement = this.myHeader;
        while (skipListElement.key < Long.MAX_VALUE) {
            skipListElement = skipListElement.forward[0];
            string = string + skipListElement.toString() + "\n";
        }
        return string;
    }

    public int getLevel() {
        return this.myLevel;
    }

    public int getMaxLevel() {
        return this.myMaxLevel;
    }

    public float getProbability() {
        return this.myProbability;
    }

    public SkipListElement getHeader() {
        return this.myHeader;
    }

    public long getNthint(int n) {
        int n2 = n - 1;
        this.iter = this.myHeader.forward[0];
        while (n2 > 0) {
            if (this.iter.key == Long.MAX_VALUE) break;
            this.iter = this.iter.forward[0];
            --n2;
        }
        if (this.iter.key != Long.MAX_VALUE) {
            return this.iter.key;
        }
        return -1L;
    }

    public void reset() {
        this.iter = this.myHeader.forward[0];
    }

    public boolean step() {
        this.iter = this.iter.forward[0];
        return this.iter.key != Long.MAX_VALUE;
    }

    public long getkey() {
        if (this.iter.key != Long.MAX_VALUE) {
            return this.iter.key;
        }
        return -1L;
    }

    public long getvalue() {
        return this.iter.value;
    }

    public long findMAX(long l) {
        SkipListElement skipListElement = this.myHeader;
        int n = this.myHeader.getLevel();
        while (n >= 0) {
            SkipListElement skipListElement2 = skipListElement.forward[n];
            while (skipListElement2.key != Long.MAX_VALUE && skipListElement2.key < l) {
                skipListElement = skipListElement2;
                skipListElement2 = skipListElement.forward[n];
            }
            --n;
        }
        if (skipListElement.key != Long.MAX_VALUE) {
            long l2 = skipListElement.key;
            return l2 == (long)this.myMaxLevel ? (long)(-this.myMaxLevel) : l2;
        }
        return this.myMaxLevel;
    }

    public long searchAlt(long l) {
        SkipListElement skipListElement = this.myHeader;
        int n = this.myHeader.getLevel();
        while (n >= 0) {
            SkipListElement skipListElement2 = skipListElement.forward[n];
            while (skipListElement2.key != Long.MAX_VALUE && skipListElement2.key < l) {
                skipListElement = skipListElement2;
                skipListElement2 = skipListElement.forward[n];
            }
            --n;
        }
        skipListElement = skipListElement.forward[0];
        if (skipListElement.key != Long.MAX_VALUE && skipListElement.key == l) {
            return skipListElement.key;
        }
        return -1L;
    }

    public long findMIN(long l) {
        SkipListElement skipListElement = null;
        SkipListElement skipListElement2 = this.myHeader;
        int n = this.myHeader.getLevel();
        while (n >= 0) {
            skipListElement = skipListElement2.forward[n];
            while (skipListElement.key != Long.MAX_VALUE && skipListElement.key <= l) {
                skipListElement2 = skipListElement;
                skipListElement = skipListElement2.forward[n];
            }
            --n;
        }
        skipListElement2 = skipListElement;
        if (skipListElement2.key != Long.MAX_VALUE) {
            long l2 = skipListElement2.key;
            return l2 == (long)this.myMaxLevel ? (long)(-this.myMaxLevel) : l2;
        }
        return this.myMaxLevel;
    }

    public long search(long l, long l2) {
        SkipListElement skipListElement = this.myHeader;
        int n = this.myHeader.getLevel();
        while (n >= 0) {
            SkipListElement skipListElement2 = skipListElement.forward[n];
            while (skipListElement2.key != Long.MAX_VALUE && skipListElement2.key < l) {
                skipListElement = skipListElement2;
                skipListElement2 = skipListElement.forward[n];
            }
            --n;
        }
        skipListElement = skipListElement.forward[0];
        if (skipListElement.key != Long.MAX_VALUE && skipListElement.key == l) {
            if (l2 > 0L) {
                this.iter = skipListElement;
            }
            return skipListElement.key;
        }
        return -1L;
    }

    public void freeRange(long l, long l2) {
        SkipListElement skipListElement;
        SkipListElement skipListElement2 = this.myHeader;
        int n = this.myHeader.getLevel();
        while (n >= 0) {
            skipListElement = skipListElement2.forward[n];
            while (skipListElement.key != Long.MAX_VALUE && skipListElement.key < l) {
                skipListElement2 = skipListElement;
                skipListElement = skipListElement2.forward[n];
            }
            --n;
        }
        skipListElement2 = skipListElement2.forward[0];
        while (skipListElement2.key != Long.MAX_VALUE && skipListElement2.key <= l2) {
            skipListElement = skipListElement2.forward[0];
            this.delete(skipListElement2.key);
            skipListElement2 = skipListElement;
        }
    }

    public void stat() {
        int n = 0;
        SkipListElement skipListElement = this.myHeader;
        SkipListElement skipListElement2 = skipListElement.forward[0];
        System.out.println("Counting elements...");
        while (skipListElement2.key != Long.MAX_VALUE) {
            ++n;
            skipListElement = skipListElement2;
            skipListElement2 = skipListElement.forward[0];
        }
        System.out.println("Have number of elements ... " + n);
        System.out.println("Size ...................... " + this.myLength);
        int[] nArray = new int[20];
        int n2 = 0;
        while (n2 < 20) {
            nArray[n2] = 0;
            ++n2;
        }
        skipListElement = this.myHeader;
        n = 0;
        skipListElement2 = skipListElement.forward[0];
        while (skipListElement2.key != Long.MAX_VALUE) {
            ++n;
            int n3 = skipListElement2.getLevel();
            nArray[n3] = nArray[n3] + 1;
            skipListElement = skipListElement2;
            skipListElement2 = skipListElement.forward[0];
        }
        long l = this.myMaxLevel * n;
        long l2 = 0L;
        int n4 = 0;
        while (n4 < 20) {
            if (nArray[n4] > 0) {
                System.out.println(n4 + ": " + nArray[n4]);
            }
            l2 += (long)(nArray[n4] * (1 + n4));
            ++n4;
        }
        System.out.println("Used  pointers " + l2);
        System.out.println("Total pointers " + l + " efficiency = " + (double)l2 / (double)l);
        nArray = null;
    }

    public int getLength() {
        return this.myLength;
    }
}

