/*
 * This file is part of Siril, an astronomy image processor.
 * Copyright (C) 2005-2011 Francois Meyer (dulle at free.fr)
 * Copyright (C) 2012-2023 team free-astro (see more in AUTHORS file)
 * Reference site is https://free-astro.org/index.php/Siril
 *
 * Siril is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Siril is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Siril. If not, see <http://www.gnu.org/licenses/>.
 */

#include <criterion/criterion.h>
#include <gsl/gsl_matrix.h>

#include "core/siril.h"
#include "algos/PSF.h"
#include "algos/photometry.h"

cominfo com;	// the core data struct
guiinfo gui;	// the gui data struct
fits gfit;	// currently loaded image

static float star[] = {
		0.020432, 0.020981, 0.021347, 0.020569, 0.020035, 0.020706, 0.021164, 0.021103, 0.021057, 0.021057, 0.021057, 0.020294, 0.019760, 0.020127, 0.020386, 0.020417, 0.020432, 0.020798, 0.021057, 0.020539, 0.020172, 0.020447, 0.020630, 0.021103, 0.021424, 0.021454, 0.021469, 0.021118, 0.020890, 0.021485, 0.021881, 0.021332, 0.020966, 0.020737, 0.020569, 0.020890, 0.021118, 0.021057, 0.021012, 0.020356, 0.019913, 0.020508, 0.020920, 0.021027, 0.021088, 0.020890, 0.020752, 0.020035, 0.019547, 0.020020, 0.020340, 0.020493, 0.020600, 0.020676, 0.020737, 0.020966, 0.021134, 0.021118, 0.021103, 0.021469, 0.021714, 0.020859, 0.020264, 0.020386, 0.020478, 0.021088, 0.021500, 0.020890, 0.020462, 0.020188, 0.019989, 0.021027, 0.021744, 0.021576, 0.021454, 0.021881, 0.022187, 0.021683, 0.021332, 0.020966, 0.020722, 0.020706, 0.020691, 0.020752, 0.020783, 0.021057, 0.021241, 0.021210, 0.021195, 0.021241, 0.021271, 0.021256, 0.021256, 0.021790, 0.022156, 0.021759, 0.021500, 0.021195, 0.020996, 0.021149,
		0.020447, 0.020981, 0.021363, 0.020584, 0.020066, 0.020554, 0.020874, 0.020874, 0.020874, 0.020645, 0.020478, 0.020615, 0.020706, 0.020752, 0.020783, 0.020600, 0.020478, 0.020645, 0.020768, 0.020630, 0.020539, 0.020569, 0.020584, 0.020813, 0.020966, 0.020981, 0.021012, 0.021073, 0.021103, 0.020768, 0.020539, 0.020508, 0.020478, 0.021149, 0.021607, 0.022141, 0.022507, 0.021561, 0.020920, 0.020600, 0.020371, 0.020783, 0.021042, 0.020432, 0.020020, 0.020768, 0.021286, 0.020737, 0.020356, 0.020874, 0.021225, 0.021057, 0.020951, 0.020737, 0.020584, 0.020676, 0.020737, 0.021012, 0.021195, 0.021012, 0.020890, 0.020996, 0.021073, 0.020996, 0.020935, 0.021302, 0.021546, 0.020691, 0.020111, 0.020417, 0.020630, 0.020890, 0.021073, 0.020905, 0.020798, 0.020783, 0.020768, 0.020829, 0.020859, 0.020630, 0.020478, 0.020661, 0.020783, 0.020920, 0.021027, 0.021118, 0.021195, 0.021073, 0.020996, 0.020920, 0.020890, 0.021607, 0.022110, 0.022019, 0.021942, 0.021714, 0.021561, 0.021500, 0.021454, 0.021683,
		0.020447, 0.020996, 0.021363, 0.020600, 0.020066, 0.020523, 0.020829, 0.020844, 0.020844, 0.020569, 0.020371, 0.020676, 0.020890, 0.020874, 0.020859, 0.020645, 0.020493, 0.020615, 0.020706, 0.020645, 0.020615, 0.020600, 0.020584, 0.020752, 0.020874, 0.020905, 0.020920, 0.021057, 0.021149, 0.020645, 0.020294, 0.020356, 0.020386, 0.021225, 0.021805, 0.022370, 0.022766, 0.021668, 0.020905, 0.020645, 0.020462, 0.020829, 0.021073, 0.020325, 0.019821, 0.020752, 0.021378, 0.020859, 0.020508, 0.021027, 0.021393, 0.021164, 0.021012, 0.020737, 0.020554, 0.020615, 0.020661, 0.020981, 0.021210, 0.020935, 0.020737, 0.021027, 0.021225, 0.021103, 0.021027, 0.021332, 0.021546, 0.020661, 0.020050, 0.020462, 0.020752, 0.020874, 0.020951, 0.020783, 0.020676, 0.020569, 0.020508, 0.020661, 0.020768, 0.020569, 0.020432, 0.020645, 0.020798, 0.020966, 0.021073, 0.021134, 0.021180, 0.021042, 0.020951, 0.020874, 0.020813, 0.021668, 0.022263, 0.022049, 0.021912, 0.021714, 0.021576, 0.021546, 0.021530, 0.021790,
		0.020706, 0.020813, 0.020890, 0.020630, 0.020447, 0.020691, 0.020874, 0.021027, 0.021134, 0.020874, 0.020691, 0.020874, 0.020996, 0.020340, 0.019913, 0.020569, 0.021027, 0.021057, 0.021073, 0.020935, 0.020829, 0.020783, 0.020752, 0.020920, 0.021042, 0.020981, 0.020935, 0.020584, 0.020340, 0.020951, 0.021363, 0.021332, 0.021302, 0.021485, 0.021607, 0.021698, 0.021759, 0.021225, 0.020859, 0.021042, 0.021180, 0.021195, 0.021195, 0.020890, 0.020676, 0.020752, 0.020798, 0.020676, 0.020600, 0.020432, 0.020310, 0.020356, 0.020386, 0.020798, 0.021073, 0.020859, 0.020722, 0.020966, 0.021118, 0.021180, 0.021225, 0.020920, 0.020706, 0.020844, 0.020935, 0.021256, 0.021485, 0.020966, 0.020600, 0.021271, 0.021729, 0.020981, 0.020478, 0.020844, 0.021103, 0.020722, 0.020462, 0.020737, 0.020920, 0.020752, 0.020630, 0.021286, 0.021744, 0.021592, 0.021485, 0.021454, 0.021424, 0.021256, 0.021149, 0.020905, 0.020752, 0.020783, 0.020798, 0.021424, 0.021866, 0.021546, 0.021317, 0.021302, 0.021286, 0.021775,
		0.020752, 0.020783, 0.020798, 0.020630, 0.020523, 0.020737, 0.020874, 0.021057, 0.021180, 0.020920, 0.020752, 0.020905, 0.021012, 0.020249, 0.019730, 0.020569, 0.021134, 0.021134, 0.021134, 0.020981, 0.020874, 0.020813, 0.020783, 0.020951, 0.021073, 0.020996, 0.020935, 0.020493, 0.020188, 0.020996, 0.021561, 0.021500, 0.021469, 0.021530, 0.021576, 0.021576, 0.021576, 0.021149, 0.020844, 0.021118, 0.021317, 0.021256, 0.021225, 0.020996, 0.020829, 0.020752, 0.020691, 0.020645, 0.020615, 0.020310, 0.020111, 0.020218, 0.020279, 0.020798, 0.021164, 0.020905, 0.020737, 0.020951, 0.021103, 0.021225, 0.021317, 0.020905, 0.020615, 0.020798, 0.020920, 0.021241, 0.021469, 0.021012, 0.020706, 0.021424, 0.021912, 0.021012, 0.020386, 0.020859, 0.021180, 0.020752, 0.020447, 0.020752, 0.020951, 0.020783, 0.020661, 0.021408, 0.021912, 0.021698, 0.021561, 0.021500, 0.021469, 0.021302, 0.021180, 0.020920, 0.020737, 0.020615, 0.020523, 0.021317, 0.021851, 0.021500, 0.021271, 0.021256, 0.021241, 0.021759,
		0.021454, 0.021057, 0.020798, 0.020951, 0.021057, 0.020508, 0.020142, 0.020783, 0.021225, 0.021073, 0.020966, 0.020859, 0.020798, 0.020783, 0.020783, 0.021103, 0.021332, 0.021515, 0.021653, 0.021668, 0.021683, 0.021897, 0.022034, 0.021103, 0.020462, 0.020844, 0.021103, 0.021027, 0.020966, 0.021363, 0.021622, 0.021378, 0.021210, 0.021546, 0.021790, 0.021256, 0.020890, 0.020996, 0.021057, 0.020829, 0.020676, 0.021149, 0.021469, 0.021378, 0.021317, 0.021241, 0.021195, 0.020401, 0.019852, 0.020294, 0.020584, 0.020371, 0.020218, 0.020340, 0.020417, 0.020996, 0.021378, 0.020844, 0.020478, 0.021393, 0.022019, 0.021515, 0.021180, 0.021332, 0.021454, 0.021439, 0.021439, 0.021393, 0.021363, 0.021714, 0.021958, 0.020874, 0.020127, 0.020829, 0.021302, 0.021347, 0.021393, 0.021225, 0.021103, 0.020752, 0.020523, 0.020371, 0.020264, 0.020981, 0.021485, 0.020920, 0.020539, 0.020859, 0.021073, 0.021042, 0.021027, 0.021286, 0.021469, 0.021347, 0.021256, 0.021469, 0.021622, 0.021241, 0.020981, 0.021225,
		0.021576, 0.021118, 0.020798, 0.021012, 0.021164, 0.020478, 0.020005, 0.020722, 0.021225, 0.021103, 0.021012, 0.020859, 0.020752, 0.020890, 0.020981, 0.021210, 0.021363, 0.021592, 0.021744, 0.021805, 0.021836, 0.022095, 0.022263, 0.021134, 0.020356, 0.020813, 0.021134, 0.021118, 0.021118, 0.021424, 0.021637, 0.021363, 0.021164, 0.021561, 0.021820, 0.021195, 0.020768, 0.020966, 0.021103, 0.020783, 0.020554, 0.021118, 0.021515, 0.021454, 0.021408, 0.021332, 0.021286, 0.020356, 0.019715, 0.020279, 0.020676, 0.020401, 0.020203, 0.020249, 0.020279, 0.020996, 0.021500, 0.020813, 0.020356, 0.021408, 0.022141, 0.021637, 0.021286, 0.021439, 0.021546, 0.021485, 0.021439, 0.021469, 0.021485, 0.021759, 0.021958, 0.020844, 0.020081, 0.020829, 0.021332, 0.021469, 0.021561, 0.021302, 0.021134, 0.020752, 0.020493, 0.020172, 0.019959, 0.020859, 0.021469, 0.020813, 0.020371, 0.020783, 0.021057, 0.021073, 0.021073, 0.021424, 0.021653, 0.021347, 0.021149, 0.021469, 0.021683, 0.021241, 0.020935, 0.021118,
		0.021347, 0.021012, 0.020768, 0.020645, 0.020539, 0.020020, 0.019654, 0.020951, 0.021836, 0.021378, 0.021057, 0.021180, 0.021271, 0.021225, 0.021195, 0.021118, 0.021073, 0.020783, 0.020584, 0.020966, 0.021225, 0.021363, 0.021469, 0.021317, 0.021225, 0.021454, 0.021607, 0.021149, 0.020829, 0.020920, 0.020981, 0.020996, 0.021012, 0.021225, 0.021378, 0.021042, 0.020813, 0.021378, 0.021759, 0.021439, 0.021210, 0.021149, 0.021118, 0.021134, 0.021134, 0.021286, 0.021378, 0.020584, 0.020035, 0.020691, 0.021134, 0.020890, 0.020722, 0.020874, 0.020981, 0.021363, 0.021622, 0.021241, 0.020966, 0.020859, 0.020783, 0.021256, 0.021592, 0.021256, 0.021027, 0.020752, 0.020569, 0.021149, 0.021546, 0.021180, 0.020920, 0.021012, 0.021073, 0.020600, 0.020279, 0.021088, 0.021637, 0.020844, 0.020310, 0.020996, 0.021469, 0.020615, 0.020020, 0.020798, 0.021332, 0.021057, 0.020859, 0.021195, 0.021424, 0.020935, 0.020615, 0.020722, 0.020798, 0.021103, 0.021317, 0.021088, 0.020935, 0.021073, 0.021164, 0.021210,
		0.021302, 0.020981, 0.020768, 0.020569, 0.020432, 0.019928, 0.019593, 0.020981, 0.021942, 0.021424, 0.021073, 0.021241, 0.021363, 0.021286, 0.021241, 0.021103, 0.021012, 0.020630, 0.020371, 0.020813, 0.021118, 0.021241, 0.021317, 0.021347, 0.021378, 0.021561, 0.021698, 0.021149, 0.020768, 0.020829, 0.020859, 0.020935, 0.020981, 0.021164, 0.021302, 0.021012, 0.020813, 0.021454, 0.021881, 0.021561, 0.021332, 0.021164, 0.021042, 0.021073, 0.021088, 0.021271, 0.021393, 0.020630, 0.020096, 0.020768, 0.021225, 0.020981, 0.020813, 0.020981, 0.021103, 0.021424, 0.021653, 0.021317, 0.021088, 0.020752, 0.020523, 0.021195, 0.021653, 0.021225, 0.020935, 0.020615, 0.020401, 0.021088, 0.021561, 0.021057, 0.020722, 0.021042, 0.021256, 0.020554, 0.020081, 0.021012, 0.021653, 0.020768, 0.020157, 0.021042, 0.021653, 0.020691, 0.020035, 0.020783, 0.021302, 0.021088, 0.020951, 0.021271, 0.021485, 0.020920, 0.020523, 0.020600, 0.020645, 0.021057, 0.021347, 0.021027, 0.020798, 0.021042, 0.021210, 0.021225,
		0.020539, 0.020432, 0.020356, 0.020661, 0.020874, 0.020478, 0.020203, 0.020691, 0.021027, 0.021057, 0.021088, 0.021439, 0.021683, 0.020905, 0.020371, 0.020844, 0.021180, 0.020966, 0.020813, 0.021073, 0.021256, 0.021103, 0.021012, 0.020890, 0.020813, 0.020935, 0.021012, 0.020874, 0.020768, 0.020493, 0.020310, 0.020783, 0.021103, 0.021012, 0.020951, 0.020813, 0.020722, 0.021271, 0.021653, 0.021927, 0.022110, 0.021927, 0.021805, 0.021637, 0.021515, 0.021469, 0.021439, 0.021027, 0.020737, 0.020813, 0.020859, 0.020706, 0.020600, 0.021408, 0.021958, 0.021408, 0.021042, 0.020859, 0.020737, 0.021164, 0.021454, 0.020493, 0.019837, 0.020706, 0.021302, 0.021317, 0.021332, 0.021103, 0.020951, 0.020829, 0.020752, 0.020615, 0.020539, 0.021256, 0.021744, 0.021057, 0.020584, 0.020539, 0.020523, 0.020523, 0.020539, 0.020279, 0.020096, 0.020783, 0.021256, 0.020844, 0.020569, 0.020783, 0.020935, 0.020661, 0.020478, 0.020554, 0.020600, 0.020676, 0.020737, 0.020783, 0.020813, 0.021149, 0.021378, 0.020874,
		0.020401, 0.020325, 0.020279, 0.020676, 0.020951, 0.020584, 0.020325, 0.020645, 0.020859, 0.020996, 0.021088, 0.021485, 0.021744, 0.020829, 0.020203, 0.020798, 0.021210, 0.021027, 0.020890, 0.021118, 0.021286, 0.021088, 0.020951, 0.020813, 0.020706, 0.020813, 0.020890, 0.020813, 0.020768, 0.020432, 0.020203, 0.020752, 0.021134, 0.020996, 0.020890, 0.020783, 0.020706, 0.021241, 0.021607, 0.022004, 0.022263, 0.022080, 0.021942, 0.021729, 0.021592, 0.021500, 0.021439, 0.021088, 0.020859, 0.020813, 0.020783, 0.020661, 0.020569, 0.021485, 0.022110, 0.021408, 0.020935, 0.020783, 0.020676, 0.021241, 0.021622, 0.020356, 0.019501, 0.020600, 0.021363, 0.021439, 0.021500, 0.021103, 0.020844, 0.020783, 0.020752, 0.020539, 0.020401, 0.021378, 0.022049, 0.021057, 0.020386, 0.020508, 0.020584, 0.020432, 0.020325, 0.020203, 0.020111, 0.020783, 0.021241, 0.020798, 0.020493, 0.020691, 0.020829, 0.020615, 0.020478, 0.020539, 0.020584, 0.020615, 0.020630, 0.020737, 0.020813, 0.021164, 0.021408, 0.020813,
		0.021118, 0.021164, 0.021195, 0.021210, 0.021241, 0.020752, 0.020432, 0.020447, 0.020478, 0.021057, 0.021454, 0.021241, 0.021103, 0.021012, 0.020966, 0.020706, 0.020523, 0.020706, 0.020844, 0.020661, 0.020539, 0.020844, 0.021042, 0.020630, 0.020356, 0.020935, 0.021347, 0.021149, 0.021012, 0.020600, 0.020325, 0.020615, 0.020813, 0.021439, 0.021851, 0.020859, 0.020172, 0.020783, 0.021195, 0.021195, 0.021210, 0.021454, 0.021622, 0.021393, 0.021225, 0.021225, 0.021241, 0.021286, 0.021332, 0.021118, 0.020981, 0.021057, 0.021103, 0.020737, 0.020478, 0.020920, 0.021225, 0.020996, 0.020844, 0.020737, 0.020676, 0.020874, 0.021012, 0.021317, 0.021530, 0.021592, 0.021622, 0.021469, 0.021378, 0.020523, 0.019959, 0.020188, 0.020356, 0.020981, 0.021424, 0.021012, 0.020737, 0.020966, 0.021118, 0.021332, 0.021485, 0.021378, 0.021302, 0.021347, 0.021378, 0.020935, 0.020615, 0.020478, 0.020386, 0.020645, 0.020813, 0.020722, 0.020645, 0.020706, 0.020737, 0.020569, 0.020447, 0.020508, 0.020539, 0.020752,
		0.021256, 0.021317, 0.021363, 0.021317, 0.021286, 0.020783, 0.020447, 0.020417, 0.020401, 0.021073, 0.021530, 0.021210, 0.020981, 0.021057, 0.021103, 0.020691, 0.020401, 0.020661, 0.020829, 0.020569, 0.020401, 0.020798, 0.021057, 0.020600, 0.020294, 0.020966, 0.021424, 0.021210, 0.021057, 0.020630, 0.020340, 0.020584, 0.020752, 0.021515, 0.022034, 0.020859, 0.020066, 0.020691, 0.021118, 0.021057, 0.021012, 0.021332, 0.021561, 0.021332, 0.021164, 0.021180, 0.021195, 0.021332, 0.021424, 0.021180, 0.021012, 0.021134, 0.021210, 0.020600, 0.020172, 0.020829, 0.021271, 0.021042, 0.020874, 0.020645, 0.020493, 0.020966, 0.021286, 0.021454, 0.021561, 0.021622, 0.021653, 0.021546, 0.021469, 0.020478, 0.019806, 0.020127, 0.020340, 0.020905, 0.021302, 0.020996, 0.020798, 0.021042, 0.021210, 0.021500, 0.021698, 0.021592, 0.021530, 0.021454, 0.021408, 0.020951, 0.020645, 0.020447, 0.020310, 0.020645, 0.020874, 0.020752, 0.020661, 0.020722, 0.020752, 0.020539, 0.020386, 0.020386, 0.020386, 0.020752,
		0.021180, 0.020920, 0.020752, 0.021424, 0.021897, 0.021530, 0.021271, 0.020523, 0.020005, 0.020523, 0.020890, 0.020874, 0.020874, 0.020874, 0.020890, 0.020478, 0.020203, 0.020371, 0.020493, 0.020554, 0.020600, 0.020981, 0.021225, 0.021225, 0.021241, 0.021118, 0.021042, 0.021286, 0.021454, 0.020996, 0.020691, 0.020737, 0.020768, 0.021195, 0.021485, 0.020798, 0.020325, 0.020325, 0.020325, 0.020600, 0.020798, 0.021088, 0.021271, 0.021454, 0.021561, 0.021347, 0.021210, 0.021134, 0.021073, 0.020981, 0.020920, 0.021515, 0.021927, 0.021454, 0.021134, 0.020798, 0.020569, 0.020905, 0.021134, 0.021393, 0.021561, 0.021149, 0.020859, 0.020752, 0.020676, 0.020691, 0.020706, 0.021225, 0.021576, 0.020966, 0.020539, 0.021103, 0.021485, 0.020691, 0.020157, 0.020462, 0.020676, 0.020615, 0.020584, 0.021027, 0.021332, 0.020920, 0.020630, 0.020859, 0.021027, 0.020768, 0.020584, 0.020676, 0.020737, 0.020829, 0.020905, 0.020737, 0.020615, 0.020493, 0.020401, 0.020356, 0.020325, 0.020447, 0.020539, 0.020569,
		0.021164, 0.020844, 0.020630, 0.021439, 0.022004, 0.021653, 0.021424, 0.020539, 0.019928, 0.020432, 0.020768, 0.020829, 0.020859, 0.020844, 0.020844, 0.020432, 0.020157, 0.020325, 0.020432, 0.020554, 0.020645, 0.021012, 0.021256, 0.021347, 0.021408, 0.021149, 0.020966, 0.021302, 0.021530, 0.021073, 0.020752, 0.020768, 0.020768, 0.021134, 0.021378, 0.020783, 0.020371, 0.020249, 0.020172, 0.020523, 0.020752, 0.021027, 0.021225, 0.021469, 0.021637, 0.021378, 0.021210, 0.021088, 0.021012, 0.020951, 0.020905, 0.021592, 0.022065, 0.021622, 0.021317, 0.020798, 0.020432, 0.020874, 0.021180, 0.021530, 0.021759, 0.021180, 0.020783, 0.020615, 0.020508, 0.020523, 0.020523, 0.021164, 0.021592, 0.021042, 0.020676, 0.021286, 0.021698, 0.020661, 0.019944, 0.020356, 0.020645, 0.020539, 0.020462, 0.020935, 0.021271, 0.020798, 0.020462, 0.020752, 0.020951, 0.020722, 0.020569, 0.020722, 0.020813, 0.020874, 0.020905, 0.020737, 0.020615, 0.020447, 0.020340, 0.020325, 0.020310, 0.020462, 0.020569, 0.020539,
		0.021622, 0.021546, 0.021500, 0.021286, 0.021134, 0.020981, 0.020890, 0.020371, 0.020035, 0.020279, 0.020462, 0.020752, 0.020966, 0.020920, 0.020890, 0.020539, 0.020279, 0.020783, 0.021118, 0.020783, 0.020554, 0.020661, 0.020722, 0.020935, 0.021073, 0.020951, 0.020874, 0.021241, 0.021485, 0.021210, 0.021027, 0.020981, 0.020951, 0.020752, 0.020615, 0.020645, 0.020661, 0.020874, 0.021042, 0.020722, 0.020508, 0.020630, 0.020722, 0.020874, 0.020981, 0.020752, 0.020600, 0.020874, 0.021057, 0.021561, 0.021897, 0.020951, 0.020310, 0.020584, 0.020768, 0.020996, 0.021164, 0.020798, 0.020554, 0.020752, 0.020890, 0.020569, 0.020356, 0.020218, 0.020142, 0.020584, 0.020890, 0.020996, 0.021073, 0.021149, 0.021210, 0.021408, 0.021561, 0.020951, 0.020554, 0.021241, 0.021714, 0.020920, 0.020386, 0.021286, 0.021912, 0.021057, 0.020462, 0.020386, 0.020325, 0.020554, 0.020691, 0.021118, 0.021408, 0.021164, 0.020996, 0.021027, 0.021042, 0.021103, 0.021134, 0.021241, 0.021317, 0.020417, 0.019791, 0.020493,
		0.021698, 0.021668, 0.021653, 0.021256, 0.020981, 0.020859, 0.020783, 0.020356, 0.020050, 0.020264, 0.020401, 0.020752, 0.020981, 0.020935, 0.020905, 0.020554, 0.020310, 0.020859, 0.021241, 0.020829, 0.020539, 0.020600, 0.020630, 0.020859, 0.021012, 0.020920, 0.020859, 0.021225, 0.021469, 0.021241, 0.021073, 0.021012, 0.020981, 0.020676, 0.020478, 0.020615, 0.020706, 0.020996, 0.021195, 0.020752, 0.020462, 0.020569, 0.020630, 0.020768, 0.020859, 0.020645, 0.020493, 0.020844, 0.021073, 0.021668, 0.022080, 0.020844, 0.019989, 0.020386, 0.020661, 0.021042, 0.021302, 0.020783, 0.020432, 0.020600, 0.020722, 0.020462, 0.020279, 0.020157, 0.020066, 0.020584, 0.020951, 0.020966, 0.020981, 0.021164, 0.021302, 0.021439, 0.021530, 0.021012, 0.020661, 0.021408, 0.021912, 0.020996, 0.020371, 0.021363, 0.022034, 0.021103, 0.020462, 0.020325, 0.020218, 0.020523, 0.020722, 0.021195, 0.021515, 0.021210, 0.021012, 0.021073, 0.021118, 0.021225, 0.021286, 0.021408, 0.021500, 0.020401, 0.019654, 0.020493,
		0.020584, 0.020539, 0.020523, 0.020859, 0.021088, 0.020569, 0.020233, 0.021088, 0.021683, 0.021012, 0.020554, 0.020706, 0.020813, 0.020691, 0.020615, 0.021042, 0.021332, 0.021012, 0.020783, 0.021378, 0.021790, 0.021286, 0.020951, 0.020920, 0.020905, 0.021042, 0.021149, 0.021134, 0.021134, 0.021393, 0.021576, 0.021210, 0.020966, 0.021027, 0.021057, 0.021134, 0.021180, 0.021241, 0.021286, 0.021027, 0.020859, 0.021088, 0.021241, 0.021317, 0.021363, 0.021073, 0.020859, 0.021118, 0.021271, 0.021317, 0.021332, 0.021286, 0.021256, 0.020661, 0.020249, 0.020722, 0.021042, 0.021134, 0.021195, 0.020523, 0.020066, 0.020600, 0.020966, 0.020935, 0.020935, 0.021027, 0.021088, 0.020737, 0.020493, 0.021225, 0.021744, 0.021027, 0.020539, 0.020249, 0.020050, 0.020935, 0.021546, 0.021012, 0.020645, 0.020966, 0.021195, 0.020737, 0.020417, 0.019974, 0.019684, 0.020493, 0.021057, 0.020981, 0.020935, 0.020600, 0.020371, 0.021118, 0.021622, 0.021210, 0.020920, 0.020844, 0.020798, 0.020447, 0.020218, 0.020478,
		0.020371, 0.020340, 0.020310, 0.020783, 0.021103, 0.020523, 0.020127, 0.021225, 0.021988, 0.021149, 0.020584, 0.020706, 0.020783, 0.020645, 0.020554, 0.021118, 0.021515, 0.021042, 0.020706, 0.021485, 0.022019, 0.021424, 0.021012, 0.020935, 0.020890, 0.021073, 0.021195, 0.021118, 0.021073, 0.021424, 0.021668, 0.021256, 0.020966, 0.021088, 0.021164, 0.021225, 0.021271, 0.021286, 0.021302, 0.021088, 0.020935, 0.021180, 0.021347, 0.021408, 0.021454, 0.021149, 0.020935, 0.021164, 0.021317, 0.021241, 0.021195, 0.021363, 0.021485, 0.020706, 0.020172, 0.020661, 0.020996, 0.021195, 0.021332, 0.020508, 0.019944, 0.020630, 0.021088, 0.021088, 0.021088, 0.021103, 0.021118, 0.020691, 0.020401, 0.021241, 0.021820, 0.020951, 0.020356, 0.020111, 0.019944, 0.020844, 0.021469, 0.021012, 0.020691, 0.020905, 0.021042, 0.020661, 0.020401, 0.019913, 0.019577, 0.020493, 0.021118, 0.020951, 0.020829, 0.020478, 0.020249, 0.021118, 0.021714, 0.021210, 0.020859, 0.020737, 0.020661, 0.020462, 0.020325, 0.020478,
		0.020874, 0.021164, 0.021347, 0.021134, 0.020981, 0.020478, 0.020127, 0.020645, 0.021012, 0.020951, 0.020920, 0.021042, 0.021118, 0.020813, 0.020600, 0.020539, 0.020493, 0.020722, 0.020890, 0.020996, 0.021073, 0.020874, 0.020737, 0.020691, 0.020661, 0.020539, 0.020462, 0.021164, 0.021653, 0.021469, 0.021332, 0.021088, 0.020920, 0.021088, 0.021210, 0.021103, 0.021012, 0.021012, 0.021012, 0.020981, 0.020966, 0.021057, 0.021134, 0.021256, 0.021332, 0.021073, 0.020890, 0.020966, 0.021027, 0.021088, 0.021149, 0.021195, 0.021225, 0.020783, 0.020462, 0.020768, 0.020981, 0.020722, 0.020539, 0.020310, 0.020157, 0.020294, 0.020386, 0.020813, 0.021118, 0.021271, 0.021378, 0.021057, 0.020844, 0.020829, 0.020813, 0.020844, 0.020859, 0.020569, 0.020371, 0.020905, 0.021271, 0.021241, 0.021210, 0.021408, 0.021561, 0.021118, 0.020813, 0.020523, 0.020325, 0.020691, 0.020951, 0.021134, 0.021271, 0.021256, 0.021256, 0.021241, 0.021225, 0.020661, 0.020264, 0.020691, 0.020981, 0.020722, 0.020539, 0.021118,
		0.020966, 0.021317, 0.021546, 0.021195, 0.020966, 0.020462, 0.020127, 0.020539, 0.020829, 0.020920, 0.020981, 0.021103, 0.021180, 0.020829, 0.020600, 0.020432, 0.020310, 0.020676, 0.020920, 0.020905, 0.020890, 0.020768, 0.020691, 0.020645, 0.020615, 0.020447, 0.020325, 0.021180, 0.021759, 0.021469, 0.021271, 0.021057, 0.020905, 0.021088, 0.021225, 0.021073, 0.020966, 0.020951, 0.020951, 0.020966, 0.020966, 0.021042, 0.021088, 0.021225, 0.021317, 0.021057, 0.020890, 0.020935, 0.020966, 0.021073, 0.021134, 0.021164, 0.021180, 0.020783, 0.020523, 0.020798, 0.020981, 0.020630, 0.020386, 0.020279, 0.020203, 0.020233, 0.020249, 0.020768, 0.021118, 0.021302, 0.021424, 0.021118, 0.020920, 0.020752, 0.020630, 0.020813, 0.020951, 0.020645, 0.020447, 0.020920, 0.021241, 0.021271, 0.021302, 0.021515, 0.021653, 0.021195, 0.020890, 0.020630, 0.020462, 0.020737, 0.020920, 0.021180, 0.021347, 0.021408, 0.021439, 0.021256, 0.021134, 0.020554, 0.020157, 0.020676, 0.021042, 0.020768, 0.020584, 0.021241,
		0.021424, 0.021195, 0.021042, 0.021180, 0.021271, 0.020722, 0.020325, 0.020981, 0.021439, 0.020966, 0.020645, 0.020890, 0.021057, 0.021042, 0.021027, 0.021164, 0.021256, 0.021317, 0.021378, 0.021210, 0.021088, 0.020722, 0.020478, 0.021149, 0.021607, 0.021485, 0.021393, 0.021836, 0.022126, 0.021561, 0.021164, 0.020722, 0.020432, 0.020829, 0.021103, 0.020859, 0.020676, 0.020661, 0.020661, 0.020981, 0.021210, 0.020661, 0.020294, 0.021271, 0.021942, 0.021332, 0.020920, 0.021225, 0.021424, 0.020874, 0.020493, 0.020584, 0.020645, 0.021469, 0.022049, 0.021592, 0.021286, 0.020813, 0.020493, 0.020996, 0.021347, 0.020798, 0.020417, 0.020996, 0.021408, 0.021622, 0.021790, 0.021118, 0.020661, 0.020874, 0.021012, 0.020432, 0.020035, 0.020188, 0.020279, 0.020508, 0.020661, 0.020661, 0.020661, 0.020722, 0.020783, 0.021073, 0.021271, 0.021088, 0.020966, 0.021118, 0.021225, 0.020966, 0.020798, 0.020737, 0.020691, 0.020935, 0.021103, 0.021134, 0.021164, 0.020615, 0.020233, 0.020218, 0.020203, 0.021271,
		0.021500, 0.021180, 0.020951, 0.021180, 0.021332, 0.020768, 0.020371, 0.021073, 0.021546, 0.020981, 0.020584, 0.020859, 0.021042, 0.021073, 0.021103, 0.021286, 0.021424, 0.021439, 0.021454, 0.021271, 0.021134, 0.020722, 0.020432, 0.021241, 0.021790, 0.021668, 0.021592, 0.021958, 0.022202, 0.021576, 0.021149, 0.020676, 0.020340, 0.020783, 0.021088, 0.020813, 0.020630, 0.020615, 0.020600, 0.020996, 0.021256, 0.020600, 0.020142, 0.021286, 0.022065, 0.021378, 0.020920, 0.021271, 0.021515, 0.020829, 0.020371, 0.020478, 0.020539, 0.021592, 0.022324, 0.021744, 0.021347, 0.020844, 0.020508, 0.021134, 0.021561, 0.020905, 0.020447, 0.021042, 0.021454, 0.021683, 0.021851, 0.021118, 0.020615, 0.020890, 0.021088, 0.020356, 0.019867, 0.020096, 0.020249, 0.020432, 0.020554, 0.020539, 0.020539, 0.020584, 0.020615, 0.021057, 0.021347, 0.021180, 0.021057, 0.021195, 0.021286, 0.020935, 0.020691, 0.020615, 0.020554, 0.020874, 0.021103, 0.021241, 0.021347, 0.020600, 0.020081, 0.020111, 0.020127, 0.021271,
		0.021790, 0.021164, 0.020752, 0.020813, 0.020859, 0.020554, 0.020340, 0.020706, 0.020951, 0.021180, 0.021332, 0.020829, 0.020478, 0.020813, 0.021057, 0.020844, 0.020706, 0.021088, 0.021363, 0.021332, 0.021317, 0.021836, 0.022187, 0.021332, 0.020752, 0.020645, 0.020569, 0.020676, 0.020752, 0.020645, 0.020584, 0.020706, 0.020798, 0.020798, 0.020798, 0.021195, 0.021485, 0.021180, 0.020966, 0.021134, 0.021256, 0.020920, 0.020676, 0.020996, 0.021210, 0.021012, 0.020874, 0.020829, 0.020813, 0.021408, 0.021820, 0.021180, 0.020752, 0.021241, 0.021576, 0.021225, 0.020981, 0.020966, 0.020966, 0.020981, 0.020996, 0.020829, 0.020722, 0.021164, 0.021469, 0.020981, 0.020661, 0.020172, 0.019852, 0.020508, 0.020951, 0.021180, 0.021347, 0.020752, 0.020340, 0.020356, 0.020356, 0.020874, 0.021225, 0.020798, 0.020493, 0.020600, 0.020661, 0.021027, 0.021271, 0.021378, 0.021454, 0.021027, 0.020737, 0.020249, 0.019928, 0.020356, 0.020645, 0.021180, 0.021546, 0.021118, 0.020844, 0.020813, 0.020783, 0.020676,
		0.021836, 0.021164, 0.020706, 0.020737, 0.020768, 0.020508, 0.020340, 0.020645, 0.020844, 0.021210, 0.021469, 0.020813, 0.020371, 0.020768, 0.021042, 0.020768, 0.020569, 0.021027, 0.021347, 0.021347, 0.021347, 0.022034, 0.022507, 0.021347, 0.020554, 0.020447, 0.020386, 0.020447, 0.020478, 0.020478, 0.020478, 0.020706, 0.020874, 0.020798, 0.020737, 0.021271, 0.021637, 0.021286, 0.021042, 0.021164, 0.021256, 0.020981, 0.020783, 0.020951, 0.021057, 0.020935, 0.020859, 0.020752, 0.020676, 0.021515, 0.022080, 0.021317, 0.020783, 0.021180, 0.021439, 0.021118, 0.020905, 0.020996, 0.021057, 0.020951, 0.020890, 0.020813, 0.020768, 0.021180, 0.021469, 0.020859, 0.020432, 0.020005, 0.019715, 0.020432, 0.020920, 0.021332, 0.021622, 0.020874, 0.020356, 0.020340, 0.020325, 0.020935, 0.021347, 0.020829, 0.020478, 0.020508, 0.020539, 0.020996, 0.021317, 0.021424, 0.021485, 0.021057, 0.020752, 0.020188, 0.019806, 0.020249, 0.020554, 0.021164, 0.021576, 0.021225, 0.020981, 0.020935, 0.020905, 0.020569,
		0.020478, 0.020661, 0.020798, 0.020798, 0.020813, 0.020905, 0.020981, 0.020920, 0.020874, 0.021164, 0.021363, 0.020829, 0.020447, 0.020798, 0.021042, 0.020768, 0.020584, 0.021088, 0.021424, 0.021592, 0.021698, 0.021790, 0.021851, 0.021485, 0.021225, 0.021057, 0.020935, 0.021073, 0.021164, 0.020996, 0.020874, 0.021073, 0.021195, 0.020935, 0.020768, 0.021103, 0.021347, 0.021225, 0.021149, 0.021424, 0.021607, 0.021286, 0.021073, 0.020935, 0.020829, 0.020829, 0.020829, 0.021103, 0.021302, 0.021454, 0.021546, 0.020859, 0.020401, 0.021057, 0.021500, 0.020935, 0.020554, 0.021134, 0.021530, 0.021332, 0.021180, 0.020874, 0.020645, 0.021088, 0.021378, 0.021103, 0.020920, 0.020920, 0.020905, 0.020691, 0.020539, 0.020966, 0.021256, 0.021057, 0.020920, 0.020920, 0.020920, 0.021347, 0.021637, 0.021073, 0.020691, 0.020630, 0.020600, 0.020645, 0.020691, 0.020829, 0.020935, 0.020905, 0.020874, 0.020661, 0.020508, 0.020920, 0.021195, 0.020890, 0.020676, 0.020859, 0.020996, 0.020493, 0.020157, 0.019928,
		0.020218, 0.020569, 0.020813, 0.020813, 0.020813, 0.020981, 0.021103, 0.020966, 0.020874, 0.021149, 0.021347, 0.020829, 0.020462, 0.020813, 0.021042, 0.020768, 0.020584, 0.021088, 0.021439, 0.021622, 0.021759, 0.021744, 0.021729, 0.021500, 0.021347, 0.021164, 0.021042, 0.021180, 0.021286, 0.021088, 0.020951, 0.021134, 0.021256, 0.020966, 0.020768, 0.021073, 0.021286, 0.021210, 0.021164, 0.021469, 0.021668, 0.021347, 0.021134, 0.020920, 0.020783, 0.020813, 0.020829, 0.021180, 0.021408, 0.021439, 0.021454, 0.020783, 0.020325, 0.021027, 0.021515, 0.020905, 0.020493, 0.021164, 0.021622, 0.021393, 0.021241, 0.020874, 0.020630, 0.021057, 0.021363, 0.021149, 0.021012, 0.021088, 0.021134, 0.020737, 0.020462, 0.020905, 0.021195, 0.021088, 0.021027, 0.021027, 0.021027, 0.021424, 0.021683, 0.021118, 0.020722, 0.020661, 0.020615, 0.020584, 0.020569, 0.020722, 0.020829, 0.020874, 0.020905, 0.020737, 0.020630, 0.021042, 0.021317, 0.020844, 0.020508, 0.020798, 0.020996, 0.020417, 0.020020, 0.019806,
		0.020752, 0.021088, 0.021317, 0.021012, 0.020813, 0.020584, 0.020432, 0.020371, 0.020325, 0.021225, 0.021851, 0.021073, 0.020554, 0.020569, 0.020584, 0.020401, 0.020294, 0.021057, 0.021576, 0.021149, 0.020859, 0.021393, 0.021775, 0.021530, 0.021378, 0.021225, 0.021118, 0.021149, 0.021164, 0.021057, 0.020981, 0.020874, 0.020798, 0.021088, 0.021302, 0.021225, 0.021180, 0.021134, 0.021088, 0.020493, 0.020096, 0.020600, 0.020935, 0.021530, 0.021927, 0.021378, 0.021012, 0.021103, 0.021164, 0.021210, 0.021241, 0.021164, 0.021103, 0.021271, 0.021393, 0.021180, 0.021042, 0.020768, 0.020584, 0.020722, 0.020813, 0.020798, 0.020798, 0.020615, 0.020493, 0.021027, 0.021393, 0.021286, 0.021210, 0.021042, 0.020935, 0.020905, 0.020890, 0.020966, 0.021027, 0.020859, 0.020752, 0.021637, 0.022232, 0.021576, 0.021118, 0.020966, 0.020874, 0.020844, 0.020829, 0.020890, 0.020951, 0.021210, 0.021393, 0.021393, 0.021408, 0.021515, 0.021592, 0.020874, 0.020386, 0.020432, 0.020462, 0.020768, 0.020966, 0.020264,
		0.020844, 0.021180, 0.021408, 0.021057, 0.020813, 0.020508, 0.020310, 0.020249, 0.020218, 0.021241, 0.021942, 0.021134, 0.020569, 0.020523, 0.020493, 0.020340, 0.020233, 0.021042, 0.021607, 0.021057, 0.020691, 0.021332, 0.021775, 0.021546, 0.021378, 0.021241, 0.021134, 0.021149, 0.021149, 0.021042, 0.020981, 0.020813, 0.020706, 0.021118, 0.021393, 0.021256, 0.021164, 0.021103, 0.021073, 0.020325, 0.019806, 0.020462, 0.020905, 0.021637, 0.022141, 0.021485, 0.021042, 0.021088, 0.021118, 0.021180, 0.021210, 0.021241, 0.021256, 0.021317, 0.021363, 0.021241, 0.021149, 0.020691, 0.020386, 0.020600, 0.020737, 0.020798, 0.020829, 0.020523, 0.020325, 0.021012, 0.021469, 0.021332, 0.021225, 0.021103, 0.021027, 0.020905, 0.020829, 0.020951, 0.021027, 0.020844, 0.020706, 0.021683, 0.022339, 0.021653, 0.021195, 0.021027, 0.020920, 0.020890, 0.020874, 0.020935, 0.020966, 0.021271, 0.021485, 0.021515, 0.021546, 0.021607, 0.021637, 0.020874, 0.020356, 0.020356, 0.020356, 0.020829, 0.021149, 0.020356,
		0.021073, 0.020996, 0.020935, 0.020432, 0.020081, 0.020523, 0.020844, 0.020859, 0.020874, 0.020874, 0.020890, 0.020569, 0.020356, 0.020615, 0.020783, 0.020829, 0.020844, 0.020859, 0.020874, 0.021134, 0.021302, 0.020371, 0.019745, 0.020554, 0.021103, 0.020768, 0.020523, 0.020661, 0.020752, 0.020813, 0.020859, 0.020691, 0.020569, 0.021103, 0.021469, 0.021195, 0.020996, 0.021500, 0.021836, 0.020859, 0.020188, 0.020737, 0.021103, 0.021088, 0.021088, 0.020462, 0.020035, 0.020798, 0.021317, 0.021088, 0.020920, 0.020737, 0.020600, 0.021027, 0.021317, 0.020905, 0.020615, 0.021256, 0.021683, 0.021256, 0.020951, 0.020661, 0.020462, 0.020874, 0.021164, 0.021378, 0.021515, 0.021500, 0.021500, 0.021271, 0.021134, 0.021027, 0.020951, 0.021012, 0.021073, 0.020661, 0.020371, 0.020523, 0.020630, 0.020981, 0.021225, 0.021393, 0.021500, 0.020951, 0.020584, 0.021057, 0.021378, 0.021378, 0.021378, 0.021683, 0.021881, 0.021225, 0.020768, 0.020600, 0.020478, 0.020691, 0.020829, 0.020935, 0.021012, 0.020920,
		0.021118, 0.020951, 0.020844, 0.020310, 0.019944, 0.020539, 0.020935, 0.020966, 0.020996, 0.020813, 0.020691, 0.020478, 0.020325, 0.020630, 0.020844, 0.020920, 0.020966, 0.020829, 0.020737, 0.021149, 0.021424, 0.020203, 0.019364, 0.020371, 0.021057, 0.020676, 0.020417, 0.020569, 0.020676, 0.020783, 0.020844, 0.020661, 0.020539, 0.021103, 0.021485, 0.021180, 0.020966, 0.021561, 0.021973, 0.020966, 0.020264, 0.020783, 0.021134, 0.020996, 0.020890, 0.020279, 0.019852, 0.020737, 0.021347, 0.021073, 0.020874, 0.020645, 0.020478, 0.020981, 0.021317, 0.020844, 0.020523, 0.021363, 0.021927, 0.021378, 0.020996, 0.020630, 0.020386, 0.020935, 0.021317, 0.021439, 0.021530, 0.021546, 0.021546, 0.021317, 0.021149, 0.021042, 0.020966, 0.021027, 0.021073, 0.020615, 0.020310, 0.020310, 0.020310, 0.020859, 0.021225, 0.021454, 0.021607, 0.020966, 0.020523, 0.021073, 0.021454, 0.021393, 0.021363, 0.021714, 0.021942, 0.021149, 0.020615, 0.020554, 0.020508, 0.020752, 0.020920, 0.020951, 0.020981, 0.021012,
		0.020676, 0.020325, 0.020081, 0.020294, 0.020447, 0.020371, 0.020325, 0.020752, 0.021042, 0.020783, 0.020600, 0.020768, 0.020874, 0.021057, 0.021195, 0.020829, 0.020600, 0.020890, 0.021088, 0.020996, 0.020935, 0.020630, 0.020432, 0.020890, 0.021195, 0.021180, 0.021164, 0.020737, 0.020462, 0.020630, 0.020737, 0.021027, 0.021241, 0.021271, 0.021286, 0.021103, 0.020966, 0.021012, 0.021027, 0.021134, 0.021210, 0.021210, 0.021210, 0.021180, 0.021164, 0.021271, 0.021347, 0.021256, 0.021195, 0.021195, 0.021195, 0.020798, 0.020523, 0.021241, 0.021714, 0.021256, 0.020935, 0.020905, 0.020890, 0.020890, 0.020874, 0.021607, 0.022095, 0.021195, 0.020569, 0.020706, 0.020798, 0.020630, 0.020508, 0.021057, 0.021439, 0.021164, 0.020981, 0.020798, 0.020676, 0.021164, 0.021500, 0.021195, 0.020981, 0.020829, 0.020722, 0.021057, 0.021302, 0.020783, 0.020417, 0.020935, 0.021286, 0.020935, 0.020691, 0.020615, 0.020569, 0.020829, 0.020996, 0.020783, 0.020630, 0.020661, 0.020676, 0.020554, 0.020462, 0.020844,
		0.020600, 0.020203, 0.019944, 0.020294, 0.020539, 0.020356, 0.020218, 0.020706, 0.021042, 0.020768, 0.020584, 0.020813, 0.020981, 0.021149, 0.021256, 0.020813, 0.020523, 0.020890, 0.021149, 0.020966, 0.020844, 0.020722, 0.020630, 0.020981, 0.021225, 0.021271, 0.021302, 0.020783, 0.020417, 0.020600, 0.020722, 0.021103, 0.021363, 0.021302, 0.021256, 0.021088, 0.020966, 0.020905, 0.020859, 0.021164, 0.021378, 0.021286, 0.021225, 0.021210, 0.021210, 0.021454, 0.021622, 0.021347, 0.021164, 0.021225, 0.021256, 0.020829, 0.020539, 0.021286, 0.021790, 0.021332, 0.021012, 0.020829, 0.020691, 0.020798, 0.020859, 0.021790, 0.022416, 0.021241, 0.020432, 0.020569, 0.020661, 0.020462, 0.020325, 0.021012, 0.021485, 0.021180, 0.020981, 0.020752, 0.020600, 0.021271, 0.021729, 0.021363, 0.021103, 0.020829, 0.020630, 0.020996, 0.021241, 0.020737, 0.020401, 0.020905, 0.021256, 0.020844, 0.020569, 0.020417, 0.020310, 0.020768, 0.021073, 0.020829, 0.020661, 0.020645, 0.020630, 0.020478, 0.020371, 0.020813,
		0.020493, 0.020691, 0.020813, 0.020706, 0.020645, 0.020630, 0.020615, 0.020935, 0.021164, 0.020813, 0.020584, 0.020584, 0.020600, 0.020264, 0.020035, 0.020737, 0.021225, 0.021149, 0.021103, 0.020310, 0.019760, 0.020508, 0.021027, 0.021378, 0.021607, 0.021012, 0.020600, 0.020905, 0.021118, 0.020600, 0.020249, 0.020905, 0.021363, 0.021149, 0.021012, 0.020752, 0.020584, 0.020783, 0.020920, 0.021027, 0.021088, 0.021622, 0.021973, 0.021469, 0.021134, 0.020874, 0.020706, 0.021469, 0.021988, 0.021302, 0.020829, 0.021149, 0.021363, 0.021210, 0.021103, 0.021622, 0.021958, 0.021317, 0.020874, 0.021424, 0.021805, 0.020844, 0.020188, 0.020768, 0.021164, 0.021378, 0.021530, 0.020981, 0.020615, 0.021103, 0.021439, 0.021210, 0.021057, 0.021149, 0.021210, 0.021454, 0.021622, 0.021317, 0.021118, 0.020294, 0.019745, 0.020218, 0.020539, 0.020691, 0.020798, 0.021088, 0.021286, 0.020935, 0.020691, 0.020783, 0.020844, 0.020584, 0.020386, 0.020462, 0.020508, 0.020569, 0.020615, 0.021057, 0.021347, 0.021378,
		0.020478, 0.020783, 0.020981, 0.020798, 0.020661, 0.020676, 0.020691, 0.020981, 0.021180, 0.020829, 0.020584, 0.020554, 0.020523, 0.020096, 0.019806, 0.020737, 0.021363, 0.021195, 0.021088, 0.020188, 0.019562, 0.020478, 0.021103, 0.021454, 0.021683, 0.020966, 0.020478, 0.020935, 0.021241, 0.020600, 0.020157, 0.020874, 0.021363, 0.021134, 0.020966, 0.020691, 0.020508, 0.020768, 0.020935, 0.020996, 0.021042, 0.021683, 0.022110, 0.021515, 0.021118, 0.020768, 0.020539, 0.021485, 0.022141, 0.021317, 0.020752, 0.021210, 0.021515, 0.021195, 0.020981, 0.021668, 0.022141, 0.021408, 0.020905, 0.021546, 0.021973, 0.020661, 0.019776, 0.020676, 0.021302, 0.021530, 0.021683, 0.021088, 0.020676, 0.021118, 0.021424, 0.021210, 0.021073, 0.021225, 0.021332, 0.021500, 0.021607, 0.021317, 0.021118, 0.020203, 0.019577, 0.020081, 0.020417, 0.020691, 0.020874, 0.021118, 0.021286, 0.020951, 0.020722, 0.020859, 0.020951, 0.020539, 0.020264, 0.020386, 0.020478, 0.020554, 0.020615, 0.021164, 0.021530, 0.021469,
		0.020325, 0.021012, 0.021485, 0.021515, 0.021530, 0.020981, 0.020600, 0.020462, 0.020356, 0.020890, 0.021271, 0.021180, 0.021118, 0.020737, 0.020493, 0.020768, 0.020951, 0.021134, 0.021256, 0.020844, 0.020569, 0.020661, 0.020737, 0.021195, 0.021500, 0.021057, 0.020768, 0.021073, 0.021286, 0.021088, 0.020951, 0.020813, 0.020706, 0.021286, 0.021683, 0.021622, 0.021576, 0.021393, 0.021256, 0.020981, 0.020783, 0.021729, 0.022385, 0.021500, 0.020890, 0.021775, 0.022385, 0.021729, 0.021271, 0.020783, 0.020447, 0.020813, 0.021057, 0.021164, 0.021241, 0.021378, 0.021469, 0.021485, 0.021500, 0.021973, 0.022293, 0.021454, 0.020890, 0.020569, 0.020356, 0.020493, 0.020584, 0.020844, 0.021012, 0.020768, 0.020615, 0.020890, 0.021073, 0.020294, 0.019760, 0.020188, 0.020478, 0.020630, 0.020752, 0.020294, 0.019974, 0.020813, 0.021393, 0.021622, 0.021790, 0.021103, 0.020645, 0.021012, 0.021271, 0.020905, 0.020645, 0.020935, 0.021134, 0.020844, 0.020630, 0.019974, 0.019516, 0.020401, 0.021012, 0.020905,
		0.020294, 0.021057, 0.021576, 0.021653, 0.021698, 0.021042, 0.020584, 0.020356, 0.020203, 0.020905, 0.021393, 0.021286, 0.021225, 0.020859, 0.020615, 0.020768, 0.020874, 0.021118, 0.021286, 0.020966, 0.020752, 0.020691, 0.020661, 0.021134, 0.021469, 0.021073, 0.020813, 0.021103, 0.021302, 0.021180, 0.021103, 0.020798, 0.020584, 0.021317, 0.021820, 0.021790, 0.021775, 0.021500, 0.021317, 0.020966, 0.020737, 0.021744, 0.022431, 0.021485, 0.020844, 0.021958, 0.022721, 0.021775, 0.021118, 0.020691, 0.020386, 0.020737, 0.020981, 0.021164, 0.021286, 0.021317, 0.021347, 0.021500, 0.021607, 0.022049, 0.022354, 0.021607, 0.021088, 0.020539, 0.020172, 0.020294, 0.020386, 0.020798, 0.021073, 0.020706, 0.020462, 0.020829, 0.021073, 0.020127, 0.019471, 0.019944, 0.020264, 0.020508, 0.020676, 0.020310, 0.020050, 0.020951, 0.021576, 0.021805, 0.021958, 0.021103, 0.020523, 0.021027, 0.021378, 0.020905, 0.020584, 0.021012, 0.021302, 0.020920, 0.020661, 0.019867, 0.019318, 0.020264, 0.020920, 0.020798,
		0.020417, 0.020768, 0.020996, 0.021042, 0.021073, 0.020966, 0.020890, 0.020874, 0.020859, 0.021256, 0.021515, 0.021103, 0.020829, 0.021241, 0.021515, 0.021210, 0.020996, 0.020691, 0.020478, 0.020508, 0.020539, 0.020523, 0.020523, 0.021103, 0.021500, 0.021439, 0.021408, 0.021317, 0.021256, 0.021607, 0.021866, 0.021180, 0.020706, 0.021027, 0.021241, 0.021592, 0.021820, 0.021607, 0.021439, 0.021714, 0.021897, 0.021759, 0.021653, 0.021332, 0.021103, 0.021118, 0.021134, 0.021729, 0.022141, 0.022309, 0.022416, 0.022095, 0.021881, 0.021958, 0.022004, 0.021744, 0.021561, 0.022004, 0.022309, 0.021683, 0.021241, 0.020981, 0.020798, 0.021118, 0.021347, 0.021912, 0.022293, 0.021347, 0.020706, 0.020615, 0.020539, 0.021225, 0.021698, 0.020615, 0.019867, 0.020218, 0.020447, 0.021164, 0.021668, 0.021500, 0.021378, 0.021347, 0.021332, 0.020920, 0.020645, 0.020798, 0.020905, 0.021225, 0.021424, 0.021485, 0.021515, 0.021073, 0.020768, 0.020798, 0.020813, 0.020676, 0.020600, 0.020569, 0.020554, 0.021012,
		0.020447, 0.020706, 0.020890, 0.020920, 0.020951, 0.020951, 0.020951, 0.020966, 0.020981, 0.021317, 0.021546, 0.021073, 0.020752, 0.021302, 0.021683, 0.021286, 0.021027, 0.020615, 0.020325, 0.020432, 0.020493, 0.020493, 0.020493, 0.021088, 0.021500, 0.021515, 0.021515, 0.021347, 0.021241, 0.021698, 0.022004, 0.021241, 0.020722, 0.020966, 0.021134, 0.021546, 0.021836, 0.021622, 0.021469, 0.021851, 0.022110, 0.021759, 0.021515, 0.021302, 0.021149, 0.020966, 0.020844, 0.021729, 0.022324, 0.022599, 0.022797, 0.022354, 0.022049, 0.022110, 0.022141, 0.021820, 0.021607, 0.022095, 0.022431, 0.021607, 0.021042, 0.020859, 0.020737, 0.021225, 0.021561, 0.022202, 0.022644, 0.021454, 0.020645, 0.020584, 0.020554, 0.021302, 0.021805, 0.020706, 0.019944, 0.020264, 0.020478, 0.021286, 0.021851, 0.021714, 0.021622, 0.021424, 0.021286, 0.020768, 0.020401, 0.020752, 0.020981, 0.021256, 0.021439, 0.021576, 0.021683, 0.021088, 0.020676, 0.020783, 0.020844, 0.020829, 0.020829, 0.020615, 0.020478, 0.021057,
		0.021225, 0.021210, 0.021210, 0.021378, 0.021500, 0.021027, 0.020691, 0.020600, 0.020523, 0.020890, 0.021134, 0.020798, 0.020569, 0.021103, 0.021485, 0.021454, 0.021439, 0.020874, 0.020493, 0.021073, 0.021469, 0.021332, 0.021225, 0.020722, 0.020386, 0.020905, 0.021256, 0.021057, 0.020920, 0.021347, 0.021637, 0.021439, 0.021286, 0.021088, 0.020951, 0.021134, 0.021256, 0.021775, 0.022141, 0.022187, 0.022217, 0.021927, 0.021729, 0.022004, 0.022202, 0.021942, 0.021759, 0.022431, 0.022889, 0.023453, 0.023835, 0.023194, 0.022751, 0.022446, 0.022248, 0.022263, 0.022278, 0.022217, 0.022187, 0.022339, 0.022446, 0.021668, 0.021118, 0.021607, 0.021942, 0.021988, 0.022019, 0.021271, 0.020768, 0.020737, 0.020706, 0.021118, 0.021393, 0.021317, 0.021271, 0.020859, 0.020569, 0.020768, 0.020905, 0.020966, 0.021012, 0.021408, 0.021683, 0.021424, 0.021241, 0.021241, 0.021256, 0.021073, 0.020951, 0.020447, 0.020096, 0.020401, 0.020600, 0.020569, 0.020554, 0.020493, 0.020462, 0.020371, 0.020310, 0.020462,
		0.021363, 0.021302, 0.021271, 0.021469, 0.021607, 0.021042, 0.020645, 0.020523, 0.020447, 0.020813, 0.021057, 0.020752, 0.020539, 0.021073, 0.021439, 0.021485, 0.021515, 0.020920, 0.020523, 0.021195, 0.021653, 0.021485, 0.021363, 0.020661, 0.020172, 0.020783, 0.021210, 0.020996, 0.020859, 0.021286, 0.021576, 0.021469, 0.021393, 0.021118, 0.020920, 0.021057, 0.021149, 0.021805, 0.022263, 0.022248, 0.022232, 0.021958, 0.021759, 0.022141, 0.022400, 0.022126, 0.021927, 0.022568, 0.022995, 0.023606, 0.024033, 0.023346, 0.022873, 0.022507, 0.022263, 0.022339, 0.022400, 0.022248, 0.022141, 0.022477, 0.022705, 0.021805, 0.021195, 0.021683, 0.022019, 0.021942, 0.021897, 0.021241, 0.020783, 0.020752, 0.020737, 0.021088, 0.021317, 0.021439, 0.021515, 0.020966, 0.020584, 0.020661, 0.020722, 0.020829, 0.020905, 0.021408, 0.021759, 0.021546, 0.021393, 0.021332, 0.021302, 0.021042, 0.020859, 0.020233, 0.019806, 0.020264, 0.020584, 0.020539, 0.020508, 0.020432, 0.020386, 0.020325, 0.020279, 0.020356,
		0.020905, 0.020249, 0.019821, 0.020508, 0.020996, 0.020172, 0.019623, 0.019959, 0.020188, 0.020844, 0.021302, 0.020951, 0.020706, 0.020630, 0.020569, 0.020798, 0.020951, 0.020798, 0.020706, 0.020966, 0.021134, 0.021164, 0.021195, 0.020966, 0.020798, 0.021012, 0.021164, 0.021363, 0.021500, 0.021347, 0.021225, 0.021347, 0.021439, 0.021576, 0.021668, 0.021347, 0.021134, 0.021927, 0.022461, 0.022324, 0.022232, 0.022705, 0.023041, 0.023163, 0.023270, 0.023560, 0.023774, 0.024247, 0.024567, 0.024735, 0.024857, 0.024353, 0.024018, 0.023758, 0.023575, 0.023545, 0.023529, 0.022995, 0.022614, 0.022507, 0.022416, 0.022065, 0.021820, 0.021973, 0.022080, 0.022171, 0.022248, 0.021622, 0.021210, 0.021576, 0.021836, 0.021714, 0.021622, 0.021378, 0.021210, 0.021378, 0.021485, 0.021012, 0.020691, 0.020981, 0.021195, 0.021149, 0.021134, 0.021210, 0.021271, 0.021347, 0.021408, 0.021347, 0.021302, 0.020813, 0.020493, 0.020401, 0.020340, 0.020722, 0.020966, 0.021317, 0.021561, 0.020768, 0.020233, 0.020798,
		0.020813, 0.020066, 0.019547, 0.020340, 0.020874, 0.020020, 0.019425, 0.019852, 0.020142, 0.020859, 0.021347, 0.020981, 0.020737, 0.020554, 0.020417, 0.020676, 0.020844, 0.020783, 0.020737, 0.020920, 0.021042, 0.021118, 0.021164, 0.021027, 0.020920, 0.021057, 0.021149, 0.021424, 0.021622, 0.021347, 0.021164, 0.021332, 0.021439, 0.021653, 0.021805, 0.021408, 0.021134, 0.021942, 0.022507, 0.022339, 0.022232, 0.022843, 0.023270, 0.023362, 0.023423, 0.023835, 0.024109, 0.024552, 0.024857, 0.024949, 0.025010, 0.024552, 0.024231, 0.023987, 0.023819, 0.023774, 0.023743, 0.023133, 0.022705, 0.022507, 0.022370, 0.022110, 0.021927, 0.022034, 0.022095, 0.022217, 0.022309, 0.021698, 0.021286, 0.021729, 0.022034, 0.021820, 0.021683, 0.021363, 0.021149, 0.021454, 0.021653, 0.021088, 0.020691, 0.021012, 0.021241, 0.021103, 0.021012, 0.021149, 0.021256, 0.021363, 0.021424, 0.021393, 0.021378, 0.020920, 0.020615, 0.020432, 0.020294, 0.020752, 0.021057, 0.021485, 0.021775, 0.020844, 0.020218, 0.020874,
		0.020981, 0.020935, 0.020905, 0.021012, 0.021088, 0.021073, 0.021057, 0.021347, 0.021546, 0.021469, 0.021424, 0.020966, 0.020661, 0.020447, 0.020310, 0.021103, 0.021653, 0.021576, 0.021515, 0.021149, 0.020905, 0.021637, 0.022141, 0.021073, 0.020325, 0.020630, 0.020844, 0.020890, 0.020920, 0.020813, 0.020722, 0.021088, 0.021332, 0.022004, 0.022446, 0.021973, 0.021637, 0.021729, 0.021805, 0.022705, 0.023316, 0.023148, 0.023041, 0.024369, 0.025269, 0.025071, 0.024918, 0.025681, 0.026215, 0.026673, 0.026978, 0.026841, 0.026749, 0.026276, 0.025971, 0.025010, 0.024353, 0.024125, 0.023972, 0.023331, 0.022889, 0.022873, 0.022873, 0.022446, 0.022156, 0.021454, 0.020966, 0.021393, 0.021668, 0.021683, 0.021683, 0.021622, 0.021561, 0.021088, 0.020768, 0.020966, 0.021103, 0.021408, 0.021622, 0.021515, 0.021439, 0.021683, 0.021851, 0.021500, 0.021256, 0.020768, 0.020432, 0.020996, 0.021378, 0.021332, 0.021302, 0.020706, 0.020294, 0.020706, 0.020996, 0.020859, 0.020752, 0.020905, 0.021012, 0.021103,
		0.021012, 0.021088, 0.021149, 0.021134, 0.021118, 0.021271, 0.021363, 0.021622, 0.021805, 0.021592, 0.021439, 0.020966, 0.020645, 0.020432, 0.020294, 0.021195, 0.021805, 0.021729, 0.021668, 0.021195, 0.020874, 0.021729, 0.022324, 0.021073, 0.020218, 0.020554, 0.020783, 0.020798, 0.020798, 0.020706, 0.020645, 0.021042, 0.021317, 0.022065, 0.022568, 0.022065, 0.021729, 0.021698, 0.021668, 0.022766, 0.023514, 0.023209, 0.022995, 0.024552, 0.025620, 0.025299, 0.025071, 0.025895, 0.026459, 0.026978, 0.027344, 0.027268, 0.027207, 0.026703, 0.026368, 0.025238, 0.024475, 0.024308, 0.024201, 0.023468, 0.022980, 0.023011, 0.023041, 0.022522, 0.022171, 0.021317, 0.020722, 0.021332, 0.021744, 0.021668, 0.021622, 0.021576, 0.021546, 0.021042, 0.020691, 0.020874, 0.020996, 0.021469, 0.021790, 0.021607, 0.021469, 0.021790, 0.022004, 0.021561, 0.021256, 0.020661, 0.020249, 0.020920, 0.021378, 0.021408, 0.021424, 0.020752, 0.020294, 0.020706, 0.020981, 0.020737, 0.020569, 0.020920, 0.021164, 0.021149,
		0.020615, 0.021347, 0.021851, 0.021073, 0.020539, 0.020905, 0.021149, 0.020920, 0.020768, 0.020676, 0.020615, 0.020523, 0.020447, 0.020600, 0.020691, 0.020859, 0.020981, 0.020935, 0.020890, 0.020676, 0.020523, 0.020829, 0.021027, 0.021363, 0.021592, 0.021683, 0.021744, 0.021759, 0.021759, 0.021515, 0.021347, 0.021363, 0.021378, 0.021607, 0.021775, 0.021714, 0.021683, 0.022416, 0.022934, 0.023270, 0.023514, 0.024033, 0.024384, 0.025589, 0.026413, 0.027878, 0.028870, 0.030549, 0.031693, 0.032959, 0.033829, 0.034684, 0.035248, 0.033097, 0.031617, 0.029450, 0.027985, 0.027222, 0.026719, 0.025345, 0.024414, 0.023239, 0.022431, 0.022339, 0.022263, 0.021592, 0.021134, 0.021378, 0.021546, 0.020905, 0.020462, 0.020615, 0.020706, 0.021210, 0.021561, 0.021530, 0.021530, 0.021790, 0.021973, 0.021332, 0.020905, 0.020890, 0.020890, 0.020813, 0.020768, 0.020844, 0.020890, 0.021103, 0.021241, 0.021546, 0.021744, 0.021134, 0.020722, 0.020981, 0.021164, 0.020844, 0.020630, 0.020691, 0.020737, 0.020768,
		0.020539, 0.021393, 0.021988, 0.021057, 0.020432, 0.020829, 0.021103, 0.020783, 0.020569, 0.020508, 0.020462, 0.020432, 0.020417, 0.020630, 0.020768, 0.020798, 0.020829, 0.020783, 0.020752, 0.020584, 0.020462, 0.020645, 0.020783, 0.021424, 0.021851, 0.021897, 0.021927, 0.021942, 0.021942, 0.021668, 0.021485, 0.021424, 0.021393, 0.021530, 0.021622, 0.021653, 0.021668, 0.022553, 0.023163, 0.023377, 0.023514, 0.024186, 0.024643, 0.025788, 0.026566, 0.028351, 0.029572, 0.031418, 0.032670, 0.034073, 0.035035, 0.036042, 0.036744, 0.034272, 0.032593, 0.030243, 0.028626, 0.027771, 0.027176, 0.025696, 0.024674, 0.023285, 0.022324, 0.022293, 0.022278, 0.021637, 0.021210, 0.021378, 0.021500, 0.020752, 0.020249, 0.020432, 0.020554, 0.021241, 0.021714, 0.021653, 0.021622, 0.021851, 0.022004, 0.021286, 0.020798, 0.020722, 0.020676, 0.020676, 0.020676, 0.020874, 0.021012, 0.021134, 0.021210, 0.021561, 0.021805, 0.021210, 0.020798, 0.021027, 0.021195, 0.020874, 0.020645, 0.020661, 0.020661, 0.020706,
		0.021042, 0.020645, 0.020386, 0.020508, 0.020584, 0.020996, 0.021286, 0.021378, 0.021439, 0.020874, 0.020508, 0.020630, 0.020722, 0.020371, 0.020127, 0.020478, 0.020706, 0.021256, 0.021622, 0.021164, 0.020844, 0.021439, 0.021836, 0.021576, 0.021393, 0.021363, 0.021332, 0.021408, 0.021469, 0.021759, 0.021942, 0.021668, 0.021469, 0.021271, 0.021149, 0.021775, 0.022202, 0.022736, 0.023117, 0.022889, 0.022736, 0.024781, 0.026169, 0.029084, 0.031067, 0.035172, 0.037964, 0.044160, 0.048386, 0.053071, 0.056260, 0.057267, 0.057954, 0.052308, 0.048432, 0.041093, 0.036088, 0.032288, 0.029694, 0.027787, 0.026474, 0.024750, 0.023575, 0.022492, 0.021744, 0.021302, 0.020996, 0.021622, 0.022049, 0.021637, 0.021363, 0.021195, 0.021088, 0.021271, 0.021393, 0.021729, 0.021958, 0.021271, 0.020813, 0.020951, 0.021042, 0.021317, 0.021500, 0.020829, 0.020371, 0.021134, 0.021668, 0.020493, 0.019684, 0.020218, 0.020569, 0.020508, 0.020462, 0.020737, 0.020905, 0.020630, 0.020432, 0.020874, 0.021180, 0.020737,
		0.021134, 0.020508, 0.020081, 0.020401, 0.020615, 0.021027, 0.021317, 0.021485, 0.021592, 0.020951, 0.020508, 0.020676, 0.020783, 0.020325, 0.020005, 0.020417, 0.020691, 0.021332, 0.021775, 0.021271, 0.020920, 0.021576, 0.022034, 0.021607, 0.021302, 0.021256, 0.021225, 0.021317, 0.021378, 0.021775, 0.022034, 0.021714, 0.021485, 0.021225, 0.021057, 0.021790, 0.022293, 0.022766, 0.023102, 0.022797, 0.022599, 0.024887, 0.026459, 0.029694, 0.031907, 0.036423, 0.039521, 0.046509, 0.051301, 0.056580, 0.060197, 0.061204, 0.061891, 0.055634, 0.051362, 0.043107, 0.037461, 0.033127, 0.030167, 0.028168, 0.026810, 0.025025, 0.023804, 0.022522, 0.021653, 0.021241, 0.020966, 0.021668, 0.022156, 0.021805, 0.021561, 0.021332, 0.021180, 0.021271, 0.021332, 0.021744, 0.022019, 0.021164, 0.020584, 0.020890, 0.021088, 0.021424, 0.021653, 0.020859, 0.020310, 0.021195, 0.021790, 0.020371, 0.019409, 0.019959, 0.020340, 0.020371, 0.020401, 0.020676, 0.020859, 0.020584, 0.020386, 0.020905, 0.021271, 0.020737,
		0.021057, 0.020874, 0.020737, 0.020508, 0.020356, 0.020935, 0.021347, 0.021073, 0.020890, 0.020890, 0.020890, 0.020798, 0.020737, 0.021103, 0.021347, 0.021256, 0.021195, 0.021073, 0.020996, 0.021180, 0.021302, 0.021027, 0.020844, 0.021500, 0.021958, 0.021759, 0.021622, 0.021378, 0.021210, 0.021286, 0.021332, 0.021286, 0.021271, 0.021729, 0.022034, 0.022400, 0.022644, 0.022889, 0.023056, 0.024582, 0.025605, 0.027878, 0.029435, 0.034287, 0.037613, 0.049836, 0.058183, 0.082475, 0.099092, 0.116701, 0.128740, 0.133043, 0.136004, 0.113313, 0.097795, 0.074586, 0.058717, 0.046876, 0.038773, 0.032639, 0.028443, 0.026307, 0.024842, 0.023835, 0.023163, 0.022354, 0.021805, 0.022293, 0.022614, 0.021912, 0.021424, 0.021439, 0.021469, 0.021103, 0.020859, 0.020737, 0.020661, 0.020691, 0.020706, 0.021195, 0.021530, 0.021393, 0.021286, 0.021454, 0.021576, 0.021424, 0.021332, 0.021042, 0.020844, 0.020890, 0.020920, 0.020783, 0.020691, 0.021317, 0.021744, 0.021164, 0.020768, 0.020462, 0.020249, 0.020523,
		0.021042, 0.020935, 0.020859, 0.020539, 0.020310, 0.020920, 0.021347, 0.020996, 0.020752, 0.020874, 0.020966, 0.020829, 0.020737, 0.021241, 0.021592, 0.021408, 0.021286, 0.021027, 0.020859, 0.021164, 0.021378, 0.020920, 0.020615, 0.021485, 0.022080, 0.021851, 0.021698, 0.021393, 0.021180, 0.021195, 0.021195, 0.021210, 0.021225, 0.021820, 0.022217, 0.022507, 0.022705, 0.022919, 0.023056, 0.024903, 0.026169, 0.028428, 0.029984, 0.035142, 0.038666, 0.052308, 0.061646, 0.089128, 0.107942, 0.127825, 0.141436, 0.146349, 0.149722, 0.123995, 0.106386, 0.080415, 0.062654, 0.049424, 0.040375, 0.033478, 0.028748, 0.026535, 0.025025, 0.024079, 0.023438, 0.022553, 0.021958, 0.022400, 0.022705, 0.021927, 0.021393, 0.021469, 0.021515, 0.021073, 0.020768, 0.020554, 0.020417, 0.020600, 0.020722, 0.021241, 0.021607, 0.021378, 0.021225, 0.021576, 0.021805, 0.021469, 0.021241, 0.021164, 0.021103, 0.021057, 0.021027, 0.020859, 0.020737, 0.021439, 0.021912, 0.021271, 0.020844, 0.020386, 0.020066, 0.020493,
		0.020722, 0.020340, 0.020081, 0.020462, 0.020722, 0.020981, 0.021164, 0.021073, 0.020996, 0.021134, 0.021225, 0.021164, 0.021118, 0.020996, 0.020905, 0.020752, 0.020661, 0.020493, 0.020386, 0.020691, 0.020920, 0.021271, 0.021500, 0.021134, 0.020874, 0.020722, 0.020615, 0.020768, 0.020874, 0.020768, 0.020691, 0.021881, 0.022705, 0.021729, 0.021073, 0.022278, 0.023102, 0.023575, 0.023896, 0.025895, 0.027268, 0.030838, 0.033280, 0.043854, 0.051072, 0.080903, 0.101320, 0.151858, 0.186450, 0.232349, 0.263752, 0.277790, 0.287404, 0.231769, 0.193698, 0.135576, 0.095796, 0.067109, 0.047486, 0.038453, 0.032273, 0.028702, 0.026261, 0.025147, 0.024384, 0.023560, 0.022980, 0.022980, 0.022965, 0.022614, 0.022385, 0.021897, 0.021561, 0.021698, 0.021790, 0.021286, 0.020951, 0.021042, 0.021118, 0.021378, 0.021546, 0.021469, 0.021424, 0.021256, 0.021134, 0.020768, 0.020508, 0.021012, 0.021347, 0.021103, 0.020920, 0.020829, 0.020783, 0.020996, 0.021149, 0.021225, 0.021286, 0.020981, 0.020768, 0.021271,
		0.020661, 0.020233, 0.019928, 0.020447, 0.020798, 0.020996, 0.021134, 0.021073, 0.021042, 0.021180, 0.021271, 0.021225, 0.021195, 0.020951, 0.020783, 0.020630, 0.020539, 0.020386, 0.020294, 0.020615, 0.020829, 0.021332, 0.021668, 0.021057, 0.020645, 0.020508, 0.020417, 0.020645, 0.020813, 0.020691, 0.020600, 0.022019, 0.022980, 0.021714, 0.020859, 0.022232, 0.023178, 0.023697, 0.024048, 0.026078, 0.027466, 0.031281, 0.033890, 0.045457, 0.053376, 0.086198, 0.108659, 0.163485, 0.200992, 0.251698, 0.286397, 0.302129, 0.312901, 0.251728, 0.209873, 0.145785, 0.101930, 0.070390, 0.048798, 0.039368, 0.032929, 0.029099, 0.026490, 0.025345, 0.024567, 0.023743, 0.023178, 0.023072, 0.023011, 0.022751, 0.022568, 0.021973, 0.021576, 0.021805, 0.021973, 0.021424, 0.021042, 0.021134, 0.021195, 0.021393, 0.021530, 0.021485, 0.021454, 0.021195, 0.021012, 0.020630, 0.020371, 0.020981, 0.021393, 0.021103, 0.020905, 0.020829, 0.020783, 0.020920, 0.021012, 0.021225, 0.021363, 0.021088, 0.020905, 0.021424,
		0.021271, 0.021424, 0.021515, 0.021180, 0.020935, 0.021042, 0.021103, 0.021637, 0.022004, 0.021469, 0.021088, 0.021073, 0.021057, 0.021057, 0.021057, 0.021103, 0.021134, 0.021027, 0.020951, 0.021500, 0.021881, 0.021759, 0.021668, 0.021744, 0.021790, 0.021256, 0.020890, 0.021576, 0.022034, 0.021347, 0.020890, 0.021180, 0.021378, 0.021759, 0.022019, 0.022492, 0.022812, 0.024216, 0.025162, 0.026596, 0.027588, 0.032975, 0.036652, 0.052354, 0.063096, 0.106386, 0.136004, 0.195880, 0.236835, 0.294041, 0.333165, 0.351247, 0.363622, 0.290425, 0.240345, 0.164538, 0.112673, 0.077287, 0.053071, 0.041474, 0.033539, 0.029435, 0.026627, 0.024735, 0.023438, 0.023087, 0.022843, 0.022232, 0.021820, 0.021790, 0.021775, 0.021302, 0.020966, 0.020981, 0.020996, 0.021180, 0.021302, 0.021195, 0.021118, 0.021225, 0.021302, 0.021225, 0.021180, 0.021057, 0.020966, 0.020539, 0.020249, 0.020951, 0.021439, 0.020951, 0.020615, 0.020584, 0.020569, 0.020340, 0.020188, 0.020722, 0.021088, 0.020844, 0.020691, 0.020768,
		0.021393, 0.021637, 0.021805, 0.021302, 0.020966, 0.021042, 0.021103, 0.021744, 0.022187, 0.021515, 0.021057, 0.021042, 0.021027, 0.021073, 0.021103, 0.021180, 0.021241, 0.021134, 0.021073, 0.021668, 0.022080, 0.021836, 0.021668, 0.021866, 0.022004, 0.021393, 0.020981, 0.021744, 0.022263, 0.021469, 0.020935, 0.021027, 0.021088, 0.021775, 0.022232, 0.022538, 0.022751, 0.024308, 0.025376, 0.026703, 0.027604, 0.033280, 0.037171, 0.053635, 0.064897, 0.110124, 0.141070, 0.201877, 0.243473, 0.301869, 0.341833, 0.360357, 0.373022, 0.297597, 0.245991, 0.168017, 0.114656, 0.078553, 0.053864, 0.041855, 0.033646, 0.029496, 0.026658, 0.024613, 0.023224, 0.022965, 0.022782, 0.022080, 0.021592, 0.021607, 0.021622, 0.021164, 0.020859, 0.020829, 0.020813, 0.021134, 0.021347, 0.021210, 0.021103, 0.021195, 0.021256, 0.021180, 0.021134, 0.021027, 0.020966, 0.020523, 0.020218, 0.020935, 0.021439, 0.020920, 0.020554, 0.020539, 0.020523, 0.020233, 0.020035, 0.020630, 0.021042, 0.020813, 0.020645, 0.020645,
		0.020706, 0.020859, 0.020951, 0.021164, 0.021317, 0.021088, 0.020920, 0.021286, 0.021546, 0.021622, 0.021668, 0.021363, 0.021149, 0.020630, 0.020279, 0.020401, 0.020493, 0.021103, 0.021515, 0.021668, 0.021775, 0.021408, 0.021164, 0.020722, 0.020417, 0.020844, 0.021134, 0.021241, 0.021317, 0.021012, 0.020798, 0.021530, 0.022034, 0.022217, 0.022354, 0.022568, 0.022705, 0.023667, 0.024323, 0.026627, 0.028214, 0.032898, 0.036103, 0.052003, 0.062882, 0.103777, 0.131762, 0.182589, 0.217380, 0.261875, 0.292317, 0.296086, 0.298650, 0.239689, 0.199344, 0.139422, 0.098421, 0.069230, 0.049271, 0.039139, 0.032212, 0.028824, 0.026490, 0.025055, 0.024079, 0.023285, 0.022751, 0.022690, 0.022644, 0.021942, 0.021469, 0.021622, 0.021729, 0.021485, 0.021317, 0.021317, 0.021302, 0.021393, 0.021469, 0.021393, 0.021347, 0.020783, 0.020386, 0.020584, 0.020722, 0.020645, 0.020600, 0.020829, 0.020981, 0.020844, 0.020752, 0.020661, 0.020600, 0.020752, 0.020859, 0.020325, 0.019959, 0.020874, 0.021515, 0.021485,
		0.020584, 0.020706, 0.020798, 0.021149, 0.021378, 0.021088, 0.020890, 0.021210, 0.021424, 0.021637, 0.021790, 0.021424, 0.021180, 0.020554, 0.020127, 0.020264, 0.020356, 0.021088, 0.021592, 0.021668, 0.021714, 0.021332, 0.021073, 0.020508, 0.020127, 0.020737, 0.021164, 0.021149, 0.021149, 0.020920, 0.020768, 0.021622, 0.022217, 0.022309, 0.022370, 0.022568, 0.022705, 0.023545, 0.024125, 0.026612, 0.028321, 0.032822, 0.035904, 0.051698, 0.062501, 0.102602, 0.130037, 0.179019, 0.212543, 0.254459, 0.283146, 0.284184, 0.284886, 0.228962, 0.190707, 0.134127, 0.095415, 0.067506, 0.048417, 0.038636, 0.031952, 0.028687, 0.026459, 0.025132, 0.024231, 0.023346, 0.022751, 0.022812, 0.022843, 0.022004, 0.021439, 0.021698, 0.021881, 0.021607, 0.021408, 0.021347, 0.021302, 0.021439, 0.021530, 0.021424, 0.021363, 0.020706, 0.020249, 0.020508, 0.020676, 0.020676, 0.020676, 0.020813, 0.020905, 0.020829, 0.020783, 0.020676, 0.020615, 0.020844, 0.021012, 0.020264, 0.019760, 0.020890, 0.021668, 0.021637,
		0.020264, 0.020462, 0.020600, 0.020722, 0.020813, 0.021088, 0.021286, 0.021210, 0.021149, 0.021088, 0.021057, 0.020691, 0.020447, 0.020722, 0.020905, 0.020935, 0.020951, 0.020829, 0.020737, 0.021271, 0.021622, 0.021729, 0.021805, 0.021515, 0.021317, 0.021759, 0.022065, 0.021622, 0.021317, 0.021698, 0.021958, 0.021775, 0.021653, 0.021912, 0.022095, 0.022675, 0.023072, 0.024033, 0.024689, 0.025910, 0.026734, 0.031373, 0.034546, 0.044724, 0.051698, 0.076722, 0.093828, 0.128222, 0.151751, 0.173846, 0.188968, 0.177905, 0.170336, 0.138262, 0.116304, 0.085466, 0.064363, 0.050141, 0.040406, 0.033783, 0.029267, 0.026856, 0.025193, 0.024094, 0.023331, 0.022675, 0.022217, 0.022278, 0.022309, 0.021714, 0.021302, 0.021347, 0.021378, 0.021393, 0.021408, 0.021103, 0.020890, 0.020600, 0.020401, 0.021271, 0.021881, 0.021347, 0.020981, 0.020874, 0.020798, 0.020523, 0.020340, 0.020569, 0.020722, 0.020966, 0.021134, 0.020813, 0.020584, 0.020752, 0.020859, 0.021088, 0.021256, 0.021012, 0.020859, 0.021149,
		0.020203, 0.020417, 0.020554, 0.020645, 0.020706, 0.021103, 0.021363, 0.021210, 0.021103, 0.020996, 0.020920, 0.020554, 0.020310, 0.020752, 0.021042, 0.021057, 0.021057, 0.020783, 0.020584, 0.021195, 0.021607, 0.021805, 0.021942, 0.021698, 0.021530, 0.021942, 0.022232, 0.021714, 0.021347, 0.021836, 0.022171, 0.021805, 0.021546, 0.021851, 0.022049, 0.022705, 0.023148, 0.024125, 0.024796, 0.025772, 0.026444, 0.031098, 0.034287, 0.043442, 0.049699, 0.071916, 0.087129, 0.118807, 0.140490, 0.158923, 0.171527, 0.158221, 0.149126, 0.121462, 0.102525, 0.076448, 0.058610, 0.046921, 0.038926, 0.032898, 0.028763, 0.026505, 0.024964, 0.023896, 0.023163, 0.022553, 0.022126, 0.022187, 0.022217, 0.021653, 0.021271, 0.021286, 0.021286, 0.021363, 0.021408, 0.021057, 0.020813, 0.020447, 0.020188, 0.021241, 0.021973, 0.021469, 0.021118, 0.020935, 0.020813, 0.020493, 0.020279, 0.020523, 0.020691, 0.020996, 0.021195, 0.020829, 0.020584, 0.020722, 0.020829, 0.021241, 0.021530, 0.021042, 0.020706, 0.021057,
		0.020523, 0.020508, 0.020508, 0.020829, 0.021057, 0.021958, 0.022583, 0.021530, 0.020813, 0.020890, 0.020966, 0.020737, 0.020600, 0.021103, 0.021454, 0.021042, 0.020768, 0.021332, 0.021714, 0.021241, 0.020920, 0.021164, 0.021332, 0.021225, 0.021164, 0.021546, 0.021805, 0.021515, 0.021317, 0.021851, 0.022217, 0.022080, 0.021988, 0.021561, 0.021271, 0.021759, 0.022095, 0.023102, 0.023789, 0.025315, 0.026352, 0.028321, 0.029679, 0.035431, 0.039368, 0.050324, 0.057816, 0.073411, 0.084092, 0.089036, 0.092439, 0.086229, 0.081971, 0.070649, 0.062913, 0.050904, 0.042695, 0.036500, 0.032273, 0.028992, 0.026749, 0.025238, 0.024201, 0.023606, 0.023194, 0.022629, 0.022248, 0.021820, 0.021515, 0.021103, 0.020813, 0.020829, 0.020829, 0.020768, 0.020722, 0.021332, 0.021759, 0.021530, 0.021378, 0.021271, 0.021195, 0.021439, 0.021607, 0.021271, 0.021042, 0.020920, 0.020829, 0.020920, 0.020981, 0.021363, 0.021622, 0.021286, 0.021057, 0.021210, 0.021302, 0.021210, 0.021164, 0.021103, 0.021073, 0.020249,
		0.020584, 0.020523, 0.020493, 0.020859, 0.021118, 0.022126, 0.022812, 0.021592, 0.020752, 0.020874, 0.020966, 0.020783, 0.020645, 0.021164, 0.021530, 0.021042, 0.020706, 0.021424, 0.021927, 0.021256, 0.020798, 0.021042, 0.021210, 0.021134, 0.021088, 0.021469, 0.021729, 0.021485, 0.021317, 0.021851, 0.022217, 0.022126, 0.022065, 0.021515, 0.021134, 0.021592, 0.021897, 0.022919, 0.023606, 0.025223, 0.026337, 0.027817, 0.028824, 0.033951, 0.037461, 0.046326, 0.052384, 0.065003, 0.073640, 0.076112, 0.077790, 0.072892, 0.069535, 0.061250, 0.055573, 0.046174, 0.039750, 0.034577, 0.031037, 0.028260, 0.026368, 0.024994, 0.024063, 0.023545, 0.023194, 0.022644, 0.022263, 0.021744, 0.021393, 0.020996, 0.020737, 0.020737, 0.020737, 0.020661, 0.020600, 0.021393, 0.021927, 0.021744, 0.021607, 0.021286, 0.021057, 0.021439, 0.021698, 0.021332, 0.021088, 0.020996, 0.020935, 0.020996, 0.021027, 0.021424, 0.021698, 0.021378, 0.021149, 0.021302, 0.021393, 0.021210, 0.021088, 0.021118, 0.021134, 0.020096,
		0.020600, 0.020706, 0.020783, 0.021012, 0.021164, 0.021195, 0.021210, 0.021256, 0.021286, 0.021134, 0.021027, 0.021424, 0.021683, 0.021515, 0.021393, 0.021042, 0.020813, 0.020691, 0.020615, 0.020859, 0.021012, 0.020706, 0.020508, 0.020951, 0.021271, 0.021454, 0.021592, 0.021424, 0.021317, 0.021500, 0.021637, 0.021698, 0.021744, 0.021775, 0.021805, 0.021714, 0.021653, 0.022293, 0.022736, 0.023621, 0.024231, 0.025040, 0.025589, 0.029023, 0.031357, 0.035126, 0.037705, 0.043229, 0.047013, 0.048371, 0.049302, 0.046174, 0.044038, 0.041337, 0.039475, 0.035447, 0.032685, 0.030549, 0.029084, 0.026474, 0.024689, 0.024033, 0.023575, 0.022187, 0.021256, 0.021592, 0.021820, 0.021637, 0.021500, 0.021317, 0.021195, 0.021256, 0.021286, 0.021302, 0.021317, 0.021286, 0.021256, 0.021500, 0.021668, 0.021118, 0.020752, 0.020691, 0.020645, 0.020600, 0.020569, 0.020554, 0.020554, 0.020447, 0.020371, 0.020020, 0.019791, 0.020584, 0.021134, 0.020935, 0.020798, 0.020508, 0.020310, 0.021057, 0.021576, 0.021073,
		0.020600, 0.020752, 0.020844, 0.021042, 0.021180, 0.021027, 0.020920, 0.021195, 0.021378, 0.021180, 0.021042, 0.021546, 0.021881, 0.021576, 0.021363, 0.021042, 0.020829, 0.020554, 0.020371, 0.020783, 0.021057, 0.020645, 0.020371, 0.020920, 0.021302, 0.021454, 0.021561, 0.021424, 0.021317, 0.021439, 0.021530, 0.021622, 0.021683, 0.021820, 0.021927, 0.021744, 0.021607, 0.022171, 0.022568, 0.023316, 0.023835, 0.024521, 0.024994, 0.028107, 0.030228, 0.033051, 0.034989, 0.039200, 0.042084, 0.043229, 0.044022, 0.041230, 0.039322, 0.037644, 0.036500, 0.033448, 0.031373, 0.029801, 0.028717, 0.026139, 0.024384, 0.023850, 0.023484, 0.021942, 0.020890, 0.021393, 0.021744, 0.021607, 0.021515, 0.021363, 0.021271, 0.021347, 0.021393, 0.021424, 0.021454, 0.021271, 0.021134, 0.021454, 0.021683, 0.021088, 0.020691, 0.020539, 0.020447, 0.020462, 0.020478, 0.020478, 0.020478, 0.020340, 0.020249, 0.019776, 0.019440, 0.020447, 0.021134, 0.020874, 0.020691, 0.020386, 0.020172, 0.021057, 0.021653, 0.021256,
		0.020752, 0.020706, 0.020676, 0.020935, 0.021103, 0.020645, 0.020325, 0.020813, 0.021134, 0.021149, 0.021164, 0.021164, 0.021164, 0.020539, 0.020111, 0.020615, 0.020951, 0.020661, 0.020462, 0.020859, 0.021118, 0.021103, 0.021073, 0.020829, 0.020661, 0.020371, 0.020188, 0.021118, 0.021759, 0.021424, 0.021210, 0.021149, 0.021118, 0.021637, 0.021988, 0.021622, 0.021363, 0.022004, 0.022446, 0.022797, 0.023041, 0.023743, 0.024231, 0.025467, 0.026307, 0.027878, 0.028946, 0.030289, 0.031189, 0.031678, 0.032013, 0.031754, 0.031571, 0.030381, 0.029557, 0.028489, 0.027756, 0.026490, 0.025635, 0.024765, 0.024170, 0.022293, 0.021027, 0.021180, 0.021271, 0.021683, 0.021958, 0.021042, 0.020417, 0.020737, 0.020951, 0.021561, 0.021988, 0.021454, 0.021088, 0.020569, 0.020218, 0.020783, 0.021164, 0.020966, 0.020813, 0.020890, 0.020935, 0.021149, 0.021286, 0.021317, 0.021347, 0.021225, 0.021149, 0.020523, 0.020096, 0.020432, 0.020661, 0.020920, 0.021103, 0.021027, 0.020966, 0.020630, 0.020401, 0.021103,
		0.020783, 0.020706, 0.020645, 0.020905, 0.021088, 0.020569, 0.020218, 0.020737, 0.021088, 0.021149, 0.021195, 0.021088, 0.021027, 0.020340, 0.019883, 0.020539, 0.020981, 0.020676, 0.020478, 0.020874, 0.021134, 0.021180, 0.021210, 0.020813, 0.020539, 0.020172, 0.019928, 0.021057, 0.021836, 0.021424, 0.021149, 0.021073, 0.021012, 0.021607, 0.022004, 0.021592, 0.021317, 0.021973, 0.022416, 0.022690, 0.022889, 0.023606, 0.024094, 0.024979, 0.025589, 0.026917, 0.027832, 0.028626, 0.029175, 0.029541, 0.029786, 0.029999, 0.030137, 0.029038, 0.028275, 0.027573, 0.027085, 0.025879, 0.025055, 0.024506, 0.024125, 0.022019, 0.020569, 0.021027, 0.021347, 0.021744, 0.022004, 0.020951, 0.020218, 0.020615, 0.020890, 0.021607, 0.022095, 0.021454, 0.021012, 0.020447, 0.020050, 0.020661, 0.021073, 0.020935, 0.020844, 0.020951, 0.021027, 0.021271, 0.021439, 0.021469, 0.021500, 0.021393, 0.021317, 0.020661, 0.020218, 0.020432, 0.020569, 0.020935, 0.021180, 0.021149, 0.021118, 0.020554, 0.020172, 0.021073,
		0.021012, 0.021454, 0.021759, 0.021286, 0.020966, 0.021149, 0.021286, 0.020996, 0.020798, 0.021271, 0.021576, 0.021393, 0.021271, 0.021012, 0.020829, 0.020508, 0.020279, 0.020508, 0.020676, 0.020508, 0.020386, 0.020630, 0.020783, 0.020752, 0.020722, 0.020752, 0.020783, 0.021073, 0.021271, 0.020676, 0.020264, 0.020951, 0.021424, 0.021424, 0.021408, 0.021500, 0.021546, 0.021790, 0.021958, 0.021912, 0.021897, 0.022538, 0.022980, 0.023346, 0.023606, 0.024414, 0.024964, 0.025315, 0.025544, 0.025940, 0.026215, 0.026322, 0.026383, 0.024979, 0.024033, 0.024201, 0.024323, 0.023621, 0.023148, 0.022721, 0.022431, 0.022126, 0.021927, 0.021820, 0.021744, 0.022065, 0.022278, 0.021515, 0.020996, 0.021134, 0.021241, 0.022156, 0.022782, 0.021180, 0.020096, 0.020310, 0.020447, 0.021103, 0.021561, 0.021180, 0.020920, 0.020813, 0.020737, 0.020600, 0.020493, 0.020325, 0.020203, 0.020371, 0.020493, 0.020768, 0.020966, 0.020615, 0.020371, 0.020569, 0.020706, 0.020768, 0.020813, 0.020951, 0.021042, 0.021515,
		0.021057, 0.021592, 0.021958, 0.021347, 0.020935, 0.021256, 0.021485, 0.021057, 0.020752, 0.021286, 0.021653, 0.021454, 0.021317, 0.021134, 0.021012, 0.020508, 0.020157, 0.020478, 0.020706, 0.020432, 0.020249, 0.020523, 0.020706, 0.020737, 0.020752, 0.020859, 0.020935, 0.021073, 0.021164, 0.020523, 0.020096, 0.020935, 0.021500, 0.021378, 0.021302, 0.021469, 0.021592, 0.021759, 0.021866, 0.021775, 0.021714, 0.022339, 0.022766, 0.023041, 0.023239, 0.023941, 0.024430, 0.024689, 0.024872, 0.025284, 0.025559, 0.025635, 0.025696, 0.024231, 0.023239, 0.023575, 0.023804, 0.023209, 0.022797, 0.022385, 0.022110, 0.022141, 0.022171, 0.021958, 0.021820, 0.022126, 0.022324, 0.021622, 0.021134, 0.021241, 0.021302, 0.022248, 0.022904, 0.021134, 0.019928, 0.020279, 0.020523, 0.021195, 0.021653, 0.021225, 0.020935, 0.020783, 0.020676, 0.020462, 0.020325, 0.020111, 0.019959, 0.020188, 0.020340, 0.020798, 0.021103, 0.020645, 0.020340, 0.020508, 0.020615, 0.020691, 0.020752, 0.021027, 0.021210, 0.021607,
		0.020356, 0.021088, 0.021592, 0.020951, 0.020493, 0.021012, 0.021363, 0.020890, 0.020569, 0.020783, 0.020935, 0.021057, 0.021134, 0.021149, 0.021149, 0.020935, 0.020783, 0.021103, 0.021332, 0.021302, 0.021286, 0.020783, 0.020417, 0.020905, 0.021241, 0.020951, 0.020737, 0.020813, 0.020859, 0.021073, 0.021225, 0.021256, 0.021286, 0.021546, 0.021744, 0.021424, 0.021225, 0.021347, 0.021439, 0.021927, 0.022248, 0.021790, 0.021469, 0.022416, 0.023072, 0.022965, 0.022889, 0.023468, 0.023865, 0.023835, 0.023819, 0.023484, 0.023270, 0.023957, 0.024430, 0.023575, 0.022980, 0.023392, 0.023682, 0.022858, 0.022309, 0.022354, 0.022370, 0.022156, 0.022004, 0.021668, 0.021454, 0.021439, 0.021424, 0.021546, 0.021622, 0.021714, 0.021775, 0.021027, 0.020523, 0.020890, 0.021149, 0.021393, 0.021561, 0.020783, 0.020233, 0.020966, 0.021454, 0.021073, 0.020798, 0.020890, 0.020935, 0.020966, 0.020996, 0.020630, 0.020371, 0.020890, 0.021241, 0.020844, 0.020569, 0.020676, 0.020752, 0.020783, 0.020798, 0.020706,
		0.020218, 0.020996, 0.021530, 0.020874, 0.020417, 0.020966, 0.021347, 0.020874, 0.020539, 0.020691, 0.020798, 0.020981, 0.021103, 0.021149, 0.021180, 0.021012, 0.020890, 0.021210, 0.021439, 0.021469, 0.021485, 0.020829, 0.020371, 0.020935, 0.021332, 0.020966, 0.020706, 0.020768, 0.020798, 0.021180, 0.021439, 0.021317, 0.021241, 0.021592, 0.021820, 0.021424, 0.021149, 0.021271, 0.021363, 0.021958, 0.022354, 0.021683, 0.021225, 0.022309, 0.023041, 0.022782, 0.022599, 0.023239, 0.023682, 0.023575, 0.023499, 0.023087, 0.022812, 0.023911, 0.024659, 0.023575, 0.022827, 0.023438, 0.023850, 0.022950, 0.022339, 0.022385, 0.022416, 0.022187, 0.022034, 0.021592, 0.021286, 0.021408, 0.021485, 0.021607, 0.021683, 0.021607, 0.021561, 0.021012, 0.020630, 0.020996, 0.021256, 0.021424, 0.021546, 0.020691, 0.020111, 0.020996, 0.021607, 0.021180, 0.020890, 0.021027, 0.021118, 0.021118, 0.021118, 0.020600, 0.020233, 0.020935, 0.021408, 0.020905, 0.020569, 0.020676, 0.020752, 0.020737, 0.020722, 0.020554,
		0.020752, 0.020584, 0.020478, 0.020478, 0.020478, 0.020874, 0.021149, 0.021118, 0.021103, 0.021225, 0.021317, 0.021088, 0.020920, 0.020981, 0.021012, 0.020890, 0.020798, 0.021012, 0.021164, 0.021103, 0.021042, 0.021088, 0.021103, 0.021408, 0.021622, 0.021103, 0.020752, 0.020508, 0.020340, 0.020661, 0.020874, 0.021027, 0.021118, 0.021653, 0.022019, 0.021820, 0.021683, 0.020935, 0.020417, 0.021530, 0.022293, 0.022080, 0.021927, 0.021851, 0.021790, 0.021805, 0.021820, 0.022797, 0.023468, 0.023438, 0.023423, 0.023239, 0.023117, 0.022797, 0.022568, 0.022278, 0.022065, 0.022339, 0.022522, 0.021988, 0.021622, 0.021088, 0.020722, 0.021576, 0.022156, 0.021408, 0.020905, 0.020905, 0.020905, 0.021057, 0.021149, 0.021561, 0.021851, 0.021317, 0.020951, 0.021332, 0.021592, 0.021393, 0.021256, 0.020691, 0.020325, 0.021256, 0.021897, 0.021134, 0.020600, 0.021180, 0.021576, 0.021271, 0.021057, 0.021027, 0.021012, 0.021134, 0.021225, 0.021042, 0.020920, 0.021378, 0.021698, 0.021027, 0.020584, 0.020554,
		0.020844, 0.020508, 0.020279, 0.020401, 0.020493, 0.020859, 0.021118, 0.021180, 0.021210, 0.021332, 0.021408, 0.021103, 0.020890, 0.020951, 0.020981, 0.020859, 0.020783, 0.020981, 0.021118, 0.021027, 0.020966, 0.021134, 0.021241, 0.021500, 0.021668, 0.021134, 0.020768, 0.020462, 0.020249, 0.020554, 0.020768, 0.020966, 0.021103, 0.021668, 0.022049, 0.021897, 0.021790, 0.020859, 0.020233, 0.021454, 0.022278, 0.022156, 0.022065, 0.021759, 0.021561, 0.021622, 0.021668, 0.022721, 0.023438, 0.023423, 0.023407, 0.023270, 0.023178, 0.022583, 0.022187, 0.022034, 0.021927, 0.022141, 0.022278, 0.021805, 0.021485, 0.020844, 0.020401, 0.021454, 0.022187, 0.021378, 0.020829, 0.020813, 0.020798, 0.020951, 0.021057, 0.021561, 0.021897, 0.021378, 0.021012, 0.021393, 0.021653, 0.021378, 0.021195, 0.020691, 0.020356, 0.021302, 0.021958, 0.021118, 0.020554, 0.021210, 0.021668, 0.021302, 0.021042, 0.021103, 0.021149, 0.021180, 0.021195, 0.021073, 0.020981, 0.021500, 0.021866, 0.021088, 0.020554, 0.020569,
		0.021241, 0.021103, 0.020996, 0.021195, 0.021317, 0.021469, 0.021576, 0.021546, 0.021515, 0.021149, 0.020905, 0.021180, 0.021378, 0.020783, 0.020371, 0.020951, 0.021332, 0.021820, 0.022156, 0.021485, 0.021012, 0.021042, 0.021057, 0.021088, 0.021118, 0.021180, 0.021225, 0.021073, 0.020951, 0.020981, 0.020981, 0.021530, 0.021912, 0.021454, 0.021149, 0.021195, 0.021241, 0.021241, 0.021256, 0.020844, 0.020569, 0.021424, 0.022004, 0.021897, 0.021820, 0.022385, 0.022782, 0.022141, 0.021714, 0.022370, 0.022827, 0.022629, 0.022492, 0.022614, 0.022705, 0.022507, 0.022370, 0.021408, 0.020752, 0.020981, 0.021149, 0.020706, 0.020417, 0.021134, 0.021637, 0.021225, 0.020951, 0.021180, 0.021332, 0.020798, 0.020447, 0.021073, 0.021500, 0.021042, 0.020722, 0.020508, 0.020356, 0.020264, 0.020203, 0.020935, 0.021424, 0.021271, 0.021180, 0.020844, 0.020630, 0.021180, 0.021546, 0.020951, 0.020523, 0.020645, 0.020737, 0.021134, 0.021408, 0.020890, 0.020539, 0.020661, 0.020737, 0.020829, 0.020890, 0.020935,
		0.021317, 0.021210, 0.021134, 0.021332, 0.021469, 0.021576, 0.021653, 0.021607, 0.021576, 0.021118, 0.020813, 0.021210, 0.021469, 0.020752, 0.020264, 0.020966, 0.021439, 0.021988, 0.022354, 0.021561, 0.021027, 0.021027, 0.021027, 0.021012, 0.021012, 0.021195, 0.021317, 0.021180, 0.021088, 0.021057, 0.021027, 0.021637, 0.022065, 0.021424, 0.020981, 0.021073, 0.021134, 0.021317, 0.021439, 0.020737, 0.020249, 0.021286, 0.021988, 0.021912, 0.021866, 0.022522, 0.022980, 0.022034, 0.021393, 0.022187, 0.022721, 0.022507, 0.022370, 0.022629, 0.022797, 0.022583, 0.022446, 0.021271, 0.020462, 0.020829, 0.021088, 0.020691, 0.020417, 0.021073, 0.021530, 0.021210, 0.020981, 0.021256, 0.021439, 0.020783, 0.020325, 0.020981, 0.021424, 0.020981, 0.020676, 0.020340, 0.020111, 0.020050, 0.020020, 0.020966, 0.021622, 0.021271, 0.021027, 0.020798, 0.020645, 0.021164, 0.021530, 0.020874, 0.020432, 0.020569, 0.020661, 0.021134, 0.021454, 0.020859, 0.020462, 0.020493, 0.020523, 0.020783, 0.020951, 0.020996,
		0.020615, 0.020935, 0.021164, 0.020829, 0.020600, 0.021027, 0.021317, 0.021088, 0.020920, 0.020279, 0.019837, 0.020478, 0.020935, 0.020935, 0.020951, 0.021103, 0.021210, 0.020706, 0.020356, 0.020798, 0.021103, 0.021057, 0.021027, 0.021057, 0.021073, 0.021454, 0.021698, 0.021790, 0.021866, 0.021881, 0.021897, 0.021759, 0.021668, 0.021775, 0.021851, 0.021576, 0.021393, 0.021088, 0.020874, 0.021042, 0.021164, 0.021302, 0.021393, 0.021057, 0.020829, 0.021759, 0.022400, 0.022141, 0.021973, 0.021714, 0.021530, 0.022065, 0.022416, 0.021927, 0.021592, 0.021485, 0.021408, 0.021530, 0.021607, 0.021759, 0.021866, 0.021561, 0.021363, 0.021439, 0.021500, 0.021561, 0.021607, 0.021851, 0.022004, 0.021164, 0.020584, 0.020676, 0.020722, 0.020630, 0.020554, 0.020996, 0.021302, 0.021088, 0.020935, 0.020951, 0.020951, 0.020874, 0.020813, 0.020554, 0.020371, 0.020798, 0.021088, 0.021241, 0.021332, 0.020813, 0.020447, 0.020493, 0.020523, 0.020920, 0.021195, 0.020737, 0.020417, 0.021118, 0.021607, 0.021134,
		0.020478, 0.020890, 0.021164, 0.020737, 0.020447, 0.020920, 0.021256, 0.020981, 0.020798, 0.020111, 0.019654, 0.020356, 0.020829, 0.020966, 0.021073, 0.021134, 0.021164, 0.020462, 0.019989, 0.020661, 0.021118, 0.021057, 0.021027, 0.021057, 0.021088, 0.021500, 0.021775, 0.021912, 0.022004, 0.022034, 0.022065, 0.021790, 0.021592, 0.021851, 0.022019, 0.021668, 0.021439, 0.021042, 0.020768, 0.021103, 0.021332, 0.021302, 0.021286, 0.020890, 0.020630, 0.021622, 0.022293, 0.022171, 0.022080, 0.021622, 0.021317, 0.021973, 0.022431, 0.021790, 0.021363, 0.021271, 0.021210, 0.021576, 0.021820, 0.021927, 0.022004, 0.021729, 0.021530, 0.021515, 0.021500, 0.021637, 0.021729, 0.021958, 0.022110, 0.021225, 0.020630, 0.020615, 0.020600, 0.020569, 0.020539, 0.021118, 0.021515, 0.021271, 0.021103, 0.020935, 0.020829, 0.020798, 0.020783, 0.020508, 0.020325, 0.020737, 0.021012, 0.021302, 0.021500, 0.020859, 0.020417, 0.020386, 0.020356, 0.020935, 0.021332, 0.020783, 0.020401, 0.021195, 0.021729, 0.021164,
		0.020935, 0.021073, 0.021149, 0.021576, 0.021881, 0.021073, 0.020523, 0.020813, 0.020996, 0.021164, 0.021271, 0.021210, 0.021164, 0.020676, 0.020356, 0.021057, 0.021546, 0.021378, 0.021256, 0.021149, 0.021073, 0.020859, 0.020706, 0.020432, 0.020233, 0.020752, 0.021088, 0.020691, 0.020401, 0.021088, 0.021546, 0.021347, 0.021210, 0.021103, 0.021042, 0.020935, 0.020859, 0.021271, 0.021546, 0.021118, 0.020829, 0.021408, 0.021820, 0.021424, 0.021164, 0.020951, 0.020798, 0.021286, 0.021622, 0.021546, 0.021485, 0.021530, 0.021561, 0.021530, 0.021515, 0.021729, 0.021881, 0.021653, 0.021500, 0.021271, 0.021134, 0.021180, 0.021225, 0.021530, 0.021744, 0.021775, 0.021790, 0.021332, 0.021027, 0.021424, 0.021698, 0.020951, 0.020432, 0.020706, 0.020905, 0.020874, 0.020844, 0.020874, 0.020890, 0.020569, 0.020356, 0.021271, 0.021897, 0.021042, 0.020447, 0.020584, 0.020661, 0.020508, 0.020386, 0.020432, 0.020462, 0.020905, 0.021210, 0.021286, 0.021347, 0.020706, 0.020279, 0.020325, 0.020356, 0.020386,
		0.021027, 0.021103, 0.021149, 0.021744, 0.022141, 0.021103, 0.020386, 0.020783, 0.021042, 0.021363, 0.021576, 0.021363, 0.021225, 0.020630, 0.020218, 0.021057, 0.021622, 0.021546, 0.021485, 0.021225, 0.021057, 0.020813, 0.020645, 0.020310, 0.020081, 0.020600, 0.020966, 0.020462, 0.020111, 0.020905, 0.021454, 0.021271, 0.021134, 0.020966, 0.020859, 0.020798, 0.020752, 0.021302, 0.021683, 0.021118, 0.020737, 0.021439, 0.021912, 0.021515, 0.021256, 0.020813, 0.020523, 0.021134, 0.021546, 0.021530, 0.021515, 0.021439, 0.021393, 0.021485, 0.021546, 0.021820, 0.022004, 0.021668, 0.021439, 0.021164, 0.020966, 0.021088, 0.021164, 0.021530, 0.021790, 0.021805, 0.021805, 0.021225, 0.020829, 0.021469, 0.021897, 0.021012, 0.020401, 0.020737, 0.020966, 0.020813, 0.020722, 0.020798, 0.020844, 0.020493, 0.020264, 0.021363, 0.022110, 0.021134, 0.020478, 0.020554, 0.020600, 0.020356, 0.020188, 0.020356, 0.020478, 0.020996, 0.021363, 0.021347, 0.021347, 0.020691, 0.020249, 0.020157, 0.020096, 0.020249,
		0.021103, 0.021302, 0.021439, 0.021180, 0.021012, 0.020981, 0.020966, 0.020935, 0.020920, 0.020981, 0.021042, 0.020874, 0.020768, 0.020722, 0.020676, 0.020996, 0.021210, 0.021164, 0.021134, 0.021012, 0.020935, 0.021180, 0.021347, 0.020951, 0.020691, 0.020768, 0.020813, 0.021286, 0.021622, 0.021408, 0.021256, 0.020676, 0.020279, 0.021027, 0.021546, 0.021073, 0.020752, 0.020951, 0.021073, 0.021195, 0.021271, 0.021942, 0.022400, 0.022263, 0.022171, 0.021912, 0.021729, 0.021241, 0.020920, 0.021332, 0.021607, 0.021698, 0.021759, 0.021317, 0.021012, 0.020951, 0.020920, 0.021180, 0.021363, 0.021302, 0.021256, 0.021607, 0.021836, 0.021302, 0.020920, 0.020981, 0.021012, 0.020768, 0.020615, 0.020859, 0.021027, 0.020920, 0.020844, 0.020966, 0.021042, 0.020966, 0.020920, 0.020630, 0.020447, 0.020706, 0.020874, 0.021042, 0.021149, 0.020768, 0.020508, 0.020935, 0.021241, 0.021057, 0.020935, 0.020432, 0.020096, 0.021027, 0.021668, 0.021103, 0.020722, 0.020356, 0.020127, 0.020172, 0.020203, 0.020829,
		0.021118, 0.021332, 0.021485, 0.021073, 0.020798, 0.020966, 0.021073, 0.020966, 0.020890, 0.020920, 0.020935, 0.020783, 0.020691, 0.020737, 0.020768, 0.020981, 0.021134, 0.021103, 0.021073, 0.020966, 0.020905, 0.021241, 0.021469, 0.021073, 0.020798, 0.020783, 0.020783, 0.021439, 0.021897, 0.021500, 0.021225, 0.020569, 0.020127, 0.021042, 0.021668, 0.021118, 0.020752, 0.020874, 0.020966, 0.021195, 0.021363, 0.022034, 0.022492, 0.022400, 0.022339, 0.022110, 0.021958, 0.021271, 0.020798, 0.021286, 0.021622, 0.021744, 0.021836, 0.021286, 0.020905, 0.020798, 0.020722, 0.021088, 0.021347, 0.021332, 0.021317, 0.021698, 0.021958, 0.021256, 0.020768, 0.020829, 0.020859, 0.020691, 0.020569, 0.020737, 0.020859, 0.020890, 0.020920, 0.020996, 0.021057, 0.020996, 0.020951, 0.020600, 0.020371, 0.020737, 0.020996, 0.020981, 0.020966, 0.020691, 0.020508, 0.021012, 0.021363, 0.021195, 0.021073, 0.020447, 0.020020, 0.021027, 0.021729, 0.021057, 0.020600, 0.020294, 0.020096, 0.020172, 0.020218, 0.020935,
		0.020996, 0.021561, 0.021942, 0.021180, 0.020661, 0.020569, 0.020508, 0.020676, 0.020798, 0.021241, 0.021546, 0.021653, 0.021714, 0.021195, 0.020829, 0.020294, 0.019944, 0.020569, 0.020996, 0.020844, 0.020752, 0.020523, 0.020371, 0.020676, 0.020874, 0.021241, 0.021485, 0.020951, 0.020600, 0.020706, 0.020783, 0.020798, 0.020813, 0.020874, 0.020920, 0.020630, 0.020447, 0.020798, 0.021027, 0.020844, 0.020706, 0.020905, 0.021042, 0.021363, 0.021592, 0.021607, 0.021607, 0.021210, 0.020920, 0.021729, 0.022278, 0.021576, 0.021088, 0.020737, 0.020508, 0.021118, 0.021530, 0.021561, 0.021592, 0.021866, 0.022065, 0.021561, 0.021225, 0.021118, 0.021042, 0.021164, 0.021256, 0.021424, 0.021530, 0.021515, 0.021500, 0.021088, 0.020798, 0.021027, 0.021195, 0.020996, 0.020859, 0.020966, 0.021027, 0.020966, 0.020935, 0.021027, 0.021088, 0.020356, 0.019852, 0.020371, 0.020722, 0.020829, 0.020890, 0.020600, 0.020401, 0.021042, 0.021485, 0.021088, 0.020813, 0.020844, 0.020874, 0.020859, 0.020859, 0.020813,
		0.020981, 0.021592, 0.022019, 0.021195, 0.020630, 0.020493, 0.020401, 0.020630, 0.020783, 0.021302, 0.021668, 0.021805, 0.021897, 0.021271, 0.020844, 0.020172, 0.019715, 0.020462, 0.020981, 0.020829, 0.020722, 0.020401, 0.020172, 0.020600, 0.020890, 0.021317, 0.021607, 0.020859, 0.020356, 0.020569, 0.020706, 0.020844, 0.020935, 0.020844, 0.020783, 0.020554, 0.020386, 0.020783, 0.021042, 0.020768, 0.020584, 0.020691, 0.020768, 0.021180, 0.021454, 0.021515, 0.021546, 0.021195, 0.020951, 0.021805, 0.022400, 0.021546, 0.020951, 0.020645, 0.020432, 0.021180, 0.021683, 0.021653, 0.021637, 0.021973, 0.022202, 0.021546, 0.021088, 0.021088, 0.021088, 0.021241, 0.021332, 0.021561, 0.021714, 0.021653, 0.021622, 0.021118, 0.020768, 0.021042, 0.021225, 0.020996, 0.020844, 0.021027, 0.021149, 0.021012, 0.020920, 0.021042, 0.021118, 0.020294, 0.019730, 0.020249, 0.020600, 0.020752, 0.020859, 0.020630, 0.020478, 0.021042, 0.021439, 0.021088, 0.020859, 0.020951, 0.021012, 0.020996, 0.020981, 0.020783,
		0.021103, 0.021515, 0.021805, 0.020996, 0.020447, 0.020874, 0.021180, 0.021103, 0.021073, 0.020798, 0.020615, 0.020554, 0.020523, 0.020798, 0.020996, 0.020508, 0.020172, 0.020920, 0.021424, 0.021454, 0.021485, 0.020661, 0.020096, 0.020249, 0.020356, 0.020340, 0.020325, 0.020951, 0.021378, 0.021118, 0.020935, 0.020920, 0.020890, 0.020722, 0.020600, 0.021027, 0.021332, 0.020920, 0.020645, 0.020859, 0.020996, 0.020752, 0.020584, 0.020508, 0.020462, 0.020447, 0.020432, 0.020844, 0.021118, 0.021378, 0.021561, 0.021424, 0.021332, 0.020920, 0.020630, 0.020798, 0.020905, 0.021180, 0.021363, 0.021149, 0.021012, 0.020737, 0.020554, 0.020539, 0.020539, 0.020951, 0.021241, 0.020813, 0.020523, 0.021561, 0.022263, 0.020951, 0.020050, 0.020294, 0.020447, 0.020813, 0.021057, 0.021042, 0.021027, 0.021408, 0.021653, 0.021530, 0.021454, 0.020798, 0.020356, 0.020462, 0.020554, 0.020676, 0.020752, 0.020966, 0.021103, 0.020874, 0.020722, 0.021241, 0.021607, 0.021073, 0.020706, 0.020508, 0.020356, 0.020325,
		0.021118, 0.021500, 0.021759, 0.020966, 0.020417, 0.020951, 0.021317, 0.021195, 0.021118, 0.020706, 0.020417, 0.020325, 0.020264, 0.020722, 0.021027, 0.020569, 0.020264, 0.020996, 0.021500, 0.021576, 0.021622, 0.020706, 0.020081, 0.020188, 0.020249, 0.020157, 0.020096, 0.020966, 0.021561, 0.021210, 0.020981, 0.020920, 0.020890, 0.020706, 0.020569, 0.021118, 0.021500, 0.020951, 0.020569, 0.020874, 0.021073, 0.020768, 0.020554, 0.020386, 0.020279, 0.020249, 0.020218, 0.020768, 0.021149, 0.021302, 0.021408, 0.021408, 0.021408, 0.020966, 0.020676, 0.020722, 0.020752, 0.021088, 0.021317, 0.020996, 0.020783, 0.020584, 0.020447, 0.020432, 0.020432, 0.020905, 0.021225, 0.020676, 0.020294, 0.021530, 0.022385, 0.020920, 0.019913, 0.020142, 0.020310, 0.020768, 0.021088, 0.021042, 0.021012, 0.021469, 0.021790, 0.021622, 0.021515, 0.020890, 0.020462, 0.020508, 0.020539, 0.020661, 0.020737, 0.021027, 0.021225, 0.020844, 0.020584, 0.021271, 0.021744, 0.021088, 0.020645, 0.020417, 0.020249, 0.020249,
		0.021118, 0.020493, 0.020066, 0.020478, 0.020768, 0.020539, 0.020371, 0.021256, 0.021851, 0.020935, 0.020310, 0.020249, 0.020203, 0.021134, 0.021775, 0.021271, 0.020935, 0.021149, 0.021302, 0.021241, 0.021195, 0.020890, 0.020691, 0.020203, 0.019883, 0.020691, 0.021256, 0.020951, 0.020737, 0.020920, 0.021027, 0.021027, 0.021027, 0.020706, 0.020493, 0.021317, 0.021881, 0.021790, 0.021729, 0.020722, 0.020050, 0.020432, 0.020706, 0.020798, 0.020874, 0.020768, 0.020691, 0.020706, 0.020706, 0.020722, 0.020737, 0.020996, 0.021164, 0.021424, 0.021592, 0.021561, 0.021530, 0.021714, 0.021851, 0.021836, 0.021836, 0.021317, 0.020951, 0.020722, 0.020569, 0.020859, 0.021057, 0.021347, 0.021546, 0.021744, 0.021866, 0.021393, 0.021057, 0.020294, 0.019776, 0.020737, 0.021393, 0.021424, 0.021439, 0.021073, 0.020813, 0.021225, 0.021515, 0.021332, 0.021210, 0.020493, 0.020005, 0.020706, 0.021195, 0.020706, 0.020371, 0.020478, 0.020554, 0.020752, 0.020874, 0.021073, 0.021195, 0.020752, 0.020447, 0.020569,
		0.021118, 0.020310, 0.019745, 0.020386, 0.020829, 0.020462, 0.020203, 0.021256, 0.021988, 0.020981, 0.020294, 0.020233, 0.020188, 0.021210, 0.021912, 0.021408, 0.021057, 0.021180, 0.021256, 0.021180, 0.021118, 0.020935, 0.020798, 0.020203, 0.019806, 0.020798, 0.021469, 0.020951, 0.020584, 0.020859, 0.021042, 0.021057, 0.021057, 0.020706, 0.020478, 0.021363, 0.021958, 0.021942, 0.021942, 0.020706, 0.019852, 0.020371, 0.020737, 0.020874, 0.020981, 0.020859, 0.020783, 0.020691, 0.020630, 0.020615, 0.020615, 0.020920, 0.021118, 0.021500, 0.021759, 0.021714, 0.021683, 0.021836, 0.021942, 0.022004, 0.022034, 0.021439, 0.021042, 0.020783, 0.020600, 0.020859, 0.021027, 0.021469, 0.021775, 0.021775, 0.021775, 0.021469, 0.021271, 0.020325, 0.019669, 0.020722, 0.021454, 0.021485, 0.021515, 0.020996, 0.020630, 0.021149, 0.021515, 0.021408, 0.021347, 0.020493, 0.019913, 0.020722, 0.021271, 0.020645, 0.020218, 0.020417, 0.020554, 0.020661, 0.020722, 0.021073, 0.021302, 0.020829, 0.020493, 0.020630,
		0.021225, 0.020233, 0.019547, 0.019867, 0.020096, 0.020417, 0.020645, 0.021012, 0.021271, 0.021103, 0.020996, 0.020996, 0.020996, 0.021424, 0.021714, 0.021668, 0.021622, 0.021241, 0.020981, 0.021210, 0.021378, 0.020829, 0.020447, 0.020432, 0.020417, 0.020951, 0.021317, 0.020722, 0.020310, 0.020356, 0.020371, 0.020798, 0.021088, 0.021195, 0.021256, 0.020691, 0.020310, 0.021012, 0.021485, 0.021302, 0.021180, 0.021225, 0.021256, 0.020783, 0.020447, 0.021180, 0.021683, 0.021164, 0.020813, 0.020859, 0.020905, 0.020584, 0.020371, 0.020829, 0.021134, 0.021530, 0.021805, 0.021485, 0.021256, 0.021485, 0.021637, 0.020966, 0.020508, 0.020569, 0.020600, 0.021073, 0.021393, 0.021118, 0.020920, 0.020661, 0.020493, 0.020996, 0.021332, 0.020859, 0.020539, 0.020905, 0.021164, 0.021576, 0.021866, 0.020706, 0.019928, 0.020249, 0.020478, 0.020706, 0.020874, 0.020294, 0.019898, 0.020203, 0.020417, 0.020356, 0.020310, 0.020447, 0.020539, 0.020142, 0.019852, 0.020844, 0.021515, 0.021439, 0.021378, 0.020996,
		0.021241, 0.020218, 0.019516, 0.019776, 0.019959, 0.020417, 0.020722, 0.020966, 0.021134, 0.021118, 0.021118, 0.021134, 0.021149, 0.021469, 0.021683, 0.021714, 0.021729, 0.021256, 0.020935, 0.021225, 0.021424, 0.020813, 0.020386, 0.020478, 0.020539, 0.020981, 0.021286, 0.020676, 0.020264, 0.020249, 0.020249, 0.020752, 0.021088, 0.021271, 0.021408, 0.020569, 0.020005, 0.020844, 0.021408, 0.021424, 0.021424, 0.021378, 0.021347, 0.020752, 0.020356, 0.021241, 0.021851, 0.021256, 0.020844, 0.020905, 0.020951, 0.020523, 0.020233, 0.020691, 0.021012, 0.021500, 0.021836, 0.021424, 0.021134, 0.021393, 0.021561, 0.020874, 0.020417, 0.020523, 0.020600, 0.021103, 0.021454, 0.021042, 0.020768, 0.020462, 0.020249, 0.020905, 0.021347, 0.020951, 0.020691, 0.020935, 0.021103, 0.021592, 0.021927, 0.020661, 0.019791, 0.020081, 0.020279, 0.020584, 0.020783, 0.020264, 0.019898, 0.020111, 0.020264, 0.020294, 0.020325, 0.020447, 0.020539, 0.020035, 0.019699, 0.020798, 0.021561, 0.021546, 0.021546, 0.021057,
		0.020783, 0.020569, 0.020417, 0.020844, 0.021134, 0.021195, 0.021256, 0.020844, 0.020554, 0.020706, 0.020829, 0.020706, 0.020630, 0.021363, 0.021866, 0.022049, 0.022187, 0.021195, 0.020523, 0.020890, 0.021134, 0.021210, 0.021256, 0.020783, 0.020462, 0.020356, 0.020294, 0.020829, 0.021210, 0.021088, 0.021012, 0.021057, 0.021088, 0.021271, 0.021393, 0.020935, 0.020615, 0.020737, 0.020813, 0.021088, 0.021286, 0.021118, 0.021012, 0.020981, 0.020966, 0.021241, 0.021424, 0.021317, 0.021241, 0.021347, 0.021408, 0.021180, 0.021012, 0.021256, 0.021424, 0.021332, 0.021271, 0.021057, 0.020920, 0.021027, 0.021103, 0.020890, 0.020752, 0.020935, 0.021057, 0.021439, 0.021683, 0.021134, 0.020768, 0.021653, 0.022263, 0.021210, 0.020493, 0.020859, 0.021103, 0.021332, 0.021485, 0.021515, 0.021530, 0.020859, 0.020401, 0.020737, 0.020966, 0.021164, 0.021302, 0.021103, 0.020966, 0.020691, 0.020493, 0.020768, 0.020935, 0.021378, 0.021683, 0.021408, 0.021225, 0.020905, 0.020691, 0.021118, 0.021408, 0.020966,
		0.020706, 0.020630, 0.020584, 0.021042, 0.021347, 0.021347, 0.021347, 0.020813, 0.020447, 0.020630, 0.020768, 0.020630, 0.020539, 0.021347, 0.021897, 0.022110, 0.022263, 0.021180, 0.020447, 0.020829, 0.021088, 0.021286, 0.021424, 0.020844, 0.020447, 0.020249, 0.020111, 0.020859, 0.021378, 0.021241, 0.021149, 0.021118, 0.021088, 0.021271, 0.021393, 0.020996, 0.020722, 0.020706, 0.020706, 0.021027, 0.021256, 0.021073, 0.020951, 0.021027, 0.021073, 0.021241, 0.021347, 0.021332, 0.021317, 0.021424, 0.021500, 0.021302, 0.021164, 0.021363, 0.021500, 0.021302, 0.021164, 0.020996, 0.020874, 0.020951, 0.021012, 0.020890, 0.020813, 0.021012, 0.021149, 0.021500, 0.021729, 0.021164, 0.020768, 0.021866, 0.022629, 0.021271, 0.020340, 0.020844, 0.021180, 0.021408, 0.021561, 0.021500, 0.021454, 0.020890, 0.020508, 0.020859, 0.021088, 0.021271, 0.021393, 0.021256, 0.021164, 0.020798, 0.020539, 0.020844, 0.021057, 0.021561, 0.021897, 0.021668, 0.021500, 0.020920, 0.020523, 0.021027, 0.021378, 0.020951,
		0.020340, 0.020661, 0.020874, 0.020783, 0.020706, 0.021195, 0.021546, 0.021134, 0.020844, 0.021195, 0.021424, 0.021714, 0.021912, 0.021500, 0.021225, 0.021378, 0.021485, 0.021393, 0.021317, 0.021088, 0.020920, 0.020920, 0.020920, 0.020539, 0.020279, 0.020432, 0.020539, 0.020523, 0.020508, 0.020966, 0.021271, 0.021393, 0.021469, 0.020645, 0.020081, 0.021027, 0.021683, 0.021027, 0.020569, 0.021332, 0.021866, 0.021134, 0.020645, 0.020554, 0.020508, 0.020706, 0.020829, 0.021424, 0.021836, 0.021790, 0.021759, 0.021073, 0.020600, 0.021118, 0.021485, 0.021393, 0.021332, 0.020813, 0.020462, 0.020798, 0.021042, 0.020874, 0.020768, 0.021057, 0.021271, 0.020783, 0.020447, 0.020386, 0.020340, 0.021454, 0.022202, 0.021500, 0.021027, 0.021347, 0.021561, 0.020966, 0.020554, 0.020935, 0.021180, 0.020737, 0.020447, 0.020600, 0.020706, 0.021256, 0.021622, 0.021424, 0.021286, 0.021469, 0.021607, 0.021134, 0.020798, 0.020752, 0.020706, 0.021363, 0.021805, 0.021439, 0.021180, 0.021286, 0.021347, 0.021241,
		0.020279, 0.020676, 0.020935, 0.020722, 0.020584, 0.021180, 0.021576, 0.021180, 0.020920, 0.021286, 0.021546, 0.021912, 0.022171, 0.021530, 0.021103, 0.021241, 0.021332, 0.021424, 0.021485, 0.021134, 0.020890, 0.020859, 0.020829, 0.020478, 0.020249, 0.020462, 0.020615, 0.020447, 0.020340, 0.020905, 0.021302, 0.021454, 0.021546, 0.020539, 0.019837, 0.021042, 0.021866, 0.021073, 0.020539, 0.021393, 0.021973, 0.021149, 0.020584, 0.020478, 0.020401, 0.020600, 0.020737, 0.021439, 0.021927, 0.021851, 0.021805, 0.021027, 0.020493, 0.021088, 0.021485, 0.021408, 0.021363, 0.020783, 0.020386, 0.020783, 0.021042, 0.020874, 0.020752, 0.021073, 0.021286, 0.020645, 0.020203, 0.020233, 0.020264, 0.021363, 0.022126, 0.021546, 0.021149, 0.021439, 0.021637, 0.020890, 0.020371, 0.020829, 0.021134, 0.020722, 0.020432, 0.020554, 0.020630, 0.021241, 0.021668, 0.021454, 0.021302, 0.021607, 0.021805, 0.021180, 0.020752, 0.020600, 0.020493, 0.021302, 0.021866, 0.021530, 0.021302, 0.021332, 0.021347, 0.021302,
		0.021408, 0.020401, 0.019699, 0.020600, 0.021210, 0.021317, 0.021393, 0.020996, 0.020722, 0.020798, 0.020844, 0.020508, 0.020279, 0.020691, 0.020966, 0.021195, 0.021347, 0.020981, 0.020737, 0.020981, 0.021149, 0.021561, 0.021851, 0.020981, 0.020371, 0.020249, 0.020157, 0.020233, 0.020294, 0.020493, 0.020645, 0.020630, 0.020630, 0.020676, 0.020706, 0.020966, 0.021149, 0.021317, 0.021439, 0.021164, 0.020966, 0.020722, 0.020539, 0.020310, 0.020157, 0.020478, 0.020691, 0.020951, 0.021118, 0.021012, 0.020935, 0.020874, 0.020844, 0.021180, 0.021408, 0.021302, 0.021241, 0.021118, 0.021042, 0.021164, 0.021241, 0.021210, 0.021180, 0.021195, 0.021210, 0.020966, 0.020798, 0.020615, 0.020478, 0.020554, 0.020600, 0.020752, 0.020844, 0.020890, 0.020935, 0.020630, 0.020417, 0.020996, 0.021393, 0.020569, 0.020005, 0.020813, 0.021378, 0.020752, 0.020310, 0.021042, 0.021546, 0.020798, 0.020294, 0.020813, 0.021164, 0.021042, 0.020966, 0.020935, 0.020920, 0.020829, 0.020768, 0.020768, 0.020783, 0.020600,
		0.021622, 0.020340, 0.019471, 0.020569, 0.021332, 0.021347, 0.021363, 0.020966, 0.020691, 0.020706, 0.020722, 0.020249, 0.019928, 0.020523, 0.020935, 0.021180, 0.021347, 0.020905, 0.020600, 0.020951, 0.021195, 0.021698, 0.022034, 0.021057, 0.020401, 0.020203, 0.020066, 0.020188, 0.020279, 0.020417, 0.020523, 0.020493, 0.020462, 0.020706, 0.020874, 0.020951, 0.021012, 0.021363, 0.021607, 0.021118, 0.020783, 0.020630, 0.020539, 0.020279, 0.020111, 0.020462, 0.020691, 0.020859, 0.020966, 0.020844, 0.020768, 0.020844, 0.020905, 0.021195, 0.021393, 0.021286, 0.021210, 0.021180, 0.021164, 0.021241, 0.021286, 0.021271, 0.021256, 0.021225, 0.021195, 0.021027, 0.020905, 0.020676, 0.020523, 0.020401, 0.020325, 0.020600, 0.020783, 0.020798, 0.020798, 0.020584, 0.020432, 0.021027, 0.021439, 0.020539, 0.019928, 0.020874, 0.021515, 0.020661, 0.020066, 0.020966, 0.021592, 0.020661, 0.020020, 0.020752, 0.021241, 0.021134, 0.021057, 0.020874, 0.020737, 0.020691, 0.020661, 0.020676, 0.020676, 0.020478,
		0.021042, 0.020569, 0.020249, 0.020478, 0.020630, 0.020874, 0.021057, 0.020752, 0.020554, 0.020859, 0.021088, 0.021164, 0.021210, 0.021012, 0.020874, 0.020859, 0.020859, 0.020554, 0.020356, 0.021027, 0.021485, 0.021042, 0.020737, 0.020539, 0.020417, 0.020188, 0.020020, 0.020127, 0.020188, 0.020356, 0.020462, 0.020829, 0.021088, 0.021134, 0.021164, 0.020996, 0.020874, 0.020752, 0.020661, 0.020859, 0.020996, 0.021256, 0.021439, 0.020935, 0.020584, 0.021286, 0.021759, 0.021439, 0.021225, 0.021210, 0.021210, 0.021134, 0.021088, 0.021195, 0.021271, 0.020706, 0.020340, 0.020340, 0.020356, 0.020630, 0.020829, 0.020829, 0.020829, 0.020676, 0.020569, 0.020859, 0.021073, 0.020935, 0.020829, 0.020539, 0.020340, 0.020859, 0.021210, 0.021164, 0.021149, 0.021073, 0.021027, 0.020996, 0.020981, 0.021103, 0.021180, 0.020584, 0.020172, 0.020386, 0.020539, 0.021180, 0.021607, 0.020844, 0.020325, 0.020890, 0.021271, 0.021210, 0.021164, 0.021271, 0.021347, 0.020996, 0.020752, 0.020493, 0.020325, 0.020920,
		0.020935, 0.020615, 0.020401, 0.020462, 0.020493, 0.020798, 0.020996, 0.020722, 0.020523, 0.020890, 0.021149, 0.021332, 0.021454, 0.021103, 0.020859, 0.020798, 0.020768, 0.020493, 0.020310, 0.021027, 0.021530, 0.020920, 0.020493, 0.020447, 0.020417, 0.020188, 0.020020, 0.020111, 0.020172, 0.020340, 0.020447, 0.020890, 0.021195, 0.021210, 0.021225, 0.020996, 0.020844, 0.020630, 0.020493, 0.020813, 0.021042, 0.021378, 0.021607, 0.021057, 0.020676, 0.021439, 0.021958, 0.021546, 0.021271, 0.021286, 0.021286, 0.021180, 0.021118, 0.021195, 0.021241, 0.020600, 0.020172, 0.020188, 0.020203, 0.020523, 0.020737, 0.020752, 0.020752, 0.020569, 0.020447, 0.020844, 0.021103, 0.020981, 0.020890, 0.020569, 0.020340, 0.020905, 0.021286, 0.021241, 0.021210, 0.021164, 0.021134, 0.020996, 0.020905, 0.021210, 0.021408, 0.020523, 0.019928, 0.020340, 0.020630, 0.021210, 0.021607, 0.020874, 0.020386, 0.020905, 0.021271, 0.021210, 0.021180, 0.021347, 0.021454, 0.021042, 0.020768, 0.020462, 0.020264, 0.021012,
		0.020432, 0.020600, 0.020706, 0.021180, 0.021500, 0.021118, 0.020874, 0.021118, 0.021286, 0.020768, 0.020417, 0.020386, 0.020371, 0.020905, 0.021271, 0.020478, 0.019944, 0.020172, 0.020340, 0.020829, 0.021164, 0.021103, 0.021057, 0.021073, 0.021088, 0.020935, 0.020844, 0.020935, 0.020996, 0.020478, 0.020127, 0.020676, 0.021042, 0.020920, 0.020829, 0.020676, 0.020569, 0.020706, 0.020783, 0.021271, 0.021592, 0.021408, 0.021286, 0.021271, 0.021271, 0.021317, 0.021347, 0.021515, 0.021637, 0.021530, 0.021454, 0.020829, 0.020417, 0.020829, 0.021118, 0.020890, 0.020737, 0.020783, 0.020813, 0.021012, 0.021164, 0.020325, 0.019745, 0.020615, 0.021210, 0.020645, 0.020264, 0.020844, 0.021256, 0.020737, 0.020386, 0.020920, 0.021286, 0.021561, 0.021744, 0.021332, 0.021042, 0.020752, 0.020539, 0.021134, 0.021530, 0.021164, 0.020920, 0.021149, 0.021302, 0.021088, 0.020951, 0.020615, 0.020386, 0.020691, 0.020905, 0.020996, 0.021057, 0.020676, 0.020417, 0.020584, 0.020706, 0.020783, 0.020844, 0.021027,
		0.020340, 0.020600, 0.020768, 0.021317, 0.021683, 0.021180, 0.020844, 0.021195, 0.021424, 0.020737, 0.020279, 0.020218, 0.020172, 0.020874, 0.021347, 0.020417, 0.019791, 0.020111, 0.020340, 0.020783, 0.021088, 0.021134, 0.021164, 0.021195, 0.021210, 0.021088, 0.020996, 0.021088, 0.021149, 0.020508, 0.020066, 0.020630, 0.021012, 0.020859, 0.020752, 0.020615, 0.020523, 0.020706, 0.020844, 0.021347, 0.021698, 0.021424, 0.021225, 0.021317, 0.021378, 0.021302, 0.021241, 0.021515, 0.021698, 0.021576, 0.021485, 0.020768, 0.020279, 0.020768, 0.021103, 0.020951, 0.020844, 0.020890, 0.020920, 0.021103, 0.021241, 0.020249, 0.019562, 0.020615, 0.021347, 0.020615, 0.020111, 0.020829, 0.021317, 0.020768, 0.020401, 0.020920, 0.021286, 0.021607, 0.021836, 0.021363, 0.021027, 0.020706, 0.020478, 0.021118, 0.021546, 0.021286, 0.021103, 0.021286, 0.021424, 0.021073, 0.020829, 0.020569, 0.020386, 0.020661, 0.020844, 0.020966, 0.021042, 0.020554, 0.020218, 0.020493, 0.020691, 0.020844, 0.020951, 0.021027,
		0.020935, 0.021027, 0.021088, 0.020630, 0.020325, 0.020615, 0.020813, 0.020783, 0.020752, 0.021210, 0.021515, 0.021332, 0.021210, 0.021134, 0.021088, 0.020890, 0.020737, 0.021271, 0.021637, 0.021042, 0.020630, 0.020813, 0.020951, 0.021118, 0.021241, 0.020890, 0.020661, 0.020737, 0.020798, 0.020569, 0.020401, 0.020783, 0.021057, 0.020539, 0.020188, 0.020325, 0.020401, 0.020569, 0.020691, 0.020676, 0.020661, 0.020798, 0.020890, 0.020874, 0.020859, 0.020630, 0.020478, 0.020493, 0.020508, 0.020600, 0.020661, 0.020447, 0.020294, 0.020600, 0.020813, 0.020859, 0.020890, 0.021378, 0.021698, 0.021668, 0.021653, 0.021073, 0.020676, 0.020890, 0.021042, 0.021164, 0.021256, 0.020722, 0.020356, 0.020798, 0.021103, 0.021134, 0.021149, 0.021408, 0.021592, 0.020584, 0.019898, 0.020737, 0.021302, 0.021118, 0.021012, 0.021271, 0.021469, 0.020966, 0.020615, 0.020249, 0.019989, 0.020569, 0.020966, 0.021042, 0.021088, 0.021073, 0.021057, 0.020966, 0.020920, 0.020920, 0.020935, 0.020996, 0.021027, 0.020935,
		0.021042, 0.021103, 0.021149, 0.020508, 0.020066, 0.020508, 0.020813, 0.020706, 0.020630, 0.021286, 0.021744, 0.021546, 0.021408, 0.021195, 0.021042, 0.020966, 0.020920, 0.021485, 0.021881, 0.021088, 0.020554, 0.020768, 0.020905, 0.021103, 0.021241, 0.020859, 0.020600, 0.020676, 0.020737, 0.020569, 0.020462, 0.020813, 0.021057, 0.020478, 0.020081, 0.020264, 0.020386, 0.020554, 0.020661, 0.020554, 0.020478, 0.020691, 0.020829, 0.020798, 0.020768, 0.020508, 0.020340, 0.020310, 0.020279, 0.020417, 0.020508, 0.020386, 0.020294, 0.020569, 0.020752, 0.020844, 0.020905, 0.021469, 0.021851, 0.021775, 0.021729, 0.021225, 0.020890, 0.020951, 0.020981, 0.021271, 0.021469, 0.020706, 0.020172, 0.020813, 0.021241, 0.021164, 0.021118, 0.021378, 0.021546, 0.020447, 0.019684, 0.020737, 0.021454, 0.021134, 0.020905, 0.021271, 0.021530, 0.020890, 0.020462, 0.020096, 0.019837, 0.020569, 0.021073, 0.021103, 0.021134, 0.021088, 0.021057, 0.021042, 0.021042, 0.021012, 0.020981, 0.021012, 0.021042, 0.020920,
		0.019821, 0.020737, 0.021363, 0.021378, 0.021393, 0.021241, 0.021149, 0.020706, 0.020417, 0.020844, 0.021134, 0.021561, 0.021866, 0.021439, 0.021164, 0.021271, 0.021347, 0.021164, 0.021042, 0.020874, 0.020752, 0.020890, 0.020996, 0.020539, 0.020218, 0.020188, 0.020157, 0.020386, 0.020539, 0.020737, 0.020890, 0.020981, 0.021042, 0.020752, 0.020554, 0.020569, 0.020584, 0.020508, 0.020462, 0.020584, 0.020676, 0.020584, 0.020539, 0.020386, 0.020294, 0.020905, 0.021332, 0.020447, 0.019852, 0.020493, 0.020920, 0.020890, 0.020874, 0.020829, 0.020798, 0.021180, 0.021439, 0.021378, 0.021332, 0.021225, 0.021164, 0.021134, 0.021118, 0.020920, 0.020783, 0.021195, 0.021469, 0.021546, 0.021607, 0.021775, 0.021897, 0.021057, 0.020478, 0.020630, 0.020752, 0.021241, 0.021576, 0.021454, 0.021363, 0.020645, 0.020142, 0.020432, 0.020630, 0.020401, 0.020264, 0.019989, 0.019791, 0.020340, 0.020706, 0.021027, 0.021256, 0.021546, 0.021759, 0.021073, 0.020615, 0.020600, 0.020584, 0.021057, 0.021378, 0.020600
};

#define HEIGHT 100
#define WIDTH 100
#define BG 0.021219

static gsl_matrix *fill_star(float *s, data_type type){
	gsl_matrix *z = gsl_matrix_alloc(HEIGHT, WIDTH);

	for (int i = 0; i < HEIGHT; i++) {
		for (int j = 0; j < WIDTH; j++) {
			double px = type == DATA_USHORT ? *s * USHRT_MAX_DOUBLE : *s;
			gsl_matrix_set(z, i, j, px);
			s++;
		}
	}
	return z;
}

void test_photometry_float() {
	double bg = BG;
	initialize_photometric_param();
	gsl_matrix *matrix = fill_star(star, DATA_FLOAT);
	psf_star *psf = psf_global_minimisation(matrix, bg, 1., 1, FALSE, TRUE, &com.pref.phot_set, FALSE, PSF_GAUSSIAN, NULL);

	cr_assert(psf, "psf failed");
	cr_assert(psf->phot, "photometry failed");
	cr_assert(psf->phot_is_valid, "photometry is not valid");

	cr_expect_float_eq(psf->mag, -3.451165f, 1e-6);
	cr_expect_float_eq(psf->s_mag, 0.146089f, 1e-6);

	cr_expect_float_eq(psf->x0, 51.27f, 1e-2);
	cr_expect_float_eq(psf->y0, 54.24f, 1e-2);
	cr_expect_float_eq(psf->fwhmx, 8.160966f, 1e-6);
	cr_expect_float_eq(psf->fwhmy, 7.250390f, 1e-6);
	cr_expect_float_eq(psf->angle, -21.648769f, 1e-6);
	cr_expect_float_eq(psf->A, 0.329290f, 1e-6);
	cr_expect_float_eq(psf->B, 0.021232f, 1e-6);
	cr_expect_float_eq(psf->rmse, 2.250e-03, 1e-6);

	gsl_matrix_free(matrix);
	free_psf(psf);
}

void test_photometry_ushort() {
	double bg = BG;
	initialize_photometric_param();
	gsl_matrix *matrix = fill_star(star, DATA_USHORT);
	psf_error error;
	psf_star *psf = psf_global_minimisation(matrix, bg, USHRT_MAX_DOUBLE, 1, FALSE, TRUE, &com.pref.phot_set, FALSE, PSF_GAUSSIAN, &error);

	cr_assert(psf, "psf failed");
	cr_assert(psf->phot, "photometry failed");
	cr_assert(psf->phot_is_valid, "photometry is not valid");
	cr_assert(error == PSF_NO_ERR, "error was set");

	/* These values are different from float case. This
	 * is perfectly normal.
	 */
	cr_expect_float_eq(psf->mag, -15.492348f, 1e-6);
	cr_expect_float_eq(psf->s_mag, 0.000947f, 1e-6);

	/* These values are almost identical to float case.
	 * This is due to the tolerance being set in the psf fit solver.
	 */
	cr_expect_float_eq(psf->x0, 51.27f, 1e-2);
	cr_expect_float_eq(psf->y0, 54.24f, 1e-2);
	cr_expect_float_eq(psf->fwhmy, 7.250367f, 1e-6);
	cr_expect_float_eq(psf->fwhmx, 8.160933f, 1e-6);
	cr_expect_float_eq(psf->fwhmy, 7.250367f, 1e-6);
	cr_expect_float_eq(psf->angle, -21.648115f, 1e-6);

	/* Here we multiply by USHRT_MAX_SINGLE and we take a low
	 * accuracy because of rounding errors.
	 */
	cr_expect_float_eq(psf->A, 0.329290f * USHRT_MAX_SINGLE, 0.1);
	cr_expect_float_eq(psf->B, 0.021232f * USHRT_MAX_SINGLE, 0.1);
	cr_expect_float_eq(psf->rmse, 2.250e-03 * USHRT_MAX_SINGLE, 0.1);

	gsl_matrix_free(matrix);
	free_psf(psf);
}

Test(science, psf_float) { test_photometry_float(); }
Test(science, psf_ushort) { test_photometry_ushort(); }
