//#define XERR
#include "loop.ih"

    // true: the case has died/detected a tumor

bool Loop::leaving(double screeningAge)
{
//    if (
//        not
//        (
//            d_naturalDeathAge < screeningAge
//            or
//            (
//                d_tumor.selfDetectable() 
//                and
//                d_tumor.selfDetectAge() < screeningAge
//            )
//        )
//    )
    
    double selfDetectAge = d_tumor.selfDetectAge();
            
    if (                                        // see below
        screeningAge  <= d_naturalDeathAge
        and
        (
            not d_tumor.selfDetectable() or
            screeningAge <= selfDetectAge
        )
    )
    {
        g_log << __FILE__ 
                " no natural death, no self-detectable/self-detected "
                "tumor:\n";
        return false;                       // no natural Death
    }

    if (                                    // bottom check: natural death
        not d_tumor.present()               // before the screening age
        or 
        (
            d_tumor.selfDetectable() and
            d_naturalDeathAge < selfDetectAge
        )
    )
    {                                       // 1st of 3 leaving alternatives
        setStatus(LEFT_DURING, d_naturalDeathAge);
        g_log << "  ** case leaves: no tumor, natural death\n";
        return true;
    }        

    intervalCancer(screeningAge);           // or an interval cancer
//    removeCase(screeningAge, selfDetectAge);

    return true;
}

//  negating the original condition to return false if the woman hasn't died:
//  return false if death didn't occur:
//        not (
//            d_naturalDeathAge < screeningAge
//            or
//            (d_tumor and d_tumor.selfDetectAge() < screeningAge)
//        )

//    if (d_tumor)
//    xerr("self detect age: " << d_tumor.selfDetectAge());
