/* Test roundd2 for SPU
   Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
   All rights reserved.

   Redistribution and use in source and binary forms,
   with or without modification, are permitted provided that the
   following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Sony Computer Entertainment Inc nor the names
      of its contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */
/**
 *
 *@@ fmodd2

 *
 *@brief
 * boundary test for fmodd2.
 * 
 *
 *@pre
 *
 *@criteria
 * Run this program and check no error will be occurred.
 *
 *@note
 * 
 *
 **/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <fenv.h>
#include <float.h>

#include "simdmath.h"
#include "common-test.h"
#include "testutils.h"


typedef union {
	struct {
	  double xxx[2];
	  double yyy[2];
      	  double rrr[2];
	} dbl;
	struct {
	  unsigned long long xxx[2];
	  unsigned long long yyy[2];
	  unsigned long long rrr[2];
	} ull;
} TestVec_Roundd2;

int main()
{
	TestVec_Roundd2 test_a[] = {
{
ull:{
// 1.00...11 / 1.0...0    -> 0.00...11,  1.00...1 /1.0...0 -> 0.0...1
{0x3ff0000000000003ULL,0x3ff0000000000001ULL},
{0x3fe0000000000000ULL,0x3fe0000000000000ULL},
{0x3cc8000000000000ULL,0x3cb0000000000000ULL}
}
},{
ull:{
// 1.00...1111 / 0.10...0    -> 0.00...11,  1.00...1 /0.10...0 -> 0.0...1
{0x3ff000000000000fULL,0x3ff0000000000001ULL},
{0x3fe0000000000000ULL,0x3fe0000000000000ULL},
{0x3cee000000000000ULL,0x3cb0000000000000ULL}
}
},

{
ull:{
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0x0000000000000000ULL, 0x7aa0000000000000ULL},/*(0.000000 4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0x7ff0000000000000ULL, 0x0000000000000001ULL},/*(inf 0.000000)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0xfff0000000000000ULL, 0x7fffffffeffffffeULL},/*(-inf nan)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0x0000000000000000ULL, 0x7aa0000000000000ULL},/*(0.000000 4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0x0000000000000001ULL},/*(inf 0.000000)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0xfff0000000000000ULL, 0x7fffffffeffffffeULL},/*(-inf nan)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL},/*(nan nan)*/
{0x7fffffffeffffffeULL, 0x7fffffffeffffffeULL}/*(nan, nan)*/
}
},
{
ull:{
{0x0000000000000000ULL, 0x7aa0000000000000ULL},/*(0.000000 4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000)*/
{0x0000000000000000ULL, 0x0000000000000000ULL},/*(0.000000 0.000000)*/
{0x0000000000000000ULL, 0x0000000000000000ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0x0000000000000001ULL},/*(inf 0.000000)*/
{0x0000000000000000ULL, 0x0000000000000000ULL},/*(0.000000 0.000000)*/
{0x0000000000000000ULL, 0x0000000000000000ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0xfff0000000000000ULL, 0x7fffffffeffffffeULL},/*(-inf nan)*/
{0x0000000000000000ULL, 0x0000000000000000ULL},/*(0.000000 0.000000)*/
{0x0000000000000000ULL, 0x7fffffffeffffffeULL}/*(0.000000, nan)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0x7ff0000000000000ULL},/*(inf inf)*/
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x7ff8000000000000ULL, 0x7ff8000000000000ULL}/*(nan, nan)*/
}
},
{
ull:{
{0xfff0000000000000ULL, 0xfff0000000000000ULL},/*(-inf -inf)*/
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x7ff8000000000000ULL, 0x7ff8000000000000ULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x7aa0000000000000ULL, 0x7aa0000000000000ULL},/*(4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000 4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000)*/
{0x7ff8000000000000ULL, 0x7ff8000000000000ULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x0000000000000001ULL, 0x0000000000000001ULL},/*(0.000000 0.000000)*/
{0x7ff8000000000000ULL, 0x7ff8000000000000ULL}/*(nan, nan)*/
}
},
{
ull:{
{0x7aa0000000000000ULL, 0x0000000000000001ULL},/*(4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000 0.000000)*/
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x7aa0000000000000ULL, 0x0000000000000001ULL}/*(4646927838993072071243945306718439250410188130185607684549287060362314553626263667328650982800488595593121011844353040782670578892327830336846345565944983205571783876398312106070895030732180427719497486819848241268961714708993375275490934188589556509412640954544199727574266715045888.000000, 0.000000)*/
}
},
{
ull:{
{0x0000000000000000ULL, 0x0000000000000000ULL},/*(0.000000 0.000000)*/
{0x7ff0000000000000ULL, 0xfff0000000000000ULL},/*(inf -inf)*/
{0x0000000000000000ULL, 0x0000000000000000ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x7fefffffffffffffULL, 0x7fefffffffffffffULL},/*(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0x7feffffffffffffeULL, 0x7feeffffffffffffULL},/*(179769313486231550856124328384506240234343437157459335924404872448581845754556114388470639943126220321960804027157371570809852884964511743044087662767600909594331927728237078876188760579532563768698654064825262115771015791463983014857704008123419459386245141723703148097529108423358883457665451722744025579520.000000 174151522439786833602873345010488654505514389466650288559122786766978114661106633662692418716441642670880455394768401421807484146614013663315566064496053950599244663907024235661361045727850388502842959666202477512028391028080020983119748774627722497113443122745251401348739825745341808746724299140883367854080.000000)*/
{0x7ca0000000000000ULL, 0x7fa0000000000000ULL}/*(19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848.000000, 5617791046444737211654078721215702292556178059194708039794690036179146118921905097897139916325235500660003558745981042426837180275450519452901482207483566386805246669527046414884444362538940441232908842252656430276192208823201965046059784704400851161354703458893321819998351435577491134526104885300757004288.000000)*/
}
},
{
ull:{
{0x0008000000000000ULL, 0x7fefffffffffffffULL},/*(0.000000 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0x7ff0000000000000ULL, 0x7ff0000000000000ULL},/*(inf inf)*/
{0x0008000000000000ULL, 0x7fefffffffffffffULL}/*(0.000000, 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
}
},
{
ull:{
{0x7fefffffffffffffULL, 0x0010000000000000ULL},/*(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000 0.000000)*/
{0x7fdfffffffffffffULL, 0x0008000000000003ULL},/*(89884656743115785407263711865852178399035283762922498299458738401578630390014269380294779316383439085770229476757191232117160663444732091384233773351768758493024955288275641038122745045194664472037934254227566971152291618451611474082904279666061674137398913102072361584369088590459649940625202013092062429184.000000 0.000000)*/
{0x0000000000000000ULL, 0x0007fffffffffffdULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x7ff0000000000000ULL, 0x7fefffffffffffffULL},/*(inf 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0x7fefffffffffffffULL, 0x0000000000000003ULL},/*(179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000 0.000000)*/
{0x7ff8000000000000ULL, 0x0000000000000002ULL}/*(nan, 0.000000)*/
}
},
{
ull:{
{0xffe0000000000000ULL, 0x7fefffffffffffffULL},/*(-89884656743115795386465259539451236680898848947115328636715040578866337902750481566354238661203768010560056939935696678829394884407208311246423715319737062188883946712432742638151109800623047059726541476042502884419075341171231440736956555270413618581675255342293149119973622969239858152417678164812112068608.000000 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0x0008000000000000ULL, 0x0010000000000000ULL},/*(0.000000 0.000000)*/
{0x8000000000000000ULL, 0x0000000000000000ULL}/*(-0.000000, 0.000000)*/
}
},
{
ull:{
{0x4004000000000000ULL, 0x403d000000000000ULL},/*(2.500000 29.000000)*/
{0x3ff8000000000000ULL, 0x4008000000000000ULL},/*(1.500000 3.000000)*/
{0x3ff0000000000000ULL, 0x4000000000000000ULL}/*(1.000000, 2.000000)*/
}
},
{
ull:{
{0x8010000000000002ULL, 0x9000000000000000ULL},/*(-0.000000 -0.000000)*/
{0x8000000000000000ULL, 0x0000000000000000ULL},/*(-0.000000 0.000000)*/
{0x0000000000000000ULL, 0x0000000000000000ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0xffefffffffffffffULL, 0x7fefffffffffffffULL},/*(-179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0xffefffffffffffffULL, 0x7fefffffffffffffULL},/*(-179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000 179769313486231570814527423731704356798070567525844996598917476803157260780028538760589558632766878171540458953514382464234321326889464182768467546703537516986049910576551282076245490090389328944075868508455133942304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368.000000)*/
{0x8000000000000000ULL, 0x0000000000000000ULL}/*(-0.000000, 0.000000)*/
}
},
{
ull:{
{0xfff0000000000000ULL, 0x7ff0000000000000ULL},/*(-inf inf)*/
{0xfff0000000000000ULL, 0x7ff0000000000000ULL},/*(-inf inf)*/
{0x7ff8000000000000ULL, 0x7ff8000000000000ULL}/*(nan, nan)*/
}
},
{
ull:{
{0x800ffffffffffff3ULL, 0x09d0000000000006ULL},/*(-0.000000 0.000000)*/
{0x8000000000000005ULL, 0x8010000000000005ULL},/*(-0.000000 -0.000000)*/
{0x8000000000000003ULL, 0x000fffffffffff88ULL}/*(-0.000000, 0.000000)*/
}
},
{
ull:{
{0x1000000000000000ULL, 0x0000000000000001ULL},/*(0.000000 0.000000)*/
{0x0010000000000005ULL, 0x8000000000000001ULL},/*(0.000000 -0.000000)*/
{0x00058000000001eaULL, 0x0000000000000000ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x0010000000000002ULL, 0x1000000000000000ULL},/*(0.000000 0.000000)*/
{0x800000000000000bULL, 0x0010000000000007ULL},/*(-0.000000 0.000000)*/
{0x0000000000000006ULL, 0x000c800000000e62ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x0000000000000002ULL, 0x0000000000000003ULL},/*(0.000000 0.000000)*/
{0x0000000000000003ULL, 0x0000000000000002ULL},/*(0.000000 0.000000)*/
{0x0000000000000002ULL, 0x0000000000000001ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x806ffffffffffff3ULL, 0x0010000000000000ULL},/*(-0.000000 0.000000)*/
{0x8000000000000005ULL, 0x0000000000000009ULL},/*(-0.000000 0.000000)*/
{0x8000000000000003ULL, 0x0000000000000007ULL}/*(-0.000000, 0.000000)*/
}
},
{
ull:{
{0x0000000000000000ULL, 0x8000000000000000ULL},/*(0.000000 -0.000000)*/
{0x800ffffffffffff1ULL, 0x0000000000000003ULL},/*(-0.000000 0.000000)*/
{0x0000000000000000ULL, 0x8000000000000000ULL}/*(0.000000, -0.000000)*/
}
},
{
ull:{
{0x1000000000000000ULL, 0x8000000000000000ULL},/*(0.000000 -0.000000)*/
{0x0010000000000005ULL, 0x0000000000000001ULL},/*(0.000000 0.000000)*/
{0x00058000000001eaULL, 0x8000000000000000ULL}/*(0.000000, -0.000000)*/
}
},
{
ull:{
{0x0fbfffffffffffffULL, 0x0f30000000000000ULL},/*(0.000000 0.000000)*/
{0x000ffffffffffff1ULL, 0x0000000000000003ULL},/*(0.000000 0.000000)*/
{0x000b7400000053f7ULL, 0x0000000000000001ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x0000000000000003ULL, 0x0000000000000003ULL},/*(0.000000 0.000000)*/
{0x0000000000000006ULL, 0x8000000000000006ULL},/*(0.000000 -0.000000)*/
{0x0000000000000003ULL, 0x0000000000000003ULL}/*(0.000000, 0.000000)*/
}
},
{
ull:{
{0x0020000000000001ULL, 0x8020000000000001ULL},/*(0.000000 -0.000000)*/
{0x8010000000000002ULL, 0x0010000000000002ULL},/*(-0.000000 0.000000)*/
{0x0010000000000000ULL, 0x8010000000000000ULL}/*(0.000000, -0.000000)*/
}
},


		{
		  ull:{
		    {0ULL,0ULL},
		    {0ULL,0ULL},
		    {0ULL,0ULL}
		  }
		}
	};
	int ii, test_ctr = 1;
	char msg[80];
	vec_double2 res_v;
	//vec_double2  input;

	TEST_SET_START("96743652190000NM","FLR", "floord2");

   TEST_START("floord2");

	for (ii=0; ; ii++) {
		if ( (test_a[ii].ull.xxx[0] == 0) 
		     && (test_a[ii].ull.xxx[1] == 0) 
		     && (test_a[ii].ull.xxx[2] == 0) ) break;

		//input = *((vec_double2 *)&test_a[ii].dbl.xxx[0]);
		res_v = fmodd2 (*((vec_double2 *)&test_a[ii].dbl.xxx[0]), 
				*((vec_double2 *)&test_a[ii].dbl.yyy[0]) );
		sprintf(msg,"9674365219%04dFLR", test_ctr++);
		TEST_CHECK(msg, allequal_llong2( (vec_llong2)res_v, (vec_llong2)*((vec_double2 *)&test_a[ii].dbl.rrr[0])), 0);
	}

   TEST_SET_DONE();

   TEST_EXIT();

}
