if(APPLE)
    include(${FWCMAKE_INSTALL_FILES_DIR}/osx_install.cmake)
elseif(WIN32)
    include(${FWCMAKE_INSTALL_FILES_DIR}/win_install.cmake)
elseif(UNIX)
    #Don't use rpath at install step
    set(CMAKE_SKIP_INSTALL_RPATH ON)
    include(${FWCMAKE_INSTALL_FILES_DIR}/linux_install.cmake)
endif()

macro(generic_install)

    if(BUILD_SDK)
        installConanDepsForSDK("${CONAN_DEPS_LIST}")
        set(CPACK_PACKAGE_VERSION_MAJOR ${GIT_TAG_MAJOR})
        set(CPACK_PACKAGE_VERSION_MINOR ${GIT_TAG_MINOR})
        set(CPACK_PACKAGE_VERSION_PATCH ${GIT_TAG_PATCH})
        set(CPACK_PACKAGE_NAME ${FWPROJECT_NAME}-${CMAKE_BUILD_TYPE})
        set(CPACK_PACKAGE_VENDOR "IRCAD-IHU")
        set(CPACK_GENERATOR TGZ)
        include(CPack)
    else()
        install_qt_plugins()
        if(APPLE)
            osx_install(${FWPROJECT_NAME})
        elseif(WIN32)
            win_install(${FWPROJECT_NAME})
        elseif(UNIX)
            linux_install(${FWPROJECT_NAME})
        endif()
    endif()

endmacro()
