#version 330
in vec3 Normal;
in float col;
in float transparent;

uniform vec4 Color[18];
uniform vec3 lightPos;
uniform float planeTransparence=0.2;

out vec4 fragColor;

vec3 blinnPhongDirectional( vec3 n , vec3 kd) {
  vec3 ambient = kd * 0.5;//Light.La * Material.Ka;
  vec3 intensity = vec3(0.8, 0.8, 0.8);
  vec3 s = normalize(lightPos);// directional light
  float sDotN = abs(dot(s, n));
  vec3 diffuse = kd * sDotN;
  vec3 spec = vec3(0.0);
  float Shininess = 48.0;
  if (sDotN > 0.0) {
    spec = vec3(1,1,1) * pow(max(dot(s,n), 0.0), Shininess);
  }
  return ambient + intensity * (diffuse + spec);
}

void main( void ){
    int coli = int(col+0.5);
    //fragColor = vec4(Color[coli].rgb,1);
    fragColor = vec4(blinnPhongDirectional( Normal, Color[coli].rgb), (transparent>0.5)?planeTransparence:1.0);
}
