// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2015 - Scilab Enterprises - Antoine ELIAS
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
// <-- WINDOWS ONLY -->
//
// <-- CLI SHELL MODE -->
//
// <-- Non-regression test for bug 13986 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=13986
//
// <-- Short Description -->
// setdefaultlanguage does not set correctly in Windows registry

old = getlanguage();

lang = [ ...
"zh_TW" ...
"zh_CN" ...
"uk_UA" ...
"ru_RU" ...
"pt_BR" ...
"pl_PL" ...
"ja_JP" ...
"it_IT" ...
"fr_FR" ...
"es_ES" ...
"en_US" ...
"de_DE" ...
"cs_CZ" ...
"ca_ES"];

for l = lang
    setdefaultlanguage(l);
    val = winqueryreg("HKEY_CURRENT_USER", "SOFTWARE\Scilab\" + getversion() + "\Settings", "LANGUAGE");
    assert_checkequal(val, l);
end


setdefaultlanguage(old);
