C/MEMBR ADD NAME=XERRWV,SSI=0
      subroutine xerrwv (msg, nmes, nerr, iert, ni, i1, i2, nr, r1, r2)
      integer nmes, nerr, iert, ni, i1, i2, nr,lun, lunit, mesflg, nch

      double precision r1, r2
      character*(*) msg
c-----------------------------------------------------------------------
c%purpose
c subroutines xerrwv, xsetf, and xsetun, as given here, constitute
c a simplified version of the slatec error handling package.
c written by a. c. hindmarsh at llnl.  version of august 13, 1981.
c this version is in double precision.
c
c%calling sequence
c all arguments are input arguments.
c
c msg    = the message (character string).
c nmes   = the length of msg (not used).
c nerr   = the error number (not used).
c iert   = the error type..
c          1 means recoverable (control returns to caller).
c          2 means fatal (run is aborted--see note below).
c ni     = number of integers (0, 1, or 2) to be printed with message.
c i1,i2  = integers to be printed, depending on ni.
c nr     = number of reals (0, 1, or 2) to be printed with message.
c r1,r2  = reals to be printed, depending on nr.
c
c%note..
c    this routine is machine-dependent and specialized for use
c in limited context, in the following ways..
c 2. the value of nmes is assumed to be at most 80.
c    (multi-line messages are generated by repeated calls.)
c 3. if iert = 2, control passes to the statement   stop
c    to abort the run.  this statement may be machine-dependent.
c 4. r1 and r2 are assumed to be in double precision and are printed
c    in d21.13 format.
c 5. the common block /eh0001/ below is data-loaded (a machine-
c    dependent feature) with default values.
c    this block is needed for proper retention of parameters used by
c    this routine which the user can reset by calling xsetf or xsetun.
c    the variables in this block are as follows..
c       mesflg = print control flag..
c                1 means print all messages (the default).
c                0 means no printing.
c       lunit  = logical unit number for messages.
c                the default is 6 (machine-dependent).
c-----------------------------------------------------------------------
c%instalation
c the following are instructions for installing this routine
c in different machine environments.
c
c to change the default output unit, change the data statement
c in the block data subprogram below.
c
c for a different run-abort command, change the statement following
c statement 100 at the end.
c!
c-----------------------------------------------------------------------
cDEC$ ATTRIBUTES DLLIMPORT:: /eh0001/
      common /eh0001/ mesflg, lunit
      integer num, imess, imode
      character*80 str
      imode = 0
c-----------------------------------------------------------------------
      if (mesflg .eq. 0) go to 100
c get logical unit number. ---------------------------------------------
cstd      lun = lunit
      lun = 6
c get number of words in message. --------------------------------------
      nch = min(len(msg),80)
c write the message. ---------------------------------------------------
c     retrieve display information
      call errmds(num,imess,imode)
cstd      write (lun, 10) (msg(i:i),i=1,nch)
cstd 10   format(1x,80a1)
c     print if we are not inside of an execstr("...", "errcatch", "n")
      if (imess .eq. 0) then
         call basout(io,lun,msg(1:nch))
      endif
      if (ni .eq. 1) then
cstd         write (lun, 20) i1
         write (str, 20) i1
 20      format(6x,'where i1 is : ',i10)
         if (imess .eq. 0) then
            call basout(io,lun,str)
         endif
      elseif (ni .eq. 2) then
cstd         write (lun, 30) i1,i2
         write (str, 30) i1,i2
 30      format(6x,'where i1 is : ',i10,3x,' and i2 : ',i10)
         if (imess .eq. 0) then
            call basout(io,lun,str)
         endif
      endif
      if (nr .eq. 1) then
cstd         write (lun, 40) r1
         write (str, 40) r1
 40      format(6x,'where r1 is : ',d21.13)
         if (imess .eq. 0) then
            call basout(io,lun,str)
         endif
      elseif (nr .eq. 2) then
cstd         write (lun, 50) r1,r2
         write (str, 50) r1,r2
 50      format(6x,'where r1 is : ',d21.13,3x,'and r2 : ',d21.13)
         if (imess .eq. 0) then
            call basout(io,lun,str)
         endif
      endif
c abort the run if iert = 2. -------------------------------------------
 100  if (iert .ne. 2) return
      ierror = 1
      end
