/*
 ** Copyright 2004-2010 - EdenWall Technologies
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 **            Pierre Chifflier <chifflier@edenwall.com>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <nuclient.h>
#include <locale.h>
#include <sys/resource.h>       /* setrlimit() */
#include <langinfo.h>
#include <stdarg.h>
#include <signal.h>
#include <iostream>
#include <QApplication>
//#include <QPushButton>
//#include <QGridLayout>

extern int debug_areas;
extern int debug_level;
extern int log_engine;

#include "systray.h"

using std::cout;
nuclient_error_t *err = NULL;

void init_library()
{
	struct rlimit core_limit;

	/* Avoid creation of core file which may contains username and password */
	if (getrlimit(RLIMIT_CORE, &core_limit) == 0)
	{
		core_limit.rlim_cur = 0;
		setrlimit(RLIMIT_CORE, &core_limit);
	}

	/* Prepare error structure */
	if (nu_client_error_init(&err) != 0)
	{
		fprintf(stderr, "Cannot init error structure!\n");
		exit(EXIT_FAILURE);
	}

	/* XXX default values: log to stdout, normal level */
	log_engine = 1;
	debug_level = 3;
	debug_areas = 31;

	/* global libnuclient init */
	if (!nu_client_global_init(err))
	{
		fprintf(stderr, "Unable to initiate nuclient library!\n");
#if (defined(NUCLIENT_VERSION_MAJOR) && NUCLIENT_VERSION_MAJOR>=4)
		fprintf(stderr, "Problem: %s\n", nu_client_strerror(NULL, err));
#else
		fprintf(stderr, "Problem: %s\n", nu_client_strerror(err));
#endif
		exit(EXIT_FAILURE);
	}

#if (defined(NUCLIENT_VERSION_MAJOR) && NUCLIENT_VERSION_MAJOR>=4)
	nu_client_init_config();

	nu_client_init_plugins();
#endif
}


int main(int argc, char **argv)
{
	init_library();

	/* needed by iconv */
	setlocale(LC_ALL, "");

	QApplication app(argc, argv);
	app.setOrganizationName("EdenWall");
	app.setApplicationName("NuApplet");
	app.setQuitOnLastWindowClosed(false);

	/* load translation */
	QString locale = QLocale::system().name();
	QTranslator translator;
	translator.load(QString(":/lang/nuapplet2_") + locale);
	//printf("Loading translation: nuapplet2_%s.qm\n", locale.toStdString().c_str());
	app.installTranslator(&translator);

	NuAppSystray nuapplet2;

	return app.exec();
}
