<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Bundle

> Bundle commands.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

This directory contains [`make`][make] rules for generating bundles and other distributable files.

</section>

<!-- /.intro -->

<!-- Usage documentation. -->

<section class="usage">

## Usage

```text
Usage: make <command> [<ENV_VAR>=<value> <ENV_VAR>=<value> ...]
```

### Commands

#### dist-bundles-publish

Publishes distributable browser bundles to the `npm` package registry.

<!-- run-disable -->

```bash
$ make dist-bundles-publish
```

#### dist-bundles-publish-dry-run

Performs a dry run of publishing packages containing distributable bundles to the `npm` package registry.

<!-- run-disable -->

```bash
$ make dist-bundles-publish-dry-run
```

#### clean-dist-bundles

Removes distributable bundle build artifacts.

<!-- run-disable -->

```bash
$ make clean-dist-bundles
```

#### npm-publish

Publishes a new project version to the npm package registry.

```bash
$ make npm-publish NPM_RELEASE_TYPE='patch' NPM_RELEASE_COMMIT_MESSAGE='New features'
```

The command supports the following environment variables:

-   **NPM_RELEASE_TYPE**: release type (e.g., `prepatch`, `patch`, `preminor`, `minor`, `premajor`, `major`, `prerelease`).
-   **NPM_RELEASE_COMMIT_MESSAGE**: release message.

This command commits changes to source control. Accordingly, this command should only be run on a clean working directory.

</section>

<!-- /.usage -->

<!-- Section to include notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[make]: https://www.gnu.org/software/make/

</section>

<!-- /.links -->
