## Usage

```js
var omit = require('{%= name %}');
```

Pass a string `key` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, 'a')
//=> { b: 'b', c: 'c' }
```

Pass an array of `keys` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c'])
//=> { b: 'b' }
```

Returns the object if no keys are passed:

```js
omit({a: 'a', b: 'b', c: 'c'})
//=> {a: 'a', b: 'b', c: 'c'}
```

Returns an empty object if no value is passed.

```js
omit()
//=> {}
```

### Filter function

An optional filter function may be passed as the last argument, with or without keys passed on the arguments:

**filter on keys**

```js
var res = omit({a: 'a', b: 'b', c: 'c'}, function (val, key) {
  return key === 'a';
});
//=> {a: 'a'}
```

**filter on values**

```js
var fn = function() {};
var obj = {a: 'a', b: 'b', c: fn};

var res = omit(obj, ['a'], function (val, key) {
  return typeof val !== 'function';
});
//=> {b: 'b'}
```
