/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.project.customizer;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.event.ChangeListener;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationGroupProvider;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;

public class WebProjectCustomizerRun extends javax.swing.JPanel implements ActionListener, ItemListener, ChangeListener, ValidationGroupProvider {

    private static final int SELECTING_SERVLET = 1;
    private static final int SELECTING_PAGE = 2;
    private static final int SELECTING_URL = 3;
    private int selecting;

    /** Creates new form WebProjectCustomizerRun */
    public WebProjectCustomizerRun(WebProjectProperties props) {
        initComponents();
        platformAndDevicePanel21.setPlatformAndCard(props);
        platformAndDevicePanel21.setProjectKind(props.getProject().kind());
        pageComboBox.setModel(props.PAGES);
        servletRadioButton.setModel(props.SELECT_SERVLET);
        pageRadioButton.setModel(props.SELECT_PAGE);
        urlRadioButton.setModel(props.SELECT_URL);
        servletTextField.setDocument(props.SERVLET_URL);
        urlTextField.setDocument(props.SPECIFIC_URL);
        launchBrowserCheckBox.setModel(props.LAUNCH_BROWSER);
        updateSelecting();
        completeUrl.setDocument(props.COMPLETE_URL);
        updateSelection();
        ButtonGroup group = new ButtonGroup();
        group.add (pageRadioButton);
        group.add (servletRadioButton);
        group.add (urlRadioButton);
        HelpCtx.setHelpIDString(this, "org.netbeans.modules.javacard.RunPanel"); //NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton2 = new javax.swing.JButton();
        urlTextField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        launchBrowserCheckBox = new javax.swing.JCheckBox();
        servletRadioButton = new javax.swing.JRadioButton();
        pageRadioButton = new javax.swing.JRadioButton();
        pageComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        servletTextField = new javax.swing.JTextField();
        urlRadioButton = new javax.swing.JRadioButton();
        completeUrl = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        platformAndDevicePanel21 = new org.netbeans.modules.javacard.api.PlatformAndDevicePanel();

        jButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/javacard/resources/rc.png"))); // NOI18N
        jButton2.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.jButton2.text")); // NOI18N
        jButton2.setToolTipText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.jButton2.toolTipText")); // NOI18N
        jButton2.addActionListener(this);

        urlTextField.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.urlTextField.text")); // NOI18N
        urlTextField.addActionListener(this);

        launchBrowserCheckBox.setSelected(true);
        launchBrowserCheckBox.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.launchBrowserCheckBox.text")); // NOI18N
        launchBrowserCheckBox.addChangeListener(this);
        launchBrowserCheckBox.addActionListener(this);

        servletRadioButton.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.servletRadioButton.text")); // NOI18N
        servletRadioButton.addActionListener(this);

        pageRadioButton.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.pageRadioButton.text")); // NOI18N
        pageRadioButton.addActionListener(this);

        pageComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        pageComboBox.addItemListener(this);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.jLabel1.text")); // NOI18N

        servletTextField.setEditable(false);
        servletTextField.setText(NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.servletTextField.text")); // NOI18N
        servletTextField.setToolTipText(NbBundle.getMessage(WebProjectCustomizerRun.class, "TIP_SERVLET")); // NOI18N

        urlRadioButton.setText(NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.urlRadioButton.text")); // NOI18N
        urlRadioButton.addActionListener(this);

        completeUrl.setEditable(false);
        completeUrl.setText(NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.completeUrl.text")); // NOI18N

        jLabel2.setText(NbBundle.getMessage(WebProjectCustomizerRun.class, "WebProjectCustomizerRun.jLabel2.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 404, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(27, 27, 27)
                        .add(jLabel1)
                        .add(39, 39, 39))
                    .add(layout.createSequentialGroup()
                        .add(31, 31, 31)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(servletRadioButton)
                            .add(pageRadioButton)
                            .add(urlRadioButton))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(servletTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 308, Short.MAX_VALUE)
                            .add(pageComboBox, 0, 308, Short.MAX_VALUE)
                            .add(urlTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 308, Short.MAX_VALUE)))
                    .add(launchBrowserCheckBox)
                    .add(completeUrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 404, Short.MAX_VALUE)
                    .add(jLabel2))
                .addContainerGap())
            .add(platformAndDevicePanel21, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 414, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(platformAndDevicePanel21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(17, 17, 17)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(launchBrowserCheckBox)
                .add(8, 8, 8)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(servletRadioButton)
                    .add(servletTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(pageRadioButton)
                    .add(pageComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(urlTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(urlRadioButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 6, Short.MAX_VALUE)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(completeUrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == urlTextField) {
            WebProjectCustomizerRun.this.urlTextFieldActionPerformed(evt);
        }
        else if (evt.getSource() == launchBrowserCheckBox) {
            WebProjectCustomizerRun.this.launchBrowserCheckBoxActionPerformed(evt);
        }
        else if (evt.getSource() == servletRadioButton) {
            WebProjectCustomizerRun.this.servletRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == pageRadioButton) {
            WebProjectCustomizerRun.this.pageRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == urlRadioButton) {
            WebProjectCustomizerRun.this.urlRadioButtonActionPerformed(evt);
        }
        else if (evt.getSource() == jButton2) {
            WebProjectCustomizerRun.this.jButton2ActionPerformed(evt);
        }
    }

    public void itemStateChanged(java.awt.event.ItemEvent evt) {
        if (evt.getSource() == pageComboBox) {
            WebProjectCustomizerRun.this.pageComboBoxItemStateChanged(evt);
        }
    }

    public void stateChanged(javax.swing.event.ChangeEvent evt) {
        if (evt.getSource() == launchBrowserCheckBox) {
            WebProjectCustomizerRun.this.launchBrowserCheckBoxStateChanged(evt);
        }
    }// </editor-fold>//GEN-END:initComponents

    private void launchBrowserCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_launchBrowserCheckBoxActionPerformed
}//GEN-LAST:event_launchBrowserCheckBoxActionPerformed

    private void launchBrowserCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_launchBrowserCheckBoxStateChanged
        updateSelection();
    }//GEN-LAST:event_launchBrowserCheckBoxStateChanged

    private void servletRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_servletRadioButtonActionPerformed
        selecting = SELECTING_SERVLET;
        updateSelection();
    }//GEN-LAST:event_servletRadioButtonActionPerformed

    private void pageRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pageRadioButtonActionPerformed
        selecting = SELECTING_PAGE;
        updateSelection();
    }//GEN-LAST:event_pageRadioButtonActionPerformed

    private void pageComboBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_pageComboBoxItemStateChanged
    }//GEN-LAST:event_pageComboBoxItemStateChanged

private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
}//GEN-LAST:event_jButton2ActionPerformed

private void urlTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlTextFieldActionPerformed
}//GEN-LAST:event_urlTextFieldActionPerformed

private void urlRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_urlRadioButtonActionPerformed
    selecting = SELECTING_URL;
    updateSelection();
}//GEN-LAST:event_urlRadioButtonActionPerformed

    private void updateSelecting() {
        selecting = servletRadioButton.isSelected()
                ? SELECTING_SERVLET : pageRadioButton.isSelected() ? SELECTING_PAGE : SELECTING_URL;
    }

    private void updateSelection() {
        boolean enabled = launchBrowserCheckBox.isSelected();

        urlTextField.setEnabled(enabled);
        servletRadioButton.setEnabled(enabled);
        urlRadioButton.setEnabled(enabled);
        pageRadioButton.setEnabled(enabled);
        pageComboBox.setEnabled(enabled);

        if (enabled) {
            switch (selecting) {
                case SELECTING_SERVLET:
                    pageComboBox.setEnabled(false);
                    urlTextField.setEnabled(false);
                    break;
                case SELECTING_PAGE:
                    pageComboBox.setEnabled(true);
                    urlTextField.setEnabled(false);
                    break;
                case SELECTING_URL:
                    pageComboBox.setEnabled(false);
                    urlTextField.setEnabled(true);
                    break;
                default:
                    throw new AssertionError();
            }
        }

    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField completeUrl;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JCheckBox launchBrowserCheckBox;
    private javax.swing.JComboBox pageComboBox;
    private javax.swing.JRadioButton pageRadioButton;
    private org.netbeans.modules.javacard.api.PlatformAndDevicePanel platformAndDevicePanel21;
    private javax.swing.JRadioButton servletRadioButton;
    private javax.swing.JTextField servletTextField;
    private javax.swing.JRadioButton urlRadioButton;
    private javax.swing.JTextField urlTextField;
    // End of variables declaration//GEN-END:variables

    public ValidationGroup getValidationGroup() {
        return platformAndDevicePanel21.getValidationGroup();
    }
}
