# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#
#
# $Id$
#

=begin

== Abstract

WebA: Web Accessor
  http interface for irc

  You can access IRC via ((<http://host:port/weba>))
  (by default).


== Configuration

BotConfig = [
{
  :name   => :WebA,
  :passwd => 'WebAPassWord', # if passwd is specified, use Basic Access Authentication with id
  :id     => 'weba',
  :port   => 12345,
  :entry  => 'weba',
  # :message_format => ... (see source)
}
]

=end

require 'webrick'
require 'lib/tagparts'

class WebA < Nadoka::NDK_Bot
  class WebAlet < WEBrick::HTTPServlet::AbstractServlet
    def initialize server, bot, authorizer
      super
      @bot  = bot
      @auth = authorizer
    end
    
    def do_GET req, res
      @auth.authenticate(req, res) if @auth
      begin
        res.body = @bot.htmlpage(req.query).to_s
        res['content-type'] = 'text/html; charset=Shift_JIS'
      rescue WebARedirect => e
        res.set_redirect(WEBrick::HTTPStatus::Found, "#{req.path}?ch=#{URI.encode(e.ch.tosjis)}")
        res.body = 'moved'
      end
    end
  end

  class WebARedirect < Exception
    attr_reader :ch
    def initialize ch
      @ch = ch
    end
  end
  
  include HTMLParts
  
  def htmlpage query
    rch = (query['ch'] || '').tojis
    ch  = ccn(rch)
    ch = !ch.empty? && (@state.channels.include?(ch) || ch == 'all') && ch

    ttl = ch ? " - #{rch.tosjis}" : ''
    
    if ch && (msg = query['message']) && !msg.empty?
      msg = msg.tojis + ' (from WebA)'
      send_privmsg(ch, msg)
      raise WebARedirect.new(ch)
    end
    
    _html(
      _head(_title("WebA: IRC Web Accessor#{ttl}")),
      _body(
        _h1("WebA#{ttl}"),
        _p(
          _a({:href => "./#{@entry}?ch="+URI.encode((rch || '').tosjis)}, 'reload'),
          _a({:href => "./#{@entry}"}, 'top')
        ),

        case ch
        when 'command'
          command_ch
        else
          view_ch(rch, ch)
          select_ch(rch, ch)
        end
      ))
  end

  def select_ch rch, ch
    _p({:class => 'channel-list'},
      (@state.channel_raw_names.sort + ['all']).map{|e|
        e = e.tosjis
        [_a({:href => "./#{@entry}?ch="+ URI.encode(e)}, e), ' ']
      }
    )
  end

  def view_ch rch, ch
    return unless ch
    
    chs = ch.tosjis
    
    if ch == 'all'
      msgs = []
      @stores.pools.each{|_, store|
        msgs.concat store.pool
      }
      msgs = msgs.sort_by{|msg| msg[:time]}
    else
      msgs = (@stores.pools[ch] && @stores.pools[ch].pool) || []
    end
    
    _div({:class => 'irc-accessor'},
      if(ch != 'all')
        _form({:method => 'get', :action => "./#{@entry}", :class => 'sayform'},
          "msg: ",
          _input({:type => 'text',   :name => 'message', :class => 'msgbox'}),
          _input({:type => 'submit', :name => 'say', :value => 'say'}),
          _input({:type => 'hidden', :name => 'ch', :value => ch})
        )
      end,
      _h2("channel #{ch.tosjis}"),
      _div({:class => 'messages'},
        msgs.map{|m|
          if ch == 'all' && m[:ch]
            chn = _a({:href => "./#{@entry}?ch=#{URI.encode(m[:ch])}"}, m[:ch].tosjis)
            msg = @config.log_format_message(@all_message_format, m)
          elsif m[:type] == 'PRIVMSG'
            chn = _a({:href => "./#{@entry}?user=#{URI.encode(m[:user])}"}, "<#{m[:user].tosjis}>")
            msg = @config.log_format_message(@message_format, m)
          else
            msg = @config.log_format_message(@message_format, m)
            chn = ''
          end
          
          _div({:class=>'msg'},
            "#{m[:time].strftime('%H:%M')} ", chn, "#{msg}".tosjis)
        }.reverse
      )
    )
  end
  
  def bot_initialize
    @stores = @logger.message_stores
    @server = WEBrick::HTTPServer.new({
      :Port => @bot_config.fetch(:port, 12345),
    })
    @entry = @bot_config.fetch(:entry, 'weba')
    
    auth = nil
    if passwd = @bot_config.fetch(:passwd, 'WebAPassWord')
      id = @bot_config.fetch(:id, 'weba')
      
      userdb = Hash.new
      userdb.extend(WEBrick::HTTPAuth::UserDB)
      userdb.auth_type = WEBrick::HTTPAuth::BasicAuth
      userdb.set_passwd("WebA Authentication", id, passwd)

      auth = WEBrick::HTTPAuth::BasicAuth.new({
        :Realm        => "WebA Authentication",
        :UserDB       => userdb,
        :Algorithm    => 'MD5-sess',
        :Qop          => [ 'auth' ],
        :UseOpaque    => true,
        :NonceExpirePeriod => 60,
        :NonceExpireDelta  => 5,
      })
    end
    
    @server.mount("/#{@entry}", WebAlet, self, auth)
    
    @server_thread = Thread.new{
      begin
        @server.start
      rescue Exception => e
        @manager.ndk_error e
      end
    }
    @message_format = @config.default_log[:message_format].merge(
      @bot_config.fetch(:message_format, {
        'PRIVMSG' => '{msg}',
        'NOTICE'  => '{{user}} {msg}',
      }))

    @all_message_format = @config.default_log[:message_format].merge(
      @bot_config.fetch(:all_message_format, {}))
  end

  def bot_destruct
    @server_thread.kill
    @server.shutdown
    sleep 1
  end
end

