/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _STUB_WIZARD_H_
#define _STUB_WIZARD_H_

#include "stub_base.h"

namespace mforms
{
namespace stub
{

class WizardImpl : public ObjectImpl
{
    void refresh_step_list(const std::vector<std::string> &steps);
  
    static void __stdcall cancel(::mforms::Wizard* wiz);
  protected:
    WizardImpl(::mforms::Wizard *wiz);
    
    static bool __stdcall create(::mforms::Wizard *self, Form *owner);
    static void __stdcall set_title(::mforms::Wizard *self, const std::string &title);
    static void __stdcall run_modal(::mforms::Wizard *self);
    static void __stdcall close(::mforms::Wizard *self);
    static void __stdcall flush_events(::mforms::Wizard *self);
    static void __stdcall set_content(::mforms::Wizard *self, View *view);
    static void __stdcall set_heading(::mforms::Wizard *self, const std::string &);
    static void __stdcall set_step_list(::mforms::Wizard *self, const std::vector<std::string> &);
    static void __stdcall set_allow_cancel(::mforms::Wizard *self, bool flag);
    static void __stdcall set_allow_back(::mforms::Wizard *self, bool flag);
    static void __stdcall set_allow_next(::mforms::Wizard *self, bool flag);
    static void __stdcall set_show_extra(::mforms::Wizard *self, bool flag);
    static void __stdcall set_extra_caption(::mforms::Wizard *self, const std::string &);
    static void __stdcall set_next_caption(::mforms::Wizard *self, const std::string &);

public:
  static void init();
  
  static void set_icon_path(const std::string &path);
};

}//end of stub namespace
}//end of mforms namespace


#endif
