//
// ccsdtq_t4.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsdtq_t4.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
CCSDTQ_T4::CCSDTQ_T4(CCR12_Info* info):z(info){};
CCSDTQ_T4::~CCSDTQ_T4(){};
  
  
  
void CCSDTQ_T4::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->f1(),z->in.at(0),z->t1(),z->t2(),z->t3(),z->t4()=>z->v2()
  
in.resize(8);
  
in.at(1)=new Tensor("ccsdtq_t4_1_0",z->mem());
offset_smith_0_1();
smith_0_1_0(); //z->f1()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_3();
smith_1_3_0(); //z->f1()=>in.at(2)
smith_2_43(); //z->t1(),z->v2()=>in.at(2)
smith_1_3(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_23(); //z->t1(),z->v2()=>in.at(1)
smith_1_64(); //z->t2(),z->v2()=>in.at(1)
smith_0_1(out); //z->t4(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_1",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1)
smith_1_25(); //z->t1(),z->v2()=>in.at(1)
smith_1_66(); //z->t2(),z->v2()=>in.at(1)
smith_0_2(out); //z->t4(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_2",z->mem());
offset_smith_0_4();
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_4();
smith_1_4_0(); //z->f1()=>in.at(2)
smith_2_45(); //z->t1(),z->v2()=>in.at(2)
smith_1_4(); //z->t4(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_1",z->mem());
offset_smith_1_11();
smith_1_11_0(); //z->v2()=>in.at(2)
smith_2_22(); //z->t1(),z->v2()=>in.at(2)
smith_2_54(); //z->t2(),z->v2()=>in.at(2)
smith_1_11(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_2",z->mem());
offset_smith_1_21();
in.at(3)=new Tensor("ccsdtq_t4_3_0",z->mem());
offset_smith_2_21();
smith_2_21_0(); //z->v2()=>in.at(3)
smith_3_42(); //z->t1(),z->v2()=>in.at(3)
smith_2_21(); //z->t3(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_47(); //z->t4(),z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsdtq_t4_3_58",z->mem());
offset_smith_2_58();
smith_3_58(); //z->t2(),z->v2()=>in.at(3)
smith_2_58(); //z->t2(),in.at(3)=>in.at(2)
delete in.at(3);
smith_1_21(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_3",z->mem());
offset_smith_1_26();
smith_1_26_0(); //z->v2()=>in.at(2)
smith_2_46(); //z->t1(),z->v2()=>in.at(2)
smith_1_26(); //z->t4(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_28(); //z->t4(),z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t4_2_4",z->mem());
offset_smith_1_30();
smith_2_30(); //z->t2(),z->v2()=>in.at(2)
smith_2_56(); //z->t3(),z->v2()=>in.at(2)
smith_1_30(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_0_4(out); //z->t1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_3",z->mem());
offset_smith_0_5();
smith_0_5_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_5();
smith_1_5_0(); //z->f1()=>in.at(2)
smith_2_48(); //z->t1(),z->v2()=>in.at(2)
smith_1_5(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_1",z->mem());
offset_smith_1_9();
smith_1_9_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsdtq_t4_3_0",z->mem());
offset_smith_2_19();
smith_2_19_0(); //z->v2()=>in.at(3)
smith_3_41(); //z->t1(),z->v2()=>in.at(3)
smith_2_19(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_50(); //z->t2(),z->v2()=>in.at(2)
smith_1_9(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_2",z->mem());
offset_smith_1_10();
smith_1_10_0(); //z->v2()=>in.at(2)
smith_2_20(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_3",z->mem());
offset_smith_1_33();
smith_1_33_0(); //z->v2()=>in.at(2)
smith_2_49(); //z->t1(),z->v2()=>in.at(2)
smith_1_33(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_34(); //z->t2(),z->v2()=>in.at(1)
smith_1_74(); //z->t3(),z->v2()=>in.at(1)
smith_0_5(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_4",z->mem());
offset_smith_0_6();
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_6();
smith_1_6_0(); //z->f1()=>in.at(2)
smith_2_52(); //z->t1(),z->v2()=>in.at(2)
smith_1_6(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_1",z->mem());
offset_smith_1_13();
smith_1_13_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsdtq_t4_3_0",z->mem());
offset_smith_2_31();
smith_2_31_0(); //z->v2()=>in.at(3)
smith_3_59(); //z->t1(),z->v2()=>in.at(3)
smith_2_31(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_63(); //z->t2(),z->v2()=>in.at(2)
smith_1_13(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_2",z->mem());
offset_smith_1_14();
smith_1_14_0(); //z->v2()=>in.at(2)
smith_2_32(); //z->t1(),z->v2()=>in.at(2)
smith_2_62(); //z->t2(),z->v2()=>in.at(2)
smith_1_14(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_3",z->mem());
offset_smith_1_29();
in.at(3)=new Tensor("ccsdtq_t4_3_0",z->mem());
offset_smith_2_29();
smith_2_29_0(); //z->v2()=>in.at(3)
smith_3_60(); //z->t1(),z->v2()=>in.at(3)
smith_2_29(); //z->t2(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_57(); //z->t3(),z->v2()=>in.at(2)
smith_1_29(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_4",z->mem());
offset_smith_1_38();
smith_1_38_0(); //z->v2()=>in.at(2)
smith_2_55(); //z->t1(),z->v2()=>in.at(2)
smith_1_38(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_40(); //z->t3(),z->v2()=>in.at(1)
smith_1_70(); //z->t4(),z->v2()=>in.at(1)
smith_0_6(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_5",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->v2()=>in.at(1)
smith_1_12(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_36();
smith_1_36_0(); //z->v2()=>in.at(2)
smith_2_53(); //z->t1(),z->v2()=>in.at(2)
smith_1_36(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_37(); //z->t2(),z->v2()=>in.at(1)
smith_1_72(); //z->t3(),z->v2()=>in.at(1)
smith_0_8(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_6",z->mem());
offset_smith_0_15();
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_15();
smith_1_15_0(); //z->v2()=>in.at(2)
smith_2_61(); //z->t2(),z->v2()=>in.at(2)
smith_1_15(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t4_2_1",z->mem());
offset_smith_1_35();
smith_1_35_0(); //z->v2()=>in.at(2)
smith_2_51(); //z->t1(),z->v2()=>in.at(2)
smith_1_35(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_39(); //z->t3(),z->v2()=>in.at(1)
smith_1_68(); //z->t4(),z->v2()=>in.at(1)
smith_0_15(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_7",z->mem());
offset_smith_0_16();
smith_0_16_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t4_2_0",z->mem());
offset_smith_1_24();
smith_1_24_0(); //z->v2()=>in.at(2)
smith_2_44(); //z->t1(),z->v2()=>in.at(2)
smith_1_24(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_65(); //z->t2(),z->v2()=>in.at(1)
smith_0_16(out); //z->t4(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_8",z->mem());
offset_smith_0_17();
smith_0_17_0(); //z->v2()=>in.at(1)
smith_1_27(); //z->t1(),z->v2()=>in.at(1)
smith_1_67(); //z->t2(),z->v2()=>in.at(1)
smith_0_17(out); //z->t4(),in.at(1)=>out
delete in.at(1);
smith_0_18(out); //z->t4(),z->v2()=>out
in.at(1)=new Tensor("ccsdtq_t4_1_69",z->mem());
offset_smith_0_69();
smith_1_69(); //z->t4(),z->v2()=>in.at(1)
smith_0_69(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_71",z->mem());
offset_smith_0_71();
smith_1_71(); //z->t3(),z->v2()=>in.at(1)
smith_0_71(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t4_1_73",z->mem());
offset_smith_0_73();
smith_1_73(); //z->t3(),z->v2()=>in.at(1)
smith_0_73(out); //z->t3(),in.at(1)=>out
delete in.at(1);
  
}
  
void CCSDTQ_T4::smith_0_1(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_f())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h9b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h9b))))))))==z->irrep_t()) { 
               long p5b_0,p6b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0,h9b_0; 
               z->restricted_8(p5b,p6b,p7b,p8b,h1b,h2b,h3b,h9b,p5b_0,p6b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0,h9b_0); 
               long h9b_1,h4b_1; 
               z->restricted_2(h9b,h4b,h9b_1,h4b_1); 
               long dim_common=z->get_range(h9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,3,2,1,0,7,+1.0); 
               } 
               else if (h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,3,2,1,0,6,-1.0); 
               } 
               else if (h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,+1.0); 
               } 
               else if (h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,-1.0); 
               } 
               in[1]->get_block(h4b_1+z->noab()*(h9b_1),k_a1); 
               z->sort_indices2(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h4b),1,0,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,2,0,1,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,0,2,1,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,0,3,2,1,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_15(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p5b<p6b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p6b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p6b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p6b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p6b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p6b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
             if (z->get_spin(p5b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p9b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
               long p5b_0,p9b_0,h1b_0,h2b_0; 
               z->restricted_4(p5b,p9b,h1b,h2b,p5b_0,p9b_0,h1b_0,h2b_0); 
               long p6b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1; 
               z->restricted_6(p6b,p7b,p8b,h3b,h4b,p9b,p6b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1); 
               long dim_common=z->get_range(p9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p5b<p9b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
               } 
               else if (p9b<=p5b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
               } 
               in[1]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()))))),k_a1); 
               z->sort_indices6(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(p9b),4,3,2,1,0,5,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p6b>=p5b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,5,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p5b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,1,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p5b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,6,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p5b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,1,0,5,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p5b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,6,0,5,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,0,6,5,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,6,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,1,0,5,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,6,0,5,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,0,6,5,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,5,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,1,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,6,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,1,0,5,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,6,0,5,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,0,6,5,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,6,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,1,0,5,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,6,0,5,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,0,6,5,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_15(){ 
 
long size=0L; 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
         in[1]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),size); 
         size+=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_16(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             for (long h10b=h9b;h10b<z->noab();++h10b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h9b)+z->get_spin(h10b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h9b)^z->get_sym(h10b))))))))==z->irrep_t()) { 
                long p5b_0,p6b_0,p7b_0,p8b_0,h1b_0,h2b_0,h9b_0,h10b_0; 
                z->restricted_8(p5b,p6b,p7b,p8b,h1b,h2b,h9b,h10b,p5b_0,p6b_0,p7b_0,p8b_0,h1b_0,h2b_0,h9b_0,h10b_0); 
                long h9b_1,h10b_1,h3b_1,h4b_1; 
                z->restricted_4(h9b,h10b,h3b,h4b,h9b_1,h10b_1,h3b_1,h4b_1); 
                long dim_common=z->get_range(h9b)*z->get_range(h10b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(h3b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                if (h2b<h9b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h10b),5,4,3,2,1,0,7,6,+1.0); 
                } 
                else if (h1b<h9b && h9b<=h2b && h2b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h10b),6,4,3,2,1,0,7,5,-1.0); 
                } 
                else if (h1b<h9b && h10b<=h2b) { 
                 z->t4()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h10b),z->get_range(h2b),7,4,3,2,1,0,6,5,+1.0); 
                } 
                else if (h9b<=h1b && h2b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),6,5,3,2,1,0,7,4,+1.0); 
                } 
                else if (h9b<=h1b && h1b<h10b && h10b<=h2b) { 
                 z->t4()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),7,5,3,2,1,0,6,4,-1.0); 
                } 
                else if (h10b<=h1b) { 
                 z->t4()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),7,6,3,2,1,0,5,4,+1.0); 
                } 
                in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
                double factor=1.0; 
                if (h9b==h10b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,1,2,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,1,3,2,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,1,0,2,+0.5/0.5); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,1,3,0,2,-0.5/0.5); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,1,0,3,2,+0.5/0.5); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_16_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h3b_0,h4b_0; 
        z->restricted_4(h9b,h10b,h3b,h4b,h9b_0,h10b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_16(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_17(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h10b=0L;h10b<z->noab();++h10b) { 
             for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h10b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h10b))))))))==z->irrep_t()) { 
                long p5b_0,p6b_0,p7b_0,p9b_0,h1b_0,h2b_0,h3b_0,h10b_0; 
                z->restricted_8(p5b,p6b,p7b,p9b,h1b,h2b,h3b,h10b,p5b_0,p6b_0,p7b_0,p9b_0,h1b_0,h2b_0,h3b_0,h10b_0); 
                long h10b_1,p8b_1,h4b_1,p9b_1; 
                z->restricted_4(h10b,p8b,h4b,p9b,h10b_1,p8b_1,h4b_1,p9b_1); 
                long dim_common=z->get_range(h10b)*z->get_range(p9b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(p8b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                if (p7b<p9b && h3b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,2,1,0,3,7,+1.0); 
                } 
                else if (p7b<p9b && h2b<h10b && h10b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,2,1,0,3,6,-1.0); 
                } 
                else if (p7b<p9b && h1b<h10b && h10b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,1,0,3,5,+1.0); 
                } 
                else if (p7b<p9b && h10b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,1,0,3,4,-1.0); 
                } 
                else if (p6b<p9b && p9b<=p7b && h3b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,1,0,2,7,-1.0); 
                } 
                else if (p6b<p9b && p9b<=p7b && h2b<h10b && h10b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,1,0,2,6,+1.0); 
                } 
                else if (p6b<p9b && p9b<=p7b && h1b<h10b && h10b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,1,0,2,5,-1.0); 
                } 
                else if (p6b<p9b && p9b<=p7b && h10b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,1,0,2,4,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h3b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,2,0,1,7,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h2b<h10b && h10b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,2,0,1,6,-1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h1b<h10b && h10b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,0,1,5,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h10b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p7b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,0,1,4,-1.0); 
                } 
                else if (p9b<=p5b && h3b<h10b) { 
                 z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,2,1,0,7,-1.0); 
                } 
                else if (p9b<=p5b && h2b<h10b && h10b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,2,1,0,6,+1.0); 
                } 
                else if (p9b<=p5b && h1b<h10b && h10b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,-1.0); 
                } 
                else if (p9b<=p5b && h10b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,+1.0); 
                } 
                in[1]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h10b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),2,1,3,0,+1.0); 
                double factor=1.0; 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p8b>=p7b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,1,4,3,2,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,1,4,3,0,2,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,1,4,0,3,2,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,1,0,4,3,2,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,1,5,4,3,2,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,1,5,4,3,0,2,+1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,1,5,4,0,3,2,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,1,5,0,4,3,2,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,1,6,5,4,3,2,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,1,6,5,4,3,0,2,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,1,6,5,4,0,3,2,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,1,6,5,0,4,3,2,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),1,7,6,5,4,3,2,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),1,7,6,5,4,3,0,2,+1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),1,7,6,5,4,0,3,2,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),1,7,6,5,0,4,3,2,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_17_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h10b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h10b_0,p8b_0,h4b_0,p9b_0; 
        z->restricted_4(h10b,p8b,h4b,p9b,h10b_0,p8b_0,h4b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h10b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(h10b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h10b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h10b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_17(){ 
 
long size=0L; 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
       in[1]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b))),size); 
       size+=z->get_range(h10b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_18(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
             for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
                long p5b_0,p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
                z->restricted_8(p5b,p6b,p9b,p10b,h1b,h2b,h3b,h4b,p5b_0,p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
                long p7b_1,p8b_1,p9b_1,p10b_1; 
                z->restricted_4(p7b,p8b,p9b,p10b,p7b_1,p8b_1,p9b_1,p10b_1); 
                long dim_common=z->get_range(p9b)*z->get_range(p10b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(p7b)*z->get_range(p8b); 
                long dima1=dim_common*dima1_sort; 
                if (p6b<p9b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,1,0,3,2,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && p6b<p10b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,0,3,1,-1.0); 
                } 
                else if (p5b<p9b && p10b<=p6b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p10b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,0,2,1,+1.0); 
                } 
                else if (p9b<=p5b && p6b<p10b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,3,0,+1.0); 
                } 
                else if (p9b<=p5b && p5b<p10b && p10b<=p6b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p10b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,2,0,-1.0); 
                } 
                else if (p10b<=p5b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
                } 
                z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p7b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
                double factor=1.0; 
                if (p9b==p10b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p7b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,1,0,5,4,3,2,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,1,6,0,5,4,3,2,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,7,6,0,5,4,3,2,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,1,0,6,5,4,3,2,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,7,0,6,5,4,3,2,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,0,7,6,5,4,3,2,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_1_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  long tileoffset; 
  tileoffset=(h4b+z->noab()*(h9b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h4b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^z->get_sym(h4b))==z->irrep_f()) { 
      long dimc=z->get_range(h9b)*z->get_range(h4b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h9b_0,h4b_0; 
      z->restricted_2(h9b,h4b,h9b_0,h4b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h9b)*z->get_range(h4b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(h4b_0+(z->nab())*(h9b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h4b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h4b),0,1,-1.0); 
      in[1]->add_block(h4b+z->noab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_1(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  if (z->get_spin(h9b)==z->get_spin(h4b)) { 
   if ((z->get_sym(h9b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_f())) { 
    if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h4b)!=4L) { 
     in[1]->input_offset(h4b+z->noab()*(h9b),size); 
     size+=z->get_range(h9b)*z->get_range(h4b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_2(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p8b<=p5b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_f())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
               long p5b_0,p6b_0,p7b_0,p9b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
               z->restricted_8(p5b,p6b,p7b,p9b,h1b,h2b,h3b,h4b,p5b_0,p6b_0,p7b_0,p9b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
               long p8b_1,p9b_1; 
               z->restricted_2(p8b,p9b,p8b_1,p9b_1); 
               long dim_common=z->get_range(p9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p8b); 
               long dima1=dim_common*dima1_sort; 
               if (p7b<p9b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,0,3,+1.0); 
               } 
               else if (p6b<p9b && p9b<=p7b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,0,2,-1.0); 
               } 
               else if (p5b<p9b && p9b<=p6b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,0,1,+1.0); 
               } 
               else if (p9b<=p5b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,-1.0); 
               } 
               in[1]->get_block(p9b_1-z->noab()+z->nvab()*(p8b_1-z->noab()),k_a1); 
               z->sort_indices2(k_a1,k_a1_sort,z->get_range(p8b),z->get_range(p9b),0,1,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p8b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,0,4,3,2,1,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,0,5,4,3,2,1,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,0,6,5,4,3,2,1,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),0,7,6,5,4,3,2,1,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_2_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
 for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
  long tileoffset; 
  tileoffset=(p9b-z->noab()+z->nvab()*(p8b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p8b)+z->get_spin(p9b)!=4L) { 
    if (z->get_spin(p8b)==z->get_spin(p9b)) { 
     if ((z->get_sym(p8b)^z->get_sym(p9b))==z->irrep_f()) { 
      long dimc=z->get_range(p8b)*z->get_range(p9b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long p8b_0,p9b_0; 
      z->restricted_2(p8b,p9b,p8b_0,p9b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p8b)*z->get_range(p9b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p9b_0+(z->nab())*(p8b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(p8b),z->get_range(p9b),0,1,+1.0); 
      in[1]->add_block(p9b-z->noab()+z->nvab()*(p8b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_2(){ 
 
long size=0L; 
for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
 for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
  if (z->get_spin(p8b)==z->get_spin(p9b)) { 
   if ((z->get_sym(p8b)^z->get_sym(p9b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p8b)+z->get_spin(p9b)!=4L) { 
     in[1]->input_offset(p9b-z->noab()+z->nvab()*(p8b-z->noab()),size); 
     size+=z->get_range(p8b)*z->get_range(p9b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_4(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p5b<p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<=p5b && p5b<p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        else if (p8b<=p5b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             if (z->get_spin(p5b)==z->get_spin(h9b)) { 
              if ((z->get_sym(p5b)^z->get_sym(h9b))==z->irrep_t()) { 
               long p5b_0,h9b_0; 
               z->restricted_2(p5b,h9b,p5b_0,h9b_0); 
               long h9b_1,p6b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1; 
               z->restricted_8(h9b,p6b,p7b,p8b,h1b,h2b,h3b,h4b,h9b_1,p6b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1); 
               long dim_common=z->get_range(h9b); 
               long dima0_sort=z->get_range(p5b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               z->t1()->get_block(h9b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
               z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h9b),0,1,+1.0); 
               in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()+z->nvab()*(h9b_1))))))),k_a1); 
               z->sort_indices8(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p6b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p5b && p5b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),6,7,5,4,3,2,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p5b && p5b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),6,5,7,4,3,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),6,5,4,7,3,2,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_4(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_f())) { 
          if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
           in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),size); 
           size+=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_5(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h9b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h9b))))))==z->irrep_t()) { 
               long p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h9b_0; 
               z->restricted_6(p5b,p6b,p7b,h1b,h2b,h9b,p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h9b_0); 
               long h9b_1,p8b_1,h3b_1,h4b_1; 
               z->restricted_4(h9b,p8b,h3b,h4b,h9b_1,p8b_1,h3b_1,h4b_1); 
               long dim_common=z->get_range(h9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (h2b<h9b) { 
                z->t3()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),4,3,2,1,0,5,+1.0); 
               } 
               else if (h1b<h9b && h9b<=h2b) { 
                z->t3()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
               } 
               else if (h9b<=h1b) { 
                z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
               } 
               in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p8b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,4,3,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,4,1,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,1,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,4,1,0,3,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,1,4,0,3,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,2,1,0,4,3,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,4,3,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,4,1,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,1,4,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,4,1,0,3,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,1,4,0,3,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,2,5,1,0,4,3,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,4,3,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,4,1,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,1,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,4,1,0,3,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,1,4,0,3,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,2,6,5,1,0,4,3,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,4,3,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,4,1,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,1,4,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,4,1,0,3,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,1,4,0,3,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),2,7,6,5,1,0,4,3,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_5_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,p8b_0,h3b_0,h4b_0; 
        z->restricted_4(h9b,p8b,h3b,h4b,h9b_0,p8b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(p8b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,-1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_5(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_6(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=0L;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h9b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h9b))))==z->irrep_t()) { 
               long p5b_0,p6b_0,h1b_0,h9b_0; 
               z->restricted_4(p5b,p6b,h1b,h9b,p5b_0,p6b_0,h1b_0,h9b_0); 
               long h9b_1,p7b_1,p8b_1,h2b_1,h3b_1,h4b_1; 
               z->restricted_6(h9b,p7b,p8b,h2b,h3b,h4b,h9b_1,p7b_1,p8b_1,h2b_1,h3b_1,h4b_1); 
               long dim_common=z->get_range(h9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (h1b<h9b) { 
                z->t2()->get_block(h9b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h9b),2,1,0,3,+1.0); 
               } 
               else if (h9b<=h1b) { 
                z->t2()->get_block(h1b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h1b),3,1,0,2,-1.0); 
               } 
               in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h9b_1))))),k_a1); 
               z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p7b>=p6b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,5,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,1,0,5,-1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,5,2,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,5,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,1,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,1,0,5,+1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,5,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,1,0,5,-1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,5,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,1,0,5,-1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,5,2,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,5,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,1,5,0,-1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,1,0,5,+1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,5,2,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,5,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,1,5,0,+1.0); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,1,0,5,-1.0); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_69(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             for (long h10b=h9b;h10b<z->noab();++h10b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h9b)+z->get_spin(h10b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h9b)^z->get_sym(h10b))))==z->irrep_t()) { 
                long p5b_0,p6b_0,h9b_0,h10b_0; 
                z->restricted_4(p5b,p6b,h9b,h10b,p5b_0,p6b_0,h9b_0,h10b_0); 
                long h9b_1,h10b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1; 
                z->restricted_8(h9b,h10b,p7b,p8b,h1b,h2b,h3b,h4b,h9b_1,h10b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1); 
                long dim_common=z->get_range(h9b)*z->get_range(h10b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h10b),1,0,3,2,+1.0); 
                in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))))))),k_a1); 
                z->sort_indices8(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
                double factor=1.0; 
                if (h9b==h10b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p7b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,4,3,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,5,6,4,3,2,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),5,7,6,4,3,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,5,4,6,3,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),5,7,4,6,3,2,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),5,4,7,6,3,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_69(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
          if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
           in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),size); 
           size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_6(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_f())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
         in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_71(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h10b=0L;h10b<z->noab();++h10b) { 
             for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h10b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h10b))))))==z->irrep_t()) { 
                long p5b_0,p6b_0,p9b_0,h1b_0,h2b_0,h10b_0; 
                z->restricted_6(p5b,p6b,p9b,h1b,h2b,h10b,p5b_0,p6b_0,p9b_0,h1b_0,h2b_0,h10b_0); 
                long h10b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1; 
                z->restricted_6(h10b,p7b,p8b,h3b,h4b,p9b,h10b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1); 
                long dim_common=z->get_range(h10b)*z->get_range(p9b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                if (p6b<p9b && h2b<h10b) { 
                 z->t3()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),4,3,1,0,2,5,+1.0); 
                } 
                else if (p6b<p9b && h1b<h10b && h10b<=h2b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),5,3,1,0,2,4,-1.0); 
                } 
                else if (p6b<p9b && h10b<=h1b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),5,4,1,0,2,3,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h2b<h10b) { 
                 z->t3()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),4,3,2,0,1,5,-1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h1b<h10b && h10b<=h2b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),5,3,2,0,1,4,+1.0); 
                } 
                else if (p5b<p9b && p9b<=p6b && h10b<=h1b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),5,4,2,0,1,3,-1.0); 
                } 
                else if (p9b<=p5b && h2b<h10b) { 
                 z->t3()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),4,3,2,1,0,5,+1.0); 
                } 
                else if (p9b<=p5b && h1b<h10b && h10b<=h2b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
                } 
                else if (p9b<=p5b && h10b<=h1b) { 
                 z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
                } 
                in[1]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h10b_1))))),k_a1); 
                z->sort_indices6(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(p9b),4,3,2,1,5,0,+1.0); 
                double factor=1.0; 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p7b>=p6b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,5,4,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,5,1,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,1,5,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,5,1,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,1,5,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,3,2,1,0,5,4,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,5,4,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,5,1,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,1,5,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,5,1,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,1,5,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,6,2,1,0,5,4,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,5,4,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,5,1,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,1,5,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,5,1,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,1,5,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,6,2,1,0,5,4,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,5,4,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,5,1,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,1,5,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,5,1,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,1,5,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,3,2,6,1,0,5,4,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,5,4,1,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,5,1,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,1,5,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,5,1,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,1,5,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,7,2,6,1,0,5,4,-1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,5,4,1,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,5,1,4,0,-1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,1,5,4,0,+1.0); 
             out->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,5,1,0,4,+1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,1,5,0,4,-1.0); 
             out->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),3,2,7,6,1,0,5,4,+1.0); 
             out->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_71(){ 
 
long size=0L; 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      if (z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
         in[1]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b))))),size); 
         size+=z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_73(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=0L;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<p8b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h2b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<=h1b && h1b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<=h1b && h1b<h4b) { 
         tileoffset=(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h9b=0L;h9b<z->noab();++h9b) { 
             for (long h10b=h9b;h10b<z->noab();++h10b) { 
              if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h9b)+z->get_spin(h10b)) { 
               if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h9b)^z->get_sym(h10b))))))==z->irrep_t()) { 
                long p5b_0,p6b_0,p7b_0,h1b_0,h9b_0,h10b_0; 
                z->restricted_6(p5b,p6b,p7b,h1b,h9b,h10b,p5b_0,p6b_0,p7b_0,h1b_0,h9b_0,h10b_0); 
                long h9b_1,h10b_1,p8b_1,h2b_1,h3b_1,h4b_1; 
                z->restricted_6(h9b,h10b,p8b,h2b,h3b,h4b,h9b_1,h10b_1,p8b_1,h2b_1,h3b_1,h4b_1); 
                long dim_common=z->get_range(h9b)*z->get_range(h10b); 
                long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                if (h1b<h9b) { 
                 z->t3()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h9b),z->get_range(h10b),3,2,1,0,5,4,+1.0); 
                } 
                else if (h9b<=h1b && h1b<h10b) { 
                 z->t3()->get_block(h10b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h9b),z->get_range(h1b),z->get_range(h10b),4,2,1,0,5,3,-1.0); 
                } 
                else if (h10b<=h1b) { 
                 z->t3()->get_block(h1b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                 z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h9b),z->get_range(h10b),z->get_range(h1b),5,2,1,0,4,3,+1.0); 
                } 
                in[1]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))))),k_a1); 
                z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
                double factor=1.0; 
                if (h9b==h10b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p8b>=p7b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,3,4,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,3,2,4,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,3,2,1,4,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,5,3,2,1,0,4,-0.5/0.5); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,3,5,4,2,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,3,5,2,4,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,3,5,2,1,4,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,6,3,5,2,1,0,4,+0.5/0.5); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,3,6,5,4,2,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,3,6,5,2,4,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,3,6,5,2,1,4,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),7,3,6,5,2,1,0,4,-0.5/0.5); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),3,7,6,5,4,2,1,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h1b && h1b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),3,7,6,5,2,4,1,0,+0.5/0.5); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),3,7,6,5,2,1,4,0,-0.5/0.5); 
             out->add_block(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),3,7,6,5,2,1,0,4,+0.5/0.5); 
             out->add_block(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_73(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
         in[1]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_8(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p6b<p7b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p7b<=p6b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p5b<p7b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p7b<=p5b && p5b<p8b && p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        else if (p8b<=p5b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))))); 
        } 
        if (out->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
               long p5b_0,p6b_0,p9b_0,h1b_0,h2b_0,h3b_0; 
               z->restricted_6(p5b,p6b,p9b,h1b,h2b,h3b,p5b_0,p6b_0,p9b_0,h1b_0,h2b_0,h3b_0); 
               long p7b_1,p8b_1,h4b_1,p9b_1; 
               z->restricted_4(p7b,p8b,h4b,p9b,p7b_1,p8b_1,h4b_1,p9b_1); 
               long dim_common=z->get_range(p9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p6b<p9b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,0,2,+1.0); 
               } 
               else if (p5b<p9b && p9b<=p6b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,-1.0); 
               } 
               else if (p9b<=p5b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
               } 
               in[1]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),2,1,0,3,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p7b>=p6b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,2,1,5,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,2,1,5,4,0,3,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,2,1,5,0,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p7b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,2,1,0,5,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,6,1,5,4,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,6,1,5,4,0,3,+1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,6,1,5,0,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,6,1,0,5,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,6,1,5,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,6,1,5,4,0,3,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,6,1,5,0,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p8b>=p6b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,6,1,0,5,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,1,6,5,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,1,6,5,4,0,3,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,1,6,5,0,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p7b>=p5b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,2,1,6,0,5,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p5b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,1,6,5,4,3,0,-1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,1,6,5,4,0,3,+1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,1,6,5,0,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,7,1,6,0,5,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,1,7,6,5,4,3,0,+1.0); 
             out->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,1,7,6,5,4,0,3,-1.0); 
             out->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,1,7,6,5,0,4,3,+1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
            if (p5b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),2,1,7,6,0,5,4,3,-1.0); 
             out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_0_8_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long p7b_0,p8b_0,h4b_0,p9b_0; 
        z->restricted_4(p7b,p8b,h4b,p9b,p7b_0,p8b_0,h4b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(p7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(p7b),z->get_range(p8b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_0_8(){ 
 
long size=0L; 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
     if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
       in[1]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),size); 
       size+=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_10(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h9b_1,p8b_1,h4b_1,p10b_1; 
           z->restricted_4(h9b,p8b,h4b,p10b,h9b_1,p8b_1,h4b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_10_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,p8b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,p8b,h4b,p10b,h9b_0,p8b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_10(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_11(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
             if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
              if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
               long p6b_0,p7b_0,p10b_0,h1b_0,h2b_0,h3b_0; 
               z->restricted_6(p6b,p7b,p10b,h1b,h2b,h3b,p6b_0,p7b_0,p10b_0,h1b_0,h2b_0,h3b_0); 
               long h9b_1,p8b_1,h4b_1,p10b_1; 
               z->restricted_4(h9b,p8b,h4b,p10b,h9b_1,p8b_1,h4b_1,p10b_1); 
               long dim_common=z->get_range(p10b); 
               long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p7b<p10b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,0,2,+1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,-1.0); 
               } 
               else if (p10b<=p6b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
               } 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),2,1,0,3,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p8b>=p7b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,6,1,5,4,3,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,6,1,5,4,0,3,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,6,1,5,0,4,3,+1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,6,1,0,5,4,3,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,1,6,5,4,3,0,-1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,1,6,5,4,0,3,+1.0); 
             in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,1,6,5,0,4,3,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,7,1,6,0,5,4,3,+1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,1,7,6,5,4,3,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,1,7,6,5,4,0,3,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,1,7,6,5,0,4,3,+1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),2,1,7,6,0,5,4,3,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_11_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,p8b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,p8b,h4b,p10b,h9b_0,p8b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_11(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_12(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p10b_0,h4b_0; 
           z->restricted_2(p10b,h4b,p10b_0,h4b_0); 
           long p7b_1,p8b_1,p9b_1,p10b_1; 
           z->restricted_4(p7b,p8b,p9b,p10b,p7b_1,p8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h4b),1,0,+1.0); 
           if (p9b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(p7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_13(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=0L;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h3b<=h2b && h2b<h4b) { 
       tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h4b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h10b=0L;h10b<z->noab();++h10b) { 
           if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h10b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h10b))))==z->irrep_t()) { 
             long p7b_0,p8b_0,h2b_0,h10b_0; 
             z->restricted_4(p7b,p8b,h2b,h10b,p7b_0,p8b_0,h2b_0,h10b_0); 
             long h9b_1,h10b_1,h3b_1,h4b_1; 
             z->restricted_4(h9b,h10b,h3b,h4b,h9b_1,h10b_1,h3b_1,h4b_1); 
             long dim_common=z->get_range(h10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             if (h2b<h10b) { 
              z->t2()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h10b),2,1,0,3,+1.0); 
             } 
             else if (h10b<=h2b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h10b),z->get_range(h2b),3,1,0,2,-1.0); 
             } 
             if (h9b<h10b) { 
              in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
             } 
             else if (h10b<=h9b) { 
              in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,3,1,0,+0.5); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h4b>=h2b && h2b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,1,3,0,-0.5); 
           in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,1,0,3,+0.5); 
           in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_13_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h3b_0,h4b_0; 
        z->restricted_4(h9b,h10b,h3b,h4b,h9b_0,h10b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,-1.0); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_13(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_14(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=0L;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (p7b<p8b && h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p7b<p8b && h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p7b<p8b && h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p7b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
             long p7b_0,p10b_0,h2b_0,h3b_0; 
             z->restricted_4(p7b,p10b,h2b,h3b,p7b_0,p10b_0,h2b_0,h3b_0); 
             long h9b_1,p8b_1,h4b_1,p10b_1; 
             z->restricted_4(h9b,p8b,h4b,p10b,h9b_1,p8b_1,h4b_1,p10b_1); 
             long dim_common=z->get_range(p10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             if (p7b<p10b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
             } 
             else if (p10b<=p7b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
             } 
             in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),2,1,0,3,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p8b>=p7b && h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,4,3,0,+1.0); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p8b>=p7b && h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,4,0,3,-1.0); 
           in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p8b>=p7b && h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,0,4,3,+1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,4,3,0,-1.0); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,4,0,3,+1.0); 
           in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,0,4,3,-1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_14_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,p8b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,p8b,h4b,p10b,h9b_0,p8b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_14(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_15(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      if (p6b<p7b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p7b<=p6b && p6b<p8b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab())))))); 
      } 
      else if (p8b<=p6b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p6b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
            if ((z->get_sym(p6b)^(z->get_sym(p10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
             long p6b_0,p10b_0,h3b_0,h4b_0; 
             z->restricted_4(p6b,p10b,h3b,h4b,p6b_0,p10b_0,h3b_0,h4b_0); 
             long p7b_1,p8b_1,p9b_1,p10b_1; 
             z->restricted_4(p7b,p8b,p9b,p10b,p7b_1,p8b_1,p9b_1,p10b_1); 
             long dim_common=z->get_range(p10b); 
             long dima0_sort=z->get_range(p6b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b); 
             long dima1=dim_common*dima1_sort; 
             if (p6b<p10b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
             } 
             else if (p10b<=p6b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
             } 
             if (p9b<p10b) { 
              in[2]->get_block(p10b_1-z->noab()+z->nvab()*(p9b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
             } 
             else if (p10b<=p9b) { 
              in[2]->get_block(p9b_1-z->noab()+z->nvab()*(p10b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p7b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),5,2,1,4,3,0,+0.5); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p8b>=p6b && p6b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),2,5,1,4,3,0,-0.5); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()))))),k_c); 
          } 
          if (p6b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),2,1,5,4,3,0,+0.5); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_15_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long p7b_0,p8b_0,p9b_0,p10b_0; 
        z->restricted_4(p7b,p8b,p9b,p10b,p7b_0,p8b_0,p9b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(p9b_0+(z->nab())*(p8b_0+(z->nab())*(p7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),0,1,2,3,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_15(){ 
 
long size=0L; 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
     if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),size); 
       size+=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_21(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h10b=0L;h10b<z->noab();++h10b) { 
             if (z->get_spin(p6b)==z->get_spin(h10b)) { 
              if ((z->get_sym(p6b)^z->get_sym(h10b))==z->irrep_t()) { 
               long p6b_0,h10b_0; 
               z->restricted_2(p6b,h10b,p6b_0,h10b_0); 
               long h9b_1,h10b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1; 
               z->restricted_8(h9b,h10b,p7b,p8b,h1b,h2b,h3b,h4b,h9b_1,h10b_1,p7b_1,p8b_1,h1b_1,h2b_1,h3b_1,h4b_1); 
               long dim_common=z->get_range(h10b); 
               long dima0_sort=z->get_range(p6b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               z->t1()->get_block(h10b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
               z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h10b),0,1,+1.0); 
               if (h9b<h10b) { 
                in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))))))),k_a1); 
                z->sort_indices8(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,0,1,+1.0); 
               } 
               else if (h10b<=h9b) { 
                in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h9b_1+z->noab()*(h10b_1))))))),k_a1); 
                z->sort_indices8(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h9b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,-1.0); 
               } 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p7b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(p6b),6,7,5,4,3,2,1,0,+0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(p6b),6,5,7,4,3,2,1,0,-0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(p6b),6,5,4,7,3,2,1,0,+0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_21(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
          if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
           in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),size); 
           size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_23(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  long tileoffset; 
  tileoffset=(h4b+z->noab()*(h9b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h4b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(h4b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h11b=0L;h11b<z->noab();++h11b) { 
       for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
        if (z->get_spin(p10b)==z->get_spin(h11b)) { 
         if ((z->get_sym(p10b)^z->get_sym(h11b))==z->irrep_t()) { 
          long p10b_0,h11b_0; 
          z->restricted_2(p10b,h11b,p10b_0,h11b_0); 
          long h9b_1,h11b_1,h4b_1,p10b_1; 
          z->restricted_4(h9b,h11b,h4b,p10b,h9b_1,h11b_1,h4b_1,p10b_1); 
          long dim_common=z->get_range(h11b)*z->get_range(p10b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h9b)*z->get_range(h4b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h11b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h11b),0,1,+1.0); 
          if (h9b<h11b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(h4b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),2,0,3,1,+1.0); 
          } 
          else if (h11b<=h9b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(h4b_1+(z->nab())*(h9b_1+(z->nab())*(h11b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),z->get_range(p10b),2,1,3,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),1,0,-1.0); 
      in[1]->add_block(h4b+z->noab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_24(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p11b_0,h3b_0; 
           z->restricted_2(p11b,h3b,p11b_0,h3b_0); 
           long h9b_1,h10b_1,h4b_1,p11b_1; 
           z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h3b),1,0,+1.0); 
           in[2]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_24_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,-1.0); 
        in[2]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_24(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[2]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_25(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
 for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
  long tileoffset; 
  tileoffset=(p9b-z->noab()+z->nvab()*(p8b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p8b)+z->get_spin(p9b)!=4L) { 
    if (z->get_spin(p8b)==z->get_spin(p9b)) { 
     if ((z->get_sym(p8b)^z->get_sym(p9b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p8b)*z->get_range(p9b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h11b=0L;h11b<z->noab();++h11b) { 
       for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
        if (z->get_spin(p10b)==z->get_spin(h11b)) { 
         if ((z->get_sym(p10b)^z->get_sym(h11b))==z->irrep_t()) { 
          long p10b_0,h11b_0; 
          z->restricted_2(p10b,h11b,p10b_0,h11b_0); 
          long h11b_1,p8b_1,p9b_1,p10b_1; 
          z->restricted_4(h11b,p8b,p9b,p10b,h11b_1,p8b_1,p9b_1,p10b_1); 
          long dim_common=z->get_range(h11b)*z->get_range(p10b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p8b)*z->get_range(p9b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h11b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h11b),0,1,+1.0); 
          if (p9b<p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,3,0,+1.0); 
          } 
          else if (p10b<=p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,2,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),1,0,-1.0); 
      in[1]->add_block(p9b-z->noab()+z->nvab()*(p8b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_26(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long h11b=0L;h11b<z->noab();++h11b) { 
             for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
              if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h11b)) { 
               if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h11b))))))))==z->irrep_t()) { 
                long p6b_0,p7b_0,p8b_0,p10b_0,h1b_0,h2b_0,h3b_0,h11b_0; 
                z->restricted_8(p6b,p7b,p8b,p10b,h1b,h2b,h3b,h11b,p6b_0,p7b_0,p8b_0,p10b_0,h1b_0,h2b_0,h3b_0,h11b_0); 
                long h9b_1,h11b_1,h4b_1,p10b_1; 
                z->restricted_4(h9b,h11b,h4b,p10b,h9b_1,h11b_1,h4b_1,p10b_1); 
                long dim_common=z->get_range(h11b)*z->get_range(p10b); 
                long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(h9b)*z->get_range(h4b); 
                long dima1=dim_common*dima1_sort; 
                if (p8b<p10b && h3b<h11b) { 
                 z->t4()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),6,5,4,2,1,0,3,7,+1.0); 
                } 
                else if (p8b<p10b && h2b<h11b && h11b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),7,5,4,2,1,0,3,6,-1.0); 
                } 
                else if (p8b<p10b && h1b<h11b && h11b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h1b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,1,0,3,5,+1.0); 
                } 
                else if (p8b<p10b && h11b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,1,0,3,4,-1.0); 
                } 
                else if (p7b<p10b && p10b<=p8b && h3b<h11b) { 
                 z->t4()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),6,5,4,3,1,0,2,7,-1.0); 
                } 
                else if (p7b<p10b && p10b<=p8b && h2b<h11b && h11b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),7,5,4,3,1,0,2,6,+1.0); 
                } 
                else if (p7b<p10b && p10b<=p8b && h1b<h11b && h11b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h1b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,1,0,2,5,-1.0); 
                } 
                else if (p7b<p10b && p10b<=p8b && h11b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,1,0,2,4,+1.0); 
                } 
                else if (p6b<p10b && p10b<=p7b && h3b<h11b) { 
                 z->t4()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),6,5,4,3,2,0,1,7,+1.0); 
                } 
                else if (p6b<p10b && p10b<=p7b && h2b<h11b && h11b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),7,5,4,3,2,0,1,6,-1.0); 
                } 
                else if (p6b<p10b && p10b<=p7b && h1b<h11b && h11b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,0,1,5,+1.0); 
                } 
                else if (p6b<p10b && p10b<=p7b && h11b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,0,1,4,-1.0); 
                } 
                else if (p10b<=p6b && h3b<h11b) { 
                 z->t4()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),6,5,4,3,2,1,0,7,-1.0); 
                } 
                else if (p10b<=p6b && h2b<h11b && h11b<=h3b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),7,5,4,3,2,1,0,6,+1.0); 
                } 
                else if (p10b<=p6b && h1b<h11b && h11b<=h2b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,-1.0); 
                } 
                else if (p10b<=p6b && h11b<=h1b) { 
                 z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,+1.0); 
                } 
                if (h9b<h11b) { 
                 in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h9b_1))),k_a1); 
                 z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),2,0,3,1,+1.0); 
                } 
                else if (h11b<=h9b) { 
                 in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h9b_1+z->noab()*(h11b_1))),k_a1); 
                 z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),z->get_range(p10b),2,1,3,0,-1.0); 
                } 
                double factor=1.0; 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),1,7,6,5,4,3,2,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),1,7,6,5,4,3,0,2,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),1,7,6,5,4,0,3,2,+1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),1,7,6,5,0,4,3,2,-1.0); 
             in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_26_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h11b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,h11b,h4b,p10b,h9b_0,h11b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_26(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_27(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h10b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p11b_0,h4b_0; 
           z->restricted_2(p11b,h4b,p11b_0,h4b_0); 
           long h10b_1,p8b_1,p9b_1,p11b_1; 
           z->restricted_4(h10b,p8b,p9b,p11b,h10b_1,p8b_1,p9b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h10b)*z->get_range(p8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h4b),1,0,+1.0); 
           if (p9b<p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),z->get_range(p11b),2,1,0,3,+1.0); 
           } 
           else if (p11b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(p8b),z->get_range(p11b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h10b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_28(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p8b && p8b<=p7b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
             for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
              if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
               if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
                long p6b_0,p7b_0,p10b_0,p11b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
                z->restricted_8(p6b,p7b,p10b,p11b,h1b,h2b,h3b,h4b,p6b_0,p7b_0,p10b_0,p11b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
                long h9b_1,p8b_1,p10b_1,p11b_1; 
                z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
                long dim_common=z->get_range(p10b)*z->get_range(p11b); 
                long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(h9b)*z->get_range(p8b); 
                long dima1=dim_common*dima1_sort; 
                if (p7b<p10b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,1,0,3,2,+1.0); 
                } 
                else if (p6b<p10b && p10b<=p7b && p7b<p11b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,0,3,1,-1.0); 
                } 
                else if (p6b<p10b && p11b<=p7b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,0,2,1,+1.0); 
                } 
                else if (p10b<=p6b && p7b<p11b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,3,0,+1.0); 
                } 
                else if (p10b<=p6b && p6b<p11b && p11b<=p7b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p11b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,2,0,-1.0); 
                } 
                else if (p11b<=p6b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
                } 
                z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),1,0,3,2,+1.0); 
                double factor=1.0; 
                if (p10b==p11b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            if (p8b>=p7b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),1,7,6,0,5,4,3,2,-0.5/0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && p8b>=p6b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),1,7,0,6,5,4,3,2,+0.5/0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),z->get_range(p6b),1,0,7,6,5,4,3,2,-0.5/0.5); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_29(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (p7b<p8b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h10b=0L;h10b<z->noab();++h10b) { 
           if (z->get_spin(p7b)==z->get_spin(h10b)) { 
            if ((z->get_sym(p7b)^z->get_sym(h10b))==z->irrep_t()) { 
             long p7b_0,h10b_0; 
             z->restricted_2(p7b,h10b,p7b_0,h10b_0); 
             long h9b_1,h10b_1,p8b_1,h2b_1,h3b_1,h4b_1; 
             z->restricted_6(h9b,h10b,p8b,h2b,h3b,h4b,h9b_1,h10b_1,p8b_1,h2b_1,h3b_1,h4b_1); 
             long dim_common=z->get_range(h10b); 
             long dima0_sort=z->get_range(p7b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             z->t1()->get_block(h10b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
             z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h10b),0,1,+1.0); 
             if (h9b<h10b) { 
              in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))))),k_a1); 
              z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,0,1,+1.0); 
             } 
             else if (h10b<=h9b) { 
              in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1+z->noab()*(h10b_1))))),k_a1); 
              z->sort_indices6(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h9b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p8b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h9b),z->get_range(p7b),4,5,3,2,1,0,+1.0); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(h9b),z->get_range(p7b),4,3,5,2,1,0,-1.0); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_29(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
         in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_3(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  long tileoffset; 
  tileoffset=(h4b+z->noab()*(h9b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h4b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_f())) { 
      long dimc=z->get_range(h9b)*z->get_range(h4b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
       if (z->get_spin(p10b)==z->get_spin(h4b)) { 
        if ((z->get_sym(p10b)^z->get_sym(h4b))==z->irrep_t()) { 
         long p10b_0,h4b_0; 
         z->restricted_2(p10b,h4b,p10b_0,h4b_0); 
         long h9b_1,p10b_1; 
         z->restricted_2(h9b,p10b,h9b_1,p10b_1); 
         long dim_common=z->get_range(p10b); 
         long dima0_sort=z->get_range(h4b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h9b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h4b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h4b),1,0,+1.0); 
         in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h9b_1),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),0,1,+1.0); 
      in[1]->add_block(h4b+z->noab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_30(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p6b<p7b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p7b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p7b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p7b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p7b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p6b<p7b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p7b<=p6b && p6b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        else if (p8b<=p6b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))))); 
        } 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
             if (z->get_spin(p6b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
              if ((z->get_sym(p6b)^(z->get_sym(p10b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
               long p6b_0,p10b_0,h1b_0,h2b_0; 
               z->restricted_4(p6b,p10b,h1b,h2b,p6b_0,p10b_0,h1b_0,h2b_0); 
               long h9b_1,p7b_1,p8b_1,h3b_1,h4b_1,p10b_1; 
               z->restricted_6(h9b,p7b,p8b,h3b,h4b,p10b,h9b_1,p7b_1,p8b_1,h3b_1,h4b_1,p10b_1); 
               long dim_common=z->get_range(p10b); 
               long dima0_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p6b<p10b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
               } 
               else if (p10b<=p6b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
               } 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h9b_1))))),k_a1); 
               z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(p10b),4,3,2,1,0,5,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p7b>=p6b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,6,5,1,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p6b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,6,1,5,0,-1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p6b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,1,6,5,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p6b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,6,1,0,5,+1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p6b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,1,6,0,5,-1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p6b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,7,3,2,1,0,6,5,+1.0); 
             in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,6,5,1,0,-1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,6,1,5,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,1,6,5,0,-1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,6,1,0,5,-1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,1,6,0,5,+1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p6b && p6b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,7,2,1,0,6,5,-1.0); 
             in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,6,5,1,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,6,1,5,0,-1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,1,6,5,0,+1.0); 
             in[1]->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,6,1,0,5,+1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,1,6,0,5,-1.0); 
             in[1]->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
            if (p6b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),4,3,2,7,1,0,6,5,+1.0); 
             in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_30(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
      if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p10b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)!=12L) { 
         in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p10b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_33(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
          if (z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h11b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h3b)^z->get_sym(h11b))))==z->irrep_t()) { 
            long p8b_0,p10b_0,h3b_0,h11b_0; 
            z->restricted_4(p8b,p10b,h3b,h11b,p8b_0,p10b_0,h3b_0,h11b_0); 
            long h9b_1,h11b_1,h4b_1,p10b_1; 
            z->restricted_4(h9b,h11b,h4b,p10b,h9b_1,h11b_1,h4b_1,p10b_1); 
            long dim_common=z->get_range(h11b)*z->get_range(p10b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(h4b); 
            long dima1=dim_common*dima1_sort; 
            if (p8b<p10b && h3b<h11b) { 
             z->t2()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(h3b),z->get_range(h11b),2,0,1,3,+1.0); 
            } 
            else if (p8b<p10b && h11b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h3b),3,0,1,2,-1.0); 
            } 
            else if (p10b<=p8b && h3b<h11b) { 
             z->t2()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),2,1,0,3,-1.0); 
            } 
            else if (p10b<=p8b && h11b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),3,1,0,2,+1.0); 
            } 
            if (h9b<h11b) { 
             in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),2,0,3,1,+1.0); 
            } 
            else if (h11b<=h9b) { 
             in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h9b_1+z->noab()*(h11b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),z->get_range(p10b),2,1,3,0,-1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),1,3,2,0,+1.0); 
         in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),1,3,0,2,-1.0); 
         in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_33_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h11b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,h11b,h4b,p10b,h9b_0,h11b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_33(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_34(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
          if (z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p10b_0,p11b_0,h3b_0,h4b_0; 
            z->restricted_4(p10b,p11b,h3b,h4b,p10b_0,p11b_0,h3b_0,h4b_0); 
            long h9b_1,p8b_1,p10b_1,p11b_1; 
            z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
            long dim_common=z->get_range(p10b)*z->get_range(p11b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(p8b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p10b==p11b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_35(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=0L;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      if (h3b<h4b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (h4b<=h3b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h10b=0L;h10b<z->noab();++h10b) { 
           for (long h11b=h10b;h11b<z->noab();++h11b) { 
            if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h10b)+z->get_spin(h11b)) { 
             if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h10b)^z->get_sym(h11b))))))==z->irrep_t()) { 
              long p6b_0,p7b_0,p8b_0,h3b_0,h10b_0,h11b_0; 
              z->restricted_6(p6b,p7b,p8b,h3b,h10b,h11b,p6b_0,p7b_0,p8b_0,h3b_0,h10b_0,h11b_0); 
              long h10b_1,h11b_1,h4b_1,p9b_1; 
              z->restricted_4(h10b,h11b,h4b,p9b,h10b_1,h11b_1,h4b_1,p9b_1); 
              long dim_common=z->get_range(h10b)*z->get_range(h11b); 
              long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h4b)*z->get_range(p9b); 
              long dima1=dim_common*dima1_sort; 
              if (h3b<h10b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h10b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h10b),z->get_range(h11b),3,2,1,0,5,4,+1.0); 
              } 
              else if (h10b<=h3b && h3b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h10b),z->get_range(h3b),z->get_range(h11b),4,2,1,0,5,3,-1.0); 
              } 
              else if (h11b<=h3b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h10b),z->get_range(h11b),z->get_range(h3b),5,2,1,0,4,3,+1.0); 
              } 
              in[2]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),3,2,1,0,+1.0); 
              double factor=1.0; 
              if (h10b==h11b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),5,4,3,2,1,0,+0.5/0.5); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (h3b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),5,4,3,1,2,0,-0.5/0.5); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_35_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h10b_0,h11b_0,h4b_0,p9b_0; 
        z->restricted_4(h10b,h11b,h4b,p9b,h10b_0,h11b_0,h4b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h10b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,+1.0); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_35(){ 
 
long size=0L; 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
       in[2]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),size); 
       size+=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_36(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long h11b=h10b;h11b<z->noab();++h11b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h10b)+z->get_spin(h11b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h10b)^z->get_sym(h11b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h10b_0,h11b_0; 
            z->restricted_4(p7b,p8b,h10b,h11b,p7b_0,p8b_0,h10b_0,h11b_0); 
            long h10b_1,h11b_1,h4b_1,p9b_1; 
            z->restricted_4(h10b,h11b,h4b,p9b,h10b_1,h11b_1,h4b_1,p9b_1); 
            long dim_common=z->get_range(h10b)*z->get_range(h11b); 
            long dima0_sort=z->get_range(p7b)*z->get_range(p8b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h4b)*z->get_range(p9b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h11b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h10b),z->get_range(h11b),1,0,3,2,+1.0); 
            in[2]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),3,2,1,0,+1.0); 
            double factor=1.0; 
            if (h10b==h11b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,+0.5/0.5); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_36_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h10b_0,h11b_0,h4b_0,p9b_0; 
        z->restricted_4(h10b,h11b,h4b,p9b,h10b_0,h11b_0,h4b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h10b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h10b),z->get_range(h11b),z->get_range(h4b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_36(){ 
 
long size=0L; 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
       in[2]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),size); 
       size+=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_37(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    if (p7b<p8b) { 
     tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    } 
    else if (p8b<=p7b) { 
     tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab())))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
          if (z->get_spin(p7b)+z->get_spin(p10b)==z->get_spin(h4b)+z->get_spin(h11b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(h4b)^z->get_sym(h11b))))==z->irrep_t()) { 
            long p7b_0,p10b_0,h4b_0,h11b_0; 
            z->restricted_4(p7b,p10b,h4b,h11b,p7b_0,p10b_0,h4b_0,h11b_0); 
            long h11b_1,p8b_1,p9b_1,p10b_1; 
            z->restricted_4(h11b,p8b,p9b,p10b,h11b_1,p8b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(h11b)*z->get_range(p10b); 
            long dima0_sort=z->get_range(p7b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p8b)*z->get_range(p9b); 
            long dima1=dim_common*dima1_sort; 
            if (p7b<p10b && h4b<h11b) { 
             z->t2()->get_block(h11b_0+z->noab()*(h4b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(h4b),z->get_range(h11b),2,0,1,3,+1.0); 
            } 
            else if (p7b<p10b && h11b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(h11b),z->get_range(h4b),3,0,1,2,-1.0); 
            } 
            else if (p10b<=p7b && h4b<h11b) { 
             z->t2()->get_block(h11b_0+z->noab()*(h4b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(h4b),z->get_range(h11b),2,1,0,3,-1.0); 
            } 
            else if (p10b<=p7b && h11b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h11b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(h11b),z->get_range(h4b),3,1,0,2,+1.0); 
            } 
            if (p9b<p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,3,0,+1.0); 
            } 
            else if (p10b<=p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,2,0,-1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (p8b>=p7b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p7b),3,1,2,0,+1.0); 
         in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        } 
        if (p7b>=p8b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p7b),1,3,2,0,-1.0); 
         in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_38(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=0L;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h11b=0L;h11b<z->noab();++h11b) { 
           for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
            if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h11b)) { 
             if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h11b))))))==z->irrep_t()) { 
              long p7b_0,p8b_0,p10b_0,h2b_0,h3b_0,h11b_0; 
              z->restricted_6(p7b,p8b,p10b,h2b,h3b,h11b,p7b_0,p8b_0,p10b_0,h2b_0,h3b_0,h11b_0); 
              long h9b_1,h11b_1,h4b_1,p10b_1; 
              z->restricted_4(h9b,h11b,h4b,p10b,h9b_1,h11b_1,h4b_1,p10b_1); 
              long dim_common=z->get_range(h11b)*z->get_range(p10b); 
              long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h9b)*z->get_range(h4b); 
              long dima1=dim_common*dima1_sort; 
              if (p8b<p10b && h3b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p8b<p10b && h2b<h11b && h11b<=h3b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p8b<p10b && h11b<=h2b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p7b<p10b && p10b<=p8b && h3b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p7b<p10b && p10b<=p8b && h2b<h11b && h11b<=h3b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p7b<p10b && p10b<=p8b && h11b<=h2b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p10b<=p7b && h3b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h11b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p10b<=p7b && h2b<h11b && h11b<=h3b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h11b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h11b),z->get_range(h3b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p10b<=p7b && h11b<=h2b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h2b),z->get_range(h3b),5,4,2,1,0,3,+1.0); 
              } 
              if (h9b<h11b) { 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),2,0,3,1,+1.0); 
              } 
              else if (h11b<=h9b) { 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h9b_1+z->noab()*(h11b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),z->get_range(p10b),2,1,3,0,-1.0); 
              } 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),1,5,4,3,2,0,+1.0); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),1,5,4,3,0,2,-1.0); 
           in[1]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),1,5,4,0,3,2,+1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_38_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h11b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,h11b,h4b,p10b,h9b_0,h11b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_38(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_39(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      if (p7b<p8b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p6b<p8b && p8b<=p7b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p8b<=p6b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab())))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h11b=0L;h11b<z->noab();++h11b) { 
           for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
            if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h11b)) { 
             if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h11b))))))==z->irrep_t()) { 
              long p6b_0,p7b_0,p10b_0,h3b_0,h4b_0,h11b_0; 
              z->restricted_6(p6b,p7b,p10b,h3b,h4b,h11b,p6b_0,p7b_0,p10b_0,h3b_0,h4b_0,h11b_0); 
              long h11b_1,p8b_1,p9b_1,p10b_1; 
              z->restricted_4(h11b,p8b,p9b,p10b,h11b_1,p8b_1,p9b_1,p10b_1); 
              long dim_common=z->get_range(h11b)*z->get_range(p10b); 
              long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(p8b)*z->get_range(p9b); 
              long dima1=dim_common*dima1_sort; 
              if (p7b<p10b && h4b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p7b<p10b && h3b<h11b && h11b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p7b<p10b && h11b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p6b<p10b && p10b<=p7b && h4b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p6b<p10b && p10b<=p7b && h3b<h11b && h11b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p6b<p10b && p10b<=p7b && h11b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p10b<=p6b && h4b<h11b) { 
               z->t3()->get_block(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p10b<=p6b && h3b<h11b && h11b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p10b<=p6b && h11b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),5,4,2,1,0,3,+1.0); 
              } 
              if (p9b<p10b) { 
               z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,3,0,+1.0); 
              } 
              else if (p10b<=p9b) { 
               z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,2,0,-1.0); 
              } 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p8b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(p7b),z->get_range(p6b),5,4,1,3,2,0,-1.0); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p7b>=p8b && p8b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(p7b),z->get_range(p6b),5,1,4,3,2,0,+1.0); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p6b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(h4b),z->get_range(h3b),z->get_range(p7b),z->get_range(p6b),1,5,4,3,2,0,-1.0); 
           in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_3_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==z->irrep_f()) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h9b_0,p10b_0; 
      z->restricted_2(h9b,p10b,h9b_0,p10b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h9b)*z->get_range(p10b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p10b_0+(z->nab())*(h9b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p10b),0,1,-1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_3(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  if (z->get_spin(h9b)==z->get_spin(p10b)) { 
   if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
     in[2]->input_offset(p10b-z->noab()+z->nvab()*(h9b),size); 
     size+=z->get_range(h9b)*z->get_range(p10b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_4(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b)))))))); 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_f())) { 
            long dimc=z->get_range(h9b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
             if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
              if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
               long p6b_0,p7b_0,p8b_0,p10b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
               z->restricted_8(p6b,p7b,p8b,p10b,h1b,h2b,h3b,h4b,p6b_0,p7b_0,p8b_0,p10b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
               long h9b_1,p10b_1; 
               z->restricted_2(h9b,p10b,h9b_1,p10b_1); 
               long dim_common=z->get_range(p10b); 
               long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b); 
               long dima1=dim_common*dima1_sort; 
               if (p8b<p10b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,0,3,+1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,0,2,-1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,0,1,+1.0); 
               } 
               else if (p10b<=p6b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,-1.0); 
               } 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h9b_1),k_a1); 
               z->sort_indices2(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            z->sort_indices8(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),0,7,6,5,4,3,2,1,+1.0); 
            in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h9b))))))),k_c); 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_40(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (p7b<p8b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
            if (z->get_spin(p7b)+z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
             if ((z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==z->irrep_t()) { 
              long p7b_0,p10b_0,p11b_0,h2b_0,h3b_0,h4b_0; 
              z->restricted_6(p7b,p10b,p11b,h2b,h3b,h4b,p7b_0,p10b_0,p11b_0,h2b_0,h3b_0,h4b_0); 
              long h9b_1,p8b_1,p10b_1,p11b_1; 
              z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
              long dim_common=z->get_range(p10b)*z->get_range(p11b); 
              long dima0_sort=z->get_range(p7b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h9b)*z->get_range(p8b); 
              long dima1=dim_common*dima1_sort; 
              if (p7b<p10b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p10b<=p7b && p7b<p11b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p11b<=p7b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p10b==p11b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p8b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),1,5,0,4,3,2,+0.5/0.5); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),1,0,5,4,3,2,-0.5/0.5); 
           in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_4_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==z->irrep_f()) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h9b_0,p10b_0; 
      z->restricted_2(h9b,p10b,h9b_0,p10b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h9b)*z->get_range(p10b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p10b_0+(z->nab())*(h9b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_4(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  if (z->get_spin(h9b)==z->get_spin(p10b)) { 
   if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
     in[2]->input_offset(p10b-z->noab()+z->nvab()*(h9b),size); 
     size+=z->get_range(h9b)*z->get_range(p10b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_5(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
          if ((z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
           long p8b_0,p10b_0,h3b_0,h4b_0; 
           z->restricted_4(p8b,p10b,h3b,h4b,p8b_0,p10b_0,h3b_0,h4b_0); 
           long h9b_1,p10b_1; 
           z->restricted_2(h9b,p10b,h9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b); 
           long dima1=dim_common*dima1_sort; 
           if (p8b<p10b) { 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
           } 
           else if (p10b<=p8b) { 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
           } 
           in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h9b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),0,3,2,1,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_5_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==z->irrep_f()) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h9b_0,p10b_0; 
      z->restricted_2(h9b,p10b,h9b_0,p10b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h9b)*z->get_range(p10b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p10b_0+(z->nab())*(h9b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_5(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  if (z->get_spin(h9b)==z->get_spin(p10b)) { 
   if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
     in[2]->input_offset(p10b-z->noab()+z->nvab()*(h9b),size); 
     size+=z->get_range(h9b)*z->get_range(p10b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_6(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_f())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==z->irrep_t()) { 
             long p7b_0,p8b_0,p10b_0,h2b_0,h3b_0,h4b_0; 
             z->restricted_6(p7b,p8b,p10b,h2b,h3b,h4b,p7b_0,p8b_0,p10b_0,h2b_0,h3b_0,h4b_0); 
             long h9b_1,p10b_1; 
             z->restricted_2(h9b,p10b,h9b_1,p10b_1); 
             long dim_common=z->get_range(p10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b); 
             long dima1=dim_common*dima1_sort; 
             if (p8b<p10b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,1,0,2,+1.0); 
             } 
             else if (p7b<p10b && p10b<=p8b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,0,1,-1.0); 
             } 
             else if (p10b<=p7b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
             } 
             in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h9b_1),k_a1); 
             z->sort_indices2(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),0,5,4,3,2,1,+1.0); 
          in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_64(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h4b=0L;h4b<z->noab();++h4b) { 
  long tileoffset; 
  tileoffset=(h4b+z->noab()*(h9b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h4b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^z->get_sym(h4b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(h4b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h12b=0L;h12b<z->noab();++h12b) { 
       for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
        for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h4b)+z->get_spin(h12b)) { 
          if ((z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h4b)^z->get_sym(h12b))))==z->irrep_t()) { 
           long p10b_0,p11b_0,h4b_0,h12b_0; 
           z->restricted_4(p10b,p11b,h4b,h12b,p10b_0,p11b_0,h4b_0,h12b_0); 
           long h9b_1,h12b_1,p10b_1,p11b_1; 
           z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
           long dim_common=z->get_range(h12b)*z->get_range(p10b)*z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b); 
           long dima1=dim_common*dima1_sort; 
           if (h4b<h12b) { 
            z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(h4b),z->get_range(h12b),2,1,0,3,+1.0); 
           } 
           else if (h12b<=h4b) { 
            z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(h12b),z->get_range(h4b),3,1,0,2,-1.0); 
           } 
           if (h9b<h12b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),0,3,2,1,+1.0); 
           } 
           else if (h12b<=h9b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),1,3,2,0,-1.0); 
           } 
           double factor=1.0; 
           if (p10b==p11b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),0,1,-0.5/0.5); 
      in[1]->add_block(h4b+z->noab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_65(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
          if (z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p11b_0,p12b_0,h3b_0,h4b_0; 
            z->restricted_4(p11b,p12b,h3b,h4b,p11b_0,p12b_0,h3b_0,h4b_0); 
            long h9b_1,h10b_1,p11b_1,p12b_1; 
            z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
            long dim_common=z->get_range(p11b)*z->get_range(p12b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p11b==p12b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_66(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
 for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
  long tileoffset; 
  tileoffset=(p9b-z->noab()+z->nvab()*(p8b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p8b)+z->get_spin(p9b)!=4L) { 
    if (z->get_spin(p8b)==z->get_spin(p9b)) { 
     if ((z->get_sym(p8b)^z->get_sym(p9b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p8b)*z->get_range(p9b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h11b=0L;h11b<z->noab();++h11b) { 
       for (long h12b=h11b;h12b<z->noab();++h12b) { 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h11b)+z->get_spin(h12b)) { 
          if ((z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h11b)^z->get_sym(h12b))))==z->irrep_t()) { 
           long p8b_0,p10b_0,h11b_0,h12b_0; 
           z->restricted_4(p8b,p10b,h11b,h12b,p8b_0,p10b_0,h11b_0,h12b_0); 
           long h11b_1,h12b_1,p9b_1,p10b_1; 
           z->restricted_4(h11b,h12b,p9b,p10b,h11b_1,h12b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(h11b)*z->get_range(h12b)*z->get_range(p10b); 
           long dima0_sort=z->get_range(p8b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           if (p8b<p10b) { 
            z->t2()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h12b),0,1,3,2,+1.0); 
           } 
           else if (p10b<=p8b) { 
            z->t2()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),1,0,3,2,-1.0); 
           } 
           if (p9b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),2,3,1,0,+1.0); 
           } 
           else if (p10b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p10b),z->get_range(p9b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           if (h11b==h12b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),1,0,-0.5/0.5); 
      in[1]->add_block(p9b-z->noab()+z->nvab()*(p8b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_67(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h10b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h12b=0L;h12b<z->noab();++h12b) { 
         for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
          if (z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h4b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h4b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p8b_0,p11b_0,h4b_0,h12b_0; 
            z->restricted_4(p8b,p11b,h4b,h12b,p8b_0,p11b_0,h4b_0,h12b_0); 
            long h10b_1,h12b_1,p9b_1,p11b_1; 
            z->restricted_4(h10b,h12b,p9b,p11b,h10b_1,h12b_1,p9b_1,p11b_1); 
            long dim_common=z->get_range(h12b)*z->get_range(p11b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h10b)*z->get_range(p9b); 
            long dima1=dim_common*dima1_sort; 
            if (p8b<p11b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h4b),z->get_range(h12b),2,0,1,3,+1.0); 
            } 
            else if (p8b<p11b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h4b),3,0,1,2,-1.0); 
            } 
            else if (p11b<=p8b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h4b),z->get_range(h12b),2,1,0,3,-1.0); 
            } 
            else if (p11b<=p8b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h4b),3,1,0,2,+1.0); 
            } 
            if (h10b<h12b && p9b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h12b),z->get_range(p9b),z->get_range(p11b),2,0,3,1,+1.0); 
            } 
            else if (h10b<h12b && p11b<=p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h12b),z->get_range(p11b),z->get_range(p9b),3,0,2,1,-1.0); 
            } 
            else if (h12b<=h10b && p9b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h10b),z->get_range(p9b),z->get_range(p11b),2,1,3,0,-1.0); 
            } 
            else if (h12b<=h10b && p11b<=p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h10b),z->get_range(p11b),z->get_range(p9b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p8b),1,3,2,0,+1.0); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_68(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h11b=0L;h11b<z->noab();++h11b) { 
           for (long h12b=h11b;h12b<z->noab();++h12b) { 
            for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
             if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h11b)+z->get_spin(h12b)) { 
              if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h11b)^z->get_sym(h12b))))))))==z->irrep_t()) { 
               long p6b_0,p7b_0,p8b_0,p10b_0,h3b_0,h4b_0,h11b_0,h12b_0; 
               z->restricted_8(p6b,p7b,p8b,p10b,h3b,h4b,h11b,h12b,p6b_0,p7b_0,p8b_0,p10b_0,h3b_0,h4b_0,h11b_0,h12b_0); 
               long h11b_1,h12b_1,p9b_1,p10b_1; 
               z->restricted_4(h11b,h12b,p9b,p10b,h11b_1,h12b_1,p9b_1,p10b_1); 
               long dim_common=z->get_range(h11b)*z->get_range(h12b)*z->get_range(p10b); 
               long dima0_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p9b); 
               long dima1=dim_common*dima1_sort; 
               if (p8b<p10b && h4b<h11b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),5,4,2,1,0,3,7,6,+1.0); 
               } 
               else if (p8b<p10b && h3b<h11b && h11b<=h4b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),6,4,2,1,0,3,7,5,-1.0); 
               } 
               else if (p8b<p10b && h3b<h11b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h3b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),7,4,2,1,0,3,6,5,+1.0); 
               } 
               else if (p8b<p10b && h11b<=h3b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,2,1,0,3,7,4,+1.0); 
               } 
               else if (p8b<p10b && h11b<=h3b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,2,1,0,3,6,4,-1.0); 
               } 
               else if (p8b<p10b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,2,1,0,3,5,4,+1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h4b<h11b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),5,4,3,1,0,2,7,6,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h3b<h11b && h11b<=h4b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),6,4,3,1,0,2,7,5,+1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h3b<h11b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),7,4,3,1,0,2,6,5,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h11b<=h3b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,3,1,0,2,7,4,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h11b<=h3b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,3,1,0,2,6,4,+1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,3,1,0,2,5,4,-1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h4b<h11b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),5,4,3,2,0,1,7,6,+1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h3b<h11b && h11b<=h4b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),6,4,3,2,0,1,7,5,-1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h3b<h11b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),7,4,3,2,0,1,6,5,+1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h11b<=h3b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,3,2,0,1,7,4,+1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h11b<=h3b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,3,2,0,1,6,4,-1.0); 
               } 
               else if (p6b<p10b && p10b<=p7b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,3,2,0,1,5,4,+1.0); 
               } 
               else if (p10b<=p6b && h4b<h11b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),5,4,3,2,1,0,7,6,-1.0); 
               } 
               else if (p10b<=p6b && h3b<h11b && h11b<=h4b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),6,4,3,2,1,0,7,5,+1.0); 
               } 
               else if (p10b<=p6b && h3b<h11b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),7,4,3,2,1,0,6,5,-1.0); 
               } 
               else if (p10b<=p6b && h11b<=h3b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,3,2,1,0,7,4,-1.0); 
               } 
               else if (p10b<=p6b && h11b<=h3b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,3,2,1,0,6,4,+1.0); 
               } 
               else if (p10b<=p6b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,3,2,1,0,5,4,-1.0); 
               } 
               if (p9b<p10b) { 
                z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),2,3,1,0,+1.0); 
               } 
               else if (p10b<=p9b) { 
                z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p10b),z->get_range(p9b),3,2,1,0,-1.0); 
               } 
               double factor=1.0; 
               if (h11b==h12b) { 
                factor=factor/2.0; 
               } 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),5,4,3,2,1,0,-0.5/0.5); 
          in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_69(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        if (in[1]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
             for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
              if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
               if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
                long p7b_0,p8b_0,p11b_0,p12b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
                z->restricted_8(p7b,p8b,p11b,p12b,h1b,h2b,h3b,h4b,p7b_0,p8b_0,p11b_0,p12b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
                long h9b_1,h10b_1,p11b_1,p12b_1; 
                z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
                long dim_common=z->get_range(p11b)*z->get_range(p12b); 
                long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
                long dima1=dim_common*dima1_sort; 
                if (p8b<p11b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,1,0,3,2,+1.0); 
                } 
                else if (p7b<p11b && p11b<=p8b && p8b<p12b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,0,3,1,-1.0); 
                } 
                else if (p7b<p11b && p12b<=p8b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p12b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,0,2,1,+1.0); 
                } 
                else if (p11b<=p7b && p8b<p12b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,3,0,+1.0); 
                } 
                else if (p11b<=p7b && p7b<p12b && p12b<=p8b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p12b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,2,0,-1.0); 
                } 
                else if (p12b<=p7b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
                } 
                z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
                double factor=1.0; 
                if (p11b==p12b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            z->sort_indices8(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),1,0,7,6,5,4,3,2,+0.5/0.5); 
            in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_6_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==z->irrep_f()) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h9b_0,p10b_0; 
      z->restricted_2(h9b,p10b,h9b_0,p10b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h9b)*z->get_range(p10b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p10b_0+(z->nab())*(h9b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p10b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p10b),0,1,-1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_6(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  if (z->get_spin(h9b)==z->get_spin(p10b)) { 
   if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
     in[2]->input_offset(p10b-z->noab()+z->nvab()*(h9b),size); 
     size+=z->get_range(h9b)*z->get_range(p10b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_70(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h12b=0L;h12b<z->noab();++h12b) { 
           for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
            for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
             if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h12b)) { 
              if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h2b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h12b))))))))==z->irrep_t()) { 
               long p7b_0,p8b_0,p10b_0,p11b_0,h2b_0,h3b_0,h4b_0,h12b_0; 
               z->restricted_8(p7b,p8b,p10b,p11b,h2b,h3b,h4b,h12b,p7b_0,p8b_0,p10b_0,p11b_0,h2b_0,h3b_0,h4b_0,h12b_0); 
               long h9b_1,h12b_1,p10b_1,p11b_1; 
               z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
               long dim_common=z->get_range(h12b)*z->get_range(p10b)*z->get_range(p11b); 
               long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b); 
               long dima1=dim_common*dima1_sort; 
               if (p8b<p10b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,1,0,3,2,7,+1.0); 
               } 
               else if (p8b<p10b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,1,0,3,2,6,-1.0); 
               } 
               else if (p8b<p10b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,1,0,3,2,5,+1.0); 
               } 
               else if (p8b<p10b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,1,0,3,2,4,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && p8b<p11b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,2,0,3,1,7,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && p8b<p11b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,2,0,3,1,6,+1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && p8b<p11b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,2,0,3,1,5,-1.0); 
               } 
               else if (p7b<p10b && p10b<=p8b && p8b<p11b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,2,0,3,1,4,+1.0); 
               } 
               else if (p7b<p10b && p11b<=p8b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,3,0,2,1,7,+1.0); 
               } 
               else if (p7b<p10b && p11b<=p8b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,3,0,2,1,6,-1.0); 
               } 
               else if (p7b<p10b && p11b<=p8b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,3,0,2,1,5,+1.0); 
               } 
               else if (p7b<p10b && p11b<=p8b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,3,0,2,1,4,-1.0); 
               } 
               else if (p10b<=p7b && p8b<p11b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,2,1,3,0,7,+1.0); 
               } 
               else if (p10b<=p7b && p8b<p11b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,2,1,3,0,6,-1.0); 
               } 
               else if (p10b<=p7b && p8b<p11b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,2,1,3,0,5,+1.0); 
               } 
               else if (p10b<=p7b && p8b<p11b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,2,1,3,0,4,-1.0); 
               } 
               else if (p10b<=p7b && p7b<p11b && p11b<=p8b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,3,1,2,0,7,-1.0); 
               } 
               else if (p10b<=p7b && p7b<p11b && p11b<=p8b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,3,1,2,0,6,+1.0); 
               } 
               else if (p10b<=p7b && p7b<p11b && p11b<=p8b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,3,1,2,0,5,-1.0); 
               } 
               else if (p10b<=p7b && p7b<p11b && p11b<=p8b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,3,1,2,0,4,+1.0); 
               } 
               else if (p11b<=p7b && h4b<h12b) { 
                z->t4()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),6,5,4,3,2,1,0,7,+1.0); 
               } 
               else if (p11b<=p7b && h3b<h12b && h12b<=h4b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),7,5,4,3,2,1,0,6,-1.0); 
               } 
               else if (p11b<=p7b && h2b<h12b && h12b<=h3b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),7,6,4,3,2,1,0,5,+1.0); 
               } 
               else if (p11b<=p7b && h12b<=h2b) { 
                z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,3,2,1,0,4,-1.0); 
               } 
               if (h9b<h12b) { 
                z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),0,3,2,1,+1.0); 
               } 
               else if (h12b<=h9b) { 
                z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),1,3,2,0,-1.0); 
               } 
               double factor=1.0; 
               if (p10b==p11b) { 
                factor=factor/2.0; 
               } 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),0,5,4,3,2,1,-0.5/0.5); 
          in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_71(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h12b=0L;h12b<z->noab();++h12b) { 
           for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
            if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h12b)) { 
             if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h12b))))))==z->irrep_t()) { 
              long p7b_0,p8b_0,p11b_0,h3b_0,h4b_0,h12b_0; 
              z->restricted_6(p7b,p8b,p11b,h3b,h4b,h12b,p7b_0,p8b_0,p11b_0,h3b_0,h4b_0,h12b_0); 
              long h10b_1,h12b_1,p9b_1,p11b_1; 
              z->restricted_4(h10b,h12b,p9b,p11b,h10b_1,h12b_1,p9b_1,p11b_1); 
              long dim_common=z->get_range(h12b)*z->get_range(p11b); 
              long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h10b)*z->get_range(p9b); 
              long dima1=dim_common*dima1_sort; 
              if (p8b<p11b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p8b<p11b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p8b<p11b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p11b<=p7b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p11b<=p7b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p11b<=p7b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,2,1,0,3,+1.0); 
              } 
              if (h10b<h12b && p9b<p11b) { 
               z->v2()->get_block(p11b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h10b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h12b),z->get_range(p9b),z->get_range(p11b),2,0,3,1,+1.0); 
              } 
              else if (h10b<h12b && p11b<=p9b) { 
               z->v2()->get_block(p9b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h10b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h12b),z->get_range(p11b),z->get_range(p9b),3,0,2,1,-1.0); 
              } 
              else if (h12b<=h10b && p9b<p11b) { 
               z->v2()->get_block(p11b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h12b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h10b),z->get_range(p9b),z->get_range(p11b),2,1,3,0,-1.0); 
              } 
              else if (h12b<=h10b && p11b<=p9b) { 
               z->v2()->get_block(p9b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h12b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h10b),z->get_range(p11b),z->get_range(p9b),3,1,2,0,+1.0); 
              } 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(h10b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),1,5,4,3,2,0,+0.5); 
          in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_72(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long h12b=h11b;h12b<z->noab();++h12b) { 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p10b)==z->get_spin(h4b)+z->get_spin(h11b)+z->get_spin(h12b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(h4b)^(z->get_sym(h11b)^z->get_sym(h12b))))))==z->irrep_t()) { 
             long p7b_0,p8b_0,p10b_0,h4b_0,h11b_0,h12b_0; 
             z->restricted_6(p7b,p8b,p10b,h4b,h11b,h12b,p7b_0,p8b_0,p10b_0,h4b_0,h11b_0,h12b_0); 
             long h11b_1,h12b_1,p9b_1,p10b_1; 
             z->restricted_4(h11b,h12b,p9b,p10b,h11b_1,h12b_1,p9b_1,p10b_1); 
             long dim_common=z->get_range(h11b)*z->get_range(h12b)*z->get_range(p10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p9b); 
             long dima1=dim_common*dima1_sort; 
             if (p8b<p10b && h4b<h11b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),3,1,0,2,5,4,+1.0); 
             } 
             else if (p8b<p10b && h11b<=h4b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),4,1,0,2,5,3,-1.0); 
             } 
             else if (p8b<p10b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),5,1,0,2,4,3,+1.0); 
             } 
             else if (p7b<p10b && p10b<=p8b && h4b<h11b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),3,2,0,1,5,4,-1.0); 
             } 
             else if (p7b<p10b && p10b<=p8b && h11b<=h4b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),4,2,0,1,5,3,+1.0); 
             } 
             else if (p7b<p10b && p10b<=p8b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),5,2,0,1,4,3,-1.0); 
             } 
             else if (p10b<=p7b && h4b<h11b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h4b),z->get_range(h11b),z->get_range(h12b),3,2,1,0,5,4,+1.0); 
             } 
             else if (p10b<=p7b && h11b<=h4b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h4b),z->get_range(h12b),4,2,1,0,5,3,-1.0); 
             } 
             else if (p10b<=p7b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),z->get_range(h4b),5,2,1,0,4,3,+1.0); 
             } 
             if (p9b<p10b) { 
              z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),2,3,1,0,+1.0); 
             } 
             else if (p10b<=p9b) { 
              z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p10b),z->get_range(p9b),3,2,1,0,-1.0); 
             } 
             double factor=1.0; 
             if (h11b==h12b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h4b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,+0.5/0.5); 
        in[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_73(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
           for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
            if (z->get_spin(p8b)+z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
             if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==z->irrep_t()) { 
              long p8b_0,p11b_0,p12b_0,h2b_0,h3b_0,h4b_0; 
              z->restricted_6(p8b,p11b,p12b,h2b,h3b,h4b,p8b_0,p11b_0,p12b_0,h2b_0,h3b_0,h4b_0); 
              long h9b_1,h10b_1,p11b_1,p12b_1; 
              z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
              long dim_common=z->get_range(p11b)*z->get_range(p12b); 
              long dima0_sort=z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
              long dima1=dim_common*dima1_sort; 
              if (p8b<p11b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(p12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p11b<=p8b && p8b<p12b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(p12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p12b<=p8b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p11b==p12b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),1,0,5,4,3,2,+0.5/0.5); 
          in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_74(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h12b=0L;h12b<z->noab();++h12b) { 
         for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
          for (long p11b=p10b;p11b<z->noab()+z->nvab();++p11b) { 
           if (z->get_spin(p8b)+z->get_spin(p10b)+z->get_spin(p11b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h12b)) { 
            if ((z->get_sym(p8b)^(z->get_sym(p10b)^(z->get_sym(p11b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h12b))))))==z->irrep_t()) { 
             long p8b_0,p10b_0,p11b_0,h3b_0,h4b_0,h12b_0; 
             z->restricted_6(p8b,p10b,p11b,h3b,h4b,h12b,p8b_0,p10b_0,p11b_0,h3b_0,h4b_0,h12b_0); 
             long h9b_1,h12b_1,p10b_1,p11b_1; 
             z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
             long dim_common=z->get_range(h12b)*z->get_range(p10b)*z->get_range(p11b); 
             long dima0_sort=z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b); 
             long dima1=dim_common*dima1_sort; 
             if (p8b<p10b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,0,2,1,5,+1.0); 
             } 
             else if (p8b<p10b && h3b<h12b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,0,2,1,4,-1.0); 
             } 
             else if (p8b<p10b && h12b<=h3b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,0,2,1,3,+1.0); 
             } 
             else if (p10b<=p8b && p8b<p11b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,1,2,0,5,-1.0); 
             } 
             else if (p10b<=p8b && p8b<p11b && h3b<h12b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,1,2,0,4,+1.0); 
             } 
             else if (p10b<=p8b && p8b<p11b && h12b<=h3b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,1,2,0,3,-1.0); 
             } 
             else if (p11b<=p8b && h4b<h12b) { 
              z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,2,1,0,5,+1.0); 
             } 
             else if (p11b<=p8b && h3b<h12b && h12b<=h4b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,2,1,0,4,-1.0); 
             } 
             else if (p11b<=p8b && h12b<=h3b) { 
              z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,2,1,0,3,+1.0); 
             } 
             if (h9b<h12b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),0,3,2,1,+1.0); 
             } 
             else if (h12b<=h9b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),1,3,2,0,-1.0); 
             } 
             double factor=1.0; 
             if (p10b==p11b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),0,3,2,1,+0.5/0.5); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_9(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         if (z->get_spin(p8b)==z->get_spin(h10b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h10b))==z->irrep_t()) { 
           long p8b_0,h10b_0; 
           z->restricted_2(p8b,h10b,p8b_0,h10b_0); 
           long h9b_1,h10b_1,h3b_1,h4b_1; 
           z->restricted_4(h9b,h10b,h3b,h4b,h9b_1,h10b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h10b); 
           long dima0_sort=z->get_range(p8b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h3b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h10b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h10b),0,1,+1.0); 
           if (h9b<h10b) { 
            in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
           } 
           else if (h10b<=h9b) { 
            in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(p8b),2,3,1,0,+1.0); 
        in[1]->add_block(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_1_9_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h3b_0,h4b_0; 
        z->restricted_4(h9b,h10b,h3b,h4b,h9b_0,h10b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_1_9(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_19(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p11b_0,h3b_0; 
           z->restricted_2(p11b,h3b,p11b_0,h3b_0); 
           long h9b_1,h10b_1,h4b_1,p11b_1; 
           z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h3b),1,0,+1.0); 
           in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_19_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,-1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_2_19(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_20(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p11b_0,h4b_0; 
           z->restricted_2(p11b,h4b,p11b_0,h4b_0); 
           long h9b_1,p8b_1,p10b_1,p11b_1; 
           z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),2,1,0,3,+1.0); 
           } 
           else if (p11b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p11b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_21(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=0L;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (h3b<h4b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (h2b<h4b && h4b<=h3b) { 
         tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (h1b<h4b && h4b<=h2b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (h4b<=h1b) { 
         tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        if (in[2]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
             if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
              if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
               long p7b_0,p8b_0,p11b_0,h1b_0,h2b_0,h3b_0; 
               z->restricted_6(p7b,p8b,p11b,h1b,h2b,h3b,p7b_0,p8b_0,p11b_0,h1b_0,h2b_0,h3b_0); 
               long h9b_1,h10b_1,h4b_1,p11b_1; 
               z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
               long dim_common=z->get_range(p11b); 
               long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p8b<p11b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,0,2,+1.0); 
               } 
               else if (p7b<p11b && p11b<=p8b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,-1.0); 
               } 
               else if (p11b<=p7b) { 
                z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
                z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
               } 
               in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (h4b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),2,1,7,6,5,4,3,0,+1.0); 
             in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (h3b>=h4b && h4b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),2,1,7,6,5,4,0,3,-1.0); 
             in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (h2b>=h4b && h4b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),2,1,7,6,5,0,4,3,+1.0); 
             in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),2,1,7,6,0,5,4,3,-1.0); 
             in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_21_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,-1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_2_21(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_22(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p11b_0,h4b_0; 
           z->restricted_2(p11b,h4b,p11b_0,h4b_0); 
           long h9b_1,p8b_1,p10b_1,p11b_1; 
           z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),2,1,0,3,+1.0); 
           } 
           else if (p11b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p11b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_29(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=0L;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      } 
      else if (h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      } 
      else if (h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      } 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
           if (z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
            if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
             long p8b_0,p11b_0,h2b_0,h3b_0; 
             z->restricted_4(p8b,p11b,h2b,h3b,p8b_0,p11b_0,h2b_0,h3b_0); 
             long h9b_1,h10b_1,h4b_1,p11b_1; 
             z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
             long dim_common=z->get_range(p11b); 
             long dima0_sort=z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             if (p8b<p11b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
             } 
             else if (p11b<=p8b) { 
              z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
             } 
             in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),2,1,5,4,3,0,+1.0); 
           in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
          } 
          if (h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),2,1,5,4,0,3,-1.0); 
           in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
          } 
          if (h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),2,1,5,0,4,3,+1.0); 
           in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_29_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,-1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_2_29(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_30(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
      long tileoffset; 
      if (p7b<p8b) { 
       tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b) { 
       tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p10b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p10b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
           if (z->get_spin(p7b)+z->get_spin(p11b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p11b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
             long p7b_0,p11b_0,h3b_0,h4b_0; 
             z->restricted_4(p7b,p11b,h3b,h4b,p7b_0,p11b_0,h3b_0,h4b_0); 
             long h9b_1,p8b_1,p10b_1,p11b_1; 
             z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
             long dim_common=z->get_range(p11b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(p10b); 
             long dima1=dim_common*dima1_sort; 
             if (p7b<p11b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
             } 
             else if (p11b<=p7b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
             } 
             if (p10b<p11b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),2,1,0,3,+1.0); 
             } 
             else if (p11b<=p10b) { 
              z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p11b),z->get_range(p10b),3,1,0,2,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p8b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p7b),2,5,1,4,3,0,+0.5); 
           in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p7b),2,1,5,4,3,0,-0.5); 
           in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_31(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p11b_0,h3b_0; 
           z->restricted_2(p11b,h3b,p11b_0,h3b_0); 
           long h9b_1,h10b_1,h4b_1,p11b_1; 
           z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h3b),1,0,+1.0); 
           in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_31_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_2_31(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_32(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p11b_0,h4b_0; 
           z->restricted_2(p11b,h4b,p11b_0,h4b_0); 
           long h9b_1,p8b_1,p10b_1,p11b_1; 
           z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),2,1,0,3,+1.0); 
           } 
           else if (p11b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p11b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_43(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h12b=0L;h12b<z->noab();++h12b) { 
       for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
        if (z->get_spin(p11b)==z->get_spin(h12b)) { 
         if ((z->get_sym(p11b)^z->get_sym(h12b))==z->irrep_t()) { 
          long p11b_0,h12b_0; 
          z->restricted_2(p11b,h12b,p11b_0,h12b_0); 
          long h9b_1,h12b_1,p10b_1,p11b_1; 
          z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
          long dim_common=z->get_range(h12b)*z->get_range(p11b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h12b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h12b),0,1,+1.0); 
          if (h9b<h12b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
          } 
          else if (h9b<h12b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
          } 
          else if (h12b<=h9b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
          } 
          else if (h12b<=h9b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),1,0,-1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_44(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p11b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+0.5); 
        in[2]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_45(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h12b=0L;h12b<z->noab();++h12b) { 
       for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
        if (z->get_spin(p11b)==z->get_spin(h12b)) { 
         if ((z->get_sym(p11b)^z->get_sym(h12b))==z->irrep_t()) { 
          long p11b_0,h12b_0; 
          z->restricted_2(p11b,h12b,p11b_0,h12b_0); 
          long h9b_1,h12b_1,p10b_1,p11b_1; 
          z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
          long dim_common=z->get_range(h12b)*z->get_range(p11b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h12b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h12b),0,1,+1.0); 
          if (h9b<h12b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
          } 
          else if (h9b<h12b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
          } 
          else if (h12b<=h9b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
          } 
          else if (h12b<=h9b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),1,0,+1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_46(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h11b_1,p10b_1,p12b_1; 
           z->restricted_4(h9b,h11b,p10b,p12b,h9b_1,h11b_1,p10b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p10b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p10b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p12b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_47(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=h2b;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        if (in[2]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^z->irrep_v())) { 
            long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
             for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
              if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
               if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==z->irrep_t()) { 
                long p7b_0,p8b_0,p11b_0,p12b_0,h1b_0,h2b_0,h3b_0,h4b_0; 
                z->restricted_8(p7b,p8b,p11b,p12b,h1b,h2b,h3b,h4b,p7b_0,p8b_0,p11b_0,p12b_0,h1b_0,h2b_0,h3b_0,h4b_0); 
                long h9b_1,h10b_1,p11b_1,p12b_1; 
                z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
                long dim_common=z->get_range(p11b)*z->get_range(p12b); 
                long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
                long dima0=dim_common*dima0_sort; 
                long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
                long dima1=dim_common*dima1_sort; 
                if (p8b<p11b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,1,0,3,2,+1.0); 
                } 
                else if (p7b<p11b && p11b<=p8b && p8b<p12b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,0,3,1,-1.0); 
                } 
                else if (p7b<p11b && p12b<=p8b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p12b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,0,2,1,+1.0); 
                } 
                else if (p11b<=p7b && p8b<p12b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(p12b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,2,1,3,0,+1.0); 
                } 
                else if (p11b<=p7b && p7b<p12b && p12b<=p8b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p12b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,1,2,0,-1.0); 
                } 
                else if (p12b<=p7b) { 
                 z->t4()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))))),k_a0); 
                 z->sort_indices8(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),7,6,5,4,3,2,1,0,+1.0); 
                } 
                z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
                double factor=1.0; 
                if (p11b==p12b) { 
                 factor=factor/2.0; 
                } 
                z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
               } 
              } 
             } 
            } 
            z->sort_indices8(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p8b),z->get_range(p7b),1,0,7,6,5,4,3,2,+0.5/0.5); 
            in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_48(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h12b=0L;h12b<z->noab();++h12b) { 
       for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
        if (z->get_spin(p11b)==z->get_spin(h12b)) { 
         if ((z->get_sym(p11b)^z->get_sym(h12b))==z->irrep_t()) { 
          long p11b_0,h12b_0; 
          z->restricted_2(p11b,h12b,p11b_0,h12b_0); 
          long h9b_1,h12b_1,p10b_1,p11b_1; 
          z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
          long dim_common=z->get_range(h12b)*z->get_range(p11b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h12b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h12b),0,1,+1.0); 
          if (h9b<h12b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
          } 
          else if (h9b<h12b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
          } 
          else if (h12b<=h9b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
          } 
          else if (h12b<=h9b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),1,0,+1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_49(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h11b_1,p10b_1,p12b_1; 
           z->restricted_4(h9b,h11b,p10b,p12b,h9b_1,h11b_1,p10b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p10b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p10b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p12b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_50(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
          if (z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p11b_0,p12b_0,h3b_0,h4b_0; 
            z->restricted_4(p11b,p12b,h3b,h4b,p11b_0,p12b_0,h3b_0,h4b_0); 
            long h9b_1,h10b_1,p11b_1,p12b_1; 
            z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
            long dim_common=z->get_range(p11b)*z->get_range(p12b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p11b==p12b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_51(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h10b_1,h11b_1,p9b_1,p12b_1; 
           z->restricted_4(h10b,h11b,p9b,p12b,h10b_1,h11b_1,p9b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h10b)*z->get_range(h11b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p9b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p9b_1+(z->nab())*(h11b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(p9b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(p12b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h11b),z->get_range(h10b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_52(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
  long tileoffset; 
  tileoffset=(p10b-z->noab()+z->nvab()*(h9b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p10b)!=4L) { 
    if (z->get_spin(h9b)==z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^z->get_sym(p10b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h9b)*z->get_range(p10b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h12b=0L;h12b<z->noab();++h12b) { 
       for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
        if (z->get_spin(p11b)==z->get_spin(h12b)) { 
         if ((z->get_sym(p11b)^z->get_sym(h12b))==z->irrep_t()) { 
          long p11b_0,h12b_0; 
          z->restricted_2(p11b,h12b,p11b_0,h12b_0); 
          long h9b_1,h12b_1,p10b_1,p11b_1; 
          z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
          long dim_common=z->get_range(h12b)*z->get_range(p11b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h12b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h12b),0,1,+1.0); 
          if (h9b<h12b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
          } 
          else if (h9b<h12b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
          } 
          else if (h12b<=h9b && p10b<p11b) { 
           z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
          } 
          else if (h12b<=h9b && p11b<=p10b) { 
           z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),1,0,-1.0); 
      in[2]->add_block(p10b-z->noab()+z->nvab()*(h9b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_53(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h10b=0L;h10b<z->noab();++h10b) { 
 for (long h11b=h10b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h10b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h10b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h10b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h10b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h10b_1,h11b_1,p9b_1,p12b_1; 
           z->restricted_4(h10b,h11b,p9b,p12b,h10b_1,h11b_1,p9b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h10b)*z->get_range(h11b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p9b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p9b_1+(z->nab())*(h11b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(p9b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h11b),z->get_range(p12b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h11b),z->get_range(h10b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h10b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_54(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h12b=0L;h12b<z->noab();++h12b) { 
         for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
          if (z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h4b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h4b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p8b_0,p11b_0,h4b_0,h12b_0; 
            z->restricted_4(p8b,p11b,h4b,h12b,p8b_0,p11b_0,h4b_0,h12b_0); 
            long h9b_1,h12b_1,p10b_1,p11b_1; 
            z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
            long dim_common=z->get_range(h12b)*z->get_range(p11b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
            long dima1=dim_common*dima1_sort; 
            if (p8b<p11b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h4b),z->get_range(h12b),2,0,1,3,+1.0); 
            } 
            else if (p8b<p11b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h4b),3,0,1,2,-1.0); 
            } 
            else if (p11b<=p8b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h4b),z->get_range(h12b),2,1,0,3,-1.0); 
            } 
            else if (p11b<=p8b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h4b),3,1,0,2,+1.0); 
            } 
            if (h9b<h12b && p10b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
            } 
            else if (h9b<h12b && p11b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
            } 
            else if (h12b<=h9b && p10b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
            } 
            else if (h12b<=h9b && p11b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),z->get_range(h4b),z->get_range(p8b),1,3,2,0,-1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_55(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h11b_1,p10b_1,p12b_1; 
           z->restricted_4(h9b,h11b,p10b,p12b,h9b_1,h11b_1,p10b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p10b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p10b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p10b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p12b),z->get_range(p10b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_56(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
      long tileoffset; 
      tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p10b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p10b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p10b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h12b=0L;h12b<z->noab();++h12b) { 
           for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
            if (z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(h12b)) { 
             if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(h12b))))))==z->irrep_t()) { 
              long p7b_0,p8b_0,p11b_0,h3b_0,h4b_0,h12b_0; 
              z->restricted_6(p7b,p8b,p11b,h3b,h4b,h12b,p7b_0,p8b_0,p11b_0,h3b_0,h4b_0,h12b_0); 
              long h9b_1,h12b_1,p10b_1,p11b_1; 
              z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
              long dim_common=z->get_range(h12b)*z->get_range(p11b); 
              long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
              long dima1=dim_common*dima1_sort; 
              if (p8b<p11b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p8b<p11b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p8b<p11b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p7b<p11b && p11b<=p8b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p11b<=p7b && h4b<h12b) { 
               z->t3()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(h12b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p11b<=p7b && h3b<h12b && h12b<=h4b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h12b),z->get_range(h4b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p11b<=p7b && h12b<=h3b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(p8b),z->get_range(h12b),z->get_range(h3b),z->get_range(h4b),5,4,2,1,0,3,+1.0); 
              } 
              if (h9b<h12b && p10b<p11b) { 
               z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
              } 
              else if (h9b<h12b && p11b<=p10b) { 
               z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
              } 
              else if (h12b<=h9b && p10b<p11b) { 
               z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
              } 
              else if (h12b<=h9b && p11b<=p10b) { 
               z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
              } 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),1,5,4,3,2,0,+1.0); 
          in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_57(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
           for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
            if (z->get_spin(p8b)+z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
             if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==z->irrep_t()) { 
              long p8b_0,p11b_0,p12b_0,h2b_0,h3b_0,h4b_0; 
              z->restricted_6(p8b,p11b,p12b,h2b,h3b,h4b,p8b_0,p11b_0,p12b_0,h2b_0,h3b_0,h4b_0); 
              long h9b_1,h10b_1,p11b_1,p12b_1; 
              z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
              long dim_common=z->get_range(p11b)*z->get_range(p12b); 
              long dima0_sort=z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
              long dima1=dim_common*dima1_sort; 
              if (p8b<p11b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(p12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p11b<=p8b && p8b<p12b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(p12b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p12b<=p8b) { 
               z->t3()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p11b==p12b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),1,0,5,4,3,2,+0.5/0.5); 
          in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_58(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    for (long h1b=0L;h1b<z->noab();++h1b) { 
     for (long h2b=h1b;h2b<z->noab();++h2b) { 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        long tileoffset; 
        if (p7b<p8b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p7b<p8b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h2b<h3b) { 
         tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h1b<h3b && h3b<=h2b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h1b<h3b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h3b<=h1b && h2b<h4b) { 
         tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h3b<=h1b && h1b<h4b && h4b<=h2b) { 
         tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        else if (p8b<=p7b && h4b<=h1b) { 
         tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))))); 
        } 
        if (in[2]->is_this_local(tileoffset)) { 
         if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
          if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
            long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
            std::fill(k_c_sort,k_c_sort+dimc,0.0); 
            for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
             if (z->get_spin(p7b)+z->get_spin(p11b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
              if ((z->get_sym(p7b)^(z->get_sym(p11b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
               long p7b_0,p11b_0,h1b_0,h2b_0; 
               z->restricted_4(p7b,p11b,h1b,h2b,p7b_0,p11b_0,h1b_0,h2b_0); 
               long h9b_1,h10b_1,p8b_1,h3b_1,h4b_1,p11b_1; 
               z->restricted_6(h9b,h10b,p8b,h3b,h4b,p11b,h9b_1,h10b_1,p8b_1,h3b_1,h4b_1,p11b_1); 
               long dim_common=z->get_range(p11b); 
               long dima0_sort=z->get_range(p7b)*z->get_range(h1b)*z->get_range(h2b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
               long dima1=dim_common*dima1_sort; 
               if (p7b<p11b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p11b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
               } 
               else if (p11b<=p7b) { 
                z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
                z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
               } 
               in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h10b_1+z->noab()*(h9b_1))))),k_a1); 
               z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(p11b),4,3,2,1,0,5,+1.0); 
               double factor=1.0; 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
            if (p8b>=p7b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,6,5,1,0,+1.0); 
             in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,6,1,5,0,-1.0); 
             in[2]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,1,6,5,0,+1.0); 
             in[2]->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,6,1,0,5,+1.0); 
             in[2]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,1,6,0,5,-1.0); 
             in[2]->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p8b>=p7b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,7,2,1,0,6,5,+1.0); 
             in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h3b>=h2b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,6,5,1,0,-1.0); 
             in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,6,1,5,0,+1.0); 
             in[2]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h4b>=h2b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,1,6,5,0,-1.0); 
             in[2]->add_block(h4b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h2b>=h4b && h3b>=h1b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,6,1,0,5,-1.0); 
             in[2]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,1,6,0,5,+1.0); 
             in[2]->add_block(h2b+z->noab()*(h4b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
            if (p7b>=p8b && h1b>=h4b) { 
             z->sort_indices8(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(h10b),z->get_range(h9b),z->get_range(h2b),z->get_range(h1b),z->get_range(p7b),4,3,2,7,1,0,6,5,-1.0); 
             in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))))),k_c); 
            } 
           } 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::offset_smith_2_58(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p11b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p11b)!=12L) { 
         in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p11b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_61(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long h12b=h11b;h12b<z->noab();++h12b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h11b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h11b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h11b_0,h12b_0; 
            z->restricted_4(p7b,p8b,h11b,h12b,p7b_0,p8b_0,h11b_0,h12b_0); 
            long h11b_1,h12b_1,p9b_1,p10b_1; 
            z->restricted_4(h11b,h12b,p9b,p10b,h11b_1,h12b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(h11b)*z->get_range(h12b); 
            long dima0_sort=z->get_range(p7b)*z->get_range(p8b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p9b)*z->get_range(p10b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),1,0,3,2,+1.0); 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),3,2,1,0,+1.0); 
            double factor=1.0; 
            if (h11b==h12b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,-0.5/0.5); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_62(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h12b=0L;h12b<z->noab();++h12b) { 
         for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
          if (z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h4b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h4b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p8b_0,p11b_0,h4b_0,h12b_0; 
            z->restricted_4(p8b,p11b,h4b,h12b,p8b_0,p11b_0,h4b_0,h12b_0); 
            long h9b_1,h12b_1,p10b_1,p11b_1; 
            z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
            long dim_common=z->get_range(h12b)*z->get_range(p11b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
            long dima1=dim_common*dima1_sort; 
            if (p8b<p11b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h4b),z->get_range(h12b),2,0,1,3,+1.0); 
            } 
            else if (p8b<p11b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h4b),3,0,1,2,-1.0); 
            } 
            else if (p11b<=p8b && h4b<h12b) { 
             z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h4b),z->get_range(h12b),2,1,0,3,-1.0); 
            } 
            else if (p11b<=p8b && h12b<=h4b) { 
             z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h4b),3,1,0,2,+1.0); 
            } 
            if (h9b<h12b && p10b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
            } 
            else if (h9b<h12b && p11b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
            } 
            else if (h12b<=h9b && p10b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
            } 
            else if (h12b<=h9b && p11b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),z->get_range(h4b),z->get_range(p8b),1,3,2,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_2_63(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
          if (z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p11b_0,p12b_0,h3b_0,h4b_0; 
            z->restricted_4(p11b,p12b,h3b,h4b,p11b_0,p12b_0,h3b_0,h4b_0); 
            long h9b_1,h10b_1,p11b_1,p12b_1; 
            z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
            long dim_common=z->get_range(p11b)*z->get_range(p12b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p11b==p12b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_3_41(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p11b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+0.5); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_3_42(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p11b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_3_58(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
      long tileoffset; 
      tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b)))))); 
      if (in[3]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p11b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p11b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p11b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p11b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
           if (z->get_spin(p8b)+z->get_spin(p12b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
            if ((z->get_sym(p8b)^(z->get_sym(p12b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
             long p8b_0,p12b_0,h3b_0,h4b_0; 
             z->restricted_4(p8b,p12b,h3b,h4b,p8b_0,p12b_0,h3b_0,h4b_0); 
             long h9b_1,h10b_1,p11b_1,p12b_1; 
             z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
             long dim_common=z->get_range(p12b); 
             long dima0_sort=z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
             long dima1=dim_common*dima1_sort; 
             if (p8b<p12b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p12b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
             } 
             else if (p12b<=p8b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p12b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
             } 
             if (p11b<p12b) { 
              z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
             } 
             else if (p12b<=p11b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),2,1,5,4,3,0,-0.5); 
          in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(h10b+z->noab()*(h9b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_3_59(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p11b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T4::smith_3_60(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
           if (p11b<p12b) { 
            z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
           } 
           else if (p12b<=p11b) { 
            z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
