//
// ccsd_2t_right.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsd_2q_right.h>
#include <chemistry/qc/ccr12/parenthesis2tnum.h>
using namespace sc;
  
  
CCSD_2Q_RIGHT::CCSD_2Q_RIGHT(CCR12_Info* info):Parenthesis2tNum(info){};
  
  
  
void CCSD_2Q_RIGHT::compute_amp(double* a_i0,const long t_p5b,const long t_p6b,const long t_p7b,const long t_p8b,const long t_h1b,const long t_h2b,const long t_h3b,const long t_h4b,const long toggle){
  
in.resize(8);
i1xn.resize(16);
  
if (toggle==1L) {
i1xn.at(0)=new Tensor("ccsd_2q_right_1x0_0",z->mem());
offset_smith_0_1();
in.at(2)=new Tensor("ccsd_2q_right_2_0",z->mem());
offset_smith_1_1();
smith_1_1_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsd_2q_right_3_0",z->mem());
offset_smith_2_4();
smith_2_4_0(); //z->v2()=>in.at(3)
smith_3_8(); //z->t1(),z->v2()=>in.at(3)
smith_2_4(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_13(); //z->t2(),z->v2()=>in.at(2)
smith_1_1(); //z->t2(),in.at(2)=>in.at(1x0)
delete in.at(2);
in.at(2)=new Tensor("ccsd_2q_right_2_1",z->mem());
offset_smith_1_2();
smith_1_2_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsd_2q_right_3_0",z->mem());
offset_smith_2_5();
smith_2_5_0(); //z->v2()=>in.at(3)
smith_3_10(); //z->t1(),z->v2()=>in.at(3)
smith_2_5(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_7(); //z->t1(),z->v2()=>in.at(2)
smith_2_12(); //z->t2(),z->v2()=>in.at(2)
smith_1_2(); //z->t2(),in.at(2)=>in.at(1x0)
delete in.at(2);
}
if (toggle==2L) {
smith_0_1(a_i0,t_p5b,t_p6b,t_p7b,t_p8b,t_h1b,t_h2b,t_h3b,t_h4b);
}
if (toggle==1L) {
i1xn.at(1)=new Tensor("ccsd_2q_right_1x1_1",z->mem());
offset_smith_0_3();
in.at(2)=new Tensor("ccsd_2q_right_2_0",z->mem());
offset_smith_1_3();
smith_1_3_0(); //z->v2()=>in.at(2)
smith_2_6(); //z->t1(),z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsd_2q_right_3_9",z->mem());
offset_smith_2_9();
smith_3_9(); //z->t1(),z->t1()=>in.at(3)
smith_2_9(); //z->v2(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_11(); //z->t2(),z->v2()=>in.at(2)
smith_1_3(); //z->t2(),in.at(2)=>in.at(1x1)
delete in.at(2);
}
if (toggle==2L) {
smith_0_3(a_i0,t_p5b,t_p6b,t_p7b,t_p8b,t_h1b,t_h2b,t_h3b,t_h4b);
}
if (toggle==3L) {
delete i1xn.at(1);
delete i1xn.at(0);
}
  
}
  
void CCSD_2Q_RIGHT::smith_0_1(double* a_i0,const long t_p5b,const long t_p6b,const long t_p7b,const long t_p8b,const long t_h1b,const long t_h2b,const long t_h3b,const long t_h4b){ 
      
const long perm[24][8]={0,1,2,3,4,5,6,7, 0,1,2,3,5,4,6,7, 0,1,2,3,6,4,5,7, 0,1,2,3,7,4,5,6, 0,2,1,3,4,5,6,7, 0,2,1,3,5,4,6,7, 0,2,1,3,6,4,5,7, 0,2,1,3,7,4,5,6, 0,3,1,2,4,5,6,7, 0,3,1,2,5,4,6,7, 0,3,1,2,6,4,5,7, 0,3,1,2,7,4,5,6, 1,2,0,3,4,5,6,7, 1,2,0,3,5,4,6,7, 1,2,0,3,6,4,5,7, 1,2,0,3,7,4,5,6, 1,3,0,2,4,5,6,7, 1,3,0,2,5,4,6,7, 1,3,0,2,6,4,5,7, 1,3,0,2,7,4,5,6, 2,3,0,1,4,5,6,7, 2,3,0,1,5,4,6,7, 2,3,0,1,6,4,5,7, 2,3,0,1,7,4,5,6}; 
const long t_b[8]={t_p5b,t_p6b,t_p7b,t_p8b,t_h1b,t_h2b,t_h3b,t_h4b}; 
for (long permutation=0L;permutation<24L;++permutation) { 
 const long p5b=t_b[perm[permutation][0]]; 
 const long p6b=t_b[perm[permutation][1]]; 
 const long p7b=t_b[perm[permutation][2]]; 
 const long p8b=t_b[perm[permutation][3]]; 
 const long h1b=t_b[perm[permutation][4]]; 
 const long h2b=t_b[perm[permutation][5]]; 
 const long h3b=t_b[perm[permutation][6]]; 
 const long h4b=t_b[perm[permutation][7]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(p5b==t_b[perm[p_p][0]] 
  && p6b==t_b[perm[p_p][1]] 
  && p7b==t_b[perm[p_p][2]] 
  && p8b==t_b[perm[p_p][3]] 
  && h1b==t_b[perm[p_p][4]] 
  && h2b==t_b[perm[p_p][5]] 
  && h3b==t_b[perm[p_p][6]] 
  && h4b==t_b[perm[p_p][7]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
  if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
   if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
    long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long h9b=0L;h9b<z->noab();++h9b) { 
     if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h9b)) { 
      if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h9b))))==z->irrep_t()) { 
       long p5b_0,p6b_0,h1b_0,h9b_0; 
       z->restricted_4(p5b,p6b,h1b,h9b,p5b_0,p6b_0,h1b_0,h9b_0); 
       long h9b_1,p7b_1,p8b_1,h2b_1,h3b_1,h4b_1; 
       z->restricted_6(h9b,p7b,p8b,h2b,h3b,h4b,h9b_1,p7b_1,p8b_1,h2b_1,h3b_1,h4b_1); 
       long dim_common=z->get_range(h9b); 
       long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (h1b<h9b) { 
         z->t2()->get_block(h9b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h9b),2,1,0,3,+1.0); 
        } 
        else if (h9b<=h1b) { 
         z->t2()->get_block(h1b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h1b),3,1,0,2,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[0]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h2b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(h9b_1))))),k_a1); 
        z->sort_indices6(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),z->get_range(h4b),5,4,3,2,1,0,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (p7b>=p6b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,5,2,1,0,+1.0); 
    } 
    if (p7b>=p6b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,5,1,0,-1.0); 
    } 
    if (p7b>=p6b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,1,5,0,+1.0); 
    } 
    if (p7b>=p6b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,6,4,3,2,1,0,5,-1.0); 
    } 
    if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,5,2,1,0,-1.0); 
    } 
    if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,5,1,0,+1.0); 
    } 
    if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,1,5,0,-1.0); 
    } 
    if (p8b>=p6b && p6b>=p7b && p7b>=p5b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,6,3,2,1,0,5,+1.0); 
    } 
    if (p8b>=p6b && p5b>=p7b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,5,2,1,0,+1.0); 
    } 
    if (p8b>=p6b && p5b>=p7b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,5,1,0,-1.0); 
    } 
    if (p8b>=p6b && p5b>=p7b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,1,5,0,+1.0); 
    } 
    if (p8b>=p6b && p5b>=p7b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,6,3,2,1,0,5,-1.0); 
    } 
    if (p6b>=p8b && p7b>=p5b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,5,2,1,0,+1.0); 
    } 
    if (p6b>=p8b && p7b>=p5b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,5,1,0,-1.0); 
    } 
    if (p6b>=p8b && p7b>=p5b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,1,5,0,+1.0); 
    } 
    if (p6b>=p8b && p7b>=p5b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),7,4,3,6,2,1,0,5,-1.0); 
    } 
    if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,5,2,1,0,-1.0); 
    } 
    if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,5,1,0,+1.0); 
    } 
    if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,1,5,0,-1.0); 
    } 
    if (p6b>=p8b && p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,7,3,6,2,1,0,5,+1.0); 
    } 
    if (p5b>=p8b && h2b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,5,2,1,0,+1.0); 
    } 
    if (p5b>=p8b && h3b>=h1b && h1b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,5,1,0,-1.0); 
    } 
    if (p5b>=p8b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,1,5,0,+1.0); 
    } 
    if (p5b>=p8b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),4,3,7,6,2,1,0,5,-1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2Q_RIGHT::offset_smith_0_1(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
         i1xn[0]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),size); 
         size+=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[0]->set_filesize(size); 
i1xn[0]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_0_3(double* a_i0,const long t_p5b,const long t_p6b,const long t_p7b,const long t_p8b,const long t_h1b,const long t_h2b,const long t_h3b,const long t_h4b){ 
      
const long perm[24][8]={0,1,2,3,4,5,6,7, 0,1,2,3,4,6,5,7, 0,1,2,3,4,7,5,6, 0,1,2,3,5,6,4,7, 0,1,2,3,5,7,4,6, 0,1,2,3,6,7,4,5, 1,0,2,3,4,5,6,7, 1,0,2,3,4,6,5,7, 1,0,2,3,4,7,5,6, 1,0,2,3,5,6,4,7, 1,0,2,3,5,7,4,6, 1,0,2,3,6,7,4,5, 2,0,1,3,4,5,6,7, 2,0,1,3,4,6,5,7, 2,0,1,3,4,7,5,6, 2,0,1,3,5,6,4,7, 2,0,1,3,5,7,4,6, 2,0,1,3,6,7,4,5, 3,0,1,2,4,5,6,7, 3,0,1,2,4,6,5,7, 3,0,1,2,4,7,5,6, 3,0,1,2,5,6,4,7, 3,0,1,2,5,7,4,6, 3,0,1,2,6,7,4,5}; 
const long t_b[8]={t_p5b,t_p6b,t_p7b,t_p8b,t_h1b,t_h2b,t_h3b,t_h4b}; 
for (long permutation=0L;permutation<24L;++permutation) { 
 const long p5b=t_b[perm[permutation][0]]; 
 const long p6b=t_b[perm[permutation][1]]; 
 const long p7b=t_b[perm[permutation][2]]; 
 const long p8b=t_b[perm[permutation][3]]; 
 const long h1b=t_b[perm[permutation][4]]; 
 const long h2b=t_b[perm[permutation][5]]; 
 const long h3b=t_b[perm[permutation][6]]; 
 const long h4b=t_b[perm[permutation][7]]; 
 bool skip=false; 
 for (long p_p=0L;p_p<permutation;++p_p) { 
  if(p5b==t_b[perm[p_p][0]] 
  && p6b==t_b[perm[p_p][1]] 
  && p7b==t_b[perm[p_p][2]] 
  && p8b==t_b[perm[p_p][3]] 
  && h1b==t_b[perm[p_p][4]] 
  && h2b==t_b[perm[p_p][5]] 
  && h3b==t_b[perm[p_p][6]] 
  && h4b==t_b[perm[p_p][7]]) skip=true; 
 } 
 if (skip) continue; 
 if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=16L) { 
  if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
   if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
    long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
    double* k_c_sort=z->mem()->malloc_local_double(dimc); 
    std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
    for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
     if (z->get_spin(p5b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
      if ((z->get_sym(p5b)^(z->get_sym(p9b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
       long p5b_0,p9b_0,h1b_0,h2b_0; 
       z->restricted_4(p5b,p9b,h1b,h2b,p5b_0,p9b_0,h1b_0,h2b_0); 
       long p6b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1; 
       z->restricted_6(p6b,p7b,p8b,h3b,h4b,p9b,p6b_1,p7b_1,p8b_1,h3b_1,h4b_1,p9b_1); 
       long dim_common=z->get_range(p9b); 
       long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
       long dima0=dim_common*dima0_sort; 
       long dima1_sort=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b); 
       long dima1=dim_common*dima1_sort; 
       if (dima0>0L && dima1>0L) { 
        double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
        double* k_a0=z->mem()->malloc_local_double(dima0); 
        if (p5b<p9b) { 
         z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
        } 
        else if (p9b<=p5b) { 
         z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
        } 
        z->mem()->free_local_double(k_a0); 
        double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
        double* k_a1=z->mem()->malloc_local_double(dima1); 
        i1xn[1]->get_block(p9b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h3b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()))))),k_a1); 
        z->sort_indices6(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),z->get_range(h3b),z->get_range(h4b),z->get_range(p9b),4,3,2,1,0,5,+1.0); 
        z->mem()->free_local_double(k_a1); 
        double factor=1.0; 
        z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        z->mem()->free_local_double(k_a1_sort); 
        z->mem()->free_local_double(k_a0_sort); 
       } 
      } 
     } 
    } 
    if (p6b>=p5b && h3b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,5,1,0,+1.0); 
    } 
    if (p6b>=p5b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,1,5,0,-1.0); 
    } 
    if (p6b>=p5b && h4b>=h2b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,6,5,0,+1.0); 
    } 
    if (p6b>=p5b && h2b>=h4b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,6,1,0,5,+1.0); 
    } 
    if (p6b>=p5b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,6,0,5,-1.0); 
    } 
    if (p6b>=p5b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),7,4,3,2,1,0,6,5,+1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h3b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,5,1,0,-1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,1,5,0,+1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h4b>=h2b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,6,5,0,-1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h2b>=h4b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,6,1,0,5,-1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,6,0,5,+1.0); 
    } 
    if (p7b>=p5b && p5b>=p6b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,7,3,2,1,0,6,5,-1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h3b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,5,1,0,+1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,1,5,0,-1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h4b>=h2b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,6,5,0,+1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h2b>=h4b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,6,1,0,5,+1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,6,0,5,-1.0); 
    } 
    if (p8b>=p5b && p5b>=p7b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,7,2,1,0,6,5,+1.0); 
    } 
    if (p5b>=p8b && h3b>=h2b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,5,1,0,-1.0); 
    } 
    if (p5b>=p8b && h4b>=h2b && h2b>=h3b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,1,5,0,+1.0); 
    } 
    if (p5b>=p8b && h4b>=h2b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,6,5,0,-1.0); 
    } 
    if (p5b>=p8b && h2b>=h4b && h3b>=h1b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,6,1,0,5,-1.0); 
    } 
    if (p5b>=p8b && h2b>=h4b && h4b>=h1b && h1b>=h3b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,6,0,5,+1.0); 
    } 
    if (p5b>=p8b && h1b>=h4b) { 
     z->sort_indices_acc8(k_c_sort,a_i0,z->get_range(h4b),z->get_range(h3b),z->get_range(p8b),z->get_range(p7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),4,3,2,7,1,0,6,5,-1.0); 
    } 
    z->mem()->free_local_double(k_c_sort); 
   } 
  } 
 } 
} 
} 
  
void CCSD_2Q_RIGHT::offset_smith_0_3(){ 
 
long size=0L; 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
       if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
         i1xn[1]->input_offset(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),size); 
         size+=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
i1xn[1]->set_filesize(size); 
i1xn[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_1(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=0L;h3b<z->noab();++h3b) { 
     for (long h4b=h3b;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h3b<=h2b && h2b<h4b) { 
       tileoffset=(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (h4b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (i1xn[0]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          double* k_c_sort=z->mem()->malloc_local_double(dimc); 
          std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
          for (long h10b=0L;h10b<z->noab();++h10b) { 
           if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h10b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h10b))))==z->irrep_t()) { 
             long p7b_0,p8b_0,h2b_0,h10b_0; 
             z->restricted_4(p7b,p8b,h2b,h10b,p7b_0,p8b_0,h2b_0,h10b_0); 
             long h9b_1,h10b_1,h3b_1,h4b_1; 
             z->restricted_4(h9b,h10b,h3b,h4b,h9b_1,h10b_1,h3b_1,h4b_1); 
             long dim_common=z->get_range(h10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             if (dima0>0L && dima1>0L) { 
              double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
              double* k_a0=z->mem()->malloc_local_double(dima0); 
              if (h2b<h10b) { 
               z->t2()->get_block(h10b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h2b),z->get_range(h10b),2,1,0,3,+1.0); 
              } 
              else if (h10b<=h2b) { 
               z->t2()->get_block(h2b_0+z->noab()*(h10b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h10b),z->get_range(h2b),3,1,0,2,-1.0); 
              } 
              z->mem()->free_local_double(k_a0); 
              double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
              double* k_a1=z->mem()->malloc_local_double(dima1); 
              if (h9b<h10b) { 
               in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
              } 
              else if (h10b<=h9b) { 
               in[2]->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h10b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
              } 
              z->mem()->free_local_double(k_a1); 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              z->mem()->free_local_double(k_a1_sort); 
              z->mem()->free_local_double(k_a0_sort); 
             } 
            } 
           } 
          } 
          double* k_c=z->mem()->malloc_local_double(dimc); 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,3,1,0,+0.5); 
           i1xn[0]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h4b>=h2b && h2b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,1,3,0,-0.5); 
           i1xn[0]->add_block(h4b+z->noab()*(h2b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(h3b),z->get_range(h9b),z->get_range(h2b),z->get_range(p8b),z->get_range(p7b),2,5,4,1,0,3,+0.5); 
           i1xn[0]->add_block(h2b+z->noab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          z->mem()->free_local_double(k_c); 
          z->mem()->free_local_double(k_c_sort); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_1_0(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        long h9b_0,h10b_0,h3b_0,h4b_0; 
        z->restricted_4(h9b,h10b,h3b,h4b,h9b_0,h10b_0,h3b_0,h4b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(h4b_0+(z->nab())*(h3b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),z->get_range(h4b),0,1,2,3,-1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_1_1(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
       in[2]->input_offset(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_2(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    for (long h3b=h2b;h3b<z->noab();++h3b) { 
     for (long h4b=0L;h4b<z->noab();++h4b) { 
      long tileoffset; 
      if (p7b<p8b && h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p7b<p8b && h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p7b<p8b && h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h3b<h4b) { 
       tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h2b<h4b && h4b<=h3b) { 
       tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      else if (p8b<=p7b && h4b<=h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b)))))); 
      } 
      if (i1xn[0]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)!=12L) { 
        if (z->get_spin(h9b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h4b)) { 
         if ((z->get_sym(h9b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h4b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h2b)*z->get_range(h3b)*z->get_range(h4b); 
          double* k_c_sort=z->mem()->malloc_local_double(dimc); 
          std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p7b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
            if ((z->get_sym(p7b)^(z->get_sym(p10b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
             long p7b_0,p10b_0,h2b_0,h3b_0; 
             z->restricted_4(p7b,p10b,h2b,h3b,p7b_0,p10b_0,h2b_0,h3b_0); 
             long h9b_1,p8b_1,h4b_1,p10b_1; 
             z->restricted_4(h9b,p8b,h4b,p10b,h9b_1,p8b_1,h4b_1,p10b_1); 
             long dim_common=z->get_range(p10b); 
             long dima0_sort=z->get_range(p7b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b); 
             long dima1=dim_common*dima1_sort; 
             if (dima0>0L && dima1>0L) { 
              double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
              double* k_a0=z->mem()->malloc_local_double(dima0); 
              if (p7b<p10b) { 
               z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
              } 
              else if (p10b<=p7b) { 
               z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p7b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
              } 
              z->mem()->free_local_double(k_a0); 
              double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
              double* k_a1=z->mem()->malloc_local_double(dima1); 
              in[2]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),2,1,0,3,+1.0); 
              z->mem()->free_local_double(k_a1); 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              z->mem()->free_local_double(k_a1_sort); 
              z->mem()->free_local_double(k_a0_sort); 
             } 
            } 
           } 
          } 
          double* k_c=z->mem()->malloc_local_double(dimc); 
          if (p8b>=p7b && h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,4,3,0,+1.0); 
           i1xn[0]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p8b>=p7b && h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,4,0,3,-1.0); 
           i1xn[0]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p8b>=p7b && h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,5,1,0,4,3,+1.0); 
           i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h4b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,4,3,0,-1.0); 
           i1xn[0]->add_block(h4b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h3b>=h4b && h4b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,4,0,3,+1.0); 
           i1xn[0]->add_block(h3b+z->noab()*(h4b+z->noab()*(h2b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          if (p7b>=p8b && h2b>=h4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h4b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h2b),z->get_range(p7b),2,1,5,0,4,3,-1.0); 
           i1xn[0]->add_block(h3b+z->noab()*(h2b+z->noab()*(h4b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(h9b))))),k_c); 
          } 
          z->mem()->free_local_double(k_c); 
          z->mem()->free_local_double(k_c_sort); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_2_0(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        long h9b_0,p8b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,p8b,h4b,p10b,h9b_0,p8b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(p8b_0+(z->nab())*(h9b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(p8b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,-1.0); 
         in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_1_2(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_3(){ 
      
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    for (long h4b=h3b;h4b<z->noab();++h4b) { 
     for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
      long tileoffset; 
      if (p6b<p7b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p7b<=p6b && p6b<p8b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab())))))); 
      } 
      else if (p8b<=p6b) { 
       tileoffset=(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))))); 
      } 
      if (i1xn[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)!=12L) { 
        if (z->get_spin(p6b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h4b)+z->get_spin(p9b)) { 
         if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h4b)^z->get_sym(p9b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p6b)*z->get_range(p7b)*z->get_range(p8b)*z->get_range(h3b)*z->get_range(h4b)*z->get_range(p9b); 
          double* k_c_sort=z->mem()->malloc_local_double(dimc); 
          std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
          for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
           if (z->get_spin(p6b)+z->get_spin(p10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
            if ((z->get_sym(p6b)^(z->get_sym(p10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
             long p6b_0,p10b_0,h3b_0,h4b_0; 
             z->restricted_4(p6b,p10b,h3b,h4b,p6b_0,p10b_0,h3b_0,h4b_0); 
             long p7b_1,p8b_1,p9b_1,p10b_1; 
             z->restricted_4(p7b,p8b,p9b,p10b,p7b_1,p8b_1,p9b_1,p10b_1); 
             long dim_common=z->get_range(p10b); 
             long dima0_sort=z->get_range(p6b)*z->get_range(h3b)*z->get_range(h4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b); 
             long dima1=dim_common*dima1_sort; 
             if (dima0>0L && dima1>0L) { 
              double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
              double* k_a0=z->mem()->malloc_local_double(dima0); 
              if (p6b<p10b) { 
               z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p10b),z->get_range(h3b),z->get_range(h4b),3,2,0,1,+1.0); 
              } 
              else if (p10b<=p6b) { 
               z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()))),k_a0); 
               z->sort_indices4(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(p6b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,-1.0); 
              } 
              z->mem()->free_local_double(k_a0); 
              double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
              double* k_a1=z->mem()->malloc_local_double(dima1); 
              if (p9b<p10b) { 
               in[2]->get_block(p10b_1-z->noab()+z->nvab()*(p9b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
              } 
              else if (p10b<=p9b) { 
               in[2]->get_block(p9b_1-z->noab()+z->nvab()*(p10b_1-z->noab()+z->nvab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
              } 
              z->mem()->free_local_double(k_a1); 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              z->mem()->free_local_double(k_a1_sort); 
              z->mem()->free_local_double(k_a0_sort); 
             } 
            } 
           } 
          } 
          double* k_c=z->mem()->malloc_local_double(dimc); 
          if (p7b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),5,2,1,4,3,0,+0.5); 
           i1xn[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p8b>=p6b && p6b>=p7b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),2,5,1,4,3,0,-0.5); 
           i1xn[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p8b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p7b-z->noab()))))),k_c); 
          } 
          if (p6b>=p8b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),z->get_range(h4b),z->get_range(h3b),z->get_range(p6b),2,1,5,4,3,0,+0.5); 
           i1xn[1]->add_block(p9b-z->noab()+z->nvab()*(h4b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))))),k_c); 
          } 
          z->mem()->free_local_double(k_c); 
          z->mem()->free_local_double(k_c_sort); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_1_3_0(){ 
      
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        long p7b_0,p8b_0,p9b_0,p10b_0; 
        z->restricted_4(p7b,p8b,p9b,p10b,p7b_0,p8b_0,p9b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p10b_0+(z->nab())*(p9b_0+(z->nab())*(p8b_0+(z->nab())*(p7b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(p7b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),0,1,2,3,-1.0); 
         in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_1_3(){ 
 
long size=0L; 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
     if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
       in[2]->input_offset(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),size); 
       size+=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_11(){ 
      
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long h12b=h11b;h12b<z->noab();++h12b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h11b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h11b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h11b_0,h12b_0; 
            z->restricted_4(p7b,p8b,h11b,h12b,p7b_0,p8b_0,h11b_0,h12b_0); 
            long h11b_1,h12b_1,p9b_1,p10b_1; 
            z->restricted_4(h11b,h12b,p9b,p10b,h11b_1,h12b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(h11b)*z->get_range(h12b); 
            long dima0_sort=z->get_range(p7b)*z->get_range(p8b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p9b)*z->get_range(p10b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h12b_0+z->noab()*(h11b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h12b_1+(z->nab())*(h11b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h11b==h12b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,-0.5/0.5); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_12(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h12b=0L;h12b<z->noab();++h12b) { 
         for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
          if (z->get_spin(p8b)+z->get_spin(p11b)==z->get_spin(h4b)+z->get_spin(h12b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p11b)^(z->get_sym(h4b)^z->get_sym(h12b))))==z->irrep_t()) { 
            long p8b_0,p11b_0,h4b_0,h12b_0; 
            z->restricted_4(p8b,p11b,h4b,h12b,p8b_0,p11b_0,h4b_0,h12b_0); 
            long h9b_1,h12b_1,p10b_1,p11b_1; 
            z->restricted_4(h9b,h12b,p10b,p11b,h9b_1,h12b_1,p10b_1,p11b_1); 
            long dim_common=z->get_range(h12b)*z->get_range(p11b); 
            long dima0_sort=z->get_range(p8b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(p10b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             if (p8b<p11b && h4b<h12b) { 
              z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h4b),z->get_range(h12b),2,0,1,3,+1.0); 
             } 
             else if (p8b<p11b && h12b<=h4b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p11b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p11b),z->get_range(h12b),z->get_range(h4b),3,0,1,2,-1.0); 
             } 
             else if (p11b<=p8b && h4b<h12b) { 
              z->t2()->get_block(h12b_0+z->noab()*(h4b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h4b),z->get_range(h12b),2,1,0,3,-1.0); 
             } 
             else if (p11b<=p8b && h12b<=h4b) { 
              z->t2()->get_block(h4b_0+z->noab()*(h12b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p8b),z->get_range(h12b),z->get_range(h4b),3,1,0,2,+1.0); 
             } 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             if (h9b<h12b && p10b<p11b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p10b),z->get_range(p11b),2,0,3,1,+1.0); 
             } 
             else if (h9b<h12b && p11b<=p10b) { 
              z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h12b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h12b),z->get_range(p11b),z->get_range(p10b),3,0,2,1,-1.0); 
             } 
             else if (h12b<=h9b && p10b<p11b) { 
              z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p10b),z->get_range(p11b),2,1,3,0,-1.0); 
             } 
             else if (h12b<=h9b && p11b<=p10b) { 
              z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(h9b_1+(z->nab())*(h12b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h12b),z->get_range(h9b),z->get_range(p11b),z->get_range(p10b),3,1,2,0,+1.0); 
             } 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h9b),z->get_range(h4b),z->get_range(p8b),1,3,2,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_13(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=h3b;h4b<z->noab();++h4b) { 
    long tileoffset; 
    tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         for (long p12b=p11b;p12b<z->noab()+z->nvab();++p12b) { 
          if (z->get_spin(p11b)+z->get_spin(p12b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
           if ((z->get_sym(p11b)^(z->get_sym(p12b)^(z->get_sym(h3b)^z->get_sym(h4b))))==z->irrep_t()) { 
            long p11b_0,p12b_0,h3b_0,h4b_0; 
            z->restricted_4(p11b,p12b,h3b,h4b,p11b_0,p12b_0,h3b_0,h4b_0); 
            long h9b_1,h10b_1,p11b_1,p12b_1; 
            z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
            long dim_common=z->get_range(p11b)*z->get_range(p12b); 
            long dima0_sort=z->get_range(h3b)*z->get_range(h4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h9b)*z->get_range(h10b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->t2()->get_block(h4b_0+z->noab()*(h3b_0+z->noab()*(p12b_0-z->noab()+z->nvab()*(p11b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(p12b),z->get_range(h3b),z->get_range(h4b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (p11b==p12b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),z->get_range(h3b),1,0,3,2,-0.5/0.5); 
        in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_4(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long h4b=0L;h4b<z->noab();++h4b) { 
    long tileoffset; 
    if (h3b<h4b) { 
     tileoffset=(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    else if (h4b<=h3b) { 
     tileoffset=(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h3b)+z->get_spin(h4b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h3b)+z->get_spin(h4b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h3b)^z->get_sym(h4b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h3b)*z->get_range(h4b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p11b_0,h3b_0; 
           z->restricted_2(p11b,h3b,p11b_0,h3b_0); 
           long h9b_1,h10b_1,h4b_1,p11b_1; 
           z->restricted_4(h9b,h10b,h4b,p11b,h9b_1,h10b_1,h4b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h3b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h3b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            in[3]->get_block(p11b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h10b_1+z->noab()*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),2,1,0,3,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (h4b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,3,0,+1.0); 
         in[2]->add_block(h4b+z->noab()*(h3b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
        if (h3b>=h4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h4b),z->get_range(h10b),z->get_range(h9b),z->get_range(h3b),2,1,0,3,-1.0); 
         in[2]->add_block(h3b+z->noab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_4_0(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long h9b_0,h10b_0,h4b_0,p11b_0; 
        z->restricted_4(h9b,h10b,h4b,p11b,h9b_0,h10b_0,h4b_0,p11b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p11b_0+(z->nab())*(h4b_0+(z->nab())*(h10b_0+(z->nab())*(h9b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h10b),z->get_range(h4b),z->get_range(p11b),0,1,2,3,+1.0); 
         in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_2_4(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
       in[3]->input_offset(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_5(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         if (z->get_spin(p8b)==z->get_spin(h11b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h11b))==z->irrep_t()) { 
           long p8b_0,h11b_0; 
           z->restricted_2(p8b,h11b,p8b_0,h11b_0); 
           long h9b_1,h11b_1,h4b_1,p10b_1; 
           z->restricted_4(h9b,h11b,h4b,p10b,h9b_1,h11b_1,h4b_1,p10b_1); 
           long dim_common=z->get_range(h11b); 
           long dima0_sort=z->get_range(p8b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h4b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h11b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h11b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (h9b<h11b) { 
             in[3]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h11b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),3,2,0,1,+1.0); 
            } 
            else if (h11b<=h9b) { 
             in[3]->get_block(p10b_1-z->noab()+z->nvab()*(h4b_1+z->noab()*(h9b_1+z->noab()*(h11b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),z->get_range(p10b),3,2,1,0,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h4b),z->get_range(h9b),z->get_range(p8b),2,3,1,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_5_0(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==z->irrep_v()) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        long h9b_0,h11b_0,h4b_0,p10b_0; 
        z->restricted_4(h9b,h11b,h4b,p10b,h9b_0,h11b_0,h4b_0,p10b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        long dima0=dim_common*dima0_sort; 
        if (dima0>0L) { 
         double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
         double* k_a0=z->mem()->malloc_local_double(dima0); 
         z->v2()->get_block(p10b_0+(z->nab())*(h4b_0+(z->nab())*(h11b_0+(z->nab())*(h9b_0))),k_a0); 
         z->sort_indices4(k_a0,k_a0_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
         z->mem()->free_local_double(k_a0); 
         double* k_c=z->mem()->malloc_local_double(dimc); 
         z->sort_indices4(k_a0_sort,k_c,z->get_range(h9b),z->get_range(h11b),z->get_range(h4b),z->get_range(p10b),0,1,2,3,+1.0); 
         in[3]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
         z->mem()->free_local_double(k_c); 
         z->mem()->free_local_double(k_a0_sort); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_2_5(){ 
 
long size=0L; 
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
     if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
       in[3]->input_offset(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),size); 
       size+=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_6(){ 
      
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    if (p7b<p8b) { 
     tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    } 
    else if (p8b<=p7b) { 
     tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab())))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         if (z->get_spin(p7b)==z->get_spin(h11b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h11b))==z->irrep_t()) { 
           long p7b_0,h11b_0; 
           z->restricted_2(p7b,h11b,p7b_0,h11b_0); 
           long h11b_1,p8b_1,p9b_1,p10b_1; 
           z->restricted_4(h11b,p8b,p9b,p10b,h11b_1,p8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(h11b); 
           long dima0_sort=z->get_range(p7b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h11b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h11b),0,1,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h11b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h11b),z->get_range(p8b),z->get_range(p9b),z->get_range(p10b),3,2,1,0,+1.0); 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p8b>=p7b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,+1.0); 
         in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        } 
        if (p7b>=p8b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p9b),z->get_range(p8b),z->get_range(p7b),2,3,1,0,-1.0); 
         in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_7(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(p8b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(p8b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(p8b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(p8b)*z->get_range(h4b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
         if (z->get_spin(p11b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p11b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p11b_0,h4b_0; 
           z->restricted_2(p11b,h4b,p11b_0,h4b_0); 
           long h9b_1,p8b_1,p10b_1,p11b_1; 
           z->restricted_4(h9b,p8b,p10b,p11b,h9b_1,p8b_1,p10b_1,p11b_1); 
           long dim_common=z->get_range(p11b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(p8b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p11b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p11b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p10b<p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),z->get_range(p11b),2,1,0,3,+1.0); 
            } 
            else if (p11b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p11b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p8b),z->get_range(p11b),z->get_range(p10b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(p8b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,+1.0); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(p8b-z->noab()+z->nvab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_2_9(){ 
      
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
   for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(p9b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(p9b)^z->get_sym(p10b))))==(z->irrep_v()^(z->irrep_t()^z->irrep_t()))) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(p9b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long h11b=0L;h11b<z->noab();++h11b) { 
         for (long h12b=h11b;h12b<z->noab();++h12b) { 
          if (z->get_spin(h11b)+z->get_spin(h12b)==z->get_spin(p9b)+z->get_spin(p10b)) { 
           if ((z->get_sym(h11b)^(z->get_sym(h12b)^(z->get_sym(p9b)^z->get_sym(p10b))))==z->irrep_v()) { 
            long h11b_0,h12b_0,p9b_0,p10b_0; 
            z->restricted_4(h11b,h12b,p9b,p10b,h11b_0,h12b_0,p9b_0,p10b_0); 
            long p7b_1,p8b_1,h11b_1,h12b_1; 
            z->restricted_4(p7b,p8b,h11b,h12b,p7b_1,p8b_1,h11b_1,h12b_1); 
            long dim_common=z->get_range(h11b)*z->get_range(h12b); 
            long dima0_sort=z->get_range(p9b)*z->get_range(p10b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p7b)*z->get_range(p8b); 
            long dima1=dim_common*dima1_sort; 
            if (dima0>0L && dima1>0L) { 
             double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
             double* k_a0=z->mem()->malloc_local_double(dima0); 
             z->v2()->get_block(p10b_0+(z->nab())*(p9b_0+(z->nab())*(h12b_0+(z->nab())*(h11b_0))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(h11b),z->get_range(h12b),z->get_range(p9b),z->get_range(p10b),3,2,1,0,+1.0); 
             z->mem()->free_local_double(k_a0); 
             double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
             double* k_a1=z->mem()->malloc_local_double(dima1); 
             in[3]->get_block(h12b_1+z->noab()*(h11b_1+z->noab()*(p8b_1-z->noab()+z->nvab()*(p7b_1-z->noab()))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h11b),z->get_range(h12b),1,0,3,2,+1.0); 
             z->mem()->free_local_double(k_a1); 
             double factor=1.0; 
             if (h11b==h12b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             z->mem()->free_local_double(k_a1_sort); 
             z->mem()->free_local_double(k_a0_sort); 
            } 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(p7b),z->get_range(p10b),z->get_range(p9b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(p10b-z->noab()+z->nvab()*(p9b-z->noab()+z->nvab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::offset_smith_2_9(){ 
 
long size=0L; 
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
  for (long h11b=0L;h11b<z->noab();++h11b) { 
   for (long h12b=h11b;h12b<z->noab();++h12b) { 
    if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h11b)+z->get_spin(h12b)) { 
     if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h11b)^z->get_sym(h12b))))==(z->irrep_t()^z->irrep_t())) { 
      if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h11b)+z->get_spin(h12b)!=8L) { 
       in[3]->input_offset(h12b+z->noab()*(h11b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),size); 
       size+=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h11b)*z->get_range(h12b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_3_10(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h11b=h9b;h11b<z->noab();++h11b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
    long tileoffset; 
    tileoffset=(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h11b)+z->get_spin(h4b)+z->get_spin(p10b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h11b)==z->get_spin(h4b)+z->get_spin(p10b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h11b)^(z->get_sym(h4b)^z->get_sym(p10b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h11b)*z->get_range(h4b)*z->get_range(p10b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h11b_1,p10b_1,p12b_1; 
           z->restricted_4(h9b,h11b,p10b,p12b,h9b_1,h11b_1,p10b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h11b)*z->get_range(p10b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p10b<p12b) { 
             z->v2()->get_block(p12b_1+(z->nab())*(p10b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p10b),z->get_range(p12b),2,1,0,3,+1.0); 
            } 
            else if (p12b<=p10b) { 
             z->v2()->get_block(p10b_1+(z->nab())*(p12b_1+(z->nab())*(h11b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h11b),z->get_range(p12b),z->get_range(p10b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p10b),z->get_range(h11b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-1.0); 
        in[3]->add_block(p10b-z->noab()+z->nvab()*(h4b+z->noab()*(h11b+z->noab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_3_8(){ 
      
for (long h9b=0L;h9b<z->noab();++h9b) { 
 for (long h10b=h9b;h10b<z->noab();++h10b) { 
  for (long h4b=0L;h4b<z->noab();++h4b) { 
   for (long p11b=z->noab();p11b<z->noab()+z->nvab();++p11b) { 
    long tileoffset; 
    tileoffset=(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h9b)+z->get_spin(h10b)+z->get_spin(h4b)+z->get_spin(p11b)!=8L) { 
      if (z->get_spin(h9b)+z->get_spin(h10b)==z->get_spin(h4b)+z->get_spin(p11b)) { 
       if ((z->get_sym(h9b)^(z->get_sym(h10b)^(z->get_sym(h4b)^z->get_sym(p11b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h9b)*z->get_range(h10b)*z->get_range(h4b)*z->get_range(p11b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        for (long p12b=z->noab();p12b<z->noab()+z->nvab();++p12b) { 
         if (z->get_spin(p12b)==z->get_spin(h4b)) { 
          if ((z->get_sym(p12b)^z->get_sym(h4b))==z->irrep_t()) { 
           long p12b_0,h4b_0; 
           z->restricted_2(p12b,h4b,p12b_0,h4b_0); 
           long h9b_1,h10b_1,p11b_1,p12b_1; 
           z->restricted_4(h9b,h10b,p11b,p12b,h9b_1,h10b_1,p11b_1,p12b_1); 
           long dim_common=z->get_range(p12b); 
           long dima0_sort=z->get_range(h4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p11b); 
           long dima1=dim_common*dima1_sort; 
           if (dima0>0L && dima1>0L) { 
            double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
            double* k_a0=z->mem()->malloc_local_double(dima0); 
            z->t1()->get_block(h4b_0+z->noab()*(p12b_0-z->noab()),k_a0); 
            z->sort_indices2(k_a0,k_a0_sort,z->get_range(p12b),z->get_range(h4b),1,0,+1.0); 
            z->mem()->free_local_double(k_a0); 
            double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
            double* k_a1=z->mem()->malloc_local_double(dima1); 
            if (p11b<p12b) { 
             z->v2()->get_block(p12b_1+(z->nab())*(p11b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p11b),z->get_range(p12b),2,1,0,3,+1.0); 
            } 
            else if (p12b<=p11b) { 
             z->v2()->get_block(p11b_1+(z->nab())*(p12b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p12b),z->get_range(p11b),3,1,0,2,-1.0); 
            } 
            z->mem()->free_local_double(k_a1); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            z->mem()->free_local_double(k_a1_sort); 
            z->mem()->free_local_double(k_a0_sort); 
           } 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p11b),z->get_range(h10b),z->get_range(h9b),z->get_range(h4b),2,1,3,0,-0.5); 
        in[3]->add_block(p11b-z->noab()+z->nvab()*(h4b+z->noab()*(h10b+z->noab()*(h9b))),k_c); 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
  
void CCSD_2Q_RIGHT::smith_3_9(){ 
      
for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  for (long h11b=0L;h11b<z->noab();++h11b) { 
   for (long h12b=0L;h12b<z->noab();++h12b) { 
    long tileoffset; 
    if (p7b<p8b && h11b<h12b) { 
     tileoffset=(h12b+z->noab()*(h11b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    } 
    else if (p7b<p8b && h12b<=h11b) { 
     tileoffset=(h11b+z->noab()*(h12b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab())))); 
    } 
    else if (p8b<=p7b && h11b<h12b) { 
     tileoffset=(h12b+z->noab()*(h11b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab())))); 
    } 
    else if (p8b<=p7b && h12b<=h11b) { 
     tileoffset=(h11b+z->noab()*(h12b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab())))); 
    } 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p7b)+z->get_spin(p8b)+z->get_spin(h11b)+z->get_spin(h12b)!=8L) { 
      if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h11b)+z->get_spin(h12b)) { 
       if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h11b)^z->get_sym(h12b))))==(z->irrep_t()^z->irrep_t())) { 
        long dimc=z->get_range(p7b)*z->get_range(p8b)*z->get_range(h11b)*z->get_range(h12b); 
        double* k_c_sort=z->mem()->malloc_local_double(dimc); 
        std::fill(k_c_sort,k_c_sort+(size_t)dimc,0.0); 
        if (z->get_spin(p7b)==z->get_spin(h11b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h11b))==z->irrep_t()) { 
          long p7b_0,h11b_0; 
          z->restricted_2(p7b,h11b,p7b_0,h11b_0); 
          long p8b_1,h12b_1; 
          z->restricted_2(p8b,h12b,p8b_1,h12b_1); 
          long dim_common=1L; 
          long dima0_sort=z->get_range(p7b)*z->get_range(h11b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p8b)*z->get_range(h12b); 
          long dima1=dim_common*dima1_sort; 
          if (dima0>0L && dima1>0L) { 
           double* k_a0_sort=z->mem()->malloc_local_double(dima0); 
           double* k_a0=z->mem()->malloc_local_double(dima0); 
           z->t1()->get_block(h11b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h11b),1,0,+1.0); 
           z->mem()->free_local_double(k_a0); 
           double* k_a1_sort=z->mem()->malloc_local_double(dima1); 
           double* k_a1=z->mem()->malloc_local_double(dima1); 
           z->t1()->get_block(h12b_1+z->noab()*(p8b_1-z->noab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(p8b),z->get_range(h12b),1,0,+1.0); 
           z->mem()->free_local_double(k_a1); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           z->mem()->free_local_double(k_a1_sort); 
           z->mem()->free_local_double(k_a0_sort); 
          } 
         } 
        } 
        double* k_c=z->mem()->malloc_local_double(dimc); 
        if (p8b>=p7b && h12b>=h11b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h12b),z->get_range(p8b),z->get_range(h11b),z->get_range(p7b),3,1,2,0,-0.5); 
         in[3]->add_block(h12b+z->noab()*(h11b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        } 
        if (p8b>=p7b && h11b>=h12b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h12b),z->get_range(p8b),z->get_range(h11b),z->get_range(p7b),3,1,0,2,+0.5); 
         in[3]->add_block(h11b+z->noab()*(h12b+z->noab()*(p8b-z->noab()+z->nvab()*(p7b-z->noab()))),k_c); 
        } 
        if (p7b>=p8b && h12b>=h11b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h12b),z->get_range(p8b),z->get_range(h11b),z->get_range(p7b),1,3,2,0,+0.5); 
         in[3]->add_block(h12b+z->noab()*(h11b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()))),k_c); 
        } 
        if (p7b>=p8b && h11b>=h12b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h12b),z->get_range(p8b),z->get_range(h11b),z->get_range(p7b),1,3,0,2,-0.5); 
         in[3]->add_block(h11b+z->noab()*(h12b+z->noab()*(p7b-z->noab()+z->nvab()*(p8b-z->noab()))),k_c); 
        } 
        z->mem()->free_local_double(k_c); 
        z->mem()->free_local_double(k_c_sort); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->sync(); 
} 
