/* getnum.c -- read a number from a DVI file.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include "extern.h"


int
DEFUN (get_number, (size, sign),
int size AND
int sign)
{
  unsigned char a, b, c, d;

  if (size > 0)
    {
      a = get_char (CHECK);

      if (sign && a > 127)
	a -= 256;

      if (size == 1)
	return (a);

      b = get_char (CHECK);

      if (size == 2)
	return ((a * 256) + b);

      c = get_char (CHECK);

      if (size == 3)
	return (((a * 256) + b) * 256 + c);

      d = get_char (CHECK);

      if (size == 4)
	return ((((a * 256) + b) * 256 + c) * 256 + d);
    }

  die ("%s:%s:%s: get_number() called with SIZE = %d\n",
    prog_name, __FILE__, __LINE__, size);
}
