/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored By: Mathias Hasselmann <mathias@openismus.com>
 */
#include "grlmediascanner/logging.h"
#include "grlmediascanner/mediasource.h"

#include <string.h>

static gboolean grl_media_scanner_plugin_init(GrlRegistry *registry,
                                          GrlPlugin *plugin,
                                          GList *configs)
{
    grl_media_scanner_logging_init();
    GRL_DEBUG("%s", __func__);

    GrlMediaScannerSource *const source = grl_media_scanner_source_new();
    GList *l;

    for (l = configs; l; l = l->next) {
        GrlConfig *const config = GRL_CONFIG(l->data);
        char *str;

        str = grl_config_get_string(config, GRL_MEDIA_SCANNER_CONFIG_INDEX_PATH);

        if (str) {
            grl_media_scanner_source_set_index_path(source, str);
            g_free(str);
            continue;
        }

        str = grl_config_get_string(config, GRL_MEDIA_SCANNER_CONFIG_SEARCH_METHOD);

        if (str) {
            GrlMediaScannerSearchMethod search_method;

            if (strcmp(str, GRL_MEDIA_SCANNER_CONFIG_SEARCH_SUBSTRING) == 0)
                search_method = GRL_MEDIA_SCANNER_SEARCH_SUBSTRING;
            else if (strcmp(str, GRL_MEDIA_SCANNER_CONFIG_SEARCH_FULL_TEXT) == 0)
                search_method = GRL_MEDIA_SCANNER_SEARCH_FULL_TEXT;
            else {
                GRL_WARNING("Ignoring unknown search method: %s", str);
                g_free(str);
                continue;
            }

            grl_media_scanner_source_set_search_method(source, search_method);
            g_free(str);
            continue;
        }
    }

    grl_registry_register_source(registry, plugin,
                                 GRL_SOURCE(source), NULL);

    return TRUE;
}

GRL_PLUGIN_REGISTER(grl_media_scanner_plugin_init, NULL, GRL_MEDIA_SCANNER_PLUGIN_ID);

