# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_cell_locator import AbstractCellLocator


class LinearTransformCellLocator(AbstractCellLocator):
    r"""
    LinearTransformCellLocator - Cell locator adaptor to perform cell
    Location on datasets that are a linear transformation of the original
    dataset.
    
    Superclass: AbstractCellLocator
    
    LinearTransformCellLocator is a cell locator adaptor that can
    accept any cell locator, e.g. StaticCellLocator, CellLocator,
    calculate the transformation matrix from the cell locator adaptor's
    dataset to the given dataset inside build_locator, and then use the
    cell locator and transformation to perform cell locator operations.
    The transformation matrix is computed using the
    https://en.wikipedia.org/wiki/Kabsch_algorithm. use_all_points allows
    you to compute the transformation using all the points of the dataset
    (use that when you are not sure if it's a linear transformation) or
    100 sample points (or less if the dataset is smaller) that are chosen
    every-nth. is_linear_transformation validates if the dataset is a
    linear transformation of the cell locator's dataset based on the used
    points.
    
    @warning The cell locator adaptor MUST be built before using it.
    
    LinearTransformCellLocator does NOT utilize ANY
    Locator/vtkAbstractCellLocator parameter:
    
    @sa
    AbstractCellLocator CellLocator StaticCellLocator
    CellTreeLocator ModifiedBSPTree OBBTree
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLinearTransformCellLocator, obj, update, **traits)
    
    use_all_points = tvtk_base.false_bool_trait(desc=\
        r"""
        use_all_points allows to compute the transformation using all the
        points of the dataset (use that when you are not if it's a linear
        transformation) or 100 sample points (or less if the dataset is
        smaller) that are chosen every-nth.
        
        Default is off.
        """
    )

    def _use_all_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseAllPoints,
                        self.use_all_points_)

    def _get_cell_locator(self):
        return wrap_vtk(self._vtk_obj.GetCellLocator())
    def _set_cell_locator(self, arg):
        old_val = self._get_cell_locator()
        self._wrap_call(self._vtk_obj.SetCellLocator,
                        deref_vtk(arg))
        self.trait_property_changed('cell_locator', old_val, arg)
    cell_locator = traits.Property(_get_cell_locator, _set_cell_locator, desc=\
        r"""
        
        """
    )

    def _get_is_linear_transformation(self):
        return self._vtk_obj.GetIsLinearTransformation()
    is_linear_transformation = traits.Property(_get_is_linear_transformation, desc=\
        r"""
        Get if the set dataset is a linear transformation of cell
        locator's dataset. The value is inside build_locator().
        """
    )

    _updateable_traits_ = \
    (('use_all_points', 'GetUseAllPoints'), ('cache_cell_bounds',
    'GetCacheCellBounds'), ('lazy_evaluation', 'GetLazyEvaluation'),
    ('retain_cell_lists', 'GetRetainCellLists'), ('automatic',
    'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_cells_per_node', 'GetNumberOfCellsPerNode'), ('max_level',
    'GetMaxLevel'), ('tolerance', 'GetTolerance'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'cache_cell_bounds', 'debug', 'global_warning_display',
    'lazy_evaluation', 'retain_cell_lists', 'use_all_points',
    'use_existing_search_structure', 'max_level',
    'number_of_cells_per_node', 'object_name', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LinearTransformCellLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LinearTransformCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'cache_cell_bounds', 'lazy_evaluation',
            'retain_cell_lists', 'use_all_points',
            'use_existing_search_structure'], [], ['max_level',
            'number_of_cells_per_node', 'object_name', 'tolerance']),
            title='Edit LinearTransformCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LinearTransformCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

