# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageMathematics(ThreadedImageAlgorithm):
    r"""
    ImageMathematics - Add, subtract, multiply, divide, invert, sin,
    cos, exp, log.
    
    Superclass: ThreadedImageAlgorithm
    
    ImageMathematics implements basic mathematic operations
    set_operation is used to select the filters behavior.  The filter can
    take two or one input.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageMathematics, obj, update, **traits)
    
    divide_by_zero_to_c = tvtk_base.false_bool_trait(desc=\
        r"""
        How to handle divide by zero. Default is 0.
        """
    )

    def _divide_by_zero_to_c_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDivideByZeroToC,
                        self.divide_by_zero_to_c_)

    operation = tvtk_base.RevPrefixMap({'add': 0, 'atan': 14, 'atan2': 15, 'absolute_value': 9, 'add_constant': 17, 'complex_multiply': 19, 'conjugate': 18, 'cos': 6, 'divide': 3, 'exp': 7, 'invert': 4, 'log': 8, 'max': 13, 'min': 12, 'multiply': 2, 'multiply_by_k': 16, 'replace_c_by_k': 20, 'sin': 5, 'square': 10, 'square_root': 11, 'subtract': 1}, default_value='add', desc=\
        r"""
        Set/Get the Operation to perform.
        """
    )

    def _operation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOperation,
                        self.operation_)

    constant_c = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        A constant used by some operations (typically additive). Default
        is 0.
        """
    )

    def _constant_c_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstantC,
                        self.constant_c)

    constant_k = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        A constant used by some operations (typically multiplicative).
        Default is 1.
        """
    )

    def _constant_k_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConstantK,
                        self.constant_k)

    def _get_input_connection(self):
        if self._vtk_obj.GetTotalNumberOfInputConnections():
            return wrap_vtk(self._vtk_obj.GetInputConnection(0, 0))
        else:
            return None
    
    def _set_input_connection(self, obj):
        old_val = self._get_input_connection()
        self._wrap_call(self._vtk_obj.SetInputConnection, deref_vtk(obj))
        self.trait_property_changed('input_connection', old_val, obj)
    input_connection = traits.Property(_get_input_connection,
                                       _set_input_connection,
                                       desc="The first input connection for this object, i.e. the result of `get_input_connection(0, 0)`.")
    
    def get_input_connection(self, *args):
        """
        get_input_connection(self, port:int, index:int)
            -> AlgorithmOutput
        C++: AlgorithmOutput *get_input_connection(int port, int index)
        Get the algorithm output port connected to an input port.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputConnection, *args)
        return wrap_vtk(ret)

    def set_input_connection(self, *args):
        """
        set_input_connection(self, idx:int, input:AlgorithmOutput)
            -> None
        C++: virtual void set_input_connection(int idx,
            AlgorithmOutput *input) override;
        set_input_connection(self, input:AlgorithmOutput) -> None
        C++: virtual void set_input_connection(AlgorithmOutput *input)
            override;
        Set the connection for the given input port index.  Each input
        port of a filter has a specific purpose.  A port may have zero or
        more connections and the required number is specified by each
        filter.  Setting the connection with this method removes all
        other connections from the port.  To add more than one connection
        use add_input_connection().
        
        * The input for the connection is the output port of another
        * filter, which is obtained with get_output_port().  Typical usage
          is
        
        * filter2->set_input_connection(0, filter1->get_output_port(0)).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnection, *my_args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, idx:int) -> DataObject
        C++: DataObject *get_input(int idx)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get one input to this filter. This method is only for support of
        old-style pipeline connections.  When writing new code you should
        use Algorithm::GetInputConnection(0, num).
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_inputs(self):
        return self._vtk_obj.GetNumberOfInputs()
    number_of_inputs = traits.Property(_get_number_of_inputs, desc=\
        r"""
        Get the number of inputs to this filter. This method is only for
        support of old-style pipeline connections.  When writing new code
        you should use Algorithm::GetNumberOfInputConnections(0).
        """
    )

    def replace_nth_input_connection(self, *args):
        """
        replace_nth_input_connection(self, idx:int, input:AlgorithmOutput)
             -> None
        C++: virtual void replace_nth_input_connection(int idx,
            AlgorithmOutput *input)
        Replace one of the input connections with a new input.  You can
        only replace input connections that you previously created with
        add_input_connection() or, in the case of the first input, with
        set_input_connection().
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReplaceNthInputConnection, *my_args)
        return ret

    def set_input1data(self, *args):
        """
        set_input1data(self, in_:DataObject) -> None
        C++: virtual void set_input1data(DataObject *in)
        Set the inputs to this filter. For some operations, the second
        input is not used.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInput1Data, *my_args)
        return ret

    def set_input2data(self, *args):
        """
        set_input2data(self, in_:DataObject) -> None
        C++: virtual void set_input2data(DataObject *in)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInput2Data, *my_args)
        return ret

    _updateable_traits_ = \
    (('divide_by_zero_to_c', 'GetDivideByZeroToC'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('operation', 'GetOperation'),
    ('split_mode', 'GetSplitMode'), ('constant_c', 'GetConstantC'),
    ('constant_k', 'GetConstantK'), ('desired_bytes_per_piece',
    'GetDesiredBytesPerPiece'), ('enable_smp', 'GetEnableSMP'),
    ('global_default_enable_smp', 'GetGlobalDefaultEnableSMP'),
    ('minimum_piece_size', 'GetMinimumPieceSize'), ('number_of_threads',
    'GetNumberOfThreads'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'divide_by_zero_to_c',
    'global_warning_display', 'release_data_flag', 'operation',
    'split_mode', 'constant_c', 'constant_k', 'desired_bytes_per_piece',
    'enable_smp', 'global_default_enable_smp', 'minimum_piece_size',
    'number_of_threads', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageMathematics, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageMathematics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['divide_by_zero_to_c'], ['operation', 'split_mode'],
            ['constant_c', 'constant_k', 'desired_bytes_per_piece', 'enable_smp',
            'global_default_enable_smp', 'minimum_piece_size',
            'number_of_threads', 'object_name']),
            title='Edit ImageMathematics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageMathematics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

