#!/usr/bin/env python
# Copyright 2013 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Distutils installer for maas-test."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

__metaclass__ = type

from setuptools import setup
import six


setup(
    name='maas-test',
    version="0.1",
    url="https://launchpad.net/maas-test",
    maintainer="Canonical",
    maintainer_email="maas-devel@lists.launchpad.net",
    packages={'maastest' if six.PY3 else b'maastest'},
    package_dir={'maastest': 'maastest'},
    install_requires=[],  # It's complicated; see README.txt
    tests_require=[],  # It's complicated; see README.txt
    test_suite="maastest.tests",
    include_package_data=True,
    zip_safe=False,
    description=(
        "A utility to test if a particular piece of hardware is "
        "compatible with MAAS."),
    entry_points={
        "console_scripts": [
            "maas-test = maastest.script:entry_point",
            ],
        },
    )
