#!/usr/bin/env python
import win32serviceutil
import win32service
import win32event
import win32api
import thread

# This will be run standalone as a service, use absolute import
from LTSPAgent import server as LTSPAgentServer

# http://code.activestate.com/recipes/576451-how-to-create-a-windows-service-in-python/
class ServiceLauncher(win32serviceutil.ServiceFramework):
    _svc_name_ = 'LTSP Agent'
    _svc_display_name_ = 'LTSP Agent'
    def __init__(self, args):
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.hWaitStop = win32event.CreateEvent(None, 0, 0, None)

    def SvcStop(self):
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        win32event.SetEvent(self.hWaitStop)

    def SvcRun(self):
        self.thread=thread.start_new_thread(LTSPAgentServer.start_server, ())
        self.ReportServiceStatus(win32service.SERVICE_RUNNING)
        self.timeout = 3000
        while True:
             # Wait for service stop signal
             rc = win32event.WaitForSingleObject(self.hWaitStop, self.timeout)
             # Check to see if self.hWaitStop happened
             if rc == win32event.WAIT_OBJECT_0:
                # Stop signal encountered
                break

def ctrlHandler(ctrlType):
   return True

if __name__ == '__main__':
    win32api.SetConsoleCtrlHandler(ctrlHandler, True)
    win32serviceutil.HandleCommandLine(ServiceLauncher)
