// SPDX-License-Identifier: GPL-2.0
/*
 * The MT7623 driver based on Linux generic pinctrl binding.
 *
 * Copyright (C) 2015 - 2018 MediaTek Inc.
 * Author: Biao Huang <biao.huang@mediatek.com>
 *	   Ryder Lee <ryder.lee@mediatek.com>
 *	   Sean Wang <sean.wang@mediatek.com>
 */

#include "pinctrl-moore.h"

#define PIN_BOND_REG0		0xb10
#define PIN_BOND_REG1		0xf20
#define PIN_BOND_REG2		0xef0
#define BOND_PCIE_CLR		(0x77 << 3)
#define BOND_I2S_CLR		0x3
#define BOND_MSDC0E_CLR		0x1

#define PIN_FIELD15(_s_pin, _e_pin, _s_addr, _x_addrs, _s_bit, _x_bits)	\
	PIN_FIELD_CALC(_s_pin, _e_pin, 0, _s_addr, _x_addrs, _s_bit,	\
		       _x_bits, 15, false)

#define PIN_FIELD16(_s_pin, _e_pin, _s_addr, _x_addrs, _s_bit, _x_bits)	\
	PIN_FIELD_CALC(_s_pin, _e_pin, 0, _s_addr, _x_addrs, _s_bit,	\
		       _x_bits, 16, 0)

#define PINS_FIELD16(_s_pin, _e_pin, _s_addr, _x_addrs, _s_bit, _x_bits)	\
	PIN_FIELD_CALC(_s_pin, _e_pin, 0, _s_addr, _x_addrs, _s_bit,	\
		       _x_bits, 16, 1)

#define MT7623_PIN(_number, _name, _eint_n, _drv_grp)			\
	MTK_PIN(_number, _name, 0, _eint_n, _drv_grp)

static const struct mtk_pin_field_calc mt7623_pin_mode_range[] = {
	PIN_FIELD15(0, 278, 0x760, 0x10, 0, 3),
};

static const struct mtk_pin_field_calc mt7623_pin_dir_range[] = {
	PIN_FIELD16(0, 175, 0x0, 0x10, 0, 1),
	PIN_FIELD16(176, 278, 0xc0, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_di_range[] = {
	PIN_FIELD16(0, 278, 0x630, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_do_range[] = {
	PIN_FIELD16(0, 278, 0x500, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_ies_range[] = {
	PINS_FIELD16(0, 6, 0xb20, 0x10, 0, 1),
	PINS_FIELD16(7, 9, 0xb20, 0x10, 1, 1),
	PINS_FIELD16(10, 13, 0xb30, 0x10, 3, 1),
	PINS_FIELD16(14, 15, 0xb30, 0x10, 13, 1),
	PINS_FIELD16(16, 17, 0xb40, 0x10, 7, 1),
	PINS_FIELD16(18, 29, 0xb40, 0x10, 13, 1),
	PINS_FIELD16(30, 32, 0xb40, 0x10, 7, 1),
	PINS_FIELD16(33, 37, 0xb40, 0x10, 13, 1),
	PIN_FIELD16(38, 38, 0xb20, 0x10, 13, 1),
	PINS_FIELD16(39, 42, 0xb40, 0x10, 13, 1),
	PINS_FIELD16(43, 45, 0xb20, 0x10, 10, 1),
	PINS_FIELD16(47, 48, 0xb20, 0x10, 11, 1),
	PIN_FIELD16(49, 49, 0xb20, 0x10, 12, 1),
	PINS_FIELD16(50, 52, 0xb20, 0x10, 13, 1),
	PINS_FIELD16(53, 56, 0xb20, 0x10, 14, 1),
	PINS_FIELD16(57, 58, 0xb20, 0x10, 15, 1),
	PIN_FIELD16(59, 59, 0xb30, 0x10, 10, 1),
	PINS_FIELD16(60, 62, 0xb30, 0x10, 0, 1),
	PINS_FIELD16(63, 65, 0xb30, 0x10, 1, 1),
	PINS_FIELD16(66, 71, 0xb30, 0x10, 2, 1),
	PINS_FIELD16(72, 74, 0xb20, 0x10, 12, 1),
	PINS_FIELD16(75, 76, 0xb30, 0x10, 3, 1),
	PINS_FIELD16(77, 78, 0xb30, 0x10, 4, 1),
	PINS_FIELD16(79, 82, 0xb30, 0x10, 5, 1),
	PINS_FIELD16(83, 84, 0xb30, 0x10, 2, 1),
	PIN_FIELD16(85, 85, 0xda0, 0x10, 4, 1),
	PIN_FIELD16(86, 86, 0xd90, 0x10, 4, 1),
	PINS_FIELD16(87, 90, 0xdb0, 0x10, 4, 1),
	PINS_FIELD16(101, 104, 0xb30, 0x10, 6, 1),
	PIN_FIELD16(105, 105, 0xd40, 0x10, 4, 1),
	PIN_FIELD16(106, 106, 0xd30, 0x10, 4, 1),
	PINS_FIELD16(107, 110, 0xd50, 0x10, 4, 1),
	PINS_FIELD16(111, 115, 0xce0, 0x10, 4, 1),
	PIN_FIELD16(116, 116, 0xcd0, 0x10, 4, 1),
	PIN_FIELD16(117, 117, 0xcc0, 0x10, 4, 1),
	PINS_FIELD16(118, 121, 0xce0, 0x10, 4, 1),
	PINS_FIELD16(122, 125, 0xb30, 0x10, 7, 1),
	PIN_FIELD16(126, 126, 0xb20, 0x10, 12, 1),
	PINS_FIELD16(127, 142, 0xb30, 0x10, 9, 1),
	PINS_FIELD16(143, 160, 0xb30, 0x10, 10, 1),
	PINS_FIELD16(161, 168, 0xb30, 0x10, 12, 1),
	PINS_FIELD16(169, 183, 0xb30, 0x10, 10, 1),
	PINS_FIELD16(184, 186, 0xb30, 0x10, 9, 1),
	PIN_FIELD16(187, 187, 0xb30, 0x10, 14, 1),
	PIN_FIELD16(188, 188, 0xb20, 0x10, 13, 1),
	PINS_FIELD16(189, 193, 0xb30, 0x10, 15, 1),
	PINS_FIELD16(194, 198, 0xb40, 0x10, 0, 1),
	PIN_FIELD16(199, 199, 0xb20, 0x10, 1, 1),
	PINS_FIELD16(200, 202, 0xb40, 0x10, 1, 1),
	PINS_FIELD16(203, 207, 0xb40, 0x10, 2, 1),
	PINS_FIELD16(208, 209, 0xb40, 0x10, 3, 1),
	PIN_FIELD16(210, 210, 0xb40, 0x10, 4, 1),
	PINS_FIELD16(211, 235, 0xb40, 0x10, 5, 1),
	PINS_FIELD16(236, 241, 0xb40, 0x10, 6, 1),
	PINS_FIELD16(242, 243, 0xb40, 0x10, 7, 1),
	PINS_FIELD16(244, 247, 0xb40, 0x10, 8, 1),
	PIN_FIELD16(248, 248, 0xb40, 0x10, 9, 1),
	PINS_FIELD16(249, 257, 0xfc0, 0x10, 4, 1),
	PIN_FIELD16(258, 258, 0xcb0, 0x10, 4, 1),
	PIN_FIELD16(259, 259, 0xc90, 0x10, 4, 1),
	PIN_FIELD16(260, 260, 0x3a0, 0x10, 4, 1),
	PIN_FIELD16(261, 261, 0xd50, 0x10, 4, 1),
	PINS_FIELD16(262, 277, 0xb40, 0x10, 12, 1),
	PIN_FIELD16(278, 278, 0xb40, 0x10, 13, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_smt_range[] = {
	PINS_FIELD16(0, 6, 0xb50, 0x10, 0, 1),
	PINS_FIELD16(7, 9, 0xb50, 0x10, 1, 1),
	PINS_FIELD16(10, 13, 0xb60, 0x10, 3, 1),
	PINS_FIELD16(14, 15, 0xb60, 0x10, 13, 1),
	PINS_FIELD16(16, 17, 0xb70, 0x10, 7, 1),
	PINS_FIELD16(18, 29, 0xb70, 0x10, 13, 1),
	PINS_FIELD16(30, 32, 0xb70, 0x10, 7, 1),
	PINS_FIELD16(33, 37, 0xb70, 0x10, 13, 1),
	PIN_FIELD16(38, 38, 0xb50, 0x10, 13, 1),
	PINS_FIELD16(39, 42, 0xb70, 0x10, 13, 1),
	PINS_FIELD16(43, 45, 0xb50, 0x10, 10, 1),
	PINS_FIELD16(47, 48, 0xb50, 0x10, 11, 1),
	PIN_FIELD16(49, 49, 0xb50, 0x10, 12, 1),
	PINS_FIELD16(50, 52, 0xb50, 0x10, 13, 1),
	PINS_FIELD16(53, 56, 0xb50, 0x10, 14, 1),
	PINS_FIELD16(57, 58, 0xb50, 0x10, 15, 1),
	PIN_FIELD16(59, 59, 0xb60, 0x10, 10, 1),
	PINS_FIELD16(60, 62, 0xb60, 0x10, 0, 1),
	PINS_FIELD16(63, 65, 0xb60, 0x10, 1, 1),
	PINS_FIELD16(66, 71, 0xb60, 0x10, 2, 1),
	PINS_FIELD16(72, 74, 0xb50, 0x10, 12, 1),
	PINS_FIELD16(75, 76, 0xb60, 0x10, 3, 1),
	PINS_FIELD16(77, 78, 0xb60, 0x10, 4, 1),
	PINS_FIELD16(79, 82, 0xb60, 0x10, 5, 1),
	PINS_FIELD16(83, 84, 0xb60, 0x10, 2, 1),
	PIN_FIELD16(85, 85, 0xda0, 0x10, 11, 1),
	PIN_FIELD16(86, 86, 0xd90, 0x10, 11, 1),
	PIN_FIELD16(87, 87, 0xdc0, 0x10, 3, 1),
	PIN_FIELD16(88, 88, 0xdc0, 0x10, 7, 1),
	PIN_FIELD16(89, 89, 0xdc0, 0x10, 11, 1),
	PIN_FIELD16(90, 90, 0xdc0, 0x10, 15, 1),
	PINS_FIELD16(101, 104, 0xb60, 0x10, 6, 1),
	PIN_FIELD16(105, 105, 0xd40, 0x10, 11, 1),
	PIN_FIELD16(106, 106, 0xd30, 0x10, 11, 1),
	PIN_FIELD16(107, 107, 0xd60, 0x10, 3, 1),
	PIN_FIELD16(108, 108, 0xd60, 0x10, 7, 1),
	PIN_FIELD16(109, 109, 0xd60, 0x10, 11, 1),
	PIN_FIELD16(110, 110, 0xd60, 0x10, 15, 1),
	PIN_FIELD16(111, 111, 0xd00, 0x10, 15, 1),
	PIN_FIELD16(112, 112, 0xd00, 0x10, 11, 1),
	PIN_FIELD16(113, 113, 0xd00, 0x10, 7, 1),
	PIN_FIELD16(114, 114, 0xd00, 0x10, 3, 1),
	PIN_FIELD16(115, 115, 0xd10, 0x10, 3, 1),
	PIN_FIELD16(116, 116, 0xcd0, 0x10, 11, 1),
	PIN_FIELD16(117, 117, 0xcc0, 0x10, 11, 1),
	PIN_FIELD16(118, 118, 0xcf0, 0x10, 15, 1),
	PIN_FIELD16(119, 119, 0xcf0, 0x10, 7, 1),
	PIN_FIELD16(120, 120, 0xcf0, 0x10, 3, 1),
	PIN_FIELD16(121, 121, 0xcf0, 0x10, 7, 1),
	PINS_FIELD16(122, 125, 0xb60, 0x10, 7, 1),
	PIN_FIELD16(126, 126, 0xb50, 0x10, 12, 1),
	PINS_FIELD16(127, 142, 0xb60, 0x10, 9, 1),
	PINS_FIELD16(143, 160, 0xb60, 0x10, 10, 1),
	PINS_FIELD16(161, 168, 0xb60, 0x10, 12, 1),
	PINS_FIELD16(169, 183, 0xb60, 0x10, 10, 1),
	PINS_FIELD16(184, 186, 0xb60, 0x10, 9, 1),
	PIN_FIELD16(187, 187, 0xb60, 0x10, 14, 1),
	PIN_FIELD16(188, 188, 0xb50, 0x10, 13, 1),
	PINS_FIELD16(189, 193, 0xb60, 0x10, 15, 1),
	PINS_FIELD16(194, 198, 0xb70, 0x10, 0, 1),
	PIN_FIELD16(199, 199, 0xb50, 0x10, 1, 1),
	PINS_FIELD16(200, 202, 0xb70, 0x10, 1, 1),
	PINS_FIELD16(203, 207, 0xb70, 0x10, 2, 1),
	PINS_FIELD16(208, 209, 0xb70, 0x10, 3, 1),
	PIN_FIELD16(210, 210, 0xb70, 0x10, 4, 1),
	PINS_FIELD16(211, 235, 0xb70, 0x10, 5, 1),
	PINS_FIELD16(236, 241, 0xb70, 0x10, 6, 1),
	PINS_FIELD16(242, 243, 0xb70, 0x10, 7, 1),
	PINS_FIELD16(244, 247, 0xb70, 0x10, 8, 1),
	PIN_FIELD16(248, 248, 0xb70, 0x10, 9, 10),
	PIN_FIELD16(249, 249, 0x140, 0x10, 3, 1),
	PIN_FIELD16(250, 250, 0x130, 0x10, 15, 1),
	PIN_FIELD16(251, 251, 0x130, 0x10, 11, 1),
	PIN_FIELD16(252, 252, 0x130, 0x10, 7, 1),
	PIN_FIELD16(253, 253, 0x130, 0x10, 3, 1),
	PIN_FIELD16(254, 254, 0xf40, 0x10, 15, 1),
	PIN_FIELD16(255, 255, 0xf40, 0x10, 11, 1),
	PIN_FIELD16(256, 256, 0xf40, 0x10, 7, 1),
	PIN_FIELD16(257, 257, 0xf40, 0x10, 3, 1),
	PIN_FIELD16(258, 258, 0xcb0, 0x10, 11, 1),
	PIN_FIELD16(259, 259, 0xc90, 0x10, 11, 1),
	PIN_FIELD16(260, 260, 0x3a0, 0x10, 11, 1),
	PIN_FIELD16(261, 261, 0x0b0, 0x10, 3, 1),
	PINS_FIELD16(262, 277, 0xb70, 0x10, 12, 1),
	PIN_FIELD16(278, 278, 0xb70, 0x10, 13, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_pullen_range[] = {
	PIN_FIELD16(0, 278, 0x150, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_pullsel_range[] = {
	PIN_FIELD16(0, 278, 0x280, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt7623_pin_drv_range[] = {
	PINS_FIELD16(0, 6, 0xf50, 0x10, 0, 4),
	PINS_FIELD16(7, 9, 0xf50, 0x10, 4, 4),
	PINS_FIELD16(10, 13, 0xf50, 0x10, 4, 4),
	PINS_FIELD16(14, 15, 0xf50, 0x10, 12, 4),
	PINS_FIELD16(16, 17, 0xf60, 0x10, 0, 4),
	PINS_FIELD16(18, 21, 0xf60, 0x10, 0, 4),
	PINS_FIELD16(22, 26, 0xf60, 0x10, 8, 4),
	PINS_FIELD16(27, 29, 0xf60, 0x10, 12, 4),
	PINS_FIELD16(30, 32, 0xf60, 0x10, 0, 4),
	PINS_FIELD16(33, 37, 0xf70, 0x10, 0, 4),
	PIN_FIELD16(38, 38, 0xf70, 0x10, 4, 4),
	PINS_FIELD16(39, 42, 0xf70, 0x10, 8, 4),
	PINS_FIELD16(43, 45, 0xf70, 0x10, 12, 4),
	PINS_FIELD16(47, 48, 0xf80, 0x10, 0, 4),
	PIN_FIELD16(49, 49, 0xf80, 0x10, 4, 4),
	PINS_FIELD16(50, 52, 0xf70, 0x10, 4, 4),
	PINS_FIELD16(53, 56, 0xf80, 0x10, 12, 4),
	PINS_FIELD16(60, 62, 0xf90, 0x10, 8, 4),
	PINS_FIELD16(63, 65, 0xf90, 0x10, 12, 4),
	PINS_FIELD16(66, 71, 0xfa0, 0x10, 0, 4),
	PINS_FIELD16(72, 74, 0xf80, 0x10, 4, 4),
	PIN_FIELD16(85, 85, 0xda0, 0x10, 0, 4),
	PIN_FIELD16(86, 86, 0xd90, 0x10, 0, 4),
	PINS_FIELD16(87, 90, 0xdb0, 0x10, 0, 4),
	PIN_FIELD16(105, 105, 0xd40, 0x10, 0, 4),
	PIN_FIELD16(106, 106, 0xd30, 0x10, 0, 4),
	PINS_FIELD16(107, 110, 0xd50, 0x10, 0, 4),
	PINS_FIELD16(111, 115, 0xce0, 0x10, 0, 4),
	PIN_FIELD16(116, 116, 0xcd0, 0x10, 0, 4),
	PIN_FIELD16(117, 117, 0xcc0, 0x10, 0, 4),
	PINS_FIELD16(118, 121, 0xce0, 0x10, 0, 4),
	PIN_FIELD16(126, 126, 0xf80, 0x10, 4, 4),
	PIN_FIELD16(188, 188, 0xf70, 0x10, 4, 4),
	PINS_FIELD16(189, 193, 0xfe0, 0x10, 8, 4),
	PINS_FIELD16(194, 198, 0xfe0, 0x10, 12, 4),
	PIN_FIELD16(199, 199, 0xf50, 0x10, 4, 4),
	PINS_FIELD16(200, 202, 0xfd0, 0x10, 0, 4),
	PINS_FIELD16(203, 207, 0xfd0, 0x10, 4, 4),
	PINS_FIELD16(208, 209, 0xfd0, 0x10, 8, 4),
	PIN_FIELD16(210, 210, 0xfd0, 0x10, 12, 4),
	PINS_FIELD16(211, 235, 0xff0, 0x10, 0, 4),
	PINS_FIELD16(236, 241, 0xff0, 0x10, 4, 4),
	PINS_FIELD16(242, 243, 0xff0, 0x10, 8, 4),
	PIN_FIELD16(248, 248, 0xf00, 0x10, 0, 4),
	PINS_FIELD16(249, 256, 0xfc0, 0x10, 0, 4),
	PIN_FIELD16(257, 257, 0xce0, 0x10, 0, 4),
	PIN_FIELD16(258, 258, 0xcb0, 0x10, 0, 4),
	PIN_FIELD16(259, 259, 0xc90, 0x10, 0, 4),
	PIN_FIELD16(260, 260, 0x3a0, 0x10, 0, 4),
	PIN_FIELD16(261, 261, 0xd50, 0x10, 0, 4),
	PINS_FIELD16(262, 277, 0xf00, 0x10, 8, 4),
	PIN_FIELD16(278, 278, 0xf70, 0x10, 8, 4),
};

static const struct mtk_pin_field_calc mt7623_pin_tdsel_range[] = {
	PINS_FIELD16(262, 276, 0x4c0, 0x10, 0, 4),
};

static const struct mtk_pin_field_calc mt7623_pin_pupd_range[] = {
	/* MSDC0 */
	PIN_FIELD16(111, 111, 0xd00, 0x10, 12, 1),
	PIN_FIELD16(112, 112, 0xd00, 0x10, 8, 1),
	PIN_FIELD16(113, 113, 0xd00, 0x10, 4, 1),
	PIN_FIELD16(114, 114, 0xd00, 0x10, 0, 1),
	PIN_FIELD16(115, 115, 0xd10, 0x10, 0, 1),
	PIN_FIELD16(116, 116, 0xcd0, 0x10, 8, 1),
	PIN_FIELD16(117, 117, 0xcc0, 0x10, 8, 1),
	PIN_FIELD16(118, 118, 0xcf0, 0x10, 12, 1),
	PIN_FIELD16(119, 119, 0xcf0, 0x10, 8, 1),
	PIN_FIELD16(120, 120, 0xcf0, 0x10, 4, 1),
	PIN_FIELD16(121, 121, 0xcf0, 0x10, 0, 1),
	/* MSDC1 */
	PIN_FIELD16(105, 105, 0xd40, 0x10, 8, 1),
	PIN_FIELD16(106, 106, 0xd30, 0x10, 8, 1),
	PIN_FIELD16(107, 107, 0xd60, 0x10, 0, 1),
	PIN_FIELD16(108, 108, 0xd60, 0x10, 10, 1),
	PIN_FIELD16(109, 109, 0xd60, 0x10, 4, 1),
	PIN_FIELD16(110, 110, 0xc60, 0x10, 12, 1),
	/* MSDC1 */
	PIN_FIELD16(85, 85, 0xda0, 0x10, 8, 1),
	PIN_FIELD16(86, 86, 0xd90, 0x10, 8, 1),
	PIN_FIELD16(87, 87, 0xdc0, 0x10, 0, 1),
	PIN_FIELD16(88, 88, 0xdc0, 0x10, 10, 1),
	PIN_FIELD16(89, 89, 0xdc0, 0x10, 4, 1),
	PIN_FIELD16(90, 90, 0xdc0, 0x10, 12, 1),
	/* MSDC0E */
	PIN_FIELD16(249, 249, 0x140, 0x10, 0, 1),
	PIN_FIELD16(250, 250, 0x130, 0x10, 12, 1),
	PIN_FIELD16(251, 251, 0x130, 0x10, 8, 1),
	PIN_FIELD16(252, 252, 0x130, 0x10, 4, 1),
	PIN_FIELD16(253, 253, 0x130, 0x10, 0, 1),
	PIN_FIELD16(254, 254, 0xf40, 0x10, 12, 1),
	PIN_FIELD16(255, 255, 0xf40, 0x10, 8, 1),
	PIN_FIELD16(256, 256, 0xf40, 0x10, 4, 1),
	PIN_FIELD16(257, 257, 0xf40, 0x10, 0, 1),
	PIN_FIELD16(25