1. О программе
===============================
	Lin_guider - это простая программа-автогид для операционной системы Linux.
	Она предназначена помочь вам получать качественные астрофотографии с длинной выдержкой. Будучи подключенным к вашему астрооборудованию и правильно настроенный Lin_guider будет компенсировать ошибки ведения вашего телескопа на протяжении всего времени фотографирования. Это позволит получить фотографии без смазанных звезд. Кроме того программа позволит исследовать периодическую ошибку вашей монтировки, благодаря возможности записи графиков отклонений. А так же, если вы любите планетную фотосъемку может записать видео без сжатия в контейнере AVI.

2. Поддерживаемое оборудование
===============================
	Для работы автогида необходимо оборудование для видеозахвата и связь с монтировкой вашего телескопа.
	Для связи с монтировкой используется порт её автогида ST-4. 

	Поддерживаемые видеоустройства:
	--------------------------------------
	1. вебкамеры, работающие через UVC-драйвер ядра (почти все вебкамеры)
	2. Philips-вебкамеры, работающие через PWC-драйвер ядра (740, 840, spc900nc, и некоторые другие)
	3. DSI 2 PRO астрокамера
	4. QHY5 ч/б 1/2
	5. QHY6 ч/б 1/3
	6. QHY5L-II-M ч/б
	7. QHY5-II ч/б

	Поддерживаемые цветные форматы видео для вебкамер:
	--------------------------------------------------
	YVU420, YUV420, JPEG, MJPEG, YUYV. 
	Вебкамеры, не поддерживающие ни один из этих форматов пока что не поддерживаются.

	Поддерживаемые исполнительные устройства (ST-4):
	-----------------------------------------
	1. LPT-коммутаторы (например релейные блоки)
	2. USB-коммутаторы основанные на FTDI-чипах (ftdi232, ftdi245) и работающие в bitbang-режиме. (например коробки производимые Ионовым Иваном)
	3. QHY5 - порт ST-4
	4. QHY6 - порт ST-4
	5. QHY5L-II-M ч/б
	6. QHY5-II ч/б
	7. GPIO драйвер для ARM платформ и платформ имеющих gpio
	8. GPUSB
	
	Таблица стабильности видео-драйверов:
	-------------------------------------
	Устройство   | Стабильность
	-------------+----------------
	UVC          | Stable
	PWC          | Stable
	DSI          | Stable
	QHY5         | Stable
	QHY6         | Stable
	QHY5L-II-M   | Unstable
	QHY5-II      | Unstable
	
	Таблица стабильности пульс-драйверов:
	-------------------------------------
	Устройство   | Стабильность
	-------------+----------------
	QHY5         | Stable
	QHY6         | Stable
	QHY5L-II-M   | Stable
	QHY5-II      | Stable
	LPT          | Stable
	FTDI         | Stable
	GPIO         | Stable
	GPUSB        | Stable
	
	Примечание:
	-----------
	Нестабильными помечены драйверы устройств с экспериментальной поддержкой и известными дефектами. 
	Причиной нестабильности может быть как драйвер, так и некачественная прошивка (firmware) производителя.
	В случае проблем с нестабильными драйверами, рекомендуется закрывать программу и переподключать устройство для
	перезагрузки его прошивки.   


3. Системные требования
===============================
	процессор - от 700Мгц
	ОЗУ - от 256Мб
	наличие USB
	ОС - Linux 32/64 bits
	QT4.5 или выше
	libusb-1.0


4. Сборка и установка
===============================
	Получить исполняемый файл программы можно собрав его из исходников. 
	Для этого необходимо:
	1. установить QT4 версии не ниже 4.5, включая dev-пакеты
	2. установить libusb-1.0, включая dev-пакеты
	3. установить fxload
	4. открыть терминал и перейти в директорию с распакованной программой
		$ cd /home/user/path/to/lin_guider
	5. выполнить configure
		$ ./configure
	6. выполнить make
		$ make
	В результате будет получен исполняемый файл программы, собранный и оптимизированный специально под вашу систему.

	7. Установить отсюда https://sourceforge.net/projects/cccd/files/firmware/ пакет с прошивками и правилами udev-а
		Если прямая установка в вашем дистрибутиве невозможна, то:
		7.1. распаковать пакет 
		7.2. из пакета скопировать все файлы с прошивками *.hex в директорию /lib/firmware/ccd/
		7.3. скопировать все файлы с расширением *.rules в вашу директорию с правилами udev. Для Debian - это /lib/udev/rules.d/
		7.4. перезапустить udev
			# /etc/init.d/udev restart


5. Настройка аппаратных средств
===============================
	Прежде чем приступить к работе с программой необходимо убедиться, что ваше видеооборудование и исполнительное устройство для монтировки нормально определилось и функционирует.
	!!! ВНИМАНИЕ !!!
	----------------
	Для избежания возможных проблем с правами доступа к устройствам, проверьте, что ваш пользователь находится в группах:
	1. video
	2. plugdev (или аналог, если такой нет)
	3. lp
	4. lpadmin

	Если вы используете вебкамеру, то проверить её можно с помощью программы guvcview. Запустив guvcview из консоли вы увидите перечень всех форматов и режимов вашей камеры.
	Если вы используете QHY5 или QHY6, то после подключения камеры к компьютеру посмотрите вывод команды dmesg в терминале, там в последних строках должно быть видно подключение неизвестного устройства, и сразу за этим смена его VID:PID и появление устройства с меткой QHY ... . Кроме того для QHY есть сторонние консольные программы, на которых можно потренироваться в её запуске под Linux-ом.
	Что касается исполнительных устройств, то для LPT-портовых коммутаторов никаких дополнительных настроек или проб не надо. Для FTDI-коммутаторов необходимо установить прилагающееся правило udev-а. Для QHY5, QHY6 если камера инициализирована успешно, то дополнительных действий не требуется.

	Первые запуски программы рекомендуется производить из терминала, чтобы видеть дополнительную информацию выводимую в консоль. В первую очередь после запуска необходимо настроить в программе видеооборудование и исполнительное устройство, далее пульсдрайвер.

	5.1. Настройка видеоустройства.
	-------------------------------
	Откройте диалог 'Video Settings' через панель инструментов.
	В первую очередь установите галку 'debug verbosity'. Это позволит видеть максимальное количество информации, включая ошибки. 
	После этого надо указать с каким видеоустройством будем работать. Для этого в надо выбрать устройство в списке Device:
	Для вебкамер так же надо указать путь к файлу видеокамеры, например /dev/video0 (камера должна быть подключена и файл устройства должен существовать)
	
	Чтобы произошло подключение к указанному устройству необходимо перезапустить программу. 
	После перезапуска должно появиться изображение с вашего видеоустройства. Если это так, то можно переходить к настройке исполнительного гидирующего устройства.
	Если же инициализация устройства не прошла успешно и было выведено окно с ошибкой, то для более детальной информации стоит посмотреть в консольный лог.
	Так же может потребоваться выставить нужную частоту кадров в секунду FPS и размер захватываемого кадра. При этом надо знать, что выдержка одного кадра рассчитывается, как 1/fps, т.е. если выставлен fps = 5, то выдержка одного кадра будет 1/5 = 200 мсек. При этом не учитывается время на перекачивание кадра и его постобработку. Поэтому реальный FPS несколько меньше, чем выбранный в списке. Эта разница не оказывает сколь-нибудь существенного воздействия на качество гидирования. Такие параметры как 'Autogain', 'Gain', 'Expo', если они доступны, стоит пробовать по картинке и смотреть, как она будет меняться.
	Параметр 'BW' - делает монохромным вывод на экран для некоторых графических форматов, что немного снижает потребление CPU. 
	Параметр 'half fps' - делает вывод на экран каждого второго кадра. Он влияет только на визуальный вывод и снижает потребление CPU, реально же все кадры захватываются и обрабатываются автогидом.
	Параметр 'Dark subtract' имеет смысл включить, если вы планируете калибровать камеру темновым кадром.
	
	5.2. Настройка исполнительного устройства.
	------------------------------------------
	Откройте диалог 'Pulse Device Settings' через панель инструментов.
	В первую очередь из выпадающего списка надо выбрать исполнительное устройство с которым будем работать.
	
	Чтобы произошло подключение к указанному устройству необходимо перезапустить программу. Если все прошло успешно, то программа запустится без сообщений об ошибке пульсдрайвера. Если же после перезапуска появилось окно с сообщением об ошибке инициализации пульсдрайвера, то смотрим внимательно в консольный лог для детализации.
	Если запуск прошел успешно, то снова открываем 'Pulse Device Settings' и проверяем, что гидирующее устройство функционирует правильно. 
	Сделать это можно несколькими способами: 
	1. нажимая тестовые кнопки RA+-, DEC+- в диалоге и проверяя светодиодную индикацию на устройстве (FTDI-коробки).
	2. нажимая тестовые кнопки RA+-, DEC+- в диалоге и слушая звук срабатывающих реле (LPT-релейные блоки)
	3. нажимая тестовые кнопки RA+-, DEC+- в диалоге и прозванивая тестером RA/DEC выводы коммутатора и земли (все типы устройств)
	Если проверка прошла успешно, то можно приступать подключить устройство к порту автогида монтировки и приступить к  гидированию. Но далеко не всегда описанного выше бывает достаточно. Например владельцы релейных блоков могут столкнуться с мертвым временем реле, например когда цепочка команд "замкнуть-разомкнуть-замкнуть" может прийти слишком быстро и разомкнувшееся реле не успеет замкнуться и останется разомкнутым. Это может привести к серьезным сбоям в гидировании. Для устранения подобного эффекта владельцам релейных блоков надо включить использование мертвого времени DT (Dead time) и подобрать его экспериментально как можно меньшим, но таким, чтоб не происходило пропусков.
	Так же владельцы GPIO, LPT и FTDI-коробок могут столкнуться с необходимостью поменять соответствие виртуальных управляющих битов (ножек разъема) реальным. Для этого используются devconf-файлы. Они будут описаны ниже.
	Если ваш коммутатор принимает команды в инвертированном виде (замкнуть - 0, а не 1), то необходимо поставить галку "inverse bits". Так же с помощью диалога 'Pulse Device Settings' можно соответствующим виртуальным битам можно назначить желаемые управляющие действия, такие, как RA+, RA-, DEC+, DEC- или отключить бит.
	Конечно, для специальных астрокамер с ST-4 разъемами все гораздо проще и описанное выше неактуально.


6. Настройка физических параметров гида
=======================================
	Когда видеоустройство и устройство управления монтировкой подключены и работают в программе, то до начала гидирования надо ввести еще несколько параметров. В диалоге 'Video Settings' надо указать:
	1. Aperture - диаметр объектива вашего гида, мм.
	2. Focal length - фокусное расстояние гида, мм.
	3. Matrix width - кол-во пикселей матрицы по горизонтали, пикс.
	4. Matrix height - кол-во пикселей матрицы по вертикали, пикс.
	6. Pixel width - ширина пикселя, мкм.
	7. Pixel height - высота пикселя, мкм.
	
	!!! ВНИМАНИЕ !!!
	----------------
	Для некоторых видов камер, включая вебкамеры, бывает доступно более одного разрешения, например 320x240 и 640x480. В этом случае надо очень внимательно отнестись к установке размера пикселя! Например, возьмем камеру Philips SPC 900 NC, имеющую матрицу в 640x480 пикселей и с размером пикселя 5.6x5.6 мкм. Если мы выберем в списке разрешений родное разрешение матрицы 640x480, то размер пикселя надо указать 5.6x5.6 мкм, как в спецификации матрицы. А если же мы выберем меньшее разрешение 320x240, то размер пикселя надо уже будет указать уже 11.2x11.2 мкм. Т.е. во столько раз больший во сколько раз меньше разрешение было выбрано. В противном случае будет нарушен масштаб всех отображаемых и вычисляемых величин.


7. Калибровка
===============================
	До начала гидирования необходимо откалибровать автогид. Для этого надо выполнить как минимум одну процедуру - определение ориентации небесной системы координат на изображении, получаемом с камеры. Кроме этого, желательно выполнить калибровку самой камеры темновым кадром.
	
	6.1. Определение ориентации небесной системы координат
	------------------------------------------------------
	Наведите гид на звезду, по которой хотите гидировать. Убедитесь, что звезда не находится вблизи края кадра. Сфокусируйте изображение. Проверьте, что все крепления затянуты и провода не висят свободно.
	Откройте диалог калибровки 'Calibration'. Параметром 'two axis' выберите по двум или по одной оси производить калибровку.
	Если полярная ось выставлена хорошо, то рекомендуется использовать автоматический режим калибровки - параметр 'auto mode'                                                                                      
		6.1.1 Автоматическая калибровка
		-------------------------------
		Укажите время в секундах в течение которого будет производиться дрейф по осям. Схватите курсором мыши зеленый квадрат и перетащите его на гидирующую звезду. Убедитесь, что квадрат следует за звездой. Нажмите кнопку 'Start'. После этого программа начнет смещать звезду по одной или двум осям. По окончании калибровки будет показан результат. В случае успешного завершения 'Status: DONE' и оси координат примут новое положение. В случае ошибки будет показано окно с сообщением об ошибке. Если полярная ось выставлена плохо, то автоматическая калибровка может завершиться ошибкой. В этом случае вообще не рекомендуется производить фотосъемку и лучше поточнее выставить полярную ось. 

		6.1.2. Ручная калибровка
		------------------------
		Если по какой-либо причине автоматическая калибровка не подходит или завершается ошибкой, то можно произвести калибровку в ручном режиме. Для этого схватите курсором мыши зеленый квадрат и перетащите его на гидирующую звезду. Убедитесь, что квадрат следует за звездой. Нажмите кнопку 'Start'. После этого с помощью пульта монтировки произведите смещение звезды в направлении  RA+ и нажмите 'Stop'. Если включен режим двух осей, то сразу после окончания дрейфа по RA произведите с пульта смещение в направлении DEC+ и нажмите 'Stop'. Важно понимать, что чем длиннее вектор смещения, тем точнее будет определено направление осей небесных координат.
		!!! ВНИМАНИЕ !!!
		----------------
		Во время калибровки рекомендуется, чтобы квадрат, следящий за звездой не касался границ видеокадра

	6.2. Калибровка камеры темновым кадром
	--------------------------------------
	Для того чтобы откалибровать камеру темновым кадром укажите в поле 'Frame count' сколько кадров надо накопить. Закройте объектив гида от света и нажмите кнопку 'Start'. По окончании набора будет сформирован темновой кадр, который будет вычитаться из каждого вновь получаемого кадра камеры, если в диалоге настройки гида поставлена галка 'Dark subtract'.


8. Гидирование
===============================
	После того, как установлена ориентация небесной системы координат можно приступать к гидированию. Откройте диалог 'Guiding'
Установите подходящий размер квадрата, удерживающего звезду 'Square size'. Площадь квадрата не должна быть слишком мала или наоборот слишком велика по сравнению с видимой площадью звезды.
	Выберите алгоритм учета порога при вычислении положения звезды 'Threshold alg'. 
	Значение 'Smart'- это более точное динамическое вычисление порога по сравнению в 'Auto'.
	Значение 'Auto' - это динамическое вычисление порога.
	Значение 'No thresh.' - отключение обработки порога.
	Далее надо настроить параметры в блоке 'Control'. В этом блоке все параметры задаются отдельно для каждой оси RA и DEC. Перечислим их:
	1. Enable directions - влючает или отключает подачу вычисленных коррекций на ось. По умолчанию включено все.
	2. Accumulate frames - включает усреднение значений координаты по N кадрам и подачу коррекции по окончании усреднения. По умолчанию 1.
	3. Proportional gain - коэффициент пропорционального члена в ПИД-регуляторе. По умолчанию может быть предвычислен в блоке 'Info'
	4. Integral gain - коэффициент интегрального члена в ПИД-регуляторе. По умолчанию равен 0.
	4. Devivative gain - коэффициент дифференциального члена в ПИД-регуляторе. По умолчанию равен 0. (в данной версии отключен)
	6. Maximum pulse - максимальная длительность корректирующего импульса. Ограничивается конкретным видом исполнительного устройства. По умолчанию 5000 мс.
	7. Minimum pulse - минимальная длительность корректирующего импульса. По умолчанию 100 мс.
	8. Avg.frm. - отключен.

	Настройку коэффициентов ПИД-регулятора надо производить опытным путем на конкретном оборудовании и с полной нагрузкой. Смысл настройки сводится к таком подбору коэффициентов, при котором не происходит 'недогидирование' (слишком медленное устранение отклонений) и не происходит 'перегидирование' (синусоидальная раскачка с возрастанием амплитуды).
	При подборе пропорционального коэффициента рекомендуется взять диапазон значений от 10 и до немного превышающего рекомендованное значение (см. блок Info). И пройти этот диапазон с шагом в 10, внимательно наблюдая, как меняется результат гидирования.
	Подбор интегрального коэффициента рекомендуется производить, если имеет место постоянное воздействие в какую-либо сторону. Этот коэффициент позволит быстрее реагировать на это воздействие, т.к. учитывает предыдущую историю.
	Дифференциальный коэффициент, как писалось выше в данный момент отключен.

	!!!ВНИМАНИЕ!!! 
	--------------
	При подборе коэффициентов стоит иметь ввиду, что их значения могут отличаться для разных осей. 

	Если полярная ось выставлена достаточно хорошо, то гидировать по оси DEC можно не часто, а раз в 2-4 кадра. Это позволит избежать чрезмерной активности на оси и ненужных вибраций. Кроме того, для оси RA рекомендуется ввести маленький дисбаланс (перевес) против суточного движения для выборки люфтов и движения с постоянным натягом. Для оси DEC рекомендуется произвести небольшое смещение полярной оси (для подробностей см. метод дрейфа) от идеального положения для того, чтобы пошло постоянное смещение в одну сторону и гидирование шло только в одном направлении. Это позволит уменьшить болтанку в районе 0.

	Значение 'Maximum pulse' обычно выбирается больше или равным периоду рабочего цикла (время между двумя последовательными захватами изображения с камеры). Его значение по умолчанию обычно не требуется менять. А вот значение 'Minimum pulse' более важно. Этот параметр обозначает порог длительности коррекций. Если вычисленная коррекция больше или равна 'Minimum pulse', то она отправляется на монтировку, в противном случае коррекция отбрасывается. Если задать этот порог очень большим, то некорректируемая полоса значений отклонений вокруг нуля будет слишком широка, а качество гидирования низким. А если задать этот порог очень маленьким, то количество коррекций около 0 будет очень большим, что приведет к постоянному дёрганью оси в противоположных направлениях, и, как следствие, плохоустранимой раскачке. Особенно это важно для высоконагруженных сетапов с невысокой общей механической жесткостью.

	С помощью диалога гидирования можно так же сохранять логи гидирования в текстовые файлы. Для этого в блоке 'Configuration' надо отметить чекбокс 'save drift' и указать имя файла. Формат файла простой текст с двумя столбцами чисел - отклонения по RA и по DEC.


9. Внешнее управление
===============================
	Начиная с версии 2.8 автогид является TCP сервером в Unix домене. Сервер принимает входящие клиентские соединения и выполняет запросы.
	С помощью запросов к серверу реализуется часто используемая в астрофото техника межкадровых подвижек "DITHERING ".
	Полный список команд, а так же протокол запросов и ответов можно посмотреть в примере
	lin_guider/tests/remote_client.c
	
	Кроме этого, автогид может быть настроен на рассылку информационных сообщений по UDP.
	Полный список сообщений можно видеть в настройках программы. Для демонстрации приема и показа сообщений можно использовать пример
	lin_guider/tests/event_monitor.pl


10. Общие рекомендации.
===============================
1. На фотографическом сетапе должно быть затянуто все, что можно затянуть: фокусёры, крепления камер, крепления оптических труб друг к другу и монтировке, крепление головы монтировки к треноге/колонне, т.д. Провода от камер не должны болтаться. Свободновисящие участки кабелей должня быть как можно короче.
2. Рекомендуется вводить небольшой дисбаланс по RA в сторону противоположную суточному вращению.
3. После выбора гидирующей звезды, если она очень яркая, рекомендуется подстроить камеру (если это позволяется аппаратно) для устранения пересвеченности.
4. После изменений параметров камеры (Gain, FPS, т.п.) требуется обязательная перекалибровка камеры темновым кадром, если он используется.
5. В околополярных областях, там где при калибровке дрейф по RA бывает очень коротким, рекомендуется включать метод калибровки по двум осям.


-------------------------------
Тёмного неба и удачного гидирования!

Автор: Андрей Степаненко (Galaxy Master)
(c)GM software'08-13

Страница проекта: http://sourceforge.net/projects/linguider/
Поддержка: galaxy_master@mail.ru
