#!/bin/sh

test_description="simple tests for otfinfo - part of LCDF Typetools"

. /usr/share/sharness/sharness.sh

OTF=/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf

test_expect_success "otfinfo version" "
    otfinfo --version > out &&
    grep -x 'otfinfo (LCDF typetools) [0-9.]\+' out
"

test_expect_success "otfinfo help" "
    otfinfo --help > out &&
    grep -Fx 'Usage: otfinfo [-sfzpg | OPTIONS] [OTFFILES...]' out
"

test_expect_success "otfinfo parse scripts" "
    otfinfo --scripts $OTF > out &&
    grep Latin/Phonetic out
"

test_done
