#ifndef LOGGERMETHODS_H
#define LOGGERMETHODS_H

#include <Logger.h>

#include <syslog.h>

namespace Log
{

class NullMethod : public Method
{
public:
	virtual void output(LogLevel level, const char* tag, const char* func,
			const std::string& msg) throw () {}
};

class FileMethod : public Method
{
protected:
	void* out;
	std::string fname;

public:
	FileMethod(const std::string& file) throw (FileException);
	virtual ~FileMethod() throw ();
	
	virtual void output(LogLevel level, const char* tag, const char* func,
			const std::string& msg) throw ();
};

class StderrMethod : public Method
{
public:
	virtual void output(LogLevel level, const char* tag, const char* func,
			const std::string& msg) throw ();
};

class SyslogMethod : public Method
{
protected:
	std::string ident;
	int facility;

public:
	SyslogMethod(const std::string& ident, int facility = LOG_DAEMON) throw ();
	virtual ~SyslogMethod() throw ();

	virtual void output(LogLevel level, const char* tag, const char* func,
			const std::string& msg) throw ();

	virtual void setupForkedChild() throw ();
};

};

// vim:set ts=4 sw=4:
#endif
