// Generated by CoffeeScript 1.3.1
(function() {
  var Previewer, root, _ref;

  Previewer = (function() {

    Previewer.name = 'Previewer';

    function Previewer(sel) {
      var _this = this;
      this.me = $(sel);
      this.image = this.me.find('.image');
      this.link = this.me.children('.image_wrapper');
      this.close_btn = this.me.children('.close');
      this.visible = false;
      this.close_btn.click(function() {
        return _this.close();
      });
      this.link.click(function(ev) {
        if (ev.which !== 1 && ev.which !== 2) {
          _this.close();
          return;
        }
        if (conf.vars.platform === 'Chrome') {
          chrome.tabs.create({
            url: _this.link.attr('href'),
            active: ev.which === 1
          }, function() {});
          _this.close();
          return false;
        }
        return _this.close();
      });
    }

    Previewer.prototype.reset = function() {
      this.reload_proc('image/ani_loading_bar.gif');
      return this.image.css('margin', '20px 0');
    };

    Previewer.prototype.reload = function(image_url) {
      this.reset();
      return this.reload_proc(image_url);
    };

    Previewer.prototype.reload_proc = function(image_url) {
      var preloader,
        _this = this;
      preloader = new Image;
      preloader.onload = function() {
        var height, preload, width;
        _this.image.attr('src', image_url);
        _this.image.css('margin', '0');
        width = preloader.width;
        height = preloader.height;
        if ($(window).width() < width + 40) {
          width = $(window).width() - 40;
          height = (width + .0) / preloader.width * preloader.height;
        }
        if ($(window).height() < height + 70) {
          height = $(window).height() - 70;
          width = (height + .0) / preloader.height * preloader.width;
        }
        _this.image.width(width);
        _this.image.height(height);
        _this.link.attr('href', image_url);
        _this.resize(width, height);
        return preload = null;
      };
      return preloader.src = image_url;
    };

    Previewer.prototype.resize = function(width, height) {
      if (width < 64) {
        width = 64;
      }
      if (height < 64) {
        height = 64;
      }
      height += 30;
      this.me.width(width).height(height);
      return this.me.css({
        'margin-top': (0 - height) / 2 - 10,
        'margin-left': (0 - width) / 2 - 10
      });
    };

    Previewer.prototype.open = function() {
      this.visible = true;
      this.me.show();
      return this.me.transition({
        'opacity': 1
      }, 100);
    };

    Previewer.prototype.close = function() {
      var _this = this;
      this.visible = false;
      return this.me.transition({
        'opacity': 0
      }, 100, function() {
        return _this.me.hide();
      });
    };

    return Previewer;

  })();

  root = typeof exports !== "undefined" && exports !== null ? exports : this;

  root.widget = (_ref = root.widget) != null ? _ref : {};

  root.widget.Previewer = Previewer;

}).call(this);
