cpp_include "<unordered_map>"

namespace cpp apache.thrift.reflection

// A type id is a 64-bit value.  The least significant 5 bits of the type id
// are the actual type (one of the values of the Type enum, below).  The
// remaining 59 bits are a unique identifier for container or user-defined
// types, or 0 for base types (void, string, bool, byte, i16, i32, i64,
// and double)

// IMPORTANT!
// These values must be exactly the same as those defined in
// thrift/compiler/parse/t_type.h
enum Type {
  TYPE_VOID = 0,
  TYPE_STRING = 1,
  TYPE_BOOL = 2,
  TYPE_BYTE = 3,
  TYPE_I16 = 4,
  TYPE_I32 = 5,
  TYPE_I64 = 6,
  TYPE_DOUBLE = 7,
  TYPE_ENUM = 8,
  TYPE_LIST = 9,
  TYPE_SET = 10,
  TYPE_MAP = 11,
  TYPE_STRUCT = 12,
  TYPE_SERVICE = 13,
  TYPE_PROGRAM = 14,
  TYPE_FLOAT = 15,
}

struct StructField {
  1: bool isRequired,
  2: i64 type,
  3: string name,
  4: optional map<string, string>
    ( cpp.template = "std::unordered_map" )
    annotations,
  5: i16 order, // lexical order of this field, 0-based
}

struct DataType {
  1: string name,
  2: optional map<i16, StructField>
    ( cpp.template = "std::unordered_map" )
    fields,
  3: optional i64 mapKeyType,
  4: optional i64 valueType,
  5: optional map<string, i32> ( cpp.template = "std::unordered_map" )
    enumValues,
}

struct Schema {
  1: map<i64, DataType> ( cpp.template = "std::unordered_map" ) dataTypes,
  // name to type
  2: map<string, i64> ( cpp.template = "std::unordered_map" ) names,
}
