// -*- C++ -*-
#ifndef HERWIG_MEvv2vs_H
#define HERWIG_MEvv2vs_H
//
// This is the declaration of the MEvv2vs class.
//

#include "GeneralHardME.h"
#include "ThePEG/Helicity/Vertex/AbstractVVVVertex.h"
#include "ThePEG/Helicity/Vertex/AbstractVVSVertex.h"
#include "ThePEG/Helicity/Vertex/AbstractVSSVertex.h"
#include "Herwig++/MatrixElement/ProductionMatrixElement.h"

namespace Herwig {

using namespace ThePEG;
using Helicity::VectorWaveFunction;
using Helicity::ScalarWaveFunction;

/**
 * This is the implementation of the matrix element for 
 * \f$2\to 2\f$ massless vector-boson pair to a vector and scalar boson.
 * It inherits from GeneralHardME and implements the appropriate virtual
 * member functions.
 *
 * @see \ref MEvv2vsInterfaces "The interfaces"
 * defined for MEvv2vs.
 */
class MEvv2vs: public GeneralHardME {

public:

  /**
   *  Typedef for VectorWaveFunction
   */
  typedef vector<VectorWaveFunction> VBVector;

public:

  /** @name Virtual functions required by the GeneralHardME class. */
  //@{
  /**
   * The matrix element for the kinematical configuration
   * previously provided by the last call to setKinematics(), suitably
   * scaled by sHat() to give a dimension-less number.
   * @return the matrix element scaled with sHat() to give a
   * dimensionless number.
   */
  virtual double me2() const;
  //@}

  /**
   * Construct the vertex information for the spin correlations
   * @param sub Pointer to the relevent SubProcess
   */
  virtual void constructVertex(tSubProPtr sub);

private:

  /**
   * Compute the matrix element for \f$V\, V\to V\, V\f$
   * @param vin1 VectorWaveFunctions for first incoming particle
   * @param vin2 VectorWaveFunctions for second incoming particle
   * @param vout1 VectorWaveFunctions for first outgoing particle
   * @param mc Whether vout1 is massless or not
   * @param sout2  ScalarWaveFunction for outgoing particle
   * @param me2 colour averaged, spin summed ME
   * @param first Whether or not first call to decide if colour decomposition etc
   * should be calculated
   * @return ProductionMatrixElement containing results of 
   * helicity calculations
   */
  ProductionMatrixElement 
  vv2vsHeME(VBVector & vin1, VBVector & vin2, 
	    VBVector & vout1, bool mc, ScalarWaveFunction & sout2,
	    double & me2, bool first ) const;

public:

  /** @name Functions used by the persistent I/O system. */
  //@{
  /**
   * Function used to write out object persistently.
   * @param os the persistent output stream written to.
   */
  void persistentOutput(PersistentOStream & os) const;

  /**
   * Function used to read in object persistently.
   * @param is the persistent input stream read from.
   * @param version the version number of the object when written.
   */
  void persistentInput(PersistentIStream & is, int version);
  //@}

  /**
   * The standard Init function used to initialize the interfaces.
   * Called exactly once for each class by the class description system
   * before the main function starts or
   * when this class is dynamically loaded.
   */
  static void Init();

protected:

  /** @name Clone Methods. */
  //@{
  /**
   * Make a simple clone of this object.
   * @return a pointer to the new object.
   */
  virtual IBPtr clone() const;

  /** Make a clone of this object, possibly modifying the cloned object
   * to make it sane.
   * @return a pointer to the new object.
   */
  virtual IBPtr fullclone() const;
  //@}

protected:

  /** @name Standard Interfaced functions. */
  //@{
  /**
   * Initialize this object after the setup phase before saving an
   * EventGenerator to disk.
   * @throws InitException if object could not be initialized properly.
   */
  virtual void doinit();

  /**
   * Initialize this object. Called in the run phase just before
   * a run begins.
   */
  virtual void doinitrun();
  //@}

private:

  /**
   * The static object used to initialize the description of this class.
   * Indicates that this is a concrete class with persistent data.
   */
  static ClassDescription<MEvv2vs> initMEvv2vs;

  /**
   * The assignment operator is private and must never be called.
   * In fact, it should not even be implemented.
   */
  MEvv2vs & operator=(const MEvv2vs &);

private:

  /**
   * Store the dynamically casted VVSVertex and VSSVertex pointers
   */
  vector<pair<AbstractVVSVertexPtr, AbstractVSSVertexPtr> > scalar_;

  /**
   * Store the dynamically casted VVVVertex and VVSVertex pointers
   */
  vector<pair<AbstractVVVVertexPtr, AbstractVVSVertexPtr> > vector_;

};

}

#include "ThePEG/Utilities/ClassTraits.h"

namespace ThePEG {

/** @cond TRAITSPECIALIZATIONS */

/** This template specialization informs ThePEG about the
 *  base classes of MEvv2vs. */
template <>
struct BaseClassTrait<Herwig::MEvv2vs,1> {
  /** Typedef of the first base class of MEvv2vs. */
  typedef Herwig::GeneralHardME NthBase;
};

/** This template specialization informs ThePEG about the name of
 *  the MEvv2vs class and the shared object where it is defined. */
template <>
struct ClassTraits<Herwig::MEvv2vs>
  : public ClassTraitsBase<Herwig::MEvv2vs> {
  /** Return a platform-independent class name */
  static string className() { return "Herwig::MEvv2vs"; }
  /**
   * The name of a file containing the dynamic library where the class
   * MEvv2vs is implemented. It may also include several, space-separated,
   * libraries if the class MEvv2vs depends on other classes (base classes
   * excepted). In this case the listed libraries will be dynamically
   * linked in the order they are specified.
   */
  static string library() { return "MEvv2vs.so"; }
};

/** @endcond */

}

#endif /* HERWIG_MEvv2vs_H */
