/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>

/*
 * In this example we will open an HDF-EOS file and attach to
 * a swath structures within the file to write a dimension scales
 */


int main()
{
  herr_t          status = FAIL;

  hid_t           swfid = FAIL;
  hid_t           SWid1 = FAIL;

  int             data[15]={1,2,3,6,9,12,15,18,23,26,29,32, 33,34,35};
  char            label[16];
  char            unit[16];
  char            format[16];
  int             nbands;
  hsize_t         count[3];

  /*
   * We first open the HDF-EOS swath file, "Swath.h5".  Because this file
   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
   * code in the open statement.  The HE5_SWopen routine returns the swath file
   * id, swfid, which is used to identify the file in subsequent routines.
   */ 

  swfid = HE5_SWopen("Swath.h5", H5F_ACC_RDWR);
 
  /*
   * If the swath file cannot be found, HE5_SWopen will return -1 for the file
   * handle (swfid).  We there check that this is not the case before
   * proceeding with the other routines.
   * 
   * The HE5_SWattach routine returns the handle to the existing swath "Swath1",
   * SWid1.  If the swath is not found, HE5_SWattach returns -1 for the handle.
   */ 

  if (swfid != FAIL)
    {	  
      SWid1 = HE5_SWattach(swfid, "Swath1");

      /* the field Spectra has Bands,Res2tr,Res2xtr dimensions. 
	 xdim = 120;
	 ydim = 200;
	 Time dim is set to 10
      */

      if (SWid1 == -1)
	{
	  printf("\t\tError: Cannot attach to swath \"Swath1\"\n");
	  HE5_SWclose(swfid);
	  return -1;
	}
      
      nbands = 15;
      
      status = HE5_SWsetdimscale(SWid1, "Spectra", "Bands", nbands, H5T_NATIVE_INT, (void *)data);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}
      
      strcpy(label, "Bands Dim");
      strcpy(unit, "None");
      strcpy(format, "I2");
      
      count[0]= 12;
      status = HE5_SWwritedscaleattr(SWid1, "Bands", "label", H5T_NATIVE_CHAR, count, label);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}

      count[0]= 6;
      status = HE5_SWwritedscaleattr(SWid1, "Bands", "unit", H5T_NATIVE_CHAR, count, unit);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}
      
      count[0]= 4;
      status = HE5_SWwritedscaleattr(SWid1, "Bands", "format", H5T_NATIVE_CHAR, count, format);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}
         
      int datbuf_i1[1] = {-999};
      count[0]= 1;
      status = HE5_SWwritedscaleattr(SWid1, "Bands", "MissingValue", H5T_NATIVE_INT, count, datbuf_i1);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}
      
      int datbuf_i2[3] = {-999,0,999};
      count[0]= 3;
      status = HE5_SWwritedscaleattr(SWid1, "Bands", "IntValues", H5T_NATIVE_INT, count, datbuf_i2);
      if (status == -1)
	{
	  printf("\t\tError: Cannot set Dimension Scale strs for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_SWdetach(SWid1);
	  HE5_SWclose(swfid);
	  return -1;
	}
      
      HE5_SWdetach(SWid1);
      
      HE5_SWclose(swfid);
      
      return 0;
    }
}
