{-| SQL queries.
-}
module DB.HSQL.PG.Sql where

import Database.HSQL.Types(SqlBind(toSqlValue))

-- | retrieval of the names of all tables
sqlAllTableNames:: String
sqlAllTableNames =
    "SELECT relname FROM pg_class WHERE relkind='r' AND relname !~ '^pg_'"


-- | retrieval of the field defs for a table name
sqlAllFieldDefsForTableName:: SqlBind t=> t-> String
sqlAllFieldDefsForTableName tableName =
    "SELECT attname, atttypid, atttypmod, attnotnull " 
    ++"FROM pg_attribute AS cols JOIN pg_class AS ts ON cols.attrelid=ts.oid " 
    ++"WHERE cols.attnum > 0 AND ts.relname="++ (toSqlValue tableName)
       ++" AND cols.attisdropped = FALSE "
