module Main (main) where

import           Codec.Compression.BZip (compress, decompress)
import qualified Data.ByteString.Lazy   as BSL
import           System.FilePath        ((</>))
import           System.IO.Temp         (withSystemTempDirectory)

main :: IO ()
main =
    compressDump *>
    decompressDump

decompressDump :: IO ()
decompressDump = withSystemTempDirectory "bz2" $
    \fp -> BSL.writeFile (fp </> "valgrind-3.15.0.tar") =<<
        (decompress <$> BSL.readFile "valgrind-3.15.0.tar.bz2")

compressDump :: IO ()
compressDump = withSystemTempDirectory "bz2" $
    \fp -> BSL.writeFile (fp </> "valgrind-3.15.0.tar.bz2") =<<
        (compress <$> BSL.readFile "valgrind-3.15.0.tar")
