//**************************************************************************************************
//                                        DlgNgsCfgSrc.hpp                                         *
//                                       ------------------                                        *
// Description : This dialogue is used to enter values associated with an NG-Spice independent     *
//               voltage source definition. It is used for Transient analysis and is based on a    *
//               pulse function.                                                                   *
// Started     : 2005-05-10                                                                        *
// Last Update : 2015-04-17                                                                        *
// Copyright   : (C) 2005 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef DLGNGSCFGSRC_HPP
#define DLGNGSCFGSRC_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "utility/PnlValue.hpp"
#include "netlist/CpntNgsIndSrc.hpp"

// wxWidgets Includes

#include <wx/tokenzr.h>

//**************************************************************************************************

class DlgNgsCfgSrc : public wxDialog
{
  private :

    // Value panel controls for a sinusoidal source
    PnlValue  m_oPnlSinAmp;
    PnlValue  m_oPnlSinFreq;
    PnlValue  m_oPnlSinOffset;
    PnlValue  m_oPnlSinDelay;
    PnlValue  m_oPnlSinDamp;

    // Value panel controls for a pulse source
    PnlValue  m_oPnlPulInitial;
    PnlValue  m_oPnlPulMax;
    PnlValue  m_oPnlPulDelay;
    PnlValue  m_oPnlPulRise;
    PnlValue  m_oPnlPulWidth;
    PnlValue  m_oPnlPulFall;
    PnlValue  m_oPnlPulPeriod;

    // Button controls
    wxButton  m_oBtnOk;
    wxButton  m_oBtnClear;
    wxButton  m_oBtnCancel;

    // Storage for validated Independent Source values
    CpntNgsIndSrc  m_oCpntIndSrc;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    void  SetValues( CpntNgsIndSrc & roCpntSrc );
    void  GetValues( CpntNgsIndSrc & roCpntSrc );

  public :

          DlgNgsCfgSrc( wxWindow * poWin );
         ~DlgNgsCfgSrc( );

    bool  bClear( void );

    bool  bSetValues( CpntNgsIndSrc & roCpntSrc );
    bool  bGetValues( CpntNgsIndSrc & roCpntSrc );

    bool  bSetName( wxString & rosName );

    // Event handlers
    void  OnBtnOk    ( wxCommandEvent & roEvtCmd );
    void  OnBtnClear ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_PNL_SIN_OFFSET = 0,
      ID_PNL_SIN_AMP,
      ID_PNL_SIN_FREQ,
      ID_PNL_SIN_DELAY,
      ID_PNL_SIN_DAMP,

      ID_PNL_PUL_INITV,
      ID_PNL_PUL_MAXV,
      ID_PNL_PUL_DELAY,
      ID_PNL_PUL_RISE,
      ID_PNL_PUL_WIDTH,
      ID_PNL_PUL_FALL,
      ID_PNL_PUL_PERIOD,

      ID_BTN_OK,
      ID_BTN_CLEAR,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_PNL_FST = ID_PNL_SIN_OFFSET,
      ID_PNL_LST = ID_PNL_PUL_PERIOD,

      ID_FST = ID_PNL_SIN_OFFSET,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // DLGNGSCFGSRC_HPP
