//**************************************************************************************************
//                                        NbkSimEngBase.hpp                                        *
//                                       -------------------                                       *
// Description : Base class for all simulator notebooks. These notebook are intended to contain    *
//               the individual analysis panels.                                                   *
// Started     : 2004-05-05                                                                        *
// Last Update : 2015-02-02                                                                        *
// Copyright   : (C) 2004 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef NBKSIMENGBASE_HPP
#define NBKSIMENGBASE_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "netlist/NetList.hpp"
#include "base/SimnBase.hpp"
#include "base/PnlAnaBase.hpp"

// wxWidgets Includes

#include <wx/notebook.h>

// Local Constant Declarations

#define  NBKSIMENG_WIDTH   572
#define  NBKSIMENG_HEIGHT  272

//**************************************************************************************************

class NbkSimEngBase : public wxNotebook
{
  protected :

    // Error message
    wxString     m_osErrMsg;

    // Attribute to identify the simulation engine type
    eTypeSimEng  m_eSimEng;

    // Enumerated type specifying the default temperature and phase units
//    static  eTypeUnits  m_eUnitsTemp; // ??? MSW 2015-02-02
    static  eTypeUnits  m_eUnitsPhase;

    // Flag to enable or disable sweep source synchronization
    static  bool        m_bSyncSwpSrcs;

  public :

                   NbkSimEngBase( wxWindow * poParent, wxWindowID oWinID );
                   NbkSimEngBase( void );
                  ~NbkSimEngBase( );

    virtual  bool  bClear( void );
             bool  bIsOk ( void )                        { return( m_osErrMsg.IsEmpty( ) ); }

    virtual  bool  bLoad( const SimnBase & roSimn ) = 0;
    virtual  bool  bSave(       SimnBase & roSimn ) = 0;

    virtual  bool  bSetPage(       eTypeCmd     eAnalysis ) = 0;
    virtual  bool  bSetPage( const wxString & rosAnalysis ) = 0;

    virtual  const  wxString & rosGetPage( void ) = 0;
    virtual         eTypeCmd     eGetPage( void ) = 0;

//    static   bool  bSetUnitsTemp  ( eTypeUnits  eUnits ); // ???  MSW 2015-02-02
    static   bool  bSetUnitsPhase ( eTypeUnits  eUnits );
    static   void   SetSyncSwpSrcs( bool        bSync  ) { m_bSyncSwpSrcs = bSync; }

             eTypeSimEng  eGetSimEng     ( void )        { return( m_eSimEng      ); }
//    static   eTypeUnits   eGetUnitsTemp  ( void )        { return( m_eUnitsTemp   ); } // ??? MSW 2015-02-02
    static   eTypeUnits   eGetUnitsPhase ( void )        { return( m_eUnitsPhase  ); }
    static   bool         bGetSyncSwpSrcs( void )        { return( m_bSyncSwpSrcs ); }

    const    wxString & rosGetErrMsg( void ) { return( m_osErrMsg ); }
             void          SetErrMsg( const wxString & rosErrMsg )
                                                         { if( bIsOk( ) ) m_osErrMsg = rosErrMsg; }

    // Event handlers
    void  OnPageChangd( wxNotebookEvent & roEvtNbk );

    // Leave this as the last line as private access is envoked by macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // NBKSIMENGBASE_HPP
