// Copyright 2018 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package inet

import (
	"gvisor.dev/gvisor/pkg/context"
)

// contextID is the inet package's type for context.Context.Value keys.
type contextID int

const (
	// CtxStack is a Context.Value key for a network stack.
	CtxStack contextID = iota
	// CtxNamespaceByFD is a Context.Value key for NamespaceByFD.
	CtxNamespaceByFD
)

// StackFromContext returns the network stack associated with ctx.
func StackFromContext(ctx context.Context) Stack {
	if v := ctx.Value(CtxStack); v != nil {
		return v.(Stack)
	}
	return nil
}

// NamespaceByFD returns the network namespace associated with the specified
// file descriptor.
type NamespaceByFD = func(fd int32) (*Namespace, error)

// NamespaceByFDFromContext returns NamespaceByFD to lookup the network
// namespace associated with the specified file descriptor.
func NamespaceByFDFromContext(ctx context.Context) NamespaceByFD {
	if v := ctx.Value(CtxNamespaceByFD); v != nil {
		return v.(NamespaceByFD)
	}
	return nil
}
