// Code generated by "./generator ./com.deepin.daemon.gesture"; DO NOT EDIT.

package gesture

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"pkg.deepin.io/lib/dbusutil"
	"pkg.deepin.io/lib/dbusutil/proxy"
)

type Gesture struct {
	gesture // interface com.deepin.daemon.Gesture
	proxy.Object
}

func NewGesture(conn *dbus.Conn) *Gesture {
	obj := new(Gesture)
	obj.Object.Init_(conn, "com.deepin.daemon.Gesture", "/com/deepin/daemon/Gesture")
	return obj
}

type gesture struct{}

func (v *gesture) GetObject_() *proxy.Object {
	return (*proxy.Object)(unsafe.Pointer(v))
}

func (*gesture) GetInterfaceName_() string {
	return "com.deepin.daemon.Gesture"
}

// method SetShortPressDuration

func (v *gesture) GoSetShortPressDuration(flags dbus.Flags, ch chan *dbus.Call, duration uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetShortPressDuration", flags, ch, duration)
}

func (v *gesture) SetShortPressDuration(flags dbus.Flags, duration uint32) error {
	return (<-v.GoSetShortPressDuration(flags, make(chan *dbus.Call, 1), duration).Done).Err
}

// method SetEdgeMoveStopDuration

func (v *gesture) GoSetEdgeMoveStopDuration(flags dbus.Flags, ch chan *dbus.Call, duration uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetEdgeMoveStopDuration", flags, ch, duration)
}

func (v *gesture) SetEdgeMoveStopDuration(flags dbus.Flags, duration uint32) error {
	return (<-v.GoSetEdgeMoveStopDuration(flags, make(chan *dbus.Call, 1), duration).Done).Err
}

// signal Event

func (v *gesture) ConnectEvent(cb func(name string, direction string, fingers int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Event", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Event",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var name string
		var direction string
		var fingers int32
		err := dbus.Store(sig.Body, &name, &direction, &fingers)
		if err == nil {
			cb(name, direction, fingers)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal DbclickDown

func (v *gesture) ConnectDbclickDown(cb func(fingers int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "DbclickDown", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".DbclickDown",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var fingers int32
		err := dbus.Store(sig.Body, &fingers)
		if err == nil {
			cb(fingers)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SwipeMoving

func (v *gesture) ConnectSwipeMoving(cb func(fingers int32, accelX float64, accely float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SwipeMoving", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SwipeMoving",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var fingers int32
		var accelX float64
		var accely float64
		err := dbus.Store(sig.Body, &fingers, &accelX, &accely)
		if err == nil {
			cb(fingers, accelX, accely)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SwipeStop

func (v *gesture) ConnectSwipeStop(cb func(fingers int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SwipeStop", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SwipeStop",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var fingers int32
		err := dbus.Store(sig.Body, &fingers)
		if err == nil {
			cb(fingers)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchEdgeEvent

func (v *gesture) ConnectTouchEdgeEvent(cb func(direction string, scalex float64, scaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchEdgeEvent", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchEdgeEvent",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var direction string
		var scalex float64
		var scaley float64
		err := dbus.Store(sig.Body, &direction, &scalex, &scaley)
		if err == nil {
			cb(direction, scalex, scaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchSinglePressTimeout

func (v *gesture) ConnectTouchSinglePressTimeout(cb func(time int32, scalex float64, scaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchSinglePressTimeout", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchSinglePressTimeout",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var time int32
		var scalex float64
		var scaley float64
		err := dbus.Store(sig.Body, &time, &scalex, &scaley)
		if err == nil {
			cb(time, scalex, scaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchPressTimeout

func (v *gesture) ConnectTouchPressTimeout(cb func(fingers int32, time int32, scalex float64, scaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchPressTimeout", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchPressTimeout",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var fingers int32
		var time int32
		var scalex float64
		var scaley float64
		err := dbus.Store(sig.Body, &fingers, &time, &scalex, &scaley)
		if err == nil {
			cb(fingers, time, scalex, scaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchUpOrCancel

func (v *gesture) ConnectTouchUpOrCancel(cb func(scalex float64, scaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchUpOrCancel", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchUpOrCancel",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var scalex float64
		var scaley float64
		err := dbus.Store(sig.Body, &scalex, &scaley)
		if err == nil {
			cb(scalex, scaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchEdgeMoveStop

func (v *gesture) ConnectTouchEdgeMoveStop(cb func(direction string, scalex float64, scaley float64, duration int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchEdgeMoveStop", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchEdgeMoveStop",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var direction string
		var scalex float64
		var scaley float64
		var duration int32
		err := dbus.Store(sig.Body, &direction, &scalex, &scaley, &duration)
		if err == nil {
			cb(direction, scalex, scaley, duration)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchEdgeMoveStopLeave

func (v *gesture) ConnectTouchEdgeMoveStopLeave(cb func(direction string, scalex float64, scaley float64, duration int32)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchEdgeMoveStopLeave", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchEdgeMoveStopLeave",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var direction string
		var scalex float64
		var scaley float64
		var duration int32
		err := dbus.Store(sig.Body, &direction, &scalex, &scaley, &duration)
		if err == nil {
			cb(direction, scalex, scaley, duration)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchMoving

func (v *gesture) ConnectTouchMoving(cb func(scalex float64, scaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchMoving", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchMoving",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var scalex float64
		var scaley float64
		err := dbus.Store(sig.Body, &scalex, &scaley)
		if err == nil {
			cb(scalex, scaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchMovementEvent

func (v *gesture) ConnectTouchMovementEvent(cb func(duration string, fingers int32, startScalex float64, startScaley float64, endScalex float64, endScaley float64)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchMovementEvent", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchMovementEvent",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var duration string
		var fingers int32
		var startScalex float64
		var startScaley float64
		var endScalex float64
		var endScaley float64
		err := dbus.Store(sig.Body, &duration, &fingers, &startScalex, &startScaley, &endScalex, &endScaley)
		if err == nil {
			cb(duration, fingers, startScalex, startScaley, endScalex, endScaley)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
