#include "gm-mcp-mud-moo-simpleedit.h"
#include "gm-mcp-session.h"
#include "gm-mcp.h"
#include "gm-debug.h"
#include "gm-world.h"
#include "gm-editor.h"

#define GM_MCP_MUD_MOO_SIMPLEEDIT_GET_PRIVATE(object)( \
		G_TYPE_INSTANCE_GET_PRIVATE((object), \
		GM_TYPE_MCP_MUD_MOO_SIMPLEEDIT, GmMcpMudMooSimpleeditPrivate))

struct _GmMcpMudMooSimpleeditPrivate {
	gchar *ref;
	gchar *name;
	gchar *type;
	
	GSList *editors;
};

/* Signals

enum {
	PROTO
	NUM_SIGNALS
};

static guint gm_mcp_mud_moo_simpleedit_signals[NUM_SIGNALS] = {0};*/

G_DEFINE_TYPE(GmMcpMudMooSimpleedit, gm_mcp_mud_moo_simpleedit, GM_TYPE_MCP_PACKAGE)

void gm_mcp_mud_moo_simpleedit_set_session(GmMcpPackage *package, GObject *session);
void gm_mcp_mud_moo_simpleedit_handle_simple(GmMcpPackage *package, 
		gchar *suffix, GList *fields);
gboolean gm_mcp_mud_moo_simpleedit_handle_multi(GmMcpPackage *package,
		gchar const *data_tag, gchar const *key, gchar const *value,
		GList *all_values);
void on_gm_mcp_mud_moo_simpleedit_editor_save(GmEditor *editor, 
		GmMcpMudMooSimpleedit *package);
		
static void
gm_mcp_mud_moo_simpleedit_remove_editor(GmMcpMudMooSimpleedit *simpleedit,
		GmEditor *editor) {
	g_signal_handlers_disconnect_by_func(editor, 
			on_gm_mcp_mud_moo_simpleedit_editor_save, simpleedit);
	
	simpleedit->priv->editors = g_slist_remove(simpleedit->priv->editors, 
			editor);
}

static void
gm_mcp_mud_moo_simpleedit_finalize(GObject *object) {
	GmMcpMudMooSimpleedit *obj = GM_MCP_MUD_MOO_SIMPLEEDIT(object);
	
	g_free(obj->priv->ref);
	g_free(obj->priv->name);
	g_free(obj->priv->type);

	while (obj->priv->editors) {
		g_object_weak_unref(G_OBJECT(obj->priv->editors->data), 
			(GWeakNotify)gm_mcp_mud_moo_simpleedit_remove_editor, obj);

		gm_mcp_mud_moo_simpleedit_remove_editor(obj, 
				GM_EDITOR(obj->priv->editors->data));
	}

	G_OBJECT_CLASS(gm_mcp_mud_moo_simpleedit_parent_class)->finalize(object);
}

static void
gm_mcp_mud_moo_simpleedit_class_init(GmMcpMudMooSimpleeditClass *klass) {
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	GmMcpPackageClass *pklass = GM_MCP_PACKAGE_CLASS(klass);
	
	object_class->finalize = gm_mcp_mud_moo_simpleedit_finalize;

	/*gm_mcp_mud_moo_simpleedit_signals[PROTO] = 
		g_signal_new("proto",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmMcpMudMooSimpleeditClass, proto),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0);*/
			
	pklass->name = "dns-org-mud-moo-simpleedit";
	pklass->set_session = gm_mcp_mud_moo_simpleedit_set_session;
	pklass->handle_simple = gm_mcp_mud_moo_simpleedit_handle_simple;
	pklass->handle_multi = gm_mcp_mud_moo_simpleedit_handle_multi;

	g_type_class_add_private(object_class, sizeof(GmMcpMudMooSimpleeditPrivate));
}

static void
gm_mcp_mud_moo_simpleedit_init(GmMcpMudMooSimpleedit *obj) {
	obj->priv = GM_MCP_MUD_MOO_SIMPLEEDIT_GET_PRIVATE(obj);
}

GmMcpMudMooSimpleedit *
gm_mcp_mud_moo_simpleedit_new() {
	GmMcpMudMooSimpleedit *obj = GM_MCP_MUD_MOO_SIMPLEEDIT(g_object_new(GM_TYPE_MCP_MUD_MOO_SIMPLEEDIT, NULL));
	
	return obj;
}

void
gm_mcp_mud_moo_simpleedit_handle_simple(GmMcpPackage *package, 
		gchar *suffix, GList *fields) {
	gchar const *name, *ref, *type;
	GmMcpMudMooSimpleedit *simpleedit = GM_MCP_MUD_MOO_SIMPLEEDIT(package);
	
	if (g_strcasecmp(suffix, "content") == 0) {
		if (!(name = gm_mcp_find_value(fields, "name"))) {
			gm_debug_msg(DEBUG_MCP, "GmMcpMooMudSimpleedit.HandleSimple: "
					"no name found, ignoring!");
		} else if (!(ref = gm_mcp_find_value(fields, "reference"))) {
			gm_debug_msg(DEBUG_MCP, "GmMcpMooMudSimpleedit.HandleSimple: "
					"no reference found, ignoring!");
		} else if (!(type = gm_mcp_find_value(fields, "type"))) {
			gm_debug_msg(DEBUG_MCP, "GmMcpMooMudSimpleedit.HandleSimple: "
					"no type found, ignoring!");
		} else {
			gm_debug_msg(DEBUG_MCP, "GmMcpMooMudSimpleedit.HandleSimple: "
					"accept content: name = %s, reference = %s, type = %s",
					name, ref, type);
			simpleedit->priv->name = g_strdup(name);
			simpleedit->priv->ref = g_strdup(ref);
			simpleedit->priv->type = g_strdup(type);
		}
	} else {
		gm_debug_msg(DEBUG_MCP, "GmMcpMooMudSimpleedit.HandleSimple: "
				"unknown suffix: %s", suffix);
	}
}

static void
gm_mcp_mud_moo_simpleedit_add_editor(GmMcpMudMooSimpleedit *package, 
		GmEditor *editor) {
	g_signal_connect(editor, "save", 
			G_CALLBACK(on_gm_mcp_mud_moo_simpleedit_editor_save), package);
	
	package->priv->editors = g_slist_prepend(package->priv->editors, editor);
	g_object_weak_ref(G_OBJECT(editor), 
			(GWeakNotify)gm_mcp_mud_moo_simpleedit_remove_editor, package);
}

gboolean
gm_mcp_mud_moo_simpleedit_handle_multi(GmMcpPackage *package,
		gchar const *data_tag, gchar const *key, gchar const *value,
		GList *all_values) {
	GmEditor *editor;
	GmMcpMudMooSimpleedit *simpleedit = GM_MCP_MUD_MOO_SIMPLEEDIT(package);
	
	if (key) {
		return FALSE;
	} else {
		// All values arrived! Yeah!
		editor = gm_editor_new_mcp(simpleedit->priv->name, 
				simpleedit->priv->ref, simpleedit->priv->type, all_values);
		
		gm_mcp_mud_moo_simpleedit_add_editor(simpleedit, editor);
		gm_world_add_editor(GM_MCP_SESSION_WORLD(GM_MCP_PACKAGE_SESSION(
				package)), editor);
	}

	return TRUE;
}

void
gm_mcp_mud_moo_simpleedit_set_session(GmMcpPackage *package, GObject *session) {
	GmMcpPackageClass *parent_class = g_type_class_peek_parent(
			GM_MCP_MUD_MOO_SIMPLEEDIT_GET_CLASS(package));	
	GSList const *editors = gm_world_editors(GM_MCP_SESSION_WORLD(
			GM_MCP_SESSION(session)));
	GmMcpMudMooSimpleedit *simpleedit = GM_MCP_MUD_MOO_SIMPLEEDIT(package);

	parent_class->set_session(package, session);
	
	for (; editors; editors = editors->next) {
		gm_mcp_mud_moo_simpleedit_add_editor(simpleedit, 
				GM_EDITOR(editors->data));
	}
}

/* Callbacks */
void
on_gm_mcp_mud_moo_simpleedit_editor_save(GmEditor *editor, 
		GmMcpMudMooSimpleedit *package) {
	GmMcpSession *session = GM_MCP_PACKAGE_SESSION(package);
	gchar *data_tag = gm_mcp_generate_data_tag();

	if (session) {
		gm_mcp_session_send_simple(session, "dns-org-mud-moo-simpleedit-set", 
				"reference", gm_editor_upload_cmd(editor), "type", 
				gm_editor_mcp_type(editor), "content*", "", "_data-tag",
				data_tag, NULL);
		gm_mcp_session_send_multiline(session, data_tag, "content", 
				gm_editor_lines(editor));
		gm_editor_saved(editor);
	}

	g_free(data_tag);
}
