#!/bin/sh

user=gitlab
dbname=gitlab_production

# If gitlab user cannot access gitlab_production,
# then it means the gitlab role does not exist
if ! su gitlab -c 'psql gitlab_production -c ""'
then
	echo "Create $user user with create database privillege..."
	su postgres -c "psql -c \"CREATE USER $user CREATEDB;\"" || {
	  exit 1 
	  }
fi

# By default the gitlab_prodcution is not owned by gitlab user
echo "Make $user user owner of $dbname database..."
su postgres -c "psql -c \"ALTER DATABASE $dbname OWNER to $user;\"" || {
  exit 1 
  }

echo "Grant all privileges to $user user..."
su postgres -c "psql -c \"GRANT ALL PRIVILEGES ON DATABASE template1 to $user;\"" || {
  exit 1
  }
