/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.BinaryBlock;
import java.io.IOException;
import java.io.InputStream;

public class FirstMetaBlock
extends BinaryBlock {
    int version;
    int szGroup;
    long beginDate;
    long beginDate_unix_seconds;
    long beginDate_unix_useconds;
    long groupInterval;
    long groupInterval_unix_seconds;
    long groupInterval_unix_useconds;

    public int getDataBlockGroupSize() {
        return this.szGroup;
    }

    public String asDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# First Meta Block\n");
        stringBuffer.append("VersionOfFormat::");
        stringBuffer.append(this.version);
        stringBuffer.append('\n');
        stringBuffer.append("SizeOfDataBlockGroup::");
        stringBuffer.append(this.szGroup);
        stringBuffer.append('\n');
        stringBuffer.append("StartedDateTimeInUNIXSeconds::");
        stringBuffer.append(this.beginDate_unix_seconds);
        stringBuffer.append('\n');
        stringBuffer.append("StartedDateTimeInUNIXuSeconds::");
        stringBuffer.append(this.beginDate_unix_useconds);
        stringBuffer.append('\n');
        stringBuffer.append("DataBlockGroupIntervalInUNIXSeconds::");
        stringBuffer.append(this.groupInterval_unix_seconds);
        stringBuffer.append('\n');
        stringBuffer.append("DataBlockGroupIntervalInUNIXuSeconds::");
        stringBuffer.append(this.groupInterval_unix_useconds);
        return stringBuffer.toString();
    }

    protected void parse_binary_block(InputStream inputStream) throws IOException {
        this.version = this.read2bytesInt(inputStream);
        this.szGroup = this.read4bytesInt(inputStream);
        this.beginDate_unix_seconds = this.read4bytesInt(inputStream);
        this.beginDate_unix_useconds = this.read4bytesInt(inputStream);
        this.beginDate = this.beginDate_unix_seconds * 1000L;
        this.beginDate += this.beginDate_unix_useconds / 1000L;
        this.groupInterval_unix_seconds = this.read4bytesInt(inputStream);
        this.groupInterval_unix_useconds = this.read4bytesInt(inputStream);
        this.groupInterval = this.groupInterval_unix_seconds * 1000L;
        this.groupInterval += this.groupInterval_unix_useconds / 1000L;
        this.valid = true;
    }

    public static FirstMetaBlock newInstance(InputStream inputStream, int n) throws IOException {
        FirstMetaBlock firstMetaBlock = new FirstMetaBlock();
        firstMetaBlock.deserialize(inputStream, n);
        return firstMetaBlock;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSizeOfGroup() {
        return this.szGroup;
    }

    public long getBeginDate() {
        return this.beginDate;
    }

    public long getGroupInterval() {
        return this.groupInterval;
    }
}

