/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.parameters;

import geotrans3.parameters.CoordinateSystemParameters;

public class PolarStereographicScaleFactorParameters
extends CoordinateSystemParameters {
    private double centralMeridian;
    private double scaleFactor;
    private char hemisphere;
    private double falseEasting;
    private double falseNorthing;

    public PolarStereographicScaleFactorParameters(int n, double d, double d2, char c, double d3, double d4) {
        super(n);
        this.centralMeridian = d;
        this.scaleFactor = d2;
        this.hemisphere = c;
        this.falseEasting = d3;
        this.falseNorthing = d4;
    }

    public boolean equal(PolarStereographicScaleFactorParameters polarStereographicScaleFactorParameters) {
        return super.equal(polarStereographicScaleFactorParameters) && this.centralMeridian == polarStereographicScaleFactorParameters.getCentralMeridian() && this.scaleFactor == polarStereographicScaleFactorParameters.getScaleFactor() && this.hemisphere == polarStereographicScaleFactorParameters.getHemisphere() && this.falseEasting == polarStereographicScaleFactorParameters.getFalseEasting() && this.falseNorthing == polarStereographicScaleFactorParameters.getFalseNorthing();
    }

    public double getCentralMeridian() {
        return this.centralMeridian;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public char getHemisphere() {
        return this.hemisphere;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public String toString() {
        return "PolarStereographicScaleFactorParameters: CentralMeridian = " + this.centralMeridian + " ScaleFactor = " + this.scaleFactor + " Hemisphere = " + this.hemisphere + " FalseEasting = " + this.falseEasting + " FalseNorthing = " + this.falseNorthing;
    }
}

