//
// File: PanelChoixImages.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 24 15:58:08 2006
//

#include "PanelChoixImages.h"

#include <wx/dir.h>

class wxDirTraverserSimple : public wxDirTraverser 
{ 
public: 
    wxDirTraverserSimple(wxArrayString& files, wxArrayString &dirs) : m_files(files),  
                                                                      m_dir(dirs) 
    {  
     
    } 
virtual wxDirTraverseResult OnFile(const wxString& filename) 
{ 
    m_files.Add(filename); 
    return wxDIR_CONTINUE; 
} 

virtual wxDirTraverseResult OnDir(const wxString& dirname) 
{ 
    m_dir.Insert(dirname, 0); 
    return wxDIR_CONTINUE; 
} 
 
 
    private: 
        wxArrayString &m_files; 
        wxArrayString &m_dir; 
}; 

PanelChoixImages::PanelChoixImages(wxWindow* parent, int id):wxPanel(parent, id)
{
    mon_parent=parent;
    // sizer de choix du répertoire
    label_repertoire= new wxStaticText(this, -1, wxT("Répertoire Source: "));
    text_ctrl_repertoire= new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
    button_choix_repertoire= new wxButton(this, -1, wxT("Choisir"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);    
    sizer_panel_saisie_repertoire= new wxBoxSizer(wxHORIZONTAL);
    sizer_panel_saisie_repertoire->Add(label_repertoire, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_repertoire->Add(text_ctrl_repertoire, 1, wxALL|wxEXPAND|wxALIGN_BOTTOM|wxALIGN_CENTER_HORIZONTAL|wxADJUST_MINSIZE, 2);
    sizer_panel_saisie_repertoire->Add(button_choix_repertoire, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);

    checkbox_parcours_recursif= new wxCheckBox(this, -1, wxT("Parcours Récursif."));

    // on ajoute le sizer de choix du répertoire et la checkbox au sizer du panel
    sizer_panel_choix_images= new wxBoxSizer(wxVERTICAL);
    sizer_panel_choix_images->Add(sizer_panel_saisie_repertoire, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    sizer_panel_choix_images->Add(checkbox_parcours_recursif, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);

    SetSizer(sizer_panel_choix_images);

    checkbox_parcours_recursif->Hide();

	// on connecte les événements
	Connect(button_choix_repertoire->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelChoixImages::on_click_button_choix_repertoire);    
	Connect(checkbox_parcours_recursif->GetId( ), wxEVT_COMMAND_CHECKBOX_CLICKED, 
											(wxObjectEventFunction) &PanelChoixImages::on_click_checkbox_parcours_recursif);    

}


PanelChoixImages::~PanelChoixImages()
{
	// TODO: put destructor code here
}

wxString PanelChoixImages::GetRepertoireSource(int numero)
{
    repertoires.Sort();
    return repertoires[numero];
}

wxString PanelChoixImages::GetNomSousRepertoire(int numero)
{
    noms_sous_repertoires.Sort();
    return noms_sous_repertoires[numero];
}

unsigned int PanelChoixImages::GetNombreRepertoires()
{
    return repertoires.GetCount();
}

void PanelChoixImages::on_click_button_choix_repertoire(wxCommandEvent& event)
{
	wxString  chemin_par_defaut(text_ctrl_repertoire->GetValue());
    if (chemin_par_defaut.IsSameAs(wxT(""))) chemin_par_defaut=wxGetCwd(); 
        
	wxDirDialog dialog (this,wxT("Choisissez le répertoire source"),chemin_par_defaut, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER);
	if (dialog.ShowModal()==wxID_OK) 
	{
		text_ctrl_repertoire->SetValue(dialog.GetPath());
        checkbox_parcours_recursif->Show(true);
        checkbox_parcours_recursif->SetValue(false);
        mon_parent->Layout();
        // on ajoute par défaut le répertoire source de base
        repertoires.Add(text_ctrl_repertoire->GetValue());
        noms_sous_repertoires.Add(wxT("/"));    
	}
}	

void PanelChoixImages::on_click_checkbox_parcours_recursif(wxCommandEvent& event)
{
    repertoires.Clear();
    noms_sous_repertoires.Clear();
    files.Clear();
    if (checkbox_parcours_recursif->IsChecked())
    {
        // on recherche tous les sous-répertoires à partir du répertoire source
        wxDir m_dir(text_ctrl_repertoire->GetValue()); // le répertoire source de base est le repertoire root du parsing 
        wxDirTraverserSimple traverser(files, repertoires); 
        m_dir.Traverse(traverser); 
        // on extrait les sous_repertoires par rapport au répertoire source de base
        for (unsigned int i=0;i<repertoires.GetCount();i++)
        {
            noms_sous_repertoires.Add(repertoires[i].Right(repertoires[i].Len()-text_ctrl_repertoire->GetValue().Len()));
        }   
    }
    // on rajoute le répertoire source de base
    repertoires.Add(text_ctrl_repertoire->GetValue());
    noms_sous_repertoires.Add(wxT("/"));    
}
