/**
* Copyright 1981-2012 ECMWF.
*
* This software is licensed under the terms of the Apache Licence 
* Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
*
* In applying this licence, ECMWF does not waive the privileges and immunities 
* granted to it by virtue of its status as an intergovernmental organisation 
* nor does it submit to any jurisdiction.
*/

#include <stdio.h>
#include <sys/times.h>
#include <time.h>

#ifndef CRAY
#include <unistd.h>
#endif

#ifndef CRAY
#ifdef FORTRAN_NO_UNDERSCORE
#define JTIMER jtimer
#else
#define JTIMER jtimer_
#endif
#endif

void JTIMER(const long * param)
{
static struct tms before, after;
static time_t utime, stime;
static long startime, endtime;

/*  If input parameter is zero, initialise the time record */
    if ( *param == 0 )
    {
      startime = times(&before);
    }

/*  Otherwise, publish elapsed time since last initialisation */
    else
    {
      endtime = times(&after);
  
      utime = after.tms_utime - before.tms_utime;
      stime = after.tms_stime - before.tms_stime;
/* Sinisa  CLOCKS_PER_SEC
    The value of this macro is the number of clock ticks per second measured by the clock function. 

	int CLK_TCK is an obsolete name for CLOCKS_PER_SEC. 
*/
      printf("CPU time used in user space = %f sec\n", 
             (float) utime/(float)CLOCKS_PER_SEC);
      printf("CPU time used by the system = %f sec\n", 
             (float) stime/(float)CLOCKS_PER_SEC);
      printf("Wall clock time used by process = %f sec\n", 
             (float) (endtime - startime)/(float)CLOCKS_PER_SEC);
    }

    return;

}
