/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner;

import gnu.bioinformatics.jaligner.algorithms.SmithWaterman;
import gnu.bioinformatics.jaligner.exceptions.ParserException;
import gnu.bioinformatics.jaligner.formats.FASTA;
import gnu.bioinformatics.jaligner.formats.Pair;
import gnu.bioinformatics.jaligner.gui.JAlignerWindow;
import gnu.bioinformatics.jaligner.util.Alignment;
import gnu.bioinformatics.jaligner.util.Matrices;
import gnu.bioinformatics.jaligner.util.Parser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Date;

public class JAligner {
    public static final String ALGORITHM_SMITH_WATERMAN = "sw";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new JAlignerWindow().show();
            } else if (args[0].equalsIgnoreCase(ALGORITHM_SMITH_WATERMAN)) {
                if (args.length != 6) {
                    System.err.println("Invalid number of arguments for Smith-Waterman algorithm");
                    JAligner.printUsage();
                    System.exit(1);
                }
                String s1 = args[1];
                String s2 = args[2];
                String matrix = args[3];
                float open = Float.parseFloat(args[4]);
                float extend = Float.parseFloat(args[5]);
                FASTA fasta1 = Parser.loadFASTA(s1);
                FASTA fasta2 = Parser.loadFASTA(s2);
                JAligner.printHeader();
                Alignment alignment = JAligner.sw(fasta1, fasta2, matrix, open, extend);
                JAligner.printStatistics(alignment, matrix, open, extend);
                Pair.print(alignment);
                JAligner.printTailer();
            } else {
                System.err.println("Invalid algorithm: " + args[0]);
                JAligner.printUsage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gnu.bioinformatics.jaligner.JAligner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(clazz.getName());
        System.out.println("$Revision: 1.7 $");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("------");
        System.out.println("Smith-Waterman:");
        System.out.println("---------------");
        StringBuffer stringBuffer = new StringBuffer("java -classpath jaligner.jar ");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gnu.bioinformatics.jaligner.JAligner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer.append(clazz2.getName()).append(" sw <s1> <s2> <matrix> <open> <extend>").toString());
        System.out.println();
        System.out.println("Example:");
        System.out.println("--------");
        StringBuffer stringBuffer2 = new StringBuffer("java -classpath jaligner.jar ");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("gnu.bioinformatics.jaligner.JAligner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer2.append(clazz3.getName()).append(" sw s1.fasta s2.fasta BLOSUM62 10.0 0.5").toString());
        System.out.println();
    }

    private static void printHeader() {
        System.out.println("########################################");
        StringBuffer stringBuffer = new StringBuffer("# Program:\t");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gnu.bioinformatics.jaligner.JAligner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer.append(clazz.getName()).toString());
        System.out.println("# Rundate:\t" + new Date().toString());
        System.out.println("# Report_file:\tstdout");
        System.out.println("########################################");
    }

    private static void printStatistics(Alignment alignment, String matrix, float open, float extend) {
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("0.00%");
        int length = alignment.getSequence1().length;
        int identity = alignment.getIdentity();
        int similarity = alignment.getSimilarity();
        int gaps = alignment.getGaps();
        float score = alignment.getScore();
        System.out.println("#=======================================");
        System.out.println("#");
        System.out.println("# Aligned_sequences: 2");
        System.out.println("# 1: " + alignment.getName1());
        System.out.println("# 2: " + alignment.getName2());
        System.out.println("# Matrix: " + matrix);
        System.out.println("# Gap_penalty: " + open);
        System.out.println("# Extend_penalty: " + extend);
        System.out.println("#");
        System.out.println("# Length: " + length);
        System.out.println("# Identity: " + identity + "/" + length + " (" + f2.format((float)identity / (float)length) + ")");
        System.out.println("# Similarity: " + similarity + "/" + length + " (" + f2.format((float)similarity / (float)length) + ")");
        System.out.println("# Gaps: " + gaps + "/" + length + " (" + f2.format((float)gaps / (float)length) + ")");
        System.out.println("# Score: " + f1.format(alignment.getScore()));
        System.out.println("#");
        System.out.println("#");
        System.out.println("#=======================================");
    }

    private static void printTailer() {
        System.out.println("#---------------------------------------");
        System.out.println("# Finished:\t" + new Date().toString());
        System.out.println("#---------------------------------------");
    }

    public static Alignment sw(InputStream is1, InputStream is2, String matrix, float open, float extend) throws ParserException, FileNotFoundException, IOException {
        FASTA fasta1 = Parser.loadFASTA(is1);
        FASTA fasta2 = Parser.loadFASTA(is2);
        return JAligner.sw(fasta1, fasta2, matrix, open, extend);
    }

    public static Alignment sw(File file1, File file2, String matrix, float open, float extend) throws ParserException, FileNotFoundException, IOException {
        FASTA fasta1 = Parser.loadFASTA(file1);
        FASTA fasta2 = Parser.loadFASTA(file2);
        return JAligner.sw(fasta1, fasta2, matrix, open, extend);
    }

    public static Alignment sw(FASTA fasta1, FASTA fasta2, String matrix, float open, float extend) throws ParserException, FileNotFoundException, IOException {
        char[] sequence1 = fasta1.getSequence();
        char[] sequence2 = fasta2.getSequence();
        Alignment alignment = JAligner.sw(sequence1, sequence2, matrix, open, extend);
        alignment.setName1(fasta1.getName());
        alignment.setName2(fasta2.getName());
        return alignment;
    }

    public static Alignment sw(String sequence1, String sequence2, String matrix, float open, float extend) throws ParserException, FileNotFoundException, IOException {
        char[] array1 = Parser.prepareSequence(sequence1);
        char[] array2 = Parser.prepareSequence(sequence2);
        return SmithWaterman.align(array1, array2, Matrices.getInstance().get(matrix), open, extend);
    }

    public static Alignment sw(char[] sequence1, char[] sequence2, String matrix, float open, float extend) throws ParserException, FileNotFoundException, IOException {
        char[] array1 = Parser.prepareSequence(sequence1);
        char[] array2 = Parser.prepareSequence(sequence2);
        return SmithWaterman.align(array1, array2, Matrices.getInstance().get(matrix), open, extend);
    }
}

