;
; Copyright (c) 2004, Intel Corporation. All rights reserved.<BR>
; This program and the accompanying materials                          
; are licensed and made available under the terms and conditions of the BSD License         
; which accompanies this distribution.  The full text of the license may be found at        
; http://opensource.org/licenses/bsd-license.php                                            
;                                                                                           
; THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,                     
; WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.             
; 
; Module Name:
; 
;    ProcessorAsms.Asm
;
; Abstract:
;       This is separated from processor.c to allow this functions to be built with /O1
;
; Notes:
; - Masm uses "This", "ebx", etc as a directive.
; - H2INC is still not embedded in our build process so I translated the struc manually.
; - Unreferenced variables/arguments (This, NewBsp, NewStack) were causing compile errors and 
;       did not know of "pragma" mechanism in MASM and I did not want to reduce the warning level. 
;       Instead, I did a dummy referenced.
;

  .686P
  .MMX
  .MODEL SMALL
  .CODE

EFI_SUCCESS                     equ     0
EFI_WARN_RETURN_FROM_LONG_JUMP  equ     5

;
; Generated by h2inc run manually
;
_EFI_JUMP_BUFFER                STRUCT 2t
_ebx            DWORD           ?
_esi            DWORD           ?
_edi            DWORD           ?
_ebp            DWORD           ?
_esp            DWORD           ?
_eip            DWORD           ?
_EFI_JUMP_BUFFER                ENDS

EFI_JUMP_BUFFER         TYPEDEF         _EFI_JUMP_BUFFER

TransferControlSetJump      PROTO  C \
        _This:PTR EFI_PEI_TRANSFER_CONTROL_PROTOCOL, \
        Jump:PTR EFI_JUMP_BUFFER

TransferControlLongJump     PROTO  C \
        _This:PTR EFI_PEI_TRANSFER_CONTROL_PROTOCOL, \
        Jump:PTR EFI_JUMP_BUFFER

SwitchStacks    PROTO  C \
   EntryPoint:PTR DWORD, \
   Parameter:DWORD, \
   NewStack:PTR DWORD, \
   NewBsp:PTR DWORD
   
SwitchIplStacks PROTO  C \
   EntryPoint:PTR DWORD, \
   Parameter1:DWORD, \
   Parameter2:DWORD, \
   NewStack:PTR DWORD, \
   NewBsp:PTR DWORD

;
;Routine Description:
;
;  This routine implements the IA32 variant of the SetJump call.  Its
;  responsibility is to store system state information for a possible
;  subsequent LongJump.
;
;Arguments:
;
;  Pointer to CPU context save buffer.
;
;Returns:
;
;  EFI_SUCCESS
;
TransferControlSetJump      PROC  C \
  _This:PTR EFI_PEI_TRANSFER_CONTROL_PROTOCOL, \
  Jump:PTR EFI_JUMP_BUFFER
    
  mov   eax, _This 
  mov   ecx, Jump
  mov   (EFI_JUMP_BUFFER PTR [ecx])._ebx, ebx
  mov   (EFI_JUMP_BUFFER PTR [ecx])._esi, esi
  mov   (EFI_JUMP_BUFFER PTR [ecx])._edi, edi
  mov   eax, [ebp]
  mov   (EFI_JUMP_BUFFER PTR [ecx])._ebp, eax
  lea   eax, [ebp+4]
  mov   (EFI_JUMP_BUFFER PTR [ecx])._esp, eax
  mov   eax, [ebp+4]
  mov   (EFI_JUMP_BUFFER PTR [ecx])._eip, eax
  mov   eax, EFI_SUCCESS
  
  ret
  
TransferControlSetJump      ENDP

;
; Routine Description:
; 
;  This routine implements the IA32 variant of the LongJump call.  Its
;  responsibility is restore the system state to the Context Buffer and
;  pass control back.
;
; Arguments:
; 
;  Pointer to CPU context save buffer.
;
; Returns:
;
;  EFI_WARN_RETURN_FROM_LONG_JUMP
;

TransferControlLongJump     PROC  C \
        _This:PTR EFI_PEI_TRANSFER_CONTROL_PROTOCOL, \
        Jump:PTR EFI_JUMP_BUFFER

  push  ebx
  push  esi
  push  edi

  mov   eax, _This
    ; set return from SetJump to EFI_WARN_RETURN_FROM_LONG_JUMP
  mov   eax, EFI_WARN_RETURN_FROM_LONG_JUMP          
  mov   ecx, Jump
  mov   ebx, (EFI_JUMP_BUFFER PTR [ecx])._ebx
  mov   esi, (EFI_JUMP_BUFFER PTR [ecx])._esi
  mov   edi, (EFI_JUMP_BUFFER PTR [ecx])._edi
  mov   ebp, (EFI_JUMP_BUFFER PTR [ecx])._ebp
  mov   esp, (EFI_JUMP_BUFFER PTR [ecx])._esp
  add   esp, 4                                       ;pop the eip
  jmp   DWORD PTR (EFI_JUMP_BUFFER PTR [ecx])._eip
  mov   eax, EFI_WARN_RETURN_FROM_LONG_JUMP
  
  pop   edi
  pop   esi
  pop   ebx
  ret
  
TransferControlLongJump     ENDP

;
; Routine Description:
;       This allows the caller to switch the stack and goes to the new entry point
;
; Arguments:
;       EntryPoint      - Pointer to the location to enter
;       Parameter       - Parameter to pass in
;       NewStack        - New Location of the stack
;       NewBsp          - New BSP
;
; Returns:
;
;       Nothing. Goes to the Entry Point passing in the new parameters
;
SwitchStacks    PROC  C \
  EntryPoint:PTR DWORD, \
  Parameter:DWORD, \
  NewStack:PTR DWORD, \
  NewBsp:PTR DWORD
  
  push  ebx
  mov   eax, NewBsp
  mov   ebx, Parameter
  mov   ecx, EntryPoint
  mov   eax, NewStack
  mov   esp, eax
  push  ebx
  push  0
  jmp   ecx
  
  pop   ebx
  ret
  
SwitchStacks    ENDP

;
; Routine Description:
;       This allows the caller to switch the stack and goes to the new entry point
;
; Arguments:
;       EntryPoint              - Pointer to the location to enter
;       Parameter1/Parameter2   - Parameter to pass in
;       NewStack                - New Location of the stack
;       NewBsp                  - New BSP
;
; Returns:
;
;       Nothing. Goes to the Entry Point passing in the new parameters
;
SwitchIplStacks PROC  C \
  EntryPoint:PTR DWORD, \
  Parameter1:DWORD, \
  Parameter2:DWORD, \
  NewStack:PTR DWORD, \
  NewBsp:PTR DWORD
  
  push  ebx
  mov   eax, NewBsp         
  mov   ebx, Parameter1
  mov   edx, Parameter2
  mov   ecx, EntryPoint
  mov   eax, NewStack
  mov   esp, eax

  push  edx
  push  ebx
  call  ecx
  
  pop   ebx
  ret
  
SwitchIplStacks ENDP

  END

