/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.FileSource;
import dumphd.util.MessagePrinter;
import dumphd.util.PESPack;
import dumphd.util.PESParserException;
import dumphd.util.PrintStreamPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class PackScanner {
    public static final int SCAN_MODE = 0;
    public static final int EDIT_MODE = 1;
    private MessagePrinter out = null;
    private int mode = 0;
    private boolean quickScan = false;
    private boolean blanking = false;
    private boolean reverting = false;
    private boolean navFix = false;
    private boolean zeroCPI = false;
    private boolean logging = false;
    private PrintWriter logger = null;

    public PackScanner(MessagePrinter mp) {
        this.out = mp;
    }

    public boolean scan(String inFileName) {
        File inFileAbsolute = new File(inFileName).getAbsoluteFile();
        FileSource inFile = null;
        this.out.println("File   : " + inFileAbsolute.getPath());
        try {
            if (this.mode == 1) {
                this.out.println("Mode   : EDIT_MODE");
                inFile = new FileSource(inFileAbsolute, 2);
            } else {
                this.out.println("Mode   : SCAN_MODE");
                inFile = new FileSource(inFileAbsolute, 0);
            }
        }
        catch (FileNotFoundException e) {
            this.out.println("Could not open input file: " + e.getMessage());
            return false;
        }
        boolean noOptions = true;
        this.out.println("Options:");
        if (this.quickScan) {
            noOptions = false;
            this.out.println("  QuickScan");
        }
        if (this.blanking) {
            noOptions = false;
            this.out.println("  Blanking");
        }
        if (this.reverting) {
            noOptions = false;
            this.out.println("  Reverting");
        }
        if (this.navFix) {
            noOptions = false;
            this.out.println("  Nav chain bugfix");
        }
        if (this.zeroCPI) {
            noOptions = false;
            this.out.println("  Zero CPI field");
        }
        if (this.logging) {
            noOptions = false;
            this.out.println("  Logging");
            try {
                this.logger = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(new File(inFileName).getName()) + ".log")));
            }
            catch (IOException e) {
                this.out.println("Could not open log file: " + e.getMessage());
                try {
                    inFile.close();
                }
                catch (IOException e2) {
                    this.out.println("Error closing input file: " + e2.getMessage());
                }
                return false;
            }
        }
        if (noOptions) {
            this.out.println("  NONE");
        }
        this.out.println();
        long offset = 0L;
        byte[] packData = new byte[2048];
        PESPack pack = new PESPack();
        boolean returnResult = true;
        String msg = null;
        boolean writeBackPack = false;
        TreeMap<String, Counter> packTable = new TreeMap<String, Counter>();
        this.out.println("Starting scan: " + new Date());
        try {
            while (inFile.read(packData, 0, packData.length) != -1) {
                block42: {
                    try {
                        pack.parse(packData, 0, this.quickScan);
                        if (pack.isNavPck()) {
                            if (this.navFix) {
                                packData[1302] = 127;
                                writeBackPack = true;
                            }
                            if (this.zeroCPI) {
                                int i = 60;
                                while (i < 76) {
                                    packData[i] = 0;
                                    ++i;
                                }
                                writeBackPack = true;
                            }
                        } else {
                            PESPack.PESPacket firstPacket = pack.getPacket(0);
                            if (this.blanking) {
                                if (firstPacket.getStreamId() == 189 && firstPacket.getSubstreamId() == 200) {
                                    firstPacket.setStreamId(0);
                                    writeBackPack = true;
                                } else if (firstPacket.getStreamId() == 253 && firstPacket.getSubstreamId() == 86) {
                                    firstPacket.setStreamId(255);
                                    writeBackPack = true;
                                }
                            }
                            if (this.reverting) {
                                if (firstPacket.getStreamId() == 0) {
                                    firstPacket.setStreamId(189);
                                    writeBackPack = true;
                                } else if (firstPacket.getStreamId() == 255) {
                                    firstPacket.setStreamId(253);
                                    writeBackPack = true;
                                }
                            }
                        }
                        String idString = pack.toString();
                        msg = String.format("0x%1$016X: %2$s", offset, idString);
                        this.logMessage(msg);
                        Counter counter = (Counter)packTable.get(idString);
                        if (counter != null) {
                            counter.inc();
                        } else {
                            packTable.put(idString, new Counter(1L));
                        }
                        if (writeBackPack) {
                            inFile.setPosition(inFile.getPosition() - (long)packData.length);
                            inFile.write(packData, 0, packData.length);
                            writeBackPack = false;
                        }
                        if (System.in.available() == 0) break block42;
                        break;
                    }
                    catch (PESParserException e) {
                        msg = String.format("0x%1$016X: Invalid pack found: %2$s", offset, e.getMessage());
                        this.logMessage(msg);
                        this.out.println(msg);
                    }
                }
                offset += (long)packData.length;
            }
        }
        catch (IOException e) {
            returnResult = false;
            this.out.println("Error reading file: " + e.getMessage());
            try {
                inFile.close();
            }
            catch (IOException e2) {
                this.out.println("Error closing input file: " + e2.getMessage());
            }
        }
        this.out.println("Scan finished: " + new Date());
        if (this.logging) {
            this.logger.close();
        }
        try {
            inFile.close();
        }
        catch (IOException e) {
            returnResult = false;
            this.out.println("Error closing input file: " + e.getMessage());
        }
        Iterator it = packTable.entrySet().iterator();
        this.out.println();
        this.out.println("Pack statistics");
        this.out.println("---------------");
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.out.println(String.valueOf((String)entry.getKey()) + " :: " + ((Counter)entry.getValue()).getCount());
        }
        return returnResult;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isQuickScan() {
        return this.quickScan;
    }

    public void setQuickScan(boolean quickScan) {
        this.quickScan = quickScan;
    }

    public boolean isBlanking() {
        return this.blanking;
    }

    public void setBlanking(boolean blanking) {
        this.blanking = blanking;
        if (blanking) {
            this.mode = 1;
            this.reverting = false;
        }
    }

    public boolean isReverting() {
        return this.reverting;
    }

    public void setReverting(boolean reverting) {
        this.reverting = reverting;
        if (reverting) {
            this.mode = 1;
            this.blanking = false;
        }
    }

    public boolean isNavFix() {
        return this.navFix;
    }

    public void setNavFix(boolean navFix) {
        this.navFix = navFix;
        if (navFix) {
            this.mode = 1;
        }
    }

    public boolean isZeroCPI() {
        return this.zeroCPI;
    }

    public void setZeroCPI(boolean zeroCPI) {
        this.zeroCPI = zeroCPI;
        if (zeroCPI) {
            this.mode = 1;
        }
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    private void logMessage(String msg) {
        if (this.logging) {
            this.logger.println(msg);
        }
    }

    public static void main(String[] args) {
        System.out.println("PackScanner 0.82 by KenD00");
        System.out.println();
        if (args.length == 2) {
            if (args[0].startsWith("-")) {
                PackScanner packScanner = new PackScanner(new PrintStreamPrinter(System.out));
                int i = 0;
                while (i < args[0].length()) {
                    switch (args[0].charAt(i)) {
                        case 'Q': 
                        case 'q': {
                            packScanner.setQuickScan(true);
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            packScanner.setBlanking(true);
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            packScanner.setReverting(true);
                            break;
                        }
                        case 'N': 
                        case 'n': {
                            packScanner.setNavFix(true);
                            break;
                        }
                        case 'Z': 
                        case 'z': {
                            packScanner.setZeroCPI(true);
                            break;
                        }
                        case 'L': 
                        case 'l': {
                            packScanner.setLogging(true);
                        }
                    }
                    ++i;
                }
                if (packScanner.scan(args[1])) {
                    System.exit(0);
                } else {
                    System.exit(2);
                }
            }
        } else if (args.length == 1) {
            if (new PackScanner(new PrintStreamPrinter(System.out)).scan(args[0])) {
                System.exit(0);
            } else {
                System.exit(2);
            }
        }
        System.out.println("Usage: PackScanner [-options] input");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -q quickscan, does not fully parse the PES header");
        System.out.println(" -b blanks the VC-1 Stream for Sub and the first DD+ Stream for Sub");
        System.out.println(" -r reverts the blanked streams");
        System.out.println(" -n enables Nav chain bugfix");
        System.out.println(" -z zeros the complete CPI field");
        System.out.println(" -l logging enabled, writes a log file with offsets to every pack");
        System.out.println();
        System.out.println("Example: scan C:\\MY_MOVIE.EVO, write log file and blank");
        System.out.println("PackScanner -lb C:\\MY_MOVIE.EVO");
        System.out.println();
        System.out.println("Pressing ENTER during the scan aborts it");
        System.exit(1);
    }

    private final class Counter {
        private long value = 0L;

        public Counter(long initValue) {
            this.value = initValue;
        }

        public void reset() {
            this.value = 0L;
        }

        public void inc() {
            ++this.value;
        }

        public void dec() {
            --this.value;
        }

        public long getCount() {
            return this.value;
        }
    }
}

